// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.model



public class CreateWorkspaceRequest private constructor(builder: Builder) {
    /**
     * Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If you specify `ORGANIZATION`, you must specify which organizational units the workspace can access in the `workspaceOrganizationalUnits` parameter.
     */
    public val accountAccessType: aws.sdk.kotlin.services.grafana.model.AccountAccessType? = builder.accountAccessType
    /**
     * Specifies whether this workspace uses SAML 2.0, Amazon Web Services Single Sign On, or both to authenticate users for using the Grafana console within a workspace. For more information, see [User authentication in Amazon Managed Grafana](https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html).
     */
    public val authenticationProviders: List<AuthenticationProviderTypes>? = builder.authenticationProviders
    /**
     * A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The name of an IAM role that already exists to use with Organizations to access Amazon Web Services data sources and notification channels in other accounts in an organization.
     */
    public val organizationRoleName: kotlin.String? = builder.organizationRoleName
    /**
     * If you specify `SERVICE_MANAGED` on AWS Grafana console, Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use Amazon Web Services data sources and notification channels. In CLI mode, the permissionType `SERVICE_MANAGED` will not create the IAM role for you.
     *
     * If you specify `CUSTOMER_MANAGED`, you will manage those roles and permissions yourself. If you are creating this workspace in a member account of an organization that is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services accounts in the organization, you must choose `CUSTOMER_MANAGED`.
     *
     * For more information, see [Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html).
     */
    public val permissionType: aws.sdk.kotlin.services.grafana.model.PermissionType? = builder.permissionType
    /**
     * The name of the CloudFormation stack set to use to generate IAM roles to be used for this workspace.
     */
    public val stackSetName: kotlin.String? = builder.stackSetName
    /**
     * The list of tags associated with the workspace.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Specify the Amazon Web Services data sources that you want to be queried in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to read data from these sources. You must still add them as data sources in the Grafana console in the workspace.
     *
     * If you don't specify a data source here, you can still add it as a data source in the workspace console later. However, you will then have to manually configure permissions for it.
     */
    public val workspaceDataSources: List<DataSourceType>? = builder.workspaceDataSources
    /**
     * A description for the workspace. This is used only to help you identify this workspace.
     *
     * Pattern: `^[\\p{L}\\p{Z}\\p{N}\\p{P}]{0,2048}$`
     */
    public val workspaceDescription: kotlin.String? = builder.workspaceDescription
    /**
     * The name for the workspace. It does not have to be unique.
     */
    public val workspaceName: kotlin.String? = builder.workspaceName
    /**
     * Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to use these channels.
     */
    public val workspaceNotificationDestinations: List<NotificationDestinationType>? = builder.workspaceNotificationDestinations
    /**
     * Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.
     */
    public val workspaceOrganizationalUnits: List<String>? = builder.workspaceOrganizationalUnits
    /**
     * The workspace needs an IAM role that grants permissions to the Amazon Web Services resources that the workspace will view data from. If you already have a role that you want to use, specify it here. The permission type should be set to `CUSTOMER_MANAGED`.
     */
    public val workspaceRoleArn: kotlin.String? = builder.workspaceRoleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.grafana.model.CreateWorkspaceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateWorkspaceRequest(")
        append("accountAccessType=$accountAccessType,")
        append("authenticationProviders=$authenticationProviders,")
        append("clientToken=$clientToken,")
        append("organizationRoleName=*** Sensitive Data Redacted ***,")
        append("permissionType=$permissionType,")
        append("stackSetName=$stackSetName,")
        append("tags=$tags,")
        append("workspaceDataSources=$workspaceDataSources,")
        append("workspaceDescription=*** Sensitive Data Redacted ***,")
        append("workspaceName=*** Sensitive Data Redacted ***,")
        append("workspaceNotificationDestinations=$workspaceNotificationDestinations,")
        append("workspaceOrganizationalUnits=*** Sensitive Data Redacted ***,")
        append("workspaceRoleArn=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountAccessType?.hashCode() ?: 0
        result = 31 * result + (authenticationProviders?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (organizationRoleName?.hashCode() ?: 0)
        result = 31 * result + (permissionType?.hashCode() ?: 0)
        result = 31 * result + (stackSetName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (workspaceDataSources?.hashCode() ?: 0)
        result = 31 * result + (workspaceDescription?.hashCode() ?: 0)
        result = 31 * result + (workspaceName?.hashCode() ?: 0)
        result = 31 * result + (workspaceNotificationDestinations?.hashCode() ?: 0)
        result = 31 * result + (workspaceOrganizationalUnits?.hashCode() ?: 0)
        result = 31 * result + (workspaceRoleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateWorkspaceRequest

        if (accountAccessType != other.accountAccessType) return false
        if (authenticationProviders != other.authenticationProviders) return false
        if (clientToken != other.clientToken) return false
        if (organizationRoleName != other.organizationRoleName) return false
        if (permissionType != other.permissionType) return false
        if (stackSetName != other.stackSetName) return false
        if (tags != other.tags) return false
        if (workspaceDataSources != other.workspaceDataSources) return false
        if (workspaceDescription != other.workspaceDescription) return false
        if (workspaceName != other.workspaceName) return false
        if (workspaceNotificationDestinations != other.workspaceNotificationDestinations) return false
        if (workspaceOrganizationalUnits != other.workspaceOrganizationalUnits) return false
        if (workspaceRoleArn != other.workspaceRoleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.grafana.model.CreateWorkspaceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If you specify `ORGANIZATION`, you must specify which organizational units the workspace can access in the `workspaceOrganizationalUnits` parameter.
         */
        public var accountAccessType: aws.sdk.kotlin.services.grafana.model.AccountAccessType? = null
        /**
         * Specifies whether this workspace uses SAML 2.0, Amazon Web Services Single Sign On, or both to authenticate users for using the Grafana console within a workspace. For more information, see [User authentication in Amazon Managed Grafana](https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html).
         */
        public var authenticationProviders: List<AuthenticationProviderTypes>? = null
        /**
         * A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The name of an IAM role that already exists to use with Organizations to access Amazon Web Services data sources and notification channels in other accounts in an organization.
         */
        public var organizationRoleName: kotlin.String? = null
        /**
         * If you specify `SERVICE_MANAGED` on AWS Grafana console, Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use Amazon Web Services data sources and notification channels. In CLI mode, the permissionType `SERVICE_MANAGED` will not create the IAM role for you.
         *
         * If you specify `CUSTOMER_MANAGED`, you will manage those roles and permissions yourself. If you are creating this workspace in a member account of an organization that is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services accounts in the organization, you must choose `CUSTOMER_MANAGED`.
         *
         * For more information, see [Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html).
         */
        public var permissionType: aws.sdk.kotlin.services.grafana.model.PermissionType? = null
        /**
         * The name of the CloudFormation stack set to use to generate IAM roles to be used for this workspace.
         */
        public var stackSetName: kotlin.String? = null
        /**
         * The list of tags associated with the workspace.
         */
        public var tags: Map<String, String>? = null
        /**
         * Specify the Amazon Web Services data sources that you want to be queried in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to read data from these sources. You must still add them as data sources in the Grafana console in the workspace.
         *
         * If you don't specify a data source here, you can still add it as a data source in the workspace console later. However, you will then have to manually configure permissions for it.
         */
        public var workspaceDataSources: List<DataSourceType>? = null
        /**
         * A description for the workspace. This is used only to help you identify this workspace.
         *
         * Pattern: `^[\\p{L}\\p{Z}\\p{N}\\p{P}]{0,2048}$`
         */
        public var workspaceDescription: kotlin.String? = null
        /**
         * The name for the workspace. It does not have to be unique.
         */
        public var workspaceName: kotlin.String? = null
        /**
         * Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to use these channels.
         */
        public var workspaceNotificationDestinations: List<NotificationDestinationType>? = null
        /**
         * Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.
         */
        public var workspaceOrganizationalUnits: List<String>? = null
        /**
         * The workspace needs an IAM role that grants permissions to the Amazon Web Services resources that the workspace will view data from. If you already have a role that you want to use, specify it here. The permission type should be set to `CUSTOMER_MANAGED`.
         */
        public var workspaceRoleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.grafana.model.CreateWorkspaceRequest) : this() {
            this.accountAccessType = x.accountAccessType
            this.authenticationProviders = x.authenticationProviders
            this.clientToken = x.clientToken
            this.organizationRoleName = x.organizationRoleName
            this.permissionType = x.permissionType
            this.stackSetName = x.stackSetName
            this.tags = x.tags
            this.workspaceDataSources = x.workspaceDataSources
            this.workspaceDescription = x.workspaceDescription
            this.workspaceName = x.workspaceName
            this.workspaceNotificationDestinations = x.workspaceNotificationDestinations
            this.workspaceOrganizationalUnits = x.workspaceOrganizationalUnits
            this.workspaceRoleArn = x.workspaceRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.grafana.model.CreateWorkspaceRequest = CreateWorkspaceRequest(this)
    }
}
