// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.model



public class ListPermissionsRequest private constructor(builder: Builder) {
    /**
     * (Optional) Limits the results to only the group that matches this ID.
     */
    public val groupId: kotlin.String? = builder.groupId
    /**
     * The maximum number of results to include in the response.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to use when requesting the next set of results. You received this token from a previous `ListPermissions` operation.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * (Optional) Limits the results to only the user that matches this ID.
     */
    public val userId: kotlin.String? = builder.userId
    /**
     * (Optional) If you specify `SSO_USER`, then only the permissions of Amazon Web Services SSO users are returned. If you specify `SSO_GROUP`, only the permissions of Amazon Web Services SSO groups are returned.
     */
    public val userType: aws.sdk.kotlin.services.grafana.model.UserType? = builder.userType
    /**
     * The ID of the workspace to list permissions for. This parameter is required.
     */
    public val workspaceId: kotlin.String? = requireNotNull(builder.workspaceId) { "A non-null value must be provided for workspaceId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.grafana.model.ListPermissionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListPermissionsRequest(")
        append("groupId=$groupId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("userId=$userId,")
        append("userType=$userType,")
        append("workspaceId=$workspaceId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = groupId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        result = 31 * result + (userType?.hashCode() ?: 0)
        result = 31 * result + (workspaceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListPermissionsRequest

        if (groupId != other.groupId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (userId != other.userId) return false
        if (userType != other.userType) return false
        if (workspaceId != other.workspaceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.grafana.model.ListPermissionsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * (Optional) Limits the results to only the group that matches this ID.
         */
        public var groupId: kotlin.String? = null
        /**
         * The maximum number of results to include in the response.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to use when requesting the next set of results. You received this token from a previous `ListPermissions` operation.
         */
        public var nextToken: kotlin.String? = null
        /**
         * (Optional) Limits the results to only the user that matches this ID.
         */
        public var userId: kotlin.String? = null
        /**
         * (Optional) If you specify `SSO_USER`, then only the permissions of Amazon Web Services SSO users are returned. If you specify `SSO_GROUP`, only the permissions of Amazon Web Services SSO groups are returned.
         */
        public var userType: aws.sdk.kotlin.services.grafana.model.UserType? = null
        /**
         * The ID of the workspace to list permissions for. This parameter is required.
         */
        public var workspaceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.grafana.model.ListPermissionsRequest) : this() {
            this.groupId = x.groupId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.userId = x.userId
            this.userType = x.userType
            this.workspaceId = x.workspaceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.grafana.model.ListPermissionsRequest = ListPermissionsRequest(this)
    }
}
