// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.model



/**
 * A structure containing information about how this workspace works with SAML.
 */
public class SamlConfiguration private constructor(builder: Builder) {
    /**
     * Lists which organizations defined in the SAML assertion are allowed to use the Amazon Managed Grafana workspace. If this is empty, all organizations in the assertion attribute have access.
     */
    public val allowedOrganizations: List<String>? = builder.allowedOrganizations
    /**
     * A structure that defines which attributes in the SAML assertion are to be used to define information about the users authenticated by that IdP to use the workspace.
     */
    public val assertionAttributes: aws.sdk.kotlin.services.grafana.model.AssertionAttributes? = builder.assertionAttributes
    /**
     * A structure containing the identity provider (IdP) metadata used to integrate the identity provider with this workspace.
     */
    public val idpMetadata: aws.sdk.kotlin.services.grafana.model.IdpMetadata? = builder.idpMetadata
    /**
     * How long a sign-on session by a SAML user is valid, before the user has to sign on again.
     */
    public val loginValidityDuration: kotlin.Int = builder.loginValidityDuration
    /**
     * A structure containing arrays that map group names in the SAML assertion to the Grafana `Admin` and `Editor` roles in the workspace.
     */
    public val roleValues: aws.sdk.kotlin.services.grafana.model.RoleValues? = builder.roleValues

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.grafana.model.SamlConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SamlConfiguration(")
        append("allowedOrganizations=$allowedOrganizations,")
        append("assertionAttributes=$assertionAttributes,")
        append("idpMetadata=$idpMetadata,")
        append("loginValidityDuration=$loginValidityDuration,")
        append("roleValues=$roleValues)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedOrganizations?.hashCode() ?: 0
        result = 31 * result + (assertionAttributes?.hashCode() ?: 0)
        result = 31 * result + (idpMetadata?.hashCode() ?: 0)
        result = 31 * result + (loginValidityDuration)
        result = 31 * result + (roleValues?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SamlConfiguration

        if (allowedOrganizations != other.allowedOrganizations) return false
        if (assertionAttributes != other.assertionAttributes) return false
        if (idpMetadata != other.idpMetadata) return false
        if (loginValidityDuration != other.loginValidityDuration) return false
        if (roleValues != other.roleValues) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.grafana.model.SamlConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Lists which organizations defined in the SAML assertion are allowed to use the Amazon Managed Grafana workspace. If this is empty, all organizations in the assertion attribute have access.
         */
        public var allowedOrganizations: List<String>? = null
        /**
         * A structure that defines which attributes in the SAML assertion are to be used to define information about the users authenticated by that IdP to use the workspace.
         */
        public var assertionAttributes: aws.sdk.kotlin.services.grafana.model.AssertionAttributes? = null
        /**
         * A structure containing the identity provider (IdP) metadata used to integrate the identity provider with this workspace.
         */
        public var idpMetadata: aws.sdk.kotlin.services.grafana.model.IdpMetadata? = null
        /**
         * How long a sign-on session by a SAML user is valid, before the user has to sign on again.
         */
        public var loginValidityDuration: kotlin.Int = 0
        /**
         * A structure containing arrays that map group names in the SAML assertion to the Grafana `Admin` and `Editor` roles in the workspace.
         */
        public var roleValues: aws.sdk.kotlin.services.grafana.model.RoleValues? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.grafana.model.SamlConfiguration) : this() {
            this.allowedOrganizations = x.allowedOrganizations
            this.assertionAttributes = x.assertionAttributes
            this.idpMetadata = x.idpMetadata
            this.loginValidityDuration = x.loginValidityDuration
            this.roleValues = x.roleValues
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.grafana.model.SamlConfiguration = SamlConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.grafana.model.AssertionAttributes] inside the given [block]
         */
        public fun assertionAttributes(block: aws.sdk.kotlin.services.grafana.model.AssertionAttributes.Builder.() -> kotlin.Unit) {
            this.assertionAttributes = aws.sdk.kotlin.services.grafana.model.AssertionAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.grafana.model.RoleValues] inside the given [block]
         */
        public fun roleValues(block: aws.sdk.kotlin.services.grafana.model.RoleValues.Builder.() -> kotlin.Unit) {
            this.roleValues = aws.sdk.kotlin.services.grafana.model.RoleValues.invoke(block)
        }
    }
}
