// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.model



public class UpdateWorkspaceRequest private constructor(builder: Builder) {
    /**
     * Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If you specify `ORGANIZATION`, you must specify which organizational units the workspace can access in the `workspaceOrganizationalUnits` parameter.
     */
    public val accountAccessType: aws.sdk.kotlin.services.grafana.model.AccountAccessType? = builder.accountAccessType
    /**
     * The name of an IAM role that already exists to use to access resources through Organizations.
     */
    public val organizationRoleName: kotlin.String? = builder.organizationRoleName
    /**
     * If you specify `Service Managed`, Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use Amazon Web Services data sources and notification channels.
     *
     * If you specify `CUSTOMER_MANAGED`, you will manage those roles and permissions yourself. If you are creating this workspace in a member account of an organization and that account is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services accounts in the organization, you must choose `CUSTOMER_MANAGED`.
     *
     * For more information, see [Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html)
     */
    public val permissionType: aws.sdk.kotlin.services.grafana.model.PermissionType? = builder.permissionType
    /**
     * The name of the CloudFormation stack set to use to generate IAM roles to be used for this workspace.
     */
    public val stackSetName: kotlin.String? = builder.stackSetName
    /**
     * Specify the Amazon Web Services data sources that you want to be queried in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to read data from these sources. You must still add them as data sources in the Grafana console in the workspace.
     *
     * If you don't specify a data source here, you can still add it as a data source later in the workspace console. However, you will then have to manually configure permissions for it.
     */
    public val workspaceDataSources: List<DataSourceType>? = builder.workspaceDataSources
    /**
     * A description for the workspace. This is used only to help you identify this workspace.
     */
    public val workspaceDescription: kotlin.String? = builder.workspaceDescription
    /**
     * The ID of the workspace to update.
     */
    public val workspaceId: kotlin.String? = requireNotNull(builder.workspaceId) { "A non-null value must be provided for workspaceId" }
    /**
     * A new name for the workspace to update.
     */
    public val workspaceName: kotlin.String? = builder.workspaceName
    /**
     * Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to use these channels.
     */
    public val workspaceNotificationDestinations: List<NotificationDestinationType>? = builder.workspaceNotificationDestinations
    /**
     * Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.
     */
    public val workspaceOrganizationalUnits: List<String>? = builder.workspaceOrganizationalUnits
    /**
     * The workspace needs an IAM role that grants permissions to the Amazon Web Services resources that the workspace will view data from. If you already have a role that you want to use, specify it here. If you omit this field and you specify some Amazon Web Services resources in `workspaceDataSources` or `workspaceNotificationDestinations`, a new IAM role with the necessary permissions is automatically created.
     */
    public val workspaceRoleArn: kotlin.String? = builder.workspaceRoleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateWorkspaceRequest(")
        append("accountAccessType=$accountAccessType,")
        append("organizationRoleName=*** Sensitive Data Redacted ***,")
        append("permissionType=$permissionType,")
        append("stackSetName=$stackSetName,")
        append("workspaceDataSources=$workspaceDataSources,")
        append("workspaceDescription=*** Sensitive Data Redacted ***,")
        append("workspaceId=$workspaceId,")
        append("workspaceName=*** Sensitive Data Redacted ***,")
        append("workspaceNotificationDestinations=$workspaceNotificationDestinations,")
        append("workspaceOrganizationalUnits=*** Sensitive Data Redacted ***,")
        append("workspaceRoleArn=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountAccessType?.hashCode() ?: 0
        result = 31 * result + (organizationRoleName?.hashCode() ?: 0)
        result = 31 * result + (permissionType?.hashCode() ?: 0)
        result = 31 * result + (stackSetName?.hashCode() ?: 0)
        result = 31 * result + (workspaceDataSources?.hashCode() ?: 0)
        result = 31 * result + (workspaceDescription?.hashCode() ?: 0)
        result = 31 * result + (workspaceId?.hashCode() ?: 0)
        result = 31 * result + (workspaceName?.hashCode() ?: 0)
        result = 31 * result + (workspaceNotificationDestinations?.hashCode() ?: 0)
        result = 31 * result + (workspaceOrganizationalUnits?.hashCode() ?: 0)
        result = 31 * result + (workspaceRoleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateWorkspaceRequest

        if (accountAccessType != other.accountAccessType) return false
        if (organizationRoleName != other.organizationRoleName) return false
        if (permissionType != other.permissionType) return false
        if (stackSetName != other.stackSetName) return false
        if (workspaceDataSources != other.workspaceDataSources) return false
        if (workspaceDescription != other.workspaceDescription) return false
        if (workspaceId != other.workspaceId) return false
        if (workspaceName != other.workspaceName) return false
        if (workspaceNotificationDestinations != other.workspaceNotificationDestinations) return false
        if (workspaceOrganizationalUnits != other.workspaceOrganizationalUnits) return false
        if (workspaceRoleArn != other.workspaceRoleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If you specify `ORGANIZATION`, you must specify which organizational units the workspace can access in the `workspaceOrganizationalUnits` parameter.
         */
        public var accountAccessType: aws.sdk.kotlin.services.grafana.model.AccountAccessType? = null
        /**
         * The name of an IAM role that already exists to use to access resources through Organizations.
         */
        public var organizationRoleName: kotlin.String? = null
        /**
         * If you specify `Service Managed`, Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use Amazon Web Services data sources and notification channels.
         *
         * If you specify `CUSTOMER_MANAGED`, you will manage those roles and permissions yourself. If you are creating this workspace in a member account of an organization and that account is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services accounts in the organization, you must choose `CUSTOMER_MANAGED`.
         *
         * For more information, see [Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html)
         */
        public var permissionType: aws.sdk.kotlin.services.grafana.model.PermissionType? = null
        /**
         * The name of the CloudFormation stack set to use to generate IAM roles to be used for this workspace.
         */
        public var stackSetName: kotlin.String? = null
        /**
         * Specify the Amazon Web Services data sources that you want to be queried in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to read data from these sources. You must still add them as data sources in the Grafana console in the workspace.
         *
         * If you don't specify a data source here, you can still add it as a data source later in the workspace console. However, you will then have to manually configure permissions for it.
         */
        public var workspaceDataSources: List<DataSourceType>? = null
        /**
         * A description for the workspace. This is used only to help you identify this workspace.
         */
        public var workspaceDescription: kotlin.String? = null
        /**
         * The ID of the workspace to update.
         */
        public var workspaceId: kotlin.String? = null
        /**
         * A new name for the workspace to update.
         */
        public var workspaceName: kotlin.String? = null
        /**
         * Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to use these channels.
         */
        public var workspaceNotificationDestinations: List<NotificationDestinationType>? = null
        /**
         * Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.
         */
        public var workspaceOrganizationalUnits: List<String>? = null
        /**
         * The workspace needs an IAM role that grants permissions to the Amazon Web Services resources that the workspace will view data from. If you already have a role that you want to use, specify it here. If you omit this field and you specify some Amazon Web Services resources in `workspaceDataSources` or `workspaceNotificationDestinations`, a new IAM role with the necessary permissions is automatically created.
         */
        public var workspaceRoleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceRequest) : this() {
            this.accountAccessType = x.accountAccessType
            this.organizationRoleName = x.organizationRoleName
            this.permissionType = x.permissionType
            this.stackSetName = x.stackSetName
            this.workspaceDataSources = x.workspaceDataSources
            this.workspaceDescription = x.workspaceDescription
            this.workspaceId = x.workspaceId
            this.workspaceName = x.workspaceName
            this.workspaceNotificationDestinations = x.workspaceNotificationDestinations
            this.workspaceOrganizationalUnits = x.workspaceOrganizationalUnits
            this.workspaceRoleArn = x.workspaceRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceRequest = UpdateWorkspaceRequest(this)
    }
}
