// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.grafana.model.CreateWorkspaceApiKeyResponse
import aws.sdk.kotlin.services.grafana.model.GrafanaException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateWorkspaceApiKeyOperationDeserializer: HttpDeserialize<CreateWorkspaceApiKeyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateWorkspaceApiKeyResponse {
        if (!response.status.isSuccess()) {
            throwCreateWorkspaceApiKeyError(context, response)
        }
        val builder = CreateWorkspaceApiKeyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateWorkspaceApiKeyOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateWorkspaceApiKeyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw GrafanaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> GrafanaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateWorkspaceApiKeyOperationBody(builder: CreateWorkspaceApiKeyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val KEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("key"))
    val KEYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("keyName"))
    val WORKSPACEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("workspaceId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(KEY_DESCRIPTOR)
        field(KEYNAME_DESCRIPTOR)
        field(WORKSPACEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                KEY_DESCRIPTOR.index -> builder.key = deserializeString()
                KEYNAME_DESCRIPTOR.index -> builder.keyName = deserializeString()
                WORKSPACEID_DESCRIPTOR.index -> builder.workspaceId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
