// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.transform

import aws.sdk.kotlin.services.grafana.model.AuthenticationProviderTypes
import aws.sdk.kotlin.services.grafana.model.SamlConfiguration
import aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceAuthenticationRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateWorkspaceAuthenticationOperationSerializer: HttpSerialize<UpdateWorkspaceAuthenticationRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateWorkspaceAuthenticationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "workspaces",
                "${input.workspaceId}".encodeLabel(),
                "authentication",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateWorkspaceAuthenticationOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateWorkspaceAuthenticationOperationBody(context: ExecutionContext, input: UpdateWorkspaceAuthenticationRequest): ByteArray {
    val serializer = JsonSerializer()
    val AUTHENTICATIONPROVIDERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("authenticationProviders"))
    val SAMLCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("samlConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHENTICATIONPROVIDERS_DESCRIPTOR)
        field(SAMLCONFIGURATION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.authenticationProviders != null) {
            listField(AUTHENTICATIONPROVIDERS_DESCRIPTOR) {
                for (el0 in input.authenticationProviders) {
                    serializeString(el0.value)
                }
            }
        }
        input.samlConfiguration?.let { field(SAMLCONFIGURATION_DESCRIPTOR, it, ::serializeSamlConfigurationDocument) }
    }
    return serializer.toByteArray()
}
