// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.health

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.health.model.*
import aws.sdk.kotlin.services.health.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Health"
const val ServiceApiVersion: String = "2016-08-04"
const val SdkVersion: String = "0.17.0-beta"

internal class DefaultHealthClient(override val config: HealthClient.Config) : HealthClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Returns a list of accounts in the organization from Organizations that are affected by the provided event. For more information about the different types of Health events, see [Event](https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html).
     *
     * Before you can call this operation, you must first enable Health to work with Organizations. To do this, call the [EnableHealthServiceAccessForOrganization](https://docs.aws.amazon.com/health/latest/APIReference/API_EnableHealthServiceAccessForOrganization.html) operation from your organization's management account.
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the next request to return more results.
     */
    override suspend fun describeAffectedAccountsForOrganization(input: DescribeAffectedAccountsForOrganizationRequest): DescribeAffectedAccountsForOrganizationResponse {
        val op = SdkHttpOperation.build<DescribeAffectedAccountsForOrganizationRequest, DescribeAffectedAccountsForOrganizationResponse> {
            serializer = DescribeAffectedAccountsForOrganizationOperationSerializer()
            deserializer = DescribeAffectedAccountsForOrganizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAffectedAccountsForOrganization"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSHealth_20160804", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "health"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of entities that have been affected by the specified events, based on the specified filter criteria. Entities can refer to individual customer resources, groups of customer resources, or any other construct, depending on the Amazon Web Services service. Events that have impact beyond that of the affected entities, or where the extent of impact is unknown, include at least one entity indicating this.
     *
     * At least one event ARN is required.
     *
     * + This API operation uses pagination. Specify the `nextToken` parameter in the next request to return more results.
     * + This operation supports resource-level permissions. You can use this operation to allow or deny access to specific Health events. For more information, see [Resource- and action-based conditions](https://docs.aws.amazon.com/health/latest/ug/security_iam_id-based-policy-examples.html#resource-action-based-conditions) in the *Health User Guide*.
     */
    override suspend fun describeAffectedEntities(input: DescribeAffectedEntitiesRequest): DescribeAffectedEntitiesResponse {
        val op = SdkHttpOperation.build<DescribeAffectedEntitiesRequest, DescribeAffectedEntitiesResponse> {
            serializer = DescribeAffectedEntitiesOperationSerializer()
            deserializer = DescribeAffectedEntitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAffectedEntities"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSHealth_20160804", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "health"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of entities that have been affected by one or more events for one or more accounts in your organization in Organizations, based on the filter criteria. Entities can refer to individual customer resources, groups of customer resources, or any other construct, depending on the Amazon Web Services service.
     *
     * At least one event Amazon Resource Name (ARN) and account ID are required.
     *
     * Before you can call this operation, you must first enable Health to work with Organizations. To do this, call the [EnableHealthServiceAccessForOrganization](https://docs.aws.amazon.com/health/latest/APIReference/API_EnableHealthServiceAccessForOrganization.html) operation from your organization's management account.
     *
     * + This API operation uses pagination. Specify the `nextToken` parameter in the next request to return more results.
     * + This operation doesn't support resource-level permissions. You can't use this operation to allow or deny access to specific Health events. For more information, see [Resource- and action-based conditions](https://docs.aws.amazon.com/health/latest/ug/security_iam_id-based-policy-examples.html#resource-action-based-conditions) in the *Health User Guide*.
     */
    override suspend fun describeAffectedEntitiesForOrganization(input: DescribeAffectedEntitiesForOrganizationRequest): DescribeAffectedEntitiesForOrganizationResponse {
        val op = SdkHttpOperation.build<DescribeAffectedEntitiesForOrganizationRequest, DescribeAffectedEntitiesForOrganizationResponse> {
            serializer = DescribeAffectedEntitiesForOrganizationOperationSerializer()
            deserializer = DescribeAffectedEntitiesForOrganizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAffectedEntitiesForOrganization"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSHealth_20160804", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "health"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the number of entities that are affected by each of the specified events.
     */
    override suspend fun describeEntityAggregates(input: DescribeEntityAggregatesRequest): DescribeEntityAggregatesResponse {
        val op = SdkHttpOperation.build<DescribeEntityAggregatesRequest, DescribeEntityAggregatesResponse> {
            serializer = DescribeEntityAggregatesOperationSerializer()
            deserializer = DescribeEntityAggregatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEntityAggregates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSHealth_20160804", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "health"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the number of events of each event type (issue, scheduled change, and account notification). If no filter is specified, the counts of all events in each category are returned.
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the next request to return more results.
     */
    override suspend fun describeEventAggregates(input: DescribeEventAggregatesRequest): DescribeEventAggregatesResponse {
        val op = SdkHttpOperation.build<DescribeEventAggregatesRequest, DescribeEventAggregatesResponse> {
            serializer = DescribeEventAggregatesOperationSerializer()
            deserializer = DescribeEventAggregatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEventAggregates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSHealth_20160804", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "health"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns detailed information about one or more specified events. Information includes standard event data (Amazon Web Services Region, service, and so on, as returned by [DescribeEvents](https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEvents.html)), a detailed event description, and possible additional metadata that depends upon the nature of the event. Affected entities are not included. To retrieve the entities, use the [DescribeAffectedEntities](https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeAffectedEntities.html) operation.
     *
     * If a specified event can't be retrieved, an error message is returned for that event.
     *
     * This operation supports resource-level permissions. You can use this operation to allow or deny access to specific Health events. For more information, see [Resource- and action-based conditions](https://docs.aws.amazon.com/health/latest/ug/security_iam_id-based-policy-examples.html#resource-action-based-conditions) in the *Health User Guide*.
     */
    override suspend fun describeEventDetails(input: DescribeEventDetailsRequest): DescribeEventDetailsResponse {
        val op = SdkHttpOperation.build<DescribeEventDetailsRequest, DescribeEventDetailsResponse> {
            serializer = DescribeEventDetailsOperationSerializer()
            deserializer = DescribeEventDetailsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEventDetails"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSHealth_20160804", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "health"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns detailed information about one or more specified events for one or more Amazon Web Services accounts in your organization. This information includes standard event data (such as the Amazon Web Services Region and service), an event description, and (depending on the event) possible metadata. This operation doesn't return affected entities, such as the resources related to the event. To return affected entities, use the [DescribeAffectedEntitiesForOrganization](https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeAffectedEntitiesForOrganization.html) operation.
     *
     * Before you can call this operation, you must first enable Health to work with Organizations. To do this, call the [EnableHealthServiceAccessForOrganization](https://docs.aws.amazon.com/health/latest/APIReference/API_EnableHealthServiceAccessForOrganization.html) operation from your organization's management account.
     *
     * When you call the `DescribeEventDetailsForOrganization` operation, specify the `organizationEventDetailFilters` object in the request. Depending on the Health event type, note the following differences:
     * + To return event details for a public event, you must specify a null value for the `awsAccountId` parameter. If you specify an account ID for a public event, Health returns an error message because public events aren't specific to an account.
     * + To return event details for an event that is specific to an account in your organization, you must specify the `awsAccountId` parameter in the request. If you don't specify an account ID, Health returns an error message because the event is specific to an account in your organization.
     *
     * For more information, see [Event](https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html).
     *
     * This operation doesn't support resource-level permissions. You can't use this operation to allow or deny access to specific Health events. For more information, see [Resource- and action-based conditions](https://docs.aws.amazon.com/health/latest/ug/security_iam_id-based-policy-examples.html#resource-action-based-conditions) in the *Health User Guide*.
     */
    override suspend fun describeEventDetailsForOrganization(input: DescribeEventDetailsForOrganizationRequest): DescribeEventDetailsForOrganizationResponse {
        val op = SdkHttpOperation.build<DescribeEventDetailsForOrganizationRequest, DescribeEventDetailsForOrganizationResponse> {
            serializer = DescribeEventDetailsForOrganizationOperationSerializer()
            deserializer = DescribeEventDetailsForOrganizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEventDetailsForOrganization"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSHealth_20160804", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "health"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the event types that meet the specified filter criteria. You can use this API operation to find information about the Health event, such as the category, Amazon Web Services service, and event code. The metadata for each event appears in the [EventType](https://docs.aws.amazon.com/health/latest/APIReference/API_EventType.html) object.
     *
     * If you don't specify a filter criteria, the API operation returns all event types, in no particular order.
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the next request to return more results.
     */
    override suspend fun describeEventTypes(input: DescribeEventTypesRequest): DescribeEventTypesResponse {
        val op = SdkHttpOperation.build<DescribeEventTypesRequest, DescribeEventTypesResponse> {
            serializer = DescribeEventTypesOperationSerializer()
            deserializer = DescribeEventTypesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEventTypes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSHealth_20160804", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "health"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about events that meet the specified filter criteria. Events are returned in a summary form and do not include the detailed description, any additional metadata that depends on the event type, or any affected resources. To retrieve that information, use the [DescribeEventDetails](https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetails.html) and [DescribeAffectedEntities](https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeAffectedEntities.html) operations.
     *
     * If no filter criteria are specified, all events are returned. Results are sorted by `lastModifiedTime`, starting with the most recent event.
     *
     * + When you call the `DescribeEvents` operation and specify an entity for the `entityValues` parameter, Health might return public events that aren't specific to that resource. For example, if you call `DescribeEvents` and specify an ID for an Amazon Elastic Compute Cloud (Amazon EC2) instance, Health might return events that aren't specific to that resource or service. To get events that are specific to a service, use the `services` parameter in the `filter` object. For more information, see [Event](https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html).
     * + This API operation uses pagination. Specify the `nextToken` parameter in the next request to return more results.
     */
    override suspend fun describeEvents(input: DescribeEventsRequest): DescribeEventsResponse {
        val op = SdkHttpOperation.build<DescribeEventsRequest, DescribeEventsResponse> {
            serializer = DescribeEventsOperationSerializer()
            deserializer = DescribeEventsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEvents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSHealth_20160804", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "health"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about events across your organization in Organizations. You can use the`filters` parameter to specify the events that you want to return. Events are returned in a summary form and don't include the affected accounts, detailed description, any additional metadata that depends on the event type, or any affected resources. To retrieve that information, use the following operations:
     * + [DescribeAffectedAccountsForOrganization](https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeAffectedAccountsForOrganization.html)
     * + [DescribeEventDetailsForOrganization](https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetailsForOrganization.html)
     * + [DescribeAffectedEntitiesForOrganization](https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeAffectedEntitiesForOrganization.html)
     *
     * If you don't specify a `filter`, the `DescribeEventsForOrganizations` returns all events across your organization. Results are sorted by `lastModifiedTime`, starting with the most recent event.
     *
     * For more information about the different types of Health events, see [Event](https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html).
     *
     * Before you can call this operation, you must first enable Health to work with Organizations. To do this, call the [EnableHealthServiceAccessForOrganization](https://docs.aws.amazon.com/health/latest/APIReference/API_EnableHealthServiceAccessForOrganization.html) operation from your organization's management account.
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the next request to return more results.
     */
    override suspend fun describeEventsForOrganization(input: DescribeEventsForOrganizationRequest): DescribeEventsForOrganizationResponse {
        val op = SdkHttpOperation.build<DescribeEventsForOrganizationRequest, DescribeEventsForOrganizationResponse> {
            serializer = DescribeEventsForOrganizationOperationSerializer()
            deserializer = DescribeEventsForOrganizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEventsForOrganization"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSHealth_20160804", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "health"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation provides status information on enabling or disabling Health to work with your organization. To call this operation, you must sign in as an IAM user, assume an IAM role, or sign in as the root user (not recommended) in the organization's management account.
     */
    override suspend fun describeHealthServiceStatusForOrganization(input: DescribeHealthServiceStatusForOrganizationRequest): DescribeHealthServiceStatusForOrganizationResponse {
        val op = SdkHttpOperation.build<DescribeHealthServiceStatusForOrganizationRequest, DescribeHealthServiceStatusForOrganizationResponse> {
            serializer = DescribeHealthServiceStatusForOrganizationOperationSerializer()
            deserializer = DescribeHealthServiceStatusForOrganizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeHealthServiceStatusForOrganization"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSHealth_20160804", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "health"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables Health from working with Organizations. To call this operation, you must sign in as an Identity and Access Management (IAM) user, assume an IAM role, or sign in as the root user (not recommended) in the organization's management account. For more information, see [Aggregating Health events](https://docs.aws.amazon.com/health/latest/ug/aggregate-events.html) in the *Health User Guide*.
     *
     * This operation doesn't remove the service-linked role from the management account in your organization. You must use the IAM console, API, or Command Line Interface (CLI) to remove the service-linked role. For more information, see [Deleting a Service-Linked Role](https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html#delete-service-linked-role) in the *IAM User Guide*.
     *
     * You can also disable the organizational feature by using the Organizations [DisableAWSServiceAccess](https://docs.aws.amazon.com/organizations/latest/APIReference/API_DisableAWSServiceAccess.html) API operation. After you call this operation, Health stops aggregating events for all other Amazon Web Services accounts in your organization. If you call the Health API operations for organizational view, Health returns an error. Health continues to aggregate health events for your Amazon Web Services account.
     */
    override suspend fun disableHealthServiceAccessForOrganization(input: DisableHealthServiceAccessForOrganizationRequest): DisableHealthServiceAccessForOrganizationResponse {
        val op = SdkHttpOperation.build<DisableHealthServiceAccessForOrganizationRequest, DisableHealthServiceAccessForOrganizationResponse> {
            serializer = DisableHealthServiceAccessForOrganizationOperationSerializer()
            deserializer = DisableHealthServiceAccessForOrganizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableHealthServiceAccessForOrganization"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSHealth_20160804", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "health"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables Health to work with Organizations. You can use the organizational view feature to aggregate events from all Amazon Web Services accounts in your organization in a centralized location.
     *
     * This operation also creates a service-linked role for the management account in the organization.
     *
     * To call this operation, you must meet the following requirements:
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan from [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/) to use the Health API. If you call the Health API from an Amazon Web Services account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, you receive a `SubscriptionRequiredException` error.
     * + You must have permission to call this operation from the organization's management account. For example IAM policies, see [Health identity-based policy examples](https://docs.aws.amazon.com/health/latest/ug/security_iam_id-based-policy-examples.html).
     * If you don't have the required support plan, you can instead use the Health console to enable the organizational view feature. For more information, see [Aggregating Health events](https://docs.aws.amazon.com/health/latest/ug/aggregate-events.html) in the *Health User Guide*.
     */
    override suspend fun enableHealthServiceAccessForOrganization(input: EnableHealthServiceAccessForOrganizationRequest): EnableHealthServiceAccessForOrganizationResponse {
        val op = SdkHttpOperation.build<EnableHealthServiceAccessForOrganizationRequest, EnableHealthServiceAccessForOrganizationResponse> {
            serializer = EnableHealthServiceAccessForOrganizationOperationSerializer()
            deserializer = EnableHealthServiceAccessForOrganizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableHealthServiceAccessForOrganization"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSHealth_20160804", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "health"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "health")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
