// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.health.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an entity that is affected by a Health event.
 */
class AffectedEntity private constructor(builder: Builder) {
    /**
     * The 12-digit Amazon Web Services account number that contains the affected entity.
     */
    val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The unique identifier for the entity. Format: `arn:aws:health:<i>entity-region</i>:<i>aws-account</i>:entity/<i>entity-id</i> `. Example: `arn:aws:health:us-east-1:111222333444:entity/AVh5GGT7ul1arKr1sE1K`
     */
    val entityArn: kotlin.String? = builder.entityArn
    /**
     * The URL of the affected entity.
     */
    val entityUrl: kotlin.String? = builder.entityUrl
    /**
     * The ID of the affected entity.
     */
    val entityValue: kotlin.String? = builder.entityValue
    /**
     * The unique identifier for the event. The event ARN has the `arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i> ` format.
     *
     * For example, an event ARN might look like the following:
     *
     * `arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456`
     */
    val eventArn: kotlin.String? = builder.eventArn
    /**
     * The most recent time that the entity was updated.
     */
    val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * The most recent status of the entity affected by the event. The possible values are `IMPAIRED`, `UNIMPAIRED`, and `UNKNOWN`.
     */
    val statusCode: aws.sdk.kotlin.services.health.model.EntityStatusCode? = builder.statusCode
    /**
     * A map of entity tags attached to the affected entity.
     *
     * Currently, the `tags` property isn't supported.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.health.model.AffectedEntity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AffectedEntity(")
        append("awsAccountId=$awsAccountId,")
        append("entityArn=$entityArn,")
        append("entityUrl=$entityUrl,")
        append("entityValue=$entityValue,")
        append("eventArn=$eventArn,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("statusCode=$statusCode,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (entityArn?.hashCode() ?: 0)
        result = 31 * result + (entityUrl?.hashCode() ?: 0)
        result = 31 * result + (entityValue?.hashCode() ?: 0)
        result = 31 * result + (eventArn?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (statusCode?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AffectedEntity

        if (awsAccountId != other.awsAccountId) return false
        if (entityArn != other.entityArn) return false
        if (entityUrl != other.entityUrl) return false
        if (entityValue != other.entityValue) return false
        if (eventArn != other.eventArn) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (statusCode != other.statusCode) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.health.model.AffectedEntity = Builder(this).apply(block).build()

    class Builder {
        /**
         * The 12-digit Amazon Web Services account number that contains the affected entity.
         */
        var awsAccountId: kotlin.String? = null
        /**
         * The unique identifier for the entity. Format: `arn:aws:health:<i>entity-region</i>:<i>aws-account</i>:entity/<i>entity-id</i> `. Example: `arn:aws:health:us-east-1:111222333444:entity/AVh5GGT7ul1arKr1sE1K`
         */
        var entityArn: kotlin.String? = null
        /**
         * The URL of the affected entity.
         */
        var entityUrl: kotlin.String? = null
        /**
         * The ID of the affected entity.
         */
        var entityValue: kotlin.String? = null
        /**
         * The unique identifier for the event. The event ARN has the `arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i> ` format.
         *
         * For example, an event ARN might look like the following:
         *
         * `arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456`
         */
        var eventArn: kotlin.String? = null
        /**
         * The most recent time that the entity was updated.
         */
        var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The most recent status of the entity affected by the event. The possible values are `IMPAIRED`, `UNIMPAIRED`, and `UNKNOWN`.
         */
        var statusCode: aws.sdk.kotlin.services.health.model.EntityStatusCode? = null
        /**
         * A map of entity tags attached to the affected entity.
         *
         * Currently, the `tags` property isn't supported.
         */
        var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.health.model.AffectedEntity) : this() {
            this.awsAccountId = x.awsAccountId
            this.entityArn = x.entityArn
            this.entityUrl = x.entityUrl
            this.entityValue = x.entityValue
            this.eventArn = x.eventArn
            this.lastUpdatedTime = x.lastUpdatedTime
            this.statusCode = x.statusCode
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.health.model.AffectedEntity = AffectedEntity(this)
    }
}
