// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.health.model



class DescribeAffectedAccountsForOrganizationResponse private constructor(builder: Builder) {
    /**
     * A JSON set of elements of the affected accounts.
     */
    val affectedAccounts: List<String>? = builder.affectedAccounts
    /**
     * This parameter specifies if the Health event is a public Amazon Web Services service event or an account-specific event.
     * + If the `eventScopeCode` value is `PUBLIC`, then the `affectedAccounts` value is always empty.
     * + If the `eventScopeCode` value is `ACCOUNT_SPECIFIC`, then the `affectedAccounts` value lists the affected Amazon Web Services accounts in your organization. For example, if an event affects a service such as Amazon Elastic Compute Cloud and you have Amazon Web Services accounts that use that service, those account IDs appear in the response.
     * + If the `eventScopeCode` value is `NONE`, then the `eventArn` that you specified in the request is invalid or doesn't exist.
     */
    val eventScopeCode: aws.sdk.kotlin.services.health.model.EventScopeCode? = builder.eventScopeCode
    /**
     * If the results of a search are large, only a portion of the results are returned, and a `nextToken` pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.
     */
    val nextToken: kotlin.String? = builder.nextToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.health.model.DescribeAffectedAccountsForOrganizationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeAffectedAccountsForOrganizationResponse(")
        append("affectedAccounts=$affectedAccounts,")
        append("eventScopeCode=$eventScopeCode,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = affectedAccounts?.hashCode() ?: 0
        result = 31 * result + (eventScopeCode?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeAffectedAccountsForOrganizationResponse

        if (affectedAccounts != other.affectedAccounts) return false
        if (eventScopeCode != other.eventScopeCode) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.health.model.DescribeAffectedAccountsForOrganizationResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * A JSON set of elements of the affected accounts.
         */
        var affectedAccounts: List<String>? = null
        /**
         * This parameter specifies if the Health event is a public Amazon Web Services service event or an account-specific event.
         * + If the `eventScopeCode` value is `PUBLIC`, then the `affectedAccounts` value is always empty.
         * + If the `eventScopeCode` value is `ACCOUNT_SPECIFIC`, then the `affectedAccounts` value lists the affected Amazon Web Services accounts in your organization. For example, if an event affects a service such as Amazon Elastic Compute Cloud and you have Amazon Web Services accounts that use that service, those account IDs appear in the response.
         * + If the `eventScopeCode` value is `NONE`, then the `eventArn` that you specified in the request is invalid or doesn't exist.
         */
        var eventScopeCode: aws.sdk.kotlin.services.health.model.EventScopeCode? = null
        /**
         * If the results of a search are large, only a portion of the results are returned, and a `nextToken` pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.
         */
        var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.health.model.DescribeAffectedAccountsForOrganizationResponse) : this() {
            this.affectedAccounts = x.affectedAccounts
            this.eventScopeCode = x.eventScopeCode
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.health.model.DescribeAffectedAccountsForOrganizationResponse = DescribeAffectedAccountsForOrganizationResponse(this)
    }
}
