// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.health.model



/**
 * The number of entities that are affected by one or more events. Returned by the [DescribeEntityAggregates](https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEntityAggregates.html) operation.
 */
class EntityAggregate private constructor(builder: Builder) {
    /**
     * The number of entities that match the criteria for the specified events.
     */
    val count: kotlin.Int = builder.count
    /**
     * The unique identifier for the event. The event ARN has the `arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i> ` format.
     *
     * For example, an event ARN might look like the following:
     *
     * `arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456`
     */
    val eventArn: kotlin.String? = builder.eventArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.health.model.EntityAggregate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EntityAggregate(")
        append("count=$count,")
        append("eventArn=$eventArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = count
        result = 31 * result + (eventArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EntityAggregate

        if (count != other.count) return false
        if (eventArn != other.eventArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.health.model.EntityAggregate = Builder(this).apply(block).build()

    class Builder {
        /**
         * The number of entities that match the criteria for the specified events.
         */
        var count: kotlin.Int = 0
        /**
         * The unique identifier for the event. The event ARN has the `arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i> ` format.
         *
         * For example, an event ARN might look like the following:
         *
         * `arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456`
         */
        var eventArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.health.model.EntityAggregate) : this() {
            this.count = x.count
            this.eventArn = x.eventArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.health.model.EntityAggregate = EntityAggregate(this)
    }
}
