// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.health.model



/**
 * The values to use to filter results from the [DescribeAffectedEntities](https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeAffectedEntities.html) operation.
 */
class EntityFilter private constructor(builder: Builder) {
    /**
     * A list of entity ARNs (unique identifiers).
     */
    val entityArns: List<String>? = builder.entityArns
    /**
     * A list of IDs for affected entities.
     */
    val entityValues: List<String>? = builder.entityValues
    /**
     * A list of event ARNs (unique identifiers). For example: `"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"`
     */
    val eventArns: List<String>? = builder.eventArns
    /**
     * A list of the most recent dates and times that the entity was updated.
     */
    val lastUpdatedTimes: List<DateTimeRange>? = builder.lastUpdatedTimes
    /**
     * A list of entity status codes (`IMPAIRED`, `UNIMPAIRED`, or `UNKNOWN`).
     */
    val statusCodes: List<EntityStatusCode>? = builder.statusCodes
    /**
     * A map of entity tags attached to the affected entity.
     *
     * Currently, the `tags` property isn't supported.
     */
    val tags: List<Map<String, String>>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.health.model.EntityFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EntityFilter(")
        append("entityArns=$entityArns,")
        append("entityValues=$entityValues,")
        append("eventArns=$eventArns,")
        append("lastUpdatedTimes=$lastUpdatedTimes,")
        append("statusCodes=$statusCodes,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = entityArns?.hashCode() ?: 0
        result = 31 * result + (entityValues?.hashCode() ?: 0)
        result = 31 * result + (eventArns?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimes?.hashCode() ?: 0)
        result = 31 * result + (statusCodes?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EntityFilter

        if (entityArns != other.entityArns) return false
        if (entityValues != other.entityValues) return false
        if (eventArns != other.eventArns) return false
        if (lastUpdatedTimes != other.lastUpdatedTimes) return false
        if (statusCodes != other.statusCodes) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.health.model.EntityFilter = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of entity ARNs (unique identifiers).
         */
        var entityArns: List<String>? = null
        /**
         * A list of IDs for affected entities.
         */
        var entityValues: List<String>? = null
        /**
         * A list of event ARNs (unique identifiers). For example: `"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"`
         */
        var eventArns: List<String>? = null
        /**
         * A list of the most recent dates and times that the entity was updated.
         */
        var lastUpdatedTimes: List<DateTimeRange>? = null
        /**
         * A list of entity status codes (`IMPAIRED`, `UNIMPAIRED`, or `UNKNOWN`).
         */
        var statusCodes: List<EntityStatusCode>? = null
        /**
         * A map of entity tags attached to the affected entity.
         *
         * Currently, the `tags` property isn't supported.
         */
        var tags: List<Map<String, String>>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.health.model.EntityFilter) : this() {
            this.entityArns = x.entityArns
            this.entityValues = x.entityValues
            this.eventArns = x.eventArns
            this.lastUpdatedTimes = x.lastUpdatedTimes
            this.statusCodes = x.statusCodes
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.health.model.EntityFilter = EntityFilter(this)
    }
}
