// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.health.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information about an Health event.
 *
 * Health events can be public or account-specific:
 * + *Public events* might be service events that are not specific to an Amazon Web Services account. For example, if there is an issue with an Amazon Web Services Region, Health provides information about the event, even if you don't use services or resources in that Region.
 * + *Account-specific* events are specific to either your Amazon Web Services account or an account in your organization. For example, if there's an issue with Amazon Elastic Compute Cloud in a Region that you use, Health provides information about the event and the affected resources in the account.
 *
 * You can determine if an event is public or account-specific by using the `eventScopeCode` parameter. For more information, see [eventScopeCode](https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html#AWSHealth-Type-Event-eventScopeCode).
 */
class Event private constructor(builder: Builder) {
    /**
     * The unique identifier for the event. The event ARN has the `arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i> ` format.
     *
     * For example, an event ARN might look like the following:
     *
     * `arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456`
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The Amazon Web Services Availability Zone of the event. For example, us-east-1a.
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The date and time that the event ended.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * This parameter specifies if the Health event is a public Amazon Web Services service event or an account-specific event.
     * + If the `eventScopeCode` value is `PUBLIC`, then the `affectedAccounts` value is always empty.
     * + If the `eventScopeCode` value is `ACCOUNT_SPECIFIC`, then the `affectedAccounts` value lists the affected Amazon Web Services accounts in your organization. For example, if an event affects a service such as Amazon Elastic Compute Cloud and you have Amazon Web Services accounts that use that service, those account IDs appear in the response.
     * + If the `eventScopeCode` value is `NONE`, then the `eventArn` that you specified in the request is invalid or doesn't exist.
     */
    val eventScopeCode: aws.sdk.kotlin.services.health.model.EventScopeCode? = builder.eventScopeCode
    /**
     * A list of event type category codes. Possible values are `issue`, `accountNotification`, or `scheduledChange`. Currently, the `investigation` value isn't supported at this time.
     */
    val eventTypeCategory: aws.sdk.kotlin.services.health.model.EventTypeCategory? = builder.eventTypeCategory
    /**
     * The unique identifier for the event type. The format is `AWS_<i>SERVICE</i>_<i>DESCRIPTION</i> `; for example, `AWS_EC2_SYSTEM_MAINTENANCE_EVENT`.
     */
    val eventTypeCode: kotlin.String? = builder.eventTypeCode
    /**
     * The most recent date and time that the event was updated.
     */
    val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * The Amazon Web Services Region name of the event.
     */
    val region: kotlin.String? = builder.region
    /**
     * The Amazon Web Services service that is affected by the event. For example, `EC2`, `RDS`.
     */
    val service: kotlin.String? = builder.service
    /**
     * The date and time that the event began.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The most recent status of the event. Possible values are `open`, `closed`, and `upcoming`.
     */
    val statusCode: aws.sdk.kotlin.services.health.model.EventStatusCode? = builder.statusCode

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.health.model.Event = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Event(")
        append("arn=$arn,")
        append("availabilityZone=$availabilityZone,")
        append("endTime=$endTime,")
        append("eventScopeCode=$eventScopeCode,")
        append("eventTypeCategory=$eventTypeCategory,")
        append("eventTypeCode=$eventTypeCode,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("region=$region,")
        append("service=$service,")
        append("startTime=$startTime,")
        append("statusCode=$statusCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (eventScopeCode?.hashCode() ?: 0)
        result = 31 * result + (eventTypeCategory?.hashCode() ?: 0)
        result = 31 * result + (eventTypeCode?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (service?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (statusCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Event

        if (arn != other.arn) return false
        if (availabilityZone != other.availabilityZone) return false
        if (endTime != other.endTime) return false
        if (eventScopeCode != other.eventScopeCode) return false
        if (eventTypeCategory != other.eventTypeCategory) return false
        if (eventTypeCode != other.eventTypeCode) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (region != other.region) return false
        if (service != other.service) return false
        if (startTime != other.startTime) return false
        if (statusCode != other.statusCode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.health.model.Event = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique identifier for the event. The event ARN has the `arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i> ` format.
         *
         * For example, an event ARN might look like the following:
         *
         * `arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456`
         */
        var arn: kotlin.String? = null
        /**
         * The Amazon Web Services Availability Zone of the event. For example, us-east-1a.
         */
        var availabilityZone: kotlin.String? = null
        /**
         * The date and time that the event ended.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * This parameter specifies if the Health event is a public Amazon Web Services service event or an account-specific event.
         * + If the `eventScopeCode` value is `PUBLIC`, then the `affectedAccounts` value is always empty.
         * + If the `eventScopeCode` value is `ACCOUNT_SPECIFIC`, then the `affectedAccounts` value lists the affected Amazon Web Services accounts in your organization. For example, if an event affects a service such as Amazon Elastic Compute Cloud and you have Amazon Web Services accounts that use that service, those account IDs appear in the response.
         * + If the `eventScopeCode` value is `NONE`, then the `eventArn` that you specified in the request is invalid or doesn't exist.
         */
        var eventScopeCode: aws.sdk.kotlin.services.health.model.EventScopeCode? = null
        /**
         * A list of event type category codes. Possible values are `issue`, `accountNotification`, or `scheduledChange`. Currently, the `investigation` value isn't supported at this time.
         */
        var eventTypeCategory: aws.sdk.kotlin.services.health.model.EventTypeCategory? = null
        /**
         * The unique identifier for the event type. The format is `AWS_<i>SERVICE</i>_<i>DESCRIPTION</i> `; for example, `AWS_EC2_SYSTEM_MAINTENANCE_EVENT`.
         */
        var eventTypeCode: kotlin.String? = null
        /**
         * The most recent date and time that the event was updated.
         */
        var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Web Services Region name of the event.
         */
        var region: kotlin.String? = null
        /**
         * The Amazon Web Services service that is affected by the event. For example, `EC2`, `RDS`.
         */
        var service: kotlin.String? = null
        /**
         * The date and time that the event began.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The most recent status of the event. Possible values are `open`, `closed`, and `upcoming`.
         */
        var statusCode: aws.sdk.kotlin.services.health.model.EventStatusCode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.health.model.Event) : this() {
            this.arn = x.arn
            this.availabilityZone = x.availabilityZone
            this.endTime = x.endTime
            this.eventScopeCode = x.eventScopeCode
            this.eventTypeCategory = x.eventTypeCategory
            this.eventTypeCode = x.eventTypeCode
            this.lastUpdatedTime = x.lastUpdatedTime
            this.region = x.region
            this.service = x.service
            this.startTime = x.startTime
            this.statusCode = x.statusCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.health.model.Event = Event(this)
    }
}
