// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.health.model



/**
 * Detailed information about an event. A combination of an [Event](https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html) object, an [EventDescription](https://docs.aws.amazon.com/health/latest/APIReference/API_EventDescription.html) object, and additional metadata about the event. Returned by the [DescribeEventDetails](https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetails.html) operation.
 */
class EventDetails private constructor(builder: Builder) {
    /**
     * Summary information about the event.
     */
    val event: aws.sdk.kotlin.services.health.model.Event? = builder.event
    /**
     * The most recent description of the event.
     */
    val eventDescription: aws.sdk.kotlin.services.health.model.EventDescription? = builder.eventDescription
    /**
     * Additional metadata about the event.
     */
    val eventMetadata: Map<String, String>? = builder.eventMetadata

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.health.model.EventDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventDetails(")
        append("event=$event,")
        append("eventDescription=$eventDescription,")
        append("eventMetadata=$eventMetadata)")
    }

    override fun hashCode(): kotlin.Int {
        var result = event?.hashCode() ?: 0
        result = 31 * result + (eventDescription?.hashCode() ?: 0)
        result = 31 * result + (eventMetadata?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventDetails

        if (event != other.event) return false
        if (eventDescription != other.eventDescription) return false
        if (eventMetadata != other.eventMetadata) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.health.model.EventDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * Summary information about the event.
         */
        var event: aws.sdk.kotlin.services.health.model.Event? = null
        /**
         * The most recent description of the event.
         */
        var eventDescription: aws.sdk.kotlin.services.health.model.EventDescription? = null
        /**
         * Additional metadata about the event.
         */
        var eventMetadata: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.health.model.EventDetails) : this() {
            this.event = x.event
            this.eventDescription = x.eventDescription
            this.eventMetadata = x.eventMetadata
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.health.model.EventDetails = EventDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.health.model.Event] inside the given [block]
         */
        fun event(block: aws.sdk.kotlin.services.health.model.Event.Builder.() -> kotlin.Unit) {
            this.event = aws.sdk.kotlin.services.health.model.Event.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.health.model.EventDescription] inside the given [block]
         */
        fun eventDescription(block: aws.sdk.kotlin.services.health.model.EventDescription.Builder.() -> kotlin.Unit) {
            this.eventDescription = aws.sdk.kotlin.services.health.model.EventDescription.invoke(block)
        }
    }
}
