// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.health.model



/**
 * The values to use to filter results from the [DescribeEvents](https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEvents.html) and [DescribeEventAggregates](https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventAggregates.html) operations.
 */
class EventFilter private constructor(builder: Builder) {
    /**
     * A list of Amazon Web Services Availability Zones.
     */
    val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * A list of dates and times that the event ended.
     */
    val endTimes: List<DateTimeRange>? = builder.endTimes
    /**
     * A list of entity ARNs (unique identifiers).
     */
    val entityArns: List<String>? = builder.entityArns
    /**
     * A list of entity identifiers, such as EC2 instance IDs (`i-34ab692e`) or EBS volumes (`vol-426ab23e`).
     */
    val entityValues: List<String>? = builder.entityValues
    /**
     * A list of event ARNs (unique identifiers). For example: `"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"`
     */
    val eventArns: List<String>? = builder.eventArns
    /**
     * A list of event status codes.
     */
    val eventStatusCodes: List<EventStatusCode>? = builder.eventStatusCodes
    /**
     * A list of event type category codes. Possible values are `issue`, `accountNotification`, or `scheduledChange`. Currently, the `investigation` value isn't supported at this time.
     */
    val eventTypeCategories: List<EventTypeCategory>? = builder.eventTypeCategories
    /**
     * A list of unique identifiers for event types. For example, `"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".`
     */
    val eventTypeCodes: List<String>? = builder.eventTypeCodes
    /**
     * A list of dates and times that the event was last updated.
     */
    val lastUpdatedTimes: List<DateTimeRange>? = builder.lastUpdatedTimes
    /**
     * A list of Amazon Web Services Regions.
     */
    val regions: List<String>? = builder.regions
    /**
     * The Amazon Web Services services associated with the event. For example, `EC2`, `RDS`.
     */
    val services: List<String>? = builder.services
    /**
     * A list of dates and times that the event began.
     */
    val startTimes: List<DateTimeRange>? = builder.startTimes
    /**
     * A map of entity tags attached to the affected entity.
     *
     * Currently, the `tags` property isn't supported.
     */
    val tags: List<Map<String, String>>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.health.model.EventFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventFilter(")
        append("availabilityZones=$availabilityZones,")
        append("endTimes=$endTimes,")
        append("entityArns=$entityArns,")
        append("entityValues=$entityValues,")
        append("eventArns=$eventArns,")
        append("eventStatusCodes=$eventStatusCodes,")
        append("eventTypeCategories=$eventTypeCategories,")
        append("eventTypeCodes=$eventTypeCodes,")
        append("lastUpdatedTimes=$lastUpdatedTimes,")
        append("regions=$regions,")
        append("services=$services,")
        append("startTimes=$startTimes,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZones?.hashCode() ?: 0
        result = 31 * result + (endTimes?.hashCode() ?: 0)
        result = 31 * result + (entityArns?.hashCode() ?: 0)
        result = 31 * result + (entityValues?.hashCode() ?: 0)
        result = 31 * result + (eventArns?.hashCode() ?: 0)
        result = 31 * result + (eventStatusCodes?.hashCode() ?: 0)
        result = 31 * result + (eventTypeCategories?.hashCode() ?: 0)
        result = 31 * result + (eventTypeCodes?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimes?.hashCode() ?: 0)
        result = 31 * result + (regions?.hashCode() ?: 0)
        result = 31 * result + (services?.hashCode() ?: 0)
        result = 31 * result + (startTimes?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventFilter

        if (availabilityZones != other.availabilityZones) return false
        if (endTimes != other.endTimes) return false
        if (entityArns != other.entityArns) return false
        if (entityValues != other.entityValues) return false
        if (eventArns != other.eventArns) return false
        if (eventStatusCodes != other.eventStatusCodes) return false
        if (eventTypeCategories != other.eventTypeCategories) return false
        if (eventTypeCodes != other.eventTypeCodes) return false
        if (lastUpdatedTimes != other.lastUpdatedTimes) return false
        if (regions != other.regions) return false
        if (services != other.services) return false
        if (startTimes != other.startTimes) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.health.model.EventFilter = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of Amazon Web Services Availability Zones.
         */
        var availabilityZones: List<String>? = null
        /**
         * A list of dates and times that the event ended.
         */
        var endTimes: List<DateTimeRange>? = null
        /**
         * A list of entity ARNs (unique identifiers).
         */
        var entityArns: List<String>? = null
        /**
         * A list of entity identifiers, such as EC2 instance IDs (`i-34ab692e`) or EBS volumes (`vol-426ab23e`).
         */
        var entityValues: List<String>? = null
        /**
         * A list of event ARNs (unique identifiers). For example: `"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"`
         */
        var eventArns: List<String>? = null
        /**
         * A list of event status codes.
         */
        var eventStatusCodes: List<EventStatusCode>? = null
        /**
         * A list of event type category codes. Possible values are `issue`, `accountNotification`, or `scheduledChange`. Currently, the `investigation` value isn't supported at this time.
         */
        var eventTypeCategories: List<EventTypeCategory>? = null
        /**
         * A list of unique identifiers for event types. For example, `"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".`
         */
        var eventTypeCodes: List<String>? = null
        /**
         * A list of dates and times that the event was last updated.
         */
        var lastUpdatedTimes: List<DateTimeRange>? = null
        /**
         * A list of Amazon Web Services Regions.
         */
        var regions: List<String>? = null
        /**
         * The Amazon Web Services services associated with the event. For example, `EC2`, `RDS`.
         */
        var services: List<String>? = null
        /**
         * A list of dates and times that the event began.
         */
        var startTimes: List<DateTimeRange>? = null
        /**
         * A map of entity tags attached to the affected entity.
         *
         * Currently, the `tags` property isn't supported.
         */
        var tags: List<Map<String, String>>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.health.model.EventFilter) : this() {
            this.availabilityZones = x.availabilityZones
            this.endTimes = x.endTimes
            this.entityArns = x.entityArns
            this.entityValues = x.entityValues
            this.eventArns = x.eventArns
            this.eventStatusCodes = x.eventStatusCodes
            this.eventTypeCategories = x.eventTypeCategories
            this.eventTypeCodes = x.eventTypeCodes
            this.lastUpdatedTimes = x.lastUpdatedTimes
            this.regions = x.regions
            this.services = x.services
            this.startTimes = x.startTimes
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.health.model.EventFilter = EventFilter(this)
    }
}
