// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.health.model



/**
 * Contains the metadata about a type of event that is reported by Health. The `EventType` shows the category, service, and the event type code of the event. For example, an `issue` might be the category, `EC2` the service, and `AWS_EC2_SYSTEM_MAINTENANCE_EVENT` the event type code.
 *
 * You can use the [DescribeEventTypes](https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventTypes.html) API operation to return this information about an event.
 *
 * You can also use the Amazon CloudWatch Events console to create a rule so that you can get notified or take action when Health delivers a specific event to your Amazon Web Services account. For more information, see [Monitor for Health events with Amazon CloudWatch Events](https://docs.aws.amazon.com/health/latest/ug/cloudwatch-events-health.html) in the *Health User Guide*.
 */
class EventType private constructor(builder: Builder) {
    /**
     * A list of event type category codes. Possible values are `issue`, `accountNotification`, or `scheduledChange`. Currently, the `investigation` value isn't supported at this time.
     */
    val category: aws.sdk.kotlin.services.health.model.EventTypeCategory? = builder.category
    /**
     * The unique identifier for the event type. The format is `AWS_<i>SERVICE</i>_<i>DESCRIPTION</i> `; for example, `AWS_EC2_SYSTEM_MAINTENANCE_EVENT`.
     */
    val code: kotlin.String? = builder.code
    /**
     * The Amazon Web Services service that is affected by the event. For example, `EC2`, `RDS`.
     */
    val service: kotlin.String? = builder.service

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.health.model.EventType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventType(")
        append("category=$category,")
        append("code=$code,")
        append("service=$service)")
    }

    override fun hashCode(): kotlin.Int {
        var result = category?.hashCode() ?: 0
        result = 31 * result + (code?.hashCode() ?: 0)
        result = 31 * result + (service?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventType

        if (category != other.category) return false
        if (code != other.code) return false
        if (service != other.service) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.health.model.EventType = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of event type category codes. Possible values are `issue`, `accountNotification`, or `scheduledChange`. Currently, the `investigation` value isn't supported at this time.
         */
        var category: aws.sdk.kotlin.services.health.model.EventTypeCategory? = null
        /**
         * The unique identifier for the event type. The format is `AWS_<i>SERVICE</i>_<i>DESCRIPTION</i> `; for example, `AWS_EC2_SYSTEM_MAINTENANCE_EVENT`.
         */
        var code: kotlin.String? = null
        /**
         * The Amazon Web Services service that is affected by the event. For example, `EC2`, `RDS`.
         */
        var service: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.health.model.EventType) : this() {
            this.category = x.category
            this.code = x.code
            this.service = x.service
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.health.model.EventType = EventType(this)
    }
}
