// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.health.model



/**
 * Detailed information about an event. A combination of an [Event](https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html) object, an [EventDescription](https://docs.aws.amazon.com/health/latest/APIReference/API_EventDescription.html) object, and additional metadata about the event. Returned by the [DescribeEventDetailsForOrganization](https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetailsForOrganization.html) operation.
 */
class OrganizationEventDetails private constructor(builder: Builder) {
    /**
     * The 12-digit Amazon Web Services account numbers that contains the affected entities.
     */
    val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * Summary information about an Health event.
     *
     * Health events can be public or account-specific:
     * + *Public events* might be service events that are not specific to an Amazon Web Services account. For example, if there is an issue with an Amazon Web Services Region, Health provides information about the event, even if you don't use services or resources in that Region.
     * + *Account-specific* events are specific to either your Amazon Web Services account or an account in your organization. For example, if there's an issue with Amazon Elastic Compute Cloud in a Region that you use, Health provides information about the event and the affected resources in the account.
     *
     * You can determine if an event is public or account-specific by using the `eventScopeCode` parameter. For more information, see [eventScopeCode](https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html#AWSHealth-Type-Event-eventScopeCode).
     */
    val event: aws.sdk.kotlin.services.health.model.Event? = builder.event
    /**
     * The detailed description of the event. Included in the information returned by the [DescribeEventDetails](https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetails.html) operation.
     */
    val eventDescription: aws.sdk.kotlin.services.health.model.EventDescription? = builder.eventDescription
    /**
     * Additional metadata about the event.
     */
    val eventMetadata: Map<String, String>? = builder.eventMetadata

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.health.model.OrganizationEventDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OrganizationEventDetails(")
        append("awsAccountId=$awsAccountId,")
        append("event=$event,")
        append("eventDescription=$eventDescription,")
        append("eventMetadata=$eventMetadata)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (event?.hashCode() ?: 0)
        result = 31 * result + (eventDescription?.hashCode() ?: 0)
        result = 31 * result + (eventMetadata?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OrganizationEventDetails

        if (awsAccountId != other.awsAccountId) return false
        if (event != other.event) return false
        if (eventDescription != other.eventDescription) return false
        if (eventMetadata != other.eventMetadata) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.health.model.OrganizationEventDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The 12-digit Amazon Web Services account numbers that contains the affected entities.
         */
        var awsAccountId: kotlin.String? = null
        /**
         * Summary information about an Health event.
         *
         * Health events can be public or account-specific:
         * + *Public events* might be service events that are not specific to an Amazon Web Services account. For example, if there is an issue with an Amazon Web Services Region, Health provides information about the event, even if you don't use services or resources in that Region.
         * + *Account-specific* events are specific to either your Amazon Web Services account or an account in your organization. For example, if there's an issue with Amazon Elastic Compute Cloud in a Region that you use, Health provides information about the event and the affected resources in the account.
         *
         * You can determine if an event is public or account-specific by using the `eventScopeCode` parameter. For more information, see [eventScopeCode](https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html#AWSHealth-Type-Event-eventScopeCode).
         */
        var event: aws.sdk.kotlin.services.health.model.Event? = null
        /**
         * The detailed description of the event. Included in the information returned by the [DescribeEventDetails](https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetails.html) operation.
         */
        var eventDescription: aws.sdk.kotlin.services.health.model.EventDescription? = null
        /**
         * Additional metadata about the event.
         */
        var eventMetadata: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.health.model.OrganizationEventDetails) : this() {
            this.awsAccountId = x.awsAccountId
            this.event = x.event
            this.eventDescription = x.eventDescription
            this.eventMetadata = x.eventMetadata
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.health.model.OrganizationEventDetails = OrganizationEventDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.health.model.Event] inside the given [block]
         */
        fun event(block: aws.sdk.kotlin.services.health.model.Event.Builder.() -> kotlin.Unit) {
            this.event = aws.sdk.kotlin.services.health.model.Event.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.health.model.EventDescription] inside the given [block]
         */
        fun eventDescription(block: aws.sdk.kotlin.services.health.model.EventDescription.Builder.() -> kotlin.Unit) {
            this.eventDescription = aws.sdk.kotlin.services.health.model.EventDescription.invoke(block)
        }
    }
}
