// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.health.model



/**
 * Error information returned when a [DescribeEventDetailsForOrganization](https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetailsForOrganization.html) operation can't find a specified event.
 */
class OrganizationEventDetailsErrorItem private constructor(builder: Builder) {
    /**
     * Error information returned when a [DescribeEventDetailsForOrganization](https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetailsForOrganization.html) operation can't find a specified event.
     */
    val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * A message that describes the error.
     *
     * If you call the `DescribeEventDetailsForOrganization` operation and receive one of the following errors, follow the recommendations in the message:
     * + We couldn't find a public event that matches your request. To find an event that is account specific, you must enter an Amazon Web Services account ID in the request.
     * + We couldn't find an account specific event for the specified Amazon Web Services account. To find an event that is public, you must enter a null value for the Amazon Web Services account ID in the request.
     * + Your Amazon Web Services account doesn't include the Amazon Web Services Support plan required to use the Health API. You must have either a Business, Enterprise On-Ramp, or Enterprise Support plan.
     */
    val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * The name of the error.
     */
    val errorName: kotlin.String? = builder.errorName
    /**
     * The unique identifier for the event. The event ARN has the `arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i> ` format.
     *
     * For example, an event ARN might look like the following:
     *
     * `arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456`
     */
    val eventArn: kotlin.String? = builder.eventArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.health.model.OrganizationEventDetailsErrorItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OrganizationEventDetailsErrorItem(")
        append("awsAccountId=$awsAccountId,")
        append("errorMessage=$errorMessage,")
        append("errorName=$errorName,")
        append("eventArn=$eventArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (errorName?.hashCode() ?: 0)
        result = 31 * result + (eventArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OrganizationEventDetailsErrorItem

        if (awsAccountId != other.awsAccountId) return false
        if (errorMessage != other.errorMessage) return false
        if (errorName != other.errorName) return false
        if (eventArn != other.eventArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.health.model.OrganizationEventDetailsErrorItem = Builder(this).apply(block).build()

    class Builder {
        /**
         * Error information returned when a [DescribeEventDetailsForOrganization](https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetailsForOrganization.html) operation can't find a specified event.
         */
        var awsAccountId: kotlin.String? = null
        /**
         * A message that describes the error.
         *
         * If you call the `DescribeEventDetailsForOrganization` operation and receive one of the following errors, follow the recommendations in the message:
         * + We couldn't find a public event that matches your request. To find an event that is account specific, you must enter an Amazon Web Services account ID in the request.
         * + We couldn't find an account specific event for the specified Amazon Web Services account. To find an event that is public, you must enter a null value for the Amazon Web Services account ID in the request.
         * + Your Amazon Web Services account doesn't include the Amazon Web Services Support plan required to use the Health API. You must have either a Business, Enterprise On-Ramp, or Enterprise Support plan.
         */
        var errorMessage: kotlin.String? = null
        /**
         * The name of the error.
         */
        var errorName: kotlin.String? = null
        /**
         * The unique identifier for the event. The event ARN has the `arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i> ` format.
         *
         * For example, an event ARN might look like the following:
         *
         * `arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456`
         */
        var eventArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.health.model.OrganizationEventDetailsErrorItem) : this() {
            this.awsAccountId = x.awsAccountId
            this.errorMessage = x.errorMessage
            this.errorName = x.errorName
            this.eventArn = x.eventArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.health.model.OrganizationEventDetailsErrorItem = OrganizationEventDetailsErrorItem(this)
    }
}
