// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.health.model



/**
 * The values to filter results from the [DescribeEventsForOrganization](https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventsForOrganization.html) operation.
 */
class OrganizationEventFilter private constructor(builder: Builder) {
    /**
     * A list of 12-digit Amazon Web Services account numbers that contains the affected entities.
     */
    val awsAccountIds: List<String>? = builder.awsAccountIds
    /**
     * A range of dates and times that is used by the [EventFilter](https://docs.aws.amazon.com/health/latest/APIReference/API_EventFilter.html) and [EntityFilter](https://docs.aws.amazon.com/health/latest/APIReference/API_EntityFilter.html) objects. If `from` is set and `to` is set: match items where the timestamp (`startTime`, `endTime`, or `lastUpdatedTime`) is between `from` and `to` inclusive. If `from` is set and `to` is not set: match items where the timestamp value is equal to or after `from`. If `from` is not set and `to` is set: match items where the timestamp value is equal to or before `to`.
     */
    val endTime: aws.sdk.kotlin.services.health.model.DateTimeRange? = builder.endTime
    /**
     * A list of entity ARNs (unique identifiers).
     */
    val entityArns: List<String>? = builder.entityArns
    /**
     * A list of entity identifiers, such as EC2 instance IDs (i-34ab692e) or EBS volumes (vol-426ab23e).
     */
    val entityValues: List<String>? = builder.entityValues
    /**
     * A list of event status codes.
     */
    val eventStatusCodes: List<EventStatusCode>? = builder.eventStatusCodes
    /**
     * A list of event type category codes. Possible values are `issue`, `accountNotification`, or `scheduledChange`. Currently, the `investigation` value isn't supported at this time.
     */
    val eventTypeCategories: List<EventTypeCategory>? = builder.eventTypeCategories
    /**
     * A list of unique identifiers for event types. For example, `"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".`
     */
    val eventTypeCodes: List<String>? = builder.eventTypeCodes
    /**
     * A range of dates and times that is used by the [EventFilter](https://docs.aws.amazon.com/health/latest/APIReference/API_EventFilter.html) and [EntityFilter](https://docs.aws.amazon.com/health/latest/APIReference/API_EntityFilter.html) objects. If `from` is set and `to` is set: match items where the timestamp (`startTime`, `endTime`, or `lastUpdatedTime`) is between `from` and `to` inclusive. If `from` is set and `to` is not set: match items where the timestamp value is equal to or after `from`. If `from` is not set and `to` is set: match items where the timestamp value is equal to or before `to`.
     */
    val lastUpdatedTime: aws.sdk.kotlin.services.health.model.DateTimeRange? = builder.lastUpdatedTime
    /**
     * A list of Amazon Web Services Regions.
     */
    val regions: List<String>? = builder.regions
    /**
     * The Amazon Web Services services associated with the event. For example, `EC2`, `RDS`.
     */
    val services: List<String>? = builder.services
    /**
     * A range of dates and times that is used by the [EventFilter](https://docs.aws.amazon.com/health/latest/APIReference/API_EventFilter.html) and [EntityFilter](https://docs.aws.amazon.com/health/latest/APIReference/API_EntityFilter.html) objects. If `from` is set and `to` is set: match items where the timestamp (`startTime`, `endTime`, or `lastUpdatedTime`) is between `from` and `to` inclusive. If `from` is set and `to` is not set: match items where the timestamp value is equal to or after `from`. If `from` is not set and `to` is set: match items where the timestamp value is equal to or before `to`.
     */
    val startTime: aws.sdk.kotlin.services.health.model.DateTimeRange? = builder.startTime

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.health.model.OrganizationEventFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OrganizationEventFilter(")
        append("awsAccountIds=$awsAccountIds,")
        append("endTime=$endTime,")
        append("entityArns=$entityArns,")
        append("entityValues=$entityValues,")
        append("eventStatusCodes=$eventStatusCodes,")
        append("eventTypeCategories=$eventTypeCategories,")
        append("eventTypeCodes=$eventTypeCodes,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("regions=$regions,")
        append("services=$services,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountIds?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (entityArns?.hashCode() ?: 0)
        result = 31 * result + (entityValues?.hashCode() ?: 0)
        result = 31 * result + (eventStatusCodes?.hashCode() ?: 0)
        result = 31 * result + (eventTypeCategories?.hashCode() ?: 0)
        result = 31 * result + (eventTypeCodes?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (regions?.hashCode() ?: 0)
        result = 31 * result + (services?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OrganizationEventFilter

        if (awsAccountIds != other.awsAccountIds) return false
        if (endTime != other.endTime) return false
        if (entityArns != other.entityArns) return false
        if (entityValues != other.entityValues) return false
        if (eventStatusCodes != other.eventStatusCodes) return false
        if (eventTypeCategories != other.eventTypeCategories) return false
        if (eventTypeCodes != other.eventTypeCodes) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (regions != other.regions) return false
        if (services != other.services) return false
        if (startTime != other.startTime) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.health.model.OrganizationEventFilter = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of 12-digit Amazon Web Services account numbers that contains the affected entities.
         */
        var awsAccountIds: List<String>? = null
        /**
         * A range of dates and times that is used by the [EventFilter](https://docs.aws.amazon.com/health/latest/APIReference/API_EventFilter.html) and [EntityFilter](https://docs.aws.amazon.com/health/latest/APIReference/API_EntityFilter.html) objects. If `from` is set and `to` is set: match items where the timestamp (`startTime`, `endTime`, or `lastUpdatedTime`) is between `from` and `to` inclusive. If `from` is set and `to` is not set: match items where the timestamp value is equal to or after `from`. If `from` is not set and `to` is set: match items where the timestamp value is equal to or before `to`.
         */
        var endTime: aws.sdk.kotlin.services.health.model.DateTimeRange? = null
        /**
         * A list of entity ARNs (unique identifiers).
         */
        var entityArns: List<String>? = null
        /**
         * A list of entity identifiers, such as EC2 instance IDs (i-34ab692e) or EBS volumes (vol-426ab23e).
         */
        var entityValues: List<String>? = null
        /**
         * A list of event status codes.
         */
        var eventStatusCodes: List<EventStatusCode>? = null
        /**
         * A list of event type category codes. Possible values are `issue`, `accountNotification`, or `scheduledChange`. Currently, the `investigation` value isn't supported at this time.
         */
        var eventTypeCategories: List<EventTypeCategory>? = null
        /**
         * A list of unique identifiers for event types. For example, `"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".`
         */
        var eventTypeCodes: List<String>? = null
        /**
         * A range of dates and times that is used by the [EventFilter](https://docs.aws.amazon.com/health/latest/APIReference/API_EventFilter.html) and [EntityFilter](https://docs.aws.amazon.com/health/latest/APIReference/API_EntityFilter.html) objects. If `from` is set and `to` is set: match items where the timestamp (`startTime`, `endTime`, or `lastUpdatedTime`) is between `from` and `to` inclusive. If `from` is set and `to` is not set: match items where the timestamp value is equal to or after `from`. If `from` is not set and `to` is set: match items where the timestamp value is equal to or before `to`.
         */
        var lastUpdatedTime: aws.sdk.kotlin.services.health.model.DateTimeRange? = null
        /**
         * A list of Amazon Web Services Regions.
         */
        var regions: List<String>? = null
        /**
         * The Amazon Web Services services associated with the event. For example, `EC2`, `RDS`.
         */
        var services: List<String>? = null
        /**
         * A range of dates and times that is used by the [EventFilter](https://docs.aws.amazon.com/health/latest/APIReference/API_EventFilter.html) and [EntityFilter](https://docs.aws.amazon.com/health/latest/APIReference/API_EntityFilter.html) objects. If `from` is set and `to` is set: match items where the timestamp (`startTime`, `endTime`, or `lastUpdatedTime`) is between `from` and `to` inclusive. If `from` is set and `to` is not set: match items where the timestamp value is equal to or after `from`. If `from` is not set and `to` is set: match items where the timestamp value is equal to or before `to`.
         */
        var startTime: aws.sdk.kotlin.services.health.model.DateTimeRange? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.health.model.OrganizationEventFilter) : this() {
            this.awsAccountIds = x.awsAccountIds
            this.endTime = x.endTime
            this.entityArns = x.entityArns
            this.entityValues = x.entityValues
            this.eventStatusCodes = x.eventStatusCodes
            this.eventTypeCategories = x.eventTypeCategories
            this.eventTypeCodes = x.eventTypeCodes
            this.lastUpdatedTime = x.lastUpdatedTime
            this.regions = x.regions
            this.services = x.services
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.health.model.OrganizationEventFilter = OrganizationEventFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.health.model.DateTimeRange] inside the given [block]
         */
        fun endTime(block: aws.sdk.kotlin.services.health.model.DateTimeRange.Builder.() -> kotlin.Unit) {
            this.endTime = aws.sdk.kotlin.services.health.model.DateTimeRange.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.health.model.DateTimeRange] inside the given [block]
         */
        fun lastUpdatedTime(block: aws.sdk.kotlin.services.health.model.DateTimeRange.Builder.() -> kotlin.Unit) {
            this.lastUpdatedTime = aws.sdk.kotlin.services.health.model.DateTimeRange.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.health.model.DateTimeRange] inside the given [block]
         */
        fun startTime(block: aws.sdk.kotlin.services.health.model.DateTimeRange.Builder.() -> kotlin.Unit) {
            this.startTime = aws.sdk.kotlin.services.health.model.DateTimeRange.invoke(block)
        }
    }
}
