// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.health.paginators

import aws.sdk.kotlin.services.health.HealthClient
import aws.sdk.kotlin.services.health.model.AffectedEntity
import aws.sdk.kotlin.services.health.model.DescribeAffectedAccountsForOrganizationRequest
import aws.sdk.kotlin.services.health.model.DescribeAffectedAccountsForOrganizationResponse
import aws.sdk.kotlin.services.health.model.DescribeAffectedEntitiesForOrganizationRequest
import aws.sdk.kotlin.services.health.model.DescribeAffectedEntitiesForOrganizationResponse
import aws.sdk.kotlin.services.health.model.DescribeAffectedEntitiesRequest
import aws.sdk.kotlin.services.health.model.DescribeAffectedEntitiesResponse
import aws.sdk.kotlin.services.health.model.DescribeEventAggregatesRequest
import aws.sdk.kotlin.services.health.model.DescribeEventAggregatesResponse
import aws.sdk.kotlin.services.health.model.DescribeEventTypesRequest
import aws.sdk.kotlin.services.health.model.DescribeEventTypesResponse
import aws.sdk.kotlin.services.health.model.DescribeEventsForOrganizationRequest
import aws.sdk.kotlin.services.health.model.DescribeEventsForOrganizationResponse
import aws.sdk.kotlin.services.health.model.DescribeEventsRequest
import aws.sdk.kotlin.services.health.model.DescribeEventsResponse
import aws.sdk.kotlin.services.health.model.Event
import aws.sdk.kotlin.services.health.model.EventAggregate
import aws.sdk.kotlin.services.health.model.EventType
import aws.sdk.kotlin.services.health.model.OrganizationEvent
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeAffectedAccountsForOrganizationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeAffectedAccountsForOrganizationRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAffectedAccountsForOrganizationResponse]
 */
fun HealthClient.describeAffectedAccountsForOrganizationPaginated(initialRequest: DescribeAffectedAccountsForOrganizationRequest): Flow<DescribeAffectedAccountsForOrganizationResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeAffectedAccountsForOrganizationPaginated.describeAffectedAccountsForOrganization(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeAffectedAccountsForOrganizationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAffectedAccountsForOrganizationResponse]
 */
fun HealthClient.describeAffectedAccountsForOrganizationPaginated(block: DescribeAffectedAccountsForOrganizationRequest.Builder.() -> Unit): Flow<DescribeAffectedAccountsForOrganizationResponse> =
    describeAffectedAccountsForOrganizationPaginated(DescribeAffectedAccountsForOrganizationRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeAffectedAccountsForOrganizationPaginated]
 * to access the nested member [AccountId]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AccountId]
 */
@JvmName("describeAffectedAccountsForOrganizationResponseAccountId")
fun Flow<DescribeAffectedAccountsForOrganizationResponse>.affectedAccounts(): Flow<String> =
    transform() { response ->
        response.affectedAccounts?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeAffectedEntitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeAffectedEntitiesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAffectedEntitiesResponse]
 */
fun HealthClient.describeAffectedEntitiesPaginated(initialRequest: DescribeAffectedEntitiesRequest): Flow<DescribeAffectedEntitiesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeAffectedEntitiesPaginated.describeAffectedEntities(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeAffectedEntitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAffectedEntitiesResponse]
 */
fun HealthClient.describeAffectedEntitiesPaginated(block: DescribeAffectedEntitiesRequest.Builder.() -> Unit): Flow<DescribeAffectedEntitiesResponse> =
    describeAffectedEntitiesPaginated(DescribeAffectedEntitiesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeAffectedEntitiesPaginated]
 * to access the nested member [AffectedEntity]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AffectedEntity]
 */
@JvmName("describeAffectedEntitiesResponseAffectedEntity")
fun Flow<DescribeAffectedEntitiesResponse>.entities(): Flow<AffectedEntity> =
    transform() { response ->
        response.entities?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeAffectedEntitiesForOrganizationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeAffectedEntitiesForOrganizationRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAffectedEntitiesForOrganizationResponse]
 */
fun HealthClient.describeAffectedEntitiesForOrganizationPaginated(initialRequest: DescribeAffectedEntitiesForOrganizationRequest): Flow<DescribeAffectedEntitiesForOrganizationResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeAffectedEntitiesForOrganizationPaginated.describeAffectedEntitiesForOrganization(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeAffectedEntitiesForOrganizationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAffectedEntitiesForOrganizationResponse]
 */
fun HealthClient.describeAffectedEntitiesForOrganizationPaginated(block: DescribeAffectedEntitiesForOrganizationRequest.Builder.() -> Unit): Flow<DescribeAffectedEntitiesForOrganizationResponse> =
    describeAffectedEntitiesForOrganizationPaginated(DescribeAffectedEntitiesForOrganizationRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeAffectedEntitiesForOrganizationPaginated]
 * to access the nested member [AffectedEntity]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AffectedEntity]
 */
@JvmName("describeAffectedEntitiesForOrganizationResponseAffectedEntity")
fun Flow<DescribeAffectedEntitiesForOrganizationResponse>.entities(): Flow<AffectedEntity> =
    transform() { response ->
        response.entities?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeEventAggregatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeEventAggregatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventAggregatesResponse]
 */
fun HealthClient.describeEventAggregatesPaginated(initialRequest: DescribeEventAggregatesRequest): Flow<DescribeEventAggregatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeEventAggregatesPaginated.describeEventAggregates(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeEventAggregatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventAggregatesResponse]
 */
fun HealthClient.describeEventAggregatesPaginated(block: DescribeEventAggregatesRequest.Builder.() -> Unit): Flow<DescribeEventAggregatesResponse> =
    describeEventAggregatesPaginated(DescribeEventAggregatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeEventAggregatesPaginated]
 * to access the nested member [EventAggregate]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EventAggregate]
 */
@JvmName("describeEventAggregatesResponseEventAggregate")
fun Flow<DescribeEventAggregatesResponse>.eventAggregates(): Flow<EventAggregate> =
    transform() { response ->
        response.eventAggregates?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventsResponse]
 */
fun HealthClient.describeEventsPaginated(initialRequest: DescribeEventsRequest): Flow<DescribeEventsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeEventsPaginated.describeEvents(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventsResponse]
 */
fun HealthClient.describeEventsPaginated(block: DescribeEventsRequest.Builder.() -> Unit): Flow<DescribeEventsResponse> =
    describeEventsPaginated(DescribeEventsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeEventsPaginated]
 * to access the nested member [Event]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Event]
 */
@JvmName("describeEventsResponseEvent")
fun Flow<DescribeEventsResponse>.events(): Flow<Event> =
    transform() { response ->
        response.events?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeEventsForOrganizationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeEventsForOrganizationRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventsForOrganizationResponse]
 */
fun HealthClient.describeEventsForOrganizationPaginated(initialRequest: DescribeEventsForOrganizationRequest): Flow<DescribeEventsForOrganizationResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeEventsForOrganizationPaginated.describeEventsForOrganization(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeEventsForOrganizationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventsForOrganizationResponse]
 */
fun HealthClient.describeEventsForOrganizationPaginated(block: DescribeEventsForOrganizationRequest.Builder.() -> Unit): Flow<DescribeEventsForOrganizationResponse> =
    describeEventsForOrganizationPaginated(DescribeEventsForOrganizationRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeEventsForOrganizationPaginated]
 * to access the nested member [OrganizationEvent]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [OrganizationEvent]
 */
@JvmName("describeEventsForOrganizationResponseOrganizationEvent")
fun Flow<DescribeEventsForOrganizationResponse>.events(): Flow<OrganizationEvent> =
    transform() { response ->
        response.events?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeEventTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeEventTypesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventTypesResponse]
 */
fun HealthClient.describeEventTypesPaginated(initialRequest: DescribeEventTypesRequest): Flow<DescribeEventTypesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeEventTypesPaginated.describeEventTypes(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeEventTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventTypesResponse]
 */
fun HealthClient.describeEventTypesPaginated(block: DescribeEventTypesRequest.Builder.() -> Unit): Flow<DescribeEventTypesResponse> =
    describeEventTypesPaginated(DescribeEventTypesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeEventTypesPaginated]
 * to access the nested member [EventType]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EventType]
 */
@JvmName("describeEventTypesResponseEventType")
fun Flow<DescribeEventTypesResponse>.eventTypes(): Flow<EventType> =
    transform() { response ->
        response.eventTypes?.forEach {
            emit(it)
        }
    }
