// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.health.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.health.model.DescribeAffectedAccountsForOrganizationResponse
import aws.sdk.kotlin.services.health.model.EventScopeCode
import aws.sdk.kotlin.services.health.model.HealthException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeAffectedAccountsForOrganizationOperationDeserializer: HttpDeserialize<DescribeAffectedAccountsForOrganizationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeAffectedAccountsForOrganizationResponse {
        if (!response.status.isSuccess()) {
            throwDescribeAffectedAccountsForOrganizationError(context, response)
        }
        val builder = DescribeAffectedAccountsForOrganizationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAffectedAccountsForOrganizationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeAffectedAccountsForOrganizationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw HealthException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidPaginationToken" -> InvalidPaginationTokenDeserializer().deserialize(context, wrappedResponse)
        else -> HealthException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAffectedAccountsForOrganizationOperationBody(builder: DescribeAffectedAccountsForOrganizationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AFFECTEDACCOUNTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("affectedAccounts"))
    val EVENTSCOPECODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("eventScopeCode"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AFFECTEDACCOUNTS_DESCRIPTOR)
        field(EVENTSCOPECODE_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AFFECTEDACCOUNTS_DESCRIPTOR.index -> builder.affectedAccounts =
                    deserializer.deserializeList(AFFECTEDACCOUNTS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                EVENTSCOPECODE_DESCRIPTOR.index -> builder.eventScopeCode = deserializeString().let { EventScopeCode.fromValue(it) }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
