// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.health.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.health.model.AffectedEntity
import aws.sdk.kotlin.services.health.model.DescribeAffectedEntitiesForOrganizationResponse
import aws.sdk.kotlin.services.health.model.HealthException
import aws.sdk.kotlin.services.health.model.OrganizationAffectedEntitiesErrorItem
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeAffectedEntitiesForOrganizationOperationDeserializer: HttpDeserialize<DescribeAffectedEntitiesForOrganizationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeAffectedEntitiesForOrganizationResponse {
        if (!response.status.isSuccess()) {
            throwDescribeAffectedEntitiesForOrganizationError(context, response)
        }
        val builder = DescribeAffectedEntitiesForOrganizationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAffectedEntitiesForOrganizationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeAffectedEntitiesForOrganizationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw HealthException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidPaginationToken" -> InvalidPaginationTokenDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedLocale" -> UnsupportedLocaleDeserializer().deserialize(context, wrappedResponse)
        else -> HealthException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAffectedEntitiesForOrganizationOperationBody(builder: DescribeAffectedEntitiesForOrganizationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENTITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("entities"))
    val FAILEDSET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failedSet"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENTITIES_DESCRIPTOR)
        field(FAILEDSET_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENTITIES_DESCRIPTOR.index -> builder.entities =
                    deserializer.deserializeList(ENTITIES_DESCRIPTOR) {
                        val col0 = mutableListOf<AffectedEntity>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAffectedEntityDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FAILEDSET_DESCRIPTOR.index -> builder.failedSet =
                    deserializer.deserializeList(FAILEDSET_DESCRIPTOR) {
                        val col0 = mutableListOf<OrganizationAffectedEntitiesErrorItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeOrganizationAffectedEntitiesErrorItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
