// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.health.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.health.model.DescribeEntityAggregatesResponse
import aws.sdk.kotlin.services.health.model.EntityAggregate
import aws.sdk.kotlin.services.health.model.HealthException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeEntityAggregatesOperationDeserializer: HttpDeserialize<DescribeEntityAggregatesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeEntityAggregatesResponse {
        if (!response.status.isSuccess()) {
            throwDescribeEntityAggregatesError(context, response)
        }
        val builder = DescribeEntityAggregatesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeEntityAggregatesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeEntityAggregatesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw HealthException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> HealthException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeEntityAggregatesOperationBody(builder: DescribeEntityAggregatesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENTITYAGGREGATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("entityAggregates"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENTITYAGGREGATES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENTITYAGGREGATES_DESCRIPTOR.index -> builder.entityAggregates =
                    deserializer.deserializeList(ENTITYAGGREGATES_DESCRIPTOR) {
                        val col0 = mutableListOf<EntityAggregate>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEntityAggregateDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
