// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.health.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.health.model.DescribeEventDetailsResponse
import aws.sdk.kotlin.services.health.model.EventDetails
import aws.sdk.kotlin.services.health.model.EventDetailsErrorItem
import aws.sdk.kotlin.services.health.model.HealthException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeEventDetailsOperationDeserializer: HttpDeserialize<DescribeEventDetailsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeEventDetailsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeEventDetailsError(context, response)
        }
        val builder = DescribeEventDetailsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeEventDetailsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeEventDetailsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw HealthException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "UnsupportedLocale" -> UnsupportedLocaleDeserializer().deserialize(context, wrappedResponse)
        else -> HealthException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeEventDetailsOperationBody(builder: DescribeEventDetailsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILEDSET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failedSet"))
    val SUCCESSFULSET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("successfulSet"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILEDSET_DESCRIPTOR)
        field(SUCCESSFULSET_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILEDSET_DESCRIPTOR.index -> builder.failedSet =
                    deserializer.deserializeList(FAILEDSET_DESCRIPTOR) {
                        val col0 = mutableListOf<EventDetailsErrorItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEventDetailsErrorItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUCCESSFULSET_DESCRIPTOR.index -> builder.successfulSet =
                    deserializer.deserializeList(SUCCESSFULSET_DESCRIPTOR) {
                        val col0 = mutableListOf<EventDetails>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEventDetailsDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
