// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.health.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.health.model.DisableHealthServiceAccessForOrganizationResponse
import aws.sdk.kotlin.services.health.model.HealthException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class DisableHealthServiceAccessForOrganizationOperationDeserializer: HttpDeserialize<DisableHealthServiceAccessForOrganizationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DisableHealthServiceAccessForOrganizationResponse {
        if (!response.status.isSuccess()) {
            throwDisableHealthServiceAccessForOrganizationError(context, response)
        }
        val builder = DisableHealthServiceAccessForOrganizationResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwDisableHealthServiceAccessForOrganizationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw HealthException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConcurrentModificationException" -> ConcurrentModificationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> HealthException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
