// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.honeycode

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.honeycode.model.*
import aws.sdk.kotlin.services.honeycode.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Honeycode"
const val ServiceApiVersion: String = "2020-03-01"
const val SdkVersion: String = "0.16.0"

internal class DefaultHoneycodeClient(override val config: HoneycodeClient.Config) : HoneycodeClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * The BatchCreateTableRows API allows you to create one or more rows at the end of a table in a workbook. The API allows you to specify the values to set in some or all of the columns in the new rows.
     *
     *  If a column is not explicitly set in a specific row, then the column level formula specified in the table will be applied to the new row. If there is no column level formula but the last row of the table has a formula, then that formula will be copied down to the new row. If there is no column level formula and no formula in the last row of the table, then that column will be left blank for the new rows.
     */
    override suspend fun batchCreateTableRows(input: BatchCreateTableRowsRequest): BatchCreateTableRowsResponse {
        val op = SdkHttpOperation.build<BatchCreateTableRowsRequest, BatchCreateTableRowsResponse> {
            serializer = BatchCreateTableRowsOperationSerializer()
            deserializer = BatchCreateTableRowsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchCreateTableRows"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "honeycode"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The BatchDeleteTableRows API allows you to delete one or more rows from a table in a workbook. You need to specify the ids of the rows that you want to delete from the table.
     */
    override suspend fun batchDeleteTableRows(input: BatchDeleteTableRowsRequest): BatchDeleteTableRowsResponse {
        val op = SdkHttpOperation.build<BatchDeleteTableRowsRequest, BatchDeleteTableRowsResponse> {
            serializer = BatchDeleteTableRowsOperationSerializer()
            deserializer = BatchDeleteTableRowsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDeleteTableRows"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "honeycode"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The BatchUpdateTableRows API allows you to update one or more rows in a table in a workbook.
     *
     *  You can specify the values to set in some or all of the columns in the table for the specified rows. If a column is not explicitly specified in a particular row, then that column will not be updated for that row. To clear out the data in a specific cell, you need to set the value as an empty string ("").
     */
    override suspend fun batchUpdateTableRows(input: BatchUpdateTableRowsRequest): BatchUpdateTableRowsResponse {
        val op = SdkHttpOperation.build<BatchUpdateTableRowsRequest, BatchUpdateTableRowsResponse> {
            serializer = BatchUpdateTableRowsOperationSerializer()
            deserializer = BatchUpdateTableRowsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchUpdateTableRows"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "honeycode"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The BatchUpsertTableRows API allows you to upsert one or more rows in a table. The upsert operation takes a filter expression as input and evaluates it to find matching rows on the destination table. If matching rows are found, it will update the cells in the matching rows to new values specified in the request. If no matching rows are found, a new row is added at the end of the table and the cells in that row are set to the new values specified in the request.
     *
     *  You can specify the values to set in some or all of the columns in the table for the matching or newly appended rows. If a column is not explicitly specified for a particular row, then that column will not be updated for that row. To clear out the data in a specific cell, you need to set the value as an empty string ("").
     */
    override suspend fun batchUpsertTableRows(input: BatchUpsertTableRowsRequest): BatchUpsertTableRowsResponse {
        val op = SdkHttpOperation.build<BatchUpsertTableRowsRequest, BatchUpsertTableRowsResponse> {
            serializer = BatchUpsertTableRowsOperationSerializer()
            deserializer = BatchUpsertTableRowsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchUpsertTableRows"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "honeycode"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The DescribeTableDataImportJob API allows you to retrieve the status and details of a table data import job.
     */
    override suspend fun describeTableDataImportJob(input: DescribeTableDataImportJobRequest): DescribeTableDataImportJobResponse {
        val op = SdkHttpOperation.build<DescribeTableDataImportJobRequest, DescribeTableDataImportJobResponse> {
            serializer = DescribeTableDataImportJobOperationSerializer()
            deserializer = DescribeTableDataImportJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTableDataImportJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "honeycode"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The GetScreenData API allows retrieval of data from a screen in a Honeycode app. The API allows setting local variables in the screen to filter, sort or otherwise affect what will be displayed on the screen.
     */
    override suspend fun getScreenData(input: GetScreenDataRequest): GetScreenDataResponse {
        val op = SdkHttpOperation.build<GetScreenDataRequest, GetScreenDataResponse> {
            serializer = GetScreenDataOperationSerializer()
            deserializer = GetScreenDataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetScreenData"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "honeycode"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The InvokeScreenAutomation API allows invoking an action defined in a screen in a Honeycode app. The API allows setting local variables, which can then be used in the automation being invoked. This allows automating the Honeycode app interactions to write, update or delete data in the workbook.
     */
    override suspend fun invokeScreenAutomation(input: InvokeScreenAutomationRequest): InvokeScreenAutomationResponse {
        val op = SdkHttpOperation.build<InvokeScreenAutomationRequest, InvokeScreenAutomationResponse> {
            serializer = InvokeScreenAutomationOperationSerializer()
            deserializer = InvokeScreenAutomationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "InvokeScreenAutomation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "honeycode"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The ListTableColumns API allows you to retrieve a list of all the columns in a table in a workbook.
     */
    override suspend fun listTableColumns(input: ListTableColumnsRequest): ListTableColumnsResponse {
        val op = SdkHttpOperation.build<ListTableColumnsRequest, ListTableColumnsResponse> {
            serializer = ListTableColumnsOperationSerializer()
            deserializer = ListTableColumnsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTableColumns"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "honeycode"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The ListTableRows API allows you to retrieve a list of all the rows in a table in a workbook.
     */
    override suspend fun listTableRows(input: ListTableRowsRequest): ListTableRowsResponse {
        val op = SdkHttpOperation.build<ListTableRowsRequest, ListTableRowsResponse> {
            serializer = ListTableRowsOperationSerializer()
            deserializer = ListTableRowsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTableRows"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "honeycode"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The ListTables API allows you to retrieve a list of all the tables in a workbook.
     */
    override suspend fun listTables(input: ListTablesRequest): ListTablesResponse {
        val op = SdkHttpOperation.build<ListTablesRequest, ListTablesResponse> {
            serializer = ListTablesOperationSerializer()
            deserializer = ListTablesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTables"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "honeycode"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The ListTagsForResource API allows you to return a resource's tags.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "honeycode"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The QueryTableRows API allows you to use a filter formula to query for specific rows in a table.
     */
    override suspend fun queryTableRows(input: QueryTableRowsRequest): QueryTableRowsResponse {
        val op = SdkHttpOperation.build<QueryTableRowsRequest, QueryTableRowsResponse> {
            serializer = QueryTableRowsOperationSerializer()
            deserializer = QueryTableRowsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "QueryTableRows"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "honeycode"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The StartTableDataImportJob API allows you to start an import job on a table. This API will only return the id of the job that was started. To find out the status of the import request, you need to call the DescribeTableDataImportJob API.
     */
    override suspend fun startTableDataImportJob(input: StartTableDataImportJobRequest): StartTableDataImportJobResponse {
        val op = SdkHttpOperation.build<StartTableDataImportJobRequest, StartTableDataImportJobResponse> {
            serializer = StartTableDataImportJobOperationSerializer()
            deserializer = StartTableDataImportJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartTableDataImportJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "honeycode"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The TagResource API allows you to add tags to an ARN-able resource. Resource includes workbook, table, screen and screen-automation.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "honeycode"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The UntagResource API allows you to removes tags from an ARN-able resource. Resource includes workbook, table, screen and screen-automation.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "honeycode"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "honeycode")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
