// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.honeycode.model



class InvokeScreenAutomationRequest private constructor(builder: Builder) {
    /**
     * The ID of the app that contains the screen automation.
     */
    val appId: kotlin.String? = builder.appId
    /**
     * The request token for performing the automation action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will return the response of the previous call rather than performing the action again.
     *
     *  Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days.
     */
    val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The row ID for the automation if the automation is defined inside a block with source or list.
     */
    val rowId: kotlin.String? = builder.rowId
    /**
     * The ID of the automation action to be performed.
     */
    val screenAutomationId: kotlin.String? = builder.screenAutomationId
    /**
     * The ID of the screen that contains the screen automation.
     */
    val screenId: kotlin.String? = builder.screenId
    /**
     * Variables are specified as a map where the key is the name of the variable as defined on the screen. The value is an object which currently has only one property, rawValue, which holds the value of the variable to be passed to the screen. Any variables defined in a screen are required to be passed in the call.
     */
    val variables: Map<String, VariableValue>? = builder.variables
    /**
     * The ID of the workbook that contains the screen automation.
     */
    val workbookId: kotlin.String? = builder.workbookId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.honeycode.model.InvokeScreenAutomationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InvokeScreenAutomationRequest(")
        append("appId=$appId,")
        append("clientRequestToken=$clientRequestToken,")
        append("rowId=$rowId,")
        append("screenAutomationId=$screenAutomationId,")
        append("screenId=$screenId,")
        append("variables=*** Sensitive Data Redacted ***,")
        append("workbookId=$workbookId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appId?.hashCode() ?: 0
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (rowId?.hashCode() ?: 0)
        result = 31 * result + (screenAutomationId?.hashCode() ?: 0)
        result = 31 * result + (screenId?.hashCode() ?: 0)
        result = 31 * result + (variables?.hashCode() ?: 0)
        result = 31 * result + (workbookId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InvokeScreenAutomationRequest

        if (appId != other.appId) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (rowId != other.rowId) return false
        if (screenAutomationId != other.screenAutomationId) return false
        if (screenId != other.screenId) return false
        if (variables != other.variables) return false
        if (workbookId != other.workbookId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.honeycode.model.InvokeScreenAutomationRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the app that contains the screen automation.
         */
        var appId: kotlin.String? = null
        /**
         * The request token for performing the automation action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will return the response of the previous call rather than performing the action again.
         *
         *  Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days.
         */
        var clientRequestToken: kotlin.String? = null
        /**
         * The row ID for the automation if the automation is defined inside a block with source or list.
         */
        var rowId: kotlin.String? = null
        /**
         * The ID of the automation action to be performed.
         */
        var screenAutomationId: kotlin.String? = null
        /**
         * The ID of the screen that contains the screen automation.
         */
        var screenId: kotlin.String? = null
        /**
         * Variables are specified as a map where the key is the name of the variable as defined on the screen. The value is an object which currently has only one property, rawValue, which holds the value of the variable to be passed to the screen. Any variables defined in a screen are required to be passed in the call.
         */
        var variables: Map<String, VariableValue>? = null
        /**
         * The ID of the workbook that contains the screen automation.
         */
        var workbookId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.honeycode.model.InvokeScreenAutomationRequest) : this() {
            this.appId = x.appId
            this.clientRequestToken = x.clientRequestToken
            this.rowId = x.rowId
            this.screenAutomationId = x.screenAutomationId
            this.screenId = x.screenId
            this.variables = x.variables
            this.workbookId = x.workbookId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.honeycode.model.InvokeScreenAutomationRequest = InvokeScreenAutomationRequest(this)
    }
}
