// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.honeycode.model



class StartTableDataImportJobRequest private constructor(builder: Builder) {
    /**
     * The request token for performing the update action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again.
     *
     *  Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days.
     */
    val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The format of the data that is being imported. Currently the only option supported is "DELIMITED_TEXT".
     */
    val dataFormat: aws.sdk.kotlin.services.honeycode.model.ImportSourceDataFormat? = builder.dataFormat
    /**
     * The source of the data that is being imported. The size of source must be no larger than 100 MB. Source must have no more than 100,000 cells and no more than 1,000 rows.
     */
    val dataSource: aws.sdk.kotlin.services.honeycode.model.ImportDataSource? = builder.dataSource
    /**
     * The ID of the table where the rows are being imported.
     *
     *  If a table with the specified id could not be found, this API throws ResourceNotFoundException.
     */
    val destinationTableId: kotlin.String? = builder.destinationTableId
    /**
     * The options for customizing this import request.
     */
    val importOptions: aws.sdk.kotlin.services.honeycode.model.ImportOptions? = builder.importOptions
    /**
     * The ID of the workbook where the rows are being imported.
     *
     *  If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
     */
    val workbookId: kotlin.String? = builder.workbookId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.honeycode.model.StartTableDataImportJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartTableDataImportJobRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("dataFormat=$dataFormat,")
        append("dataSource=$dataSource,")
        append("destinationTableId=$destinationTableId,")
        append("importOptions=$importOptions,")
        append("workbookId=$workbookId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (dataFormat?.hashCode() ?: 0)
        result = 31 * result + (dataSource?.hashCode() ?: 0)
        result = 31 * result + (destinationTableId?.hashCode() ?: 0)
        result = 31 * result + (importOptions?.hashCode() ?: 0)
        result = 31 * result + (workbookId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartTableDataImportJobRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (dataFormat != other.dataFormat) return false
        if (dataSource != other.dataSource) return false
        if (destinationTableId != other.destinationTableId) return false
        if (importOptions != other.importOptions) return false
        if (workbookId != other.workbookId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.honeycode.model.StartTableDataImportJobRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The request token for performing the update action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again.
         *
         *  Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days.
         */
        var clientRequestToken: kotlin.String? = null
        /**
         * The format of the data that is being imported. Currently the only option supported is "DELIMITED_TEXT".
         */
        var dataFormat: aws.sdk.kotlin.services.honeycode.model.ImportSourceDataFormat? = null
        /**
         * The source of the data that is being imported. The size of source must be no larger than 100 MB. Source must have no more than 100,000 cells and no more than 1,000 rows.
         */
        var dataSource: aws.sdk.kotlin.services.honeycode.model.ImportDataSource? = null
        /**
         * The ID of the table where the rows are being imported.
         *
         *  If a table with the specified id could not be found, this API throws ResourceNotFoundException.
         */
        var destinationTableId: kotlin.String? = null
        /**
         * The options for customizing this import request.
         */
        var importOptions: aws.sdk.kotlin.services.honeycode.model.ImportOptions? = null
        /**
         * The ID of the workbook where the rows are being imported.
         *
         *  If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
         */
        var workbookId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.honeycode.model.StartTableDataImportJobRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.dataFormat = x.dataFormat
            this.dataSource = x.dataSource
            this.destinationTableId = x.destinationTableId
            this.importOptions = x.importOptions
            this.workbookId = x.workbookId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.honeycode.model.StartTableDataImportJobRequest = StartTableDataImportJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.honeycode.model.ImportDataSource] inside the given [block]
         */
        fun dataSource(block: aws.sdk.kotlin.services.honeycode.model.ImportDataSource.Builder.() -> kotlin.Unit) {
            this.dataSource = aws.sdk.kotlin.services.honeycode.model.ImportDataSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.honeycode.model.ImportOptions] inside the given [block]
         */
        fun importOptions(block: aws.sdk.kotlin.services.honeycode.model.ImportOptions.Builder.() -> kotlin.Unit) {
            this.importOptions = aws.sdk.kotlin.services.honeycode.model.ImportOptions.invoke(block)
        }
    }
}
