// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.honeycode.model



/**
 * Data needed to upsert rows in a table as part of a single item in the BatchUpsertTableRows request.
 */
class UpsertRowData private constructor(builder: Builder) {
    /**
     * An external identifier that represents a single item in the request that is being upserted as part of the BatchUpsertTableRows request. This can be any string that you can use to identify the item in the request. The BatchUpsertTableRows API puts the batch item id in the results to allow you to link data in the request to data in the results.
     */
    val batchItemId: kotlin.String? = builder.batchItemId
    /**
     * A map representing the cells to update for the matching rows or an appended row. The key is the column id of the cell and the value is the CellInput object that represents the data to set in that cell.
     */
    val cellsToUpdate: Map<String, CellInput>? = builder.cellsToUpdate
    /**
     * The filter formula to use to find existing matching rows to update. The formula needs to return zero or more rows. If the formula returns 0 rows, then a new row will be appended in the target table. If the formula returns one or more rows, then the returned rows will be updated.
     *
     *  Note that the filter formula needs to return rows from the target table for the upsert operation to succeed. If the filter formula has a syntax error or it doesn't evaluate to zero or more rows in the target table for any one item in the input list, then the entire BatchUpsertTableRows request fails and no updates are made to the table.
     */
    val filter: aws.sdk.kotlin.services.honeycode.model.Filter? = builder.filter

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.honeycode.model.UpsertRowData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpsertRowData(")
        append("batchItemId=$batchItemId,")
        append("cellsToUpdate=$cellsToUpdate,")
        append("filter=$filter)")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchItemId?.hashCode() ?: 0
        result = 31 * result + (cellsToUpdate?.hashCode() ?: 0)
        result = 31 * result + (filter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpsertRowData

        if (batchItemId != other.batchItemId) return false
        if (cellsToUpdate != other.cellsToUpdate) return false
        if (filter != other.filter) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.honeycode.model.UpsertRowData = Builder(this).apply(block).build()

    class Builder {
        /**
         * An external identifier that represents a single item in the request that is being upserted as part of the BatchUpsertTableRows request. This can be any string that you can use to identify the item in the request. The BatchUpsertTableRows API puts the batch item id in the results to allow you to link data in the request to data in the results.
         */
        var batchItemId: kotlin.String? = null
        /**
         * A map representing the cells to update for the matching rows or an appended row. The key is the column id of the cell and the value is the CellInput object that represents the data to set in that cell.
         */
        var cellsToUpdate: Map<String, CellInput>? = null
        /**
         * The filter formula to use to find existing matching rows to update. The formula needs to return zero or more rows. If the formula returns 0 rows, then a new row will be appended in the target table. If the formula returns one or more rows, then the returned rows will be updated.
         *
         *  Note that the filter formula needs to return rows from the target table for the upsert operation to succeed. If the filter formula has a syntax error or it doesn't evaluate to zero or more rows in the target table for any one item in the input list, then the entire BatchUpsertTableRows request fails and no updates are made to the table.
         */
        var filter: aws.sdk.kotlin.services.honeycode.model.Filter? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.honeycode.model.UpsertRowData) : this() {
            this.batchItemId = x.batchItemId
            this.cellsToUpdate = x.cellsToUpdate
            this.filter = x.filter
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.honeycode.model.UpsertRowData = UpsertRowData(this)

        /**
         * construct an [aws.sdk.kotlin.services.honeycode.model.Filter] inside the given [block]
         */
        fun filter(block: aws.sdk.kotlin.services.honeycode.model.Filter.Builder.() -> kotlin.Unit) {
            this.filter = aws.sdk.kotlin.services.honeycode.model.Filter.invoke(block)
        }
    }
}
