// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.honeycode.transform

import aws.sdk.kotlin.services.honeycode.model.BatchCreateTableRowsRequest
import aws.sdk.kotlin.services.honeycode.model.CreateRowData
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class BatchCreateTableRowsOperationSerializer: HttpSerialize<BatchCreateTableRowsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: BatchCreateTableRowsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "workbooks",
                "${input.workbookId}".encodeLabel(),
                "tables",
                "${input.tableId}".encodeLabel(),
                "rows",
                "batchcreate",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeBatchCreateTableRowsOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeBatchCreateTableRowsOperationBody(context: ExecutionContext, input: BatchCreateTableRowsRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val ROWSTOCREATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("rowsToCreate"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(ROWSTOCREATE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) }
        if (input.rowsToCreate != null) {
            listField(ROWSTOCREATE_DESCRIPTOR) {
                for (el0 in input.rowsToCreate) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeCreateRowDataDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
