// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.honeycode.model



class ListTableRowsRequest private constructor(builder: Builder) {
    /**
     * The maximum number of rows to return in each page of the results.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
     *
     *  Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * This parameter is optional. If one or more row ids are specified in this list, then only the specified row ids are returned in the result. If no row ids are specified here, then all the rows in the table are returned.
     */
    val rowIds: List<String>? = builder.rowIds
    /**
     * The ID of the table whose rows are being retrieved.
     *
     *  If a table with the specified id could not be found, this API throws ResourceNotFoundException.
     */
    val tableId: kotlin.String? = builder.tableId
    /**
     * The ID of the workbook that contains the table whose rows are being retrieved.
     *
     *  If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
     */
    val workbookId: kotlin.String? = builder.workbookId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.honeycode.model.ListTableRowsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListTableRowsRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("rowIds=$rowIds,")
        append("tableId=$tableId,")
        append("workbookId=$workbookId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (rowIds?.hashCode() ?: 0)
        result = 31 * result + (tableId?.hashCode() ?: 0)
        result = 31 * result + (workbookId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListTableRowsRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (rowIds != other.rowIds) return false
        if (tableId != other.tableId) return false
        if (workbookId != other.workbookId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.honeycode.model.ListTableRowsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The maximum number of rows to return in each page of the results.
         */
        var maxResults: kotlin.Int? = null
        /**
         * This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
         *
         *  Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException.
         */
        var nextToken: kotlin.String? = null
        /**
         * This parameter is optional. If one or more row ids are specified in this list, then only the specified row ids are returned in the result. If no row ids are specified here, then all the rows in the table are returned.
         */
        var rowIds: List<String>? = null
        /**
         * The ID of the table whose rows are being retrieved.
         *
         *  If a table with the specified id could not be found, this API throws ResourceNotFoundException.
         */
        var tableId: kotlin.String? = null
        /**
         * The ID of the workbook that contains the table whose rows are being retrieved.
         *
         *  If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
         */
        var workbookId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.honeycode.model.ListTableRowsRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.rowIds = x.rowIds
            this.tableId = x.tableId
            this.workbookId = x.workbookId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.honeycode.model.ListTableRowsRequest = ListTableRowsRequest(this)
    }
}
