// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.honeycode.paginators

import aws.sdk.kotlin.services.honeycode.HoneycodeClient
import aws.sdk.kotlin.services.honeycode.model.ListTableColumnsRequest
import aws.sdk.kotlin.services.honeycode.model.ListTableColumnsResponse
import aws.sdk.kotlin.services.honeycode.model.ListTableRowsRequest
import aws.sdk.kotlin.services.honeycode.model.ListTableRowsResponse
import aws.sdk.kotlin.services.honeycode.model.ListTablesRequest
import aws.sdk.kotlin.services.honeycode.model.ListTablesResponse
import aws.sdk.kotlin.services.honeycode.model.QueryTableRowsRequest
import aws.sdk.kotlin.services.honeycode.model.QueryTableRowsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListTableColumnsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTableColumnsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTableColumnsResponse]
 */
fun HoneycodeClient.listTableColumnsPaginated(initialRequest: ListTableColumnsRequest): Flow<ListTableColumnsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTableColumnsPaginated.listTableColumns(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTableColumnsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTableColumnsResponse]
 */
fun HoneycodeClient.listTableColumnsPaginated(block: ListTableColumnsRequest.Builder.() -> Unit): Flow<ListTableColumnsResponse> =
    listTableColumnsPaginated(ListTableColumnsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTableRowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTableRowsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTableRowsResponse]
 */
fun HoneycodeClient.listTableRowsPaginated(initialRequest: ListTableRowsRequest): Flow<ListTableRowsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTableRowsPaginated.listTableRows(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTableRowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTableRowsResponse]
 */
fun HoneycodeClient.listTableRowsPaginated(block: ListTableRowsRequest.Builder.() -> Unit): Flow<ListTableRowsResponse> =
    listTableRowsPaginated(ListTableRowsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTablesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTablesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTablesResponse]
 */
fun HoneycodeClient.listTablesPaginated(initialRequest: ListTablesRequest): Flow<ListTablesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTablesPaginated.listTables(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTablesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTablesResponse]
 */
fun HoneycodeClient.listTablesPaginated(block: ListTablesRequest.Builder.() -> Unit): Flow<ListTablesResponse> =
    listTablesPaginated(ListTablesRequest.Builder().apply(block).build())

/**
 * Paginate over [QueryTableRowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [QueryTableRowsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [QueryTableRowsResponse]
 */
fun HoneycodeClient.queryTableRowsPaginated(initialRequest: QueryTableRowsRequest): Flow<QueryTableRowsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@queryTableRowsPaginated.queryTableRows(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [QueryTableRowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [QueryTableRowsResponse]
 */
fun HoneycodeClient.queryTableRowsPaginated(block: QueryTableRowsRequest.Builder.() -> Unit): Flow<QueryTableRowsResponse> =
    queryTableRowsPaginated(QueryTableRowsRequest.Builder().apply(block).build())
