/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.runtime.http.engine.crt;

import aws.sdk.kotlin.crt.CRT;
import aws.sdk.kotlin.crt.http.HttpClientConnection;
import aws.sdk.kotlin.crt.http.HttpHeader;
import aws.sdk.kotlin.crt.http.HttpHeaderBlock;
import aws.sdk.kotlin.crt.http.HttpStream;
import aws.sdk.kotlin.crt.http.HttpStreamResponseHandler;
import aws.sdk.kotlin.crt.io.Buffer;
import aws.sdk.kotlin.runtime.ClientException;
import aws.sdk.kotlin.runtime.http.engine.crt.BufferedReadChannel;
import aws.sdk.kotlin.runtime.http.engine.crt.BufferedReadChannelJVMKt;
import aws.smithy.kotlin.runtime.http.HeadersBuilder;
import aws.smithy.kotlin.runtime.http.HttpBody;
import aws.smithy.kotlin.runtime.http.HttpStatusCode;
import aws.smithy.kotlin.runtime.http.HttpStatusCodeKt;
import aws.smithy.kotlin.runtime.http.response.HttpResponse;
import aws.smithy.kotlin.runtime.io.SdkByteReadChannel;
import aws.smithy.kotlin.runtime.logging.Logger;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\b\u0000\u0018\u00002\u00020BB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\b\u001a\u00020\u0005H\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ7\u0010 \u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000e2\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dH\u0016\u00a2\u0006\u0004\b \u0010!J\u001f\u0010\"\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\"\u0010\u001aJ\u0017\u0010#\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b#\u0010$J\u0013\u0010(\u001a\u00020%H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b&\u0010'R\u0016\u0010*\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0014\u0010\u0002\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010,R\u0018\u0010-\u001a\u0004\u0018\u00010\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0014\u00100\u001a\u00020/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0014\u00103\u001a\u0002028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0014\u00106\u001a\u0002058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107R\u001a\u00109\u001a\b\u0012\u0004\u0012\u00020%088\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0018\u0010<\u001a\u0004\u0018\u00010;8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b<\u0010=R\u0016\u0010>\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010+R\u0018\u0010?\u001a\u00020)*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010@\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006A"}, d2={"Laws/sdk/kotlin/runtime/http/engine/crt/SdkStreamResponseHandler;", "Laws/sdk/kotlin/crt/http/HttpClientConnection;", "conn", "<init>", "(Laws/sdk/kotlin/crt/http/HttpClientConnection;)V", "", "complete$http_client_engine_crt", "()V", "complete", "", "contentLength", "Laws/smithy/kotlin/runtime/http/HttpBody;", "createHttpResponseBody", "(J)Laws/smithy/kotlin/runtime/http/HttpBody;", "", "size", "onDataConsumed", "(I)V", "Laws/sdk/kotlin/crt/http/HttpStream;", "stream", "Laws/sdk/kotlin/crt/io/Buffer;", "bodyBytesIn", "onResponseBody", "(Laws/sdk/kotlin/crt/http/HttpStream;Laws/sdk/kotlin/crt/io/Buffer;)I", "errorCode", "onResponseComplete", "(Laws/sdk/kotlin/crt/http/HttpStream;I)V", "responseStatusCode", "blockType", "", "Laws/sdk/kotlin/crt/http/HttpHeader;", "nextHeaders", "onResponseHeaders", "(Laws/sdk/kotlin/crt/http/HttpStream;IILjava/util/List;)V", "onResponseHeadersDone", "signalResponse", "(Laws/sdk/kotlin/crt/http/HttpStream;)V", "Laws/smithy/kotlin/runtime/http/response/HttpResponse;", "waitForResponse$http_client_engine_crt", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "waitForResponse", "", "cancelled", "Z", "Laws/sdk/kotlin/crt/http/HttpClientConnection;", "crtStream", "Laws/sdk/kotlin/crt/http/HttpStream;", "Laws/smithy/kotlin/runtime/http/HeadersBuilder;", "headers", "Laws/smithy/kotlin/runtime/http/HeadersBuilder;", "Ljava/util/concurrent/locks/ReentrantLock;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "Laws/smithy/kotlin/runtime/logging/Logger;", "logger", "Laws/smithy/kotlin/runtime/logging/Logger;", "Lkotlinx/coroutines/channels/Channel;", "responseReady", "Lkotlinx/coroutines/channels/Channel;", "Laws/sdk/kotlin/runtime/http/engine/crt/BufferedReadChannel;", "sdkBody", "Laws/sdk/kotlin/runtime/http/engine/crt/BufferedReadChannel;", "streamCompleted", "isMainHeadersBlock", "(I)Z", "http-client-engine-crt", "Laws/sdk/kotlin/crt/http/HttpStreamResponseHandler;"})
public final class SdkStreamResponseHandler
implements HttpStreamResponseHandler {
    @NotNull
    private final HttpClientConnection conn;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Channel<HttpResponse> responseReady;
    @NotNull
    private final HeadersBuilder headers;
    @Nullable
    private BufferedReadChannel sdkBody;
    @NotNull
    private final ReentrantLock lock;
    @Nullable
    private HttpStream crtStream;
    private boolean cancelled;
    private boolean streamCompleted;

    public SdkStreamResponseHandler(@NotNull HttpClientConnection conn2) {
        Intrinsics.checkNotNullParameter((Object)conn2, (String)"conn");
        this.conn = conn2;
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$getLogger = false;
        Logger.Companion companion = this_$iv;
        String string = Reflection.getOrCreateKotlinClass(SdkStreamResponseHandler.class).getQualifiedName();
        if (string == null) {
            Logger.Companion companion2 = companion;
            boolean bl = false;
            Logger.Companion companion3 = companion2;
            String string2 = "getLogger<T> cannot be used on an anonymous object";
            throw new IllegalArgumentException(string2.toString());
        }
        this.logger = companion.getLogger(string);
        this.responseReady = ChannelKt.Channel$default((int)1, null, null, (int)6, null);
        this.headers = new HeadersBuilder();
        this.lock = new ReentrantLock();
    }

    private final boolean isMainHeadersBlock(int $this$isMainHeadersBlock) {
        return $this$isMainHeadersBlock == HttpHeaderBlock.MAIN.getBlockType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onDataConsumed(int size) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Unit unit;
            boolean bl = false;
            HttpStream httpStream = this.crtStream;
            if (httpStream == null) {
                unit = null;
            } else {
                httpStream.incrementWindow(size);
                unit = Unit.INSTANCE;
            }
            Unit unit2 = unit;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public void onResponseHeaders(@NotNull HttpStream stream, int responseStatusCode, int blockType, @Nullable List<HttpHeader> nextHeaders) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        if (!this.isMainHeadersBlock(blockType)) {
            return;
        }
        List<HttpHeader> list = nextHeaders;
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HttpHeader it = (HttpHeader)element$iv;
                boolean bl = false;
                this.headers.append(it.getName(), it.getValue());
            }
        }
    }

    private final HttpBody createHttpResponseBody(long contentLength) {
        this.sdkBody = BufferedReadChannelJVMKt.bufferedReadChannel((Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>((Object)this){

            public final void invoke(int p0) {
                SdkStreamResponseHandler.access$onDataConsumed((SdkStreamResponseHandler)this.receiver, p0);
            }
        }));
        return (HttpBody)new HttpBody.Streaming(contentLength, this){
            private final long contentLength;
            final /* synthetic */ long $contentLength;
            final /* synthetic */ SdkStreamResponseHandler this$0;
            {
                this.$contentLength = $contentLength;
                this.this$0 = $receiver;
                this.contentLength = this.$contentLength;
            }

            @NotNull
            public Long getContentLength() {
                return this.contentLength;
            }

            @NotNull
            public SdkByteReadChannel readFrom() {
                BufferedReadChannel bufferedReadChannel = SdkStreamResponseHandler.access$getSdkBody$p(this.this$0);
                Intrinsics.checkNotNull((Object)bufferedReadChannel);
                return bufferedReadChannel;
            }
        };
    }

    private final void signalResponse(HttpStream stream) {
        HttpBody httpBody;
        Object[] objectArray;
        boolean hasBody;
        long l;
        String string;
        if (this.responseReady.isClosedForSend()) {
            return;
        }
        String string2 = this.headers.get("Transfer-Encoding");
        if (string2 == null) {
            string = null;
        } else {
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            string = string3;
        }
        String transferEncoding = string;
        boolean chunked = Intrinsics.areEqual(transferEncoding, (Object)"chunked");
        String string4 = this.headers.get("Content-Length");
        long contentLength = string4 == null ? 0L : (l = Long.parseLong(string4));
        HttpStatusCode status = HttpStatusCode.Companion.fromValue(stream.getResponseStatusCode());
        boolean bl = hasBody = (contentLength > 0L || chunked) && !CollectionsKt.listOf((Object[])(objectArray = new HttpStatusCode[]{HttpStatusCode.Companion.getNotModified(), HttpStatusCode.Companion.getNoContent()})).contains(status) && !HttpStatusCodeKt.isInformational((HttpStatusCode)status);
        if (!bl) {
            httpBody = (HttpBody)HttpBody.Empty.INSTANCE;
        } else if (bl) {
            httpBody = this.createHttpResponseBody(contentLength);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        HttpBody body = httpBody;
        HttpResponse resp = new HttpResponse(status, this.headers.build(), body);
        Object result = this.responseReady.trySend-JP2dKIU((Object)resp);
        if (!ChannelResult.isSuccess-impl((Object)result)) {
            boolean bl2 = false;
            String string5 = Intrinsics.stringPlus((String)"signalling response failed, result was: ", (Object)ChannelResult.exceptionOrNull-impl((Object)result));
            throw new IllegalStateException(string5.toString());
        }
        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.responseReady), null, (int)1, null);
    }

    public void onResponseHeadersDone(@NotNull HttpStream stream, int blockType) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        if (!this.isMainHeadersBlock(blockType)) {
            return;
        }
        this.signalResponse(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onResponseBody(@NotNull HttpStream stream, @NotNull Buffer bodyBytesIn) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)bodyBytesIn, (String)"bodyBytesIn");
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl2 = false;
            this.crtStream = stream;
            bl = this.cancelled;
        }
        finally {
            reentrantLock.unlock();
        }
        boolean isCancelled = bl;
        if (isCancelled) {
            return bodyBytesIn.getLen();
        }
        BufferedReadChannel bufferedReadChannel = this.sdkBody;
        if (bufferedReadChannel == null) {
            boolean bl3 = false;
            String string = "unexpected response body";
            throw new IllegalStateException(string.toString());
        }
        BufferedReadChannel sdkRespChan = bufferedReadChannel;
        sdkRespChan.write(bodyBytesIn);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponseComplete(@NotNull HttpStream stream, int errorCode) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            this.crtStream = null;
            this.streamCompleted = true;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            reentrantLock.unlock();
        }
        if (errorCode != 0) {
            String errorDescription = CRT.INSTANCE.errorString(errorCode);
            ClientException ex = new ClientException("CrtHttpEngine::response failed: ec=" + errorCode + "; description=" + errorDescription);
            this.responseReady.close((Throwable)ex);
            BufferedReadChannel bufferedReadChannel = this.sdkBody;
            if (bufferedReadChannel != null) {
                bufferedReadChannel.cancel((Throwable)ex);
            }
        } else {
            BufferedReadChannel bufferedReadChannel = this.sdkBody;
            if (bufferedReadChannel != null) {
                bufferedReadChannel.close();
            }
            this.signalResponse(stream);
        }
    }

    @Nullable
    public final Object waitForResponse$http_client_engine_crt(@NotNull Continuation<? super HttpResponse> $completion) {
        return this.responseReady.receive($completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void complete$http_client_engine_crt() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean forceClose;
            boolean bl = false;
            boolean bl2 = forceClose = !this.streamCompleted;
            if (forceClose) {
                this.logger.debug((Function0)new Function0<Object>(this){
                    final /* synthetic */ SdkStreamResponseHandler this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "stream did not complete before job, forcing connection shutdown! handler=" + this.this$0 + "; conn=" + SdkStreamResponseHandler.access$getConn$p(this.this$0) + "; stream=" + SdkStreamResponseHandler.access$getCrtStream$p(this.this$0);
                    }
                });
                this.conn.shutdown();
                this.cancelled = true;
            }
            this.conn.close();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public static final /* synthetic */ void access$onDataConsumed(SdkStreamResponseHandler $this, int size) {
        $this.onDataConsumed(size);
    }

    public static final /* synthetic */ BufferedReadChannel access$getSdkBody$p(SdkStreamResponseHandler $this) {
        return $this.sdkBody;
    }

    public static final /* synthetic */ HttpClientConnection access$getConn$p(SdkStreamResponseHandler $this) {
        return $this.conn;
    }

    public static final /* synthetic */ HttpStream access$getCrtStream$p(SdkStreamResponseHandler $this) {
        return $this.crtStream;
    }
}

