// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.iam.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.iam.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * <fullname>Identity and Access Management</fullname>
 * Identity and Access Management (IAM) is a web service for securely controlling
 * access to Amazon Web Services services. With IAM, you can centrally manage users, security credentials
 * such as access keys, and permissions that control which Amazon Web Services resources users and
 * applications can access. For more information about IAM, see <a href="http://aws.amazon.com/iam/">Identity and Access Management (IAM) and the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/">Identity and Access Management User Guide.
 */
interface IamClient : SdkClient {

    override val serviceName: String
        get() = "IAM"
    /**
     * IamClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): IamClient {
            val config = Config.Builder().apply(block).build()
            return DefaultIamClient(config)
        }

        operator fun invoke(config: Config): IamClient = DefaultIamClient(config)

        /**
         * Construct a [IamClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): IamClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultIamClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds a new client ID (also known as audience) to the list of client IDs already
     * registered for the specified IAM OpenID Connect (OIDC) provider resource.
     * This operation is idempotent; it does not fail or return an error if you add an
     * existing client ID to the provider.
     */
    suspend fun addClientIdToOpenIdConnectProvider(input: AddClientIdToOpenIdConnectProviderRequest): AddClientIdToOpenIdConnectProviderResponse

    /**
     * Adds a new client ID (also known as audience) to the list of client IDs already
     * registered for the specified IAM OpenID Connect (OIDC) provider resource.
     * This operation is idempotent; it does not fail or return an error if you add an
     * existing client ID to the provider.
     */
    suspend fun addClientIdToOpenIdConnectProvider(block: AddClientIdToOpenIdConnectProviderRequest.Builder.() -> Unit) = addClientIdToOpenIdConnectProvider(AddClientIdToOpenIdConnectProviderRequest.Builder().apply(block).build())

    /**
     * Adds the specified IAM role to the specified instance profile. An instance profile
     * can contain only one role, and this quota cannot be increased. You can remove the
     * existing role and then add a different role to an instance profile. You must then wait
     * for the change to appear across all of Amazon Web Services because of <a href="https://en.wikipedia.org/wiki/Eventual_consistency">eventual
     * consistency. To force the change, you must <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIamInstanceProfile.html">disassociate the instance profile and then <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateIamInstanceProfile.html">associate the
     * instance profile, or you can stop your instance and then restart it.
     *
     * The caller of this operation must be granted the PassRole permission
     * on the IAM role by a permissions policy.
     *
     * For more information about roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with roles. For more
     * information about instance profiles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance
     * profiles.
     */
    suspend fun addRoleToInstanceProfile(input: AddRoleToInstanceProfileRequest): AddRoleToInstanceProfileResponse

    /**
     * Adds the specified IAM role to the specified instance profile. An instance profile
     * can contain only one role, and this quota cannot be increased. You can remove the
     * existing role and then add a different role to an instance profile. You must then wait
     * for the change to appear across all of Amazon Web Services because of <a href="https://en.wikipedia.org/wiki/Eventual_consistency">eventual
     * consistency. To force the change, you must <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIamInstanceProfile.html">disassociate the instance profile and then <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateIamInstanceProfile.html">associate the
     * instance profile, or you can stop your instance and then restart it.
     *
     * The caller of this operation must be granted the PassRole permission
     * on the IAM role by a permissions policy.
     *
     * For more information about roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with roles. For more
     * information about instance profiles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance
     * profiles.
     */
    suspend fun addRoleToInstanceProfile(block: AddRoleToInstanceProfileRequest.Builder.() -> Unit) = addRoleToInstanceProfile(AddRoleToInstanceProfileRequest.Builder().apply(block).build())

    /**
     * Adds the specified user to the specified group.
     */
    suspend fun addUserToGroup(input: AddUserToGroupRequest): AddUserToGroupResponse

    /**
     * Adds the specified user to the specified group.
     */
    suspend fun addUserToGroup(block: AddUserToGroupRequest.Builder.() -> Unit) = addUserToGroup(AddUserToGroupRequest.Builder().apply(block).build())

    /**
     * Attaches the specified managed policy to the specified IAM group.
     * You use this operation to attach a managed policy to a group. To embed an inline
     * policy in a group, use PutGroupPolicy.
     * As a best practice, you can validate your IAM policies.
     * To learn more, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM policies
     * in the IAM User Guide.
     * For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     */
    suspend fun attachGroupPolicy(input: AttachGroupPolicyRequest): AttachGroupPolicyResponse

    /**
     * Attaches the specified managed policy to the specified IAM group.
     * You use this operation to attach a managed policy to a group. To embed an inline
     * policy in a group, use PutGroupPolicy.
     * As a best practice, you can validate your IAM policies.
     * To learn more, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM policies
     * in the IAM User Guide.
     * For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     */
    suspend fun attachGroupPolicy(block: AttachGroupPolicyRequest.Builder.() -> Unit) = attachGroupPolicy(AttachGroupPolicyRequest.Builder().apply(block).build())

    /**
     * Attaches the specified managed policy to the specified IAM role. When you attach a
     * managed policy to a role, the managed policy becomes part of the role's permission
     * (access) policy.
     *
     * You cannot use a managed policy as the role's trust policy. The role's trust
     * policy is created at the same time as the role, using CreateRole.
     * You can update a role's trust policy using UpdateAssumeRolePolicy.
     *
     * Use this operation to attach a managed policy to a role. To embed
     * an inline policy in a role, use PutRolePolicy. For more information
     * about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     * As a best practice, you can validate your IAM policies.
     * To learn more, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM policies
     * in the IAM User Guide.
     */
    suspend fun attachRolePolicy(input: AttachRolePolicyRequest): AttachRolePolicyResponse

    /**
     * Attaches the specified managed policy to the specified IAM role. When you attach a
     * managed policy to a role, the managed policy becomes part of the role's permission
     * (access) policy.
     *
     * You cannot use a managed policy as the role's trust policy. The role's trust
     * policy is created at the same time as the role, using CreateRole.
     * You can update a role's trust policy using UpdateAssumeRolePolicy.
     *
     * Use this operation to attach a managed policy to a role. To embed
     * an inline policy in a role, use PutRolePolicy. For more information
     * about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     * As a best practice, you can validate your IAM policies.
     * To learn more, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM policies
     * in the IAM User Guide.
     */
    suspend fun attachRolePolicy(block: AttachRolePolicyRequest.Builder.() -> Unit) = attachRolePolicy(AttachRolePolicyRequest.Builder().apply(block).build())

    /**
     * Attaches the specified managed policy to the specified user.
     * You use this operation to attach a managed policy to a user. To
     * embed an inline policy in a user, use PutUserPolicy.
     * As a best practice, you can validate your IAM policies.
     * To learn more, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM policies
     * in the IAM User Guide.
     * For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     */
    suspend fun attachUserPolicy(input: AttachUserPolicyRequest): AttachUserPolicyResponse

    /**
     * Attaches the specified managed policy to the specified user.
     * You use this operation to attach a managed policy to a user. To
     * embed an inline policy in a user, use PutUserPolicy.
     * As a best practice, you can validate your IAM policies.
     * To learn more, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM policies
     * in the IAM User Guide.
     * For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     */
    suspend fun attachUserPolicy(block: AttachUserPolicyRequest.Builder.() -> Unit) = attachUserPolicy(AttachUserPolicyRequest.Builder().apply(block).build())

    /**
     * Changes the password of the IAM user who is calling this operation. This operation
     * can be performed using the CLI, the Amazon Web Services API, or the My
     * Security Credentials page in the Amazon Web Services Management Console. The Amazon Web Services account root user
     * password is not affected by this operation.
     * Use UpdateLoginProfile to use the CLI, the Amazon Web Services API, or the
     * Users page in the IAM console to change the
     * password for any IAM user. For more information about modifying passwords, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing
     * passwords in the IAM User Guide.
     */
    suspend fun changePassword(input: ChangePasswordRequest): ChangePasswordResponse

    /**
     * Changes the password of the IAM user who is calling this operation. This operation
     * can be performed using the CLI, the Amazon Web Services API, or the My
     * Security Credentials page in the Amazon Web Services Management Console. The Amazon Web Services account root user
     * password is not affected by this operation.
     * Use UpdateLoginProfile to use the CLI, the Amazon Web Services API, or the
     * Users page in the IAM console to change the
     * password for any IAM user. For more information about modifying passwords, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing
     * passwords in the IAM User Guide.
     */
    suspend fun changePassword(block: ChangePasswordRequest.Builder.() -> Unit) = changePassword(ChangePasswordRequest.Builder().apply(block).build())

    /**
     * Creates a new Amazon Web Services secret access key and corresponding Amazon Web Services access key ID for the
     * specified user. The default status for new keys is Active.
     * If you do not specify a user name, IAM determines the user name implicitly based on
     * the Amazon Web Services access key ID signing the request. This operation works for access keys under
     * the Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web Services account root
     * user credentials. This is true even if the Amazon Web Services account has no associated users.
     * For information about quotas on the number of keys you can create, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS
     * quotas in the IAM User Guide.
     *
     * To ensure the security of your Amazon Web Services account, the secret access key is accessible
     * only during key and user creation. You must save the key (for example, in a text
     * file) if you want to be able to access it again. If a secret key is lost, you can
     * delete the access keys for the associated user and then create new keys.
     */
    suspend fun createAccessKey(input: CreateAccessKeyRequest): CreateAccessKeyResponse

    /**
     * Creates a new Amazon Web Services secret access key and corresponding Amazon Web Services access key ID for the
     * specified user. The default status for new keys is Active.
     * If you do not specify a user name, IAM determines the user name implicitly based on
     * the Amazon Web Services access key ID signing the request. This operation works for access keys under
     * the Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web Services account root
     * user credentials. This is true even if the Amazon Web Services account has no associated users.
     * For information about quotas on the number of keys you can create, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS
     * quotas in the IAM User Guide.
     *
     * To ensure the security of your Amazon Web Services account, the secret access key is accessible
     * only during key and user creation. You must save the key (for example, in a text
     * file) if you want to be able to access it again. If a secret key is lost, you can
     * delete the access keys for the associated user and then create new keys.
     */
    suspend fun createAccessKey(block: CreateAccessKeyRequest.Builder.() -> Unit) = createAccessKey(CreateAccessKeyRequest.Builder().apply(block).build())

    /**
     * Creates an alias for your Amazon Web Services account. For information about using an Amazon Web Services account
     * alias, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an
     * alias for your Amazon Web Services account ID in the
     * IAM User Guide.
     */
    suspend fun createAccountAlias(input: CreateAccountAliasRequest): CreateAccountAliasResponse

    /**
     * Creates an alias for your Amazon Web Services account. For information about using an Amazon Web Services account
     * alias, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an
     * alias for your Amazon Web Services account ID in the
     * IAM User Guide.
     */
    suspend fun createAccountAlias(block: CreateAccountAliasRequest.Builder.() -> Unit) = createAccountAlias(CreateAccountAliasRequest.Builder().apply(block).build())

    /**
     * Creates a new group.
     * For information about the number of groups you can create, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS
     * quotas in the IAM User Guide.
     */
    suspend fun createGroup(input: CreateGroupRequest): CreateGroupResponse

    /**
     * Creates a new group.
     * For information about the number of groups you can create, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS
     * quotas in the IAM User Guide.
     */
    suspend fun createGroup(block: CreateGroupRequest.Builder.() -> Unit) = createGroup(CreateGroupRequest.Builder().apply(block).build())

    /**
     * Creates a new instance profile. For information about instance profiles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html">Using
     * roles for applications on Amazon EC2 in the
     * IAM User Guide, and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-roles-for-amazon-ec2.html#ec2-instance-profile">Instance profiles in the Amazon EC2 User Guide.
     * For information about the number of instance profiles you can create, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM object
     * quotas in the IAM User Guide.
     */
    suspend fun createInstanceProfile(input: CreateInstanceProfileRequest): CreateInstanceProfileResponse

    /**
     * Creates a new instance profile. For information about instance profiles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html">Using
     * roles for applications on Amazon EC2 in the
     * IAM User Guide, and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-roles-for-amazon-ec2.html#ec2-instance-profile">Instance profiles in the Amazon EC2 User Guide.
     * For information about the number of instance profiles you can create, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM object
     * quotas in the IAM User Guide.
     */
    suspend fun createInstanceProfile(block: CreateInstanceProfileRequest.Builder.() -> Unit) = createInstanceProfile(CreateInstanceProfileRequest.Builder().apply(block).build())

    /**
     * Creates a password for the specified IAM user. A password allows an IAM user to
     * access Amazon Web Services services through the Amazon Web Services Management Console.
     * You can use the CLI, the Amazon Web Services API, or the Users
     * page in the IAM console to create a password for any IAM user. Use ChangePassword to update your own existing password in the My Security Credentials page in the Amazon Web Services Management Console.
     * For more information about managing passwords, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing passwords in the
     * IAM User Guide.
     */
    suspend fun createLoginProfile(input: CreateLoginProfileRequest): CreateLoginProfileResponse

    /**
     * Creates a password for the specified IAM user. A password allows an IAM user to
     * access Amazon Web Services services through the Amazon Web Services Management Console.
     * You can use the CLI, the Amazon Web Services API, or the Users
     * page in the IAM console to create a password for any IAM user. Use ChangePassword to update your own existing password in the My Security Credentials page in the Amazon Web Services Management Console.
     * For more information about managing passwords, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing passwords in the
     * IAM User Guide.
     */
    suspend fun createLoginProfile(block: CreateLoginProfileRequest.Builder.() -> Unit) = createLoginProfile(CreateLoginProfileRequest.Builder().apply(block).build())

    /**
     * Creates an IAM entity to describe an identity provider (IdP) that supports <a href="http://openid.net/connect/">OpenID Connect (OIDC).
     * The OIDC provider that you create with this operation can be used as a principal in a
     * role's trust policy. Such a policy establishes a trust relationship between Amazon Web Services and
     * the OIDC provider.
     * If you are using an OIDC identity provider from Google, Facebook, or Amazon Cognito, you don't
     * need to create a separate IAM identity provider. These OIDC identity providers are
     * already built-in to Amazon Web Services and are available for your use. Instead, you can move directly
     * to creating new roles using your identity provider. To learn more, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-idp_oidc.html">Creating
     * a role for web identity or OpenID connect federation in the IAM
     * User Guide.
     * When you create the IAM OIDC provider, you specify the following:
     *
     *
     * The URL of the OIDC identity provider (IdP) to trust
     *
     * A list of client IDs (also known as audiences) that identify the application
     * or applications allowed to authenticate using the OIDC provider
     *
     * A list of thumbprints of one or more server certificates that the IdP
     * uses
     *
     *
     * You get all of this information from the OIDC IdP you want to use to access
     * Amazon Web Services.
     *
     * Amazon Web Services secures communication with some OIDC identity providers (IdPs) through our
     * library of trusted certificate authorities (CAs) instead of using a certificate
     * thumbprint to verify your IdP server certificate. These OIDC IdPs include Google, and
     * those that use an Amazon S3 bucket to host a JSON Web Key Set (JWKS) endpoint. In these
     * cases, your legacy thumbprint remains in your configuration, but is no longer used for validation.
     *
     *
     * The trust for the OIDC provider is derived from the IAM provider that this
     * operation creates. Therefore, it is best to limit access to the CreateOpenIDConnectProvider operation to highly privileged
     * users.
     */
    suspend fun createOpenIdConnectProvider(input: CreateOpenIdConnectProviderRequest): CreateOpenIdConnectProviderResponse

    /**
     * Creates an IAM entity to describe an identity provider (IdP) that supports <a href="http://openid.net/connect/">OpenID Connect (OIDC).
     * The OIDC provider that you create with this operation can be used as a principal in a
     * role's trust policy. Such a policy establishes a trust relationship between Amazon Web Services and
     * the OIDC provider.
     * If you are using an OIDC identity provider from Google, Facebook, or Amazon Cognito, you don't
     * need to create a separate IAM identity provider. These OIDC identity providers are
     * already built-in to Amazon Web Services and are available for your use. Instead, you can move directly
     * to creating new roles using your identity provider. To learn more, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-idp_oidc.html">Creating
     * a role for web identity or OpenID connect federation in the IAM
     * User Guide.
     * When you create the IAM OIDC provider, you specify the following:
     *
     *
     * The URL of the OIDC identity provider (IdP) to trust
     *
     * A list of client IDs (also known as audiences) that identify the application
     * or applications allowed to authenticate using the OIDC provider
     *
     * A list of thumbprints of one or more server certificates that the IdP
     * uses
     *
     *
     * You get all of this information from the OIDC IdP you want to use to access
     * Amazon Web Services.
     *
     * Amazon Web Services secures communication with some OIDC identity providers (IdPs) through our
     * library of trusted certificate authorities (CAs) instead of using a certificate
     * thumbprint to verify your IdP server certificate. These OIDC IdPs include Google, and
     * those that use an Amazon S3 bucket to host a JSON Web Key Set (JWKS) endpoint. In these
     * cases, your legacy thumbprint remains in your configuration, but is no longer used for validation.
     *
     *
     * The trust for the OIDC provider is derived from the IAM provider that this
     * operation creates. Therefore, it is best to limit access to the CreateOpenIDConnectProvider operation to highly privileged
     * users.
     */
    suspend fun createOpenIdConnectProvider(block: CreateOpenIdConnectProviderRequest.Builder.() -> Unit) = createOpenIdConnectProvider(CreateOpenIdConnectProviderRequest.Builder().apply(block).build())

    /**
     * Creates a new managed policy for your Amazon Web Services account.
     * This operation creates a policy version with a version identifier of v1
     * and sets v1 as the policy's default version. For more information about policy versions,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed policies in the
     * IAM User Guide.
     * As a best practice, you can validate your IAM policies.
     * To learn more, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM policies
     * in the IAM User Guide.
     * For more information about managed policies in general, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed
     * policies and inline policies in the
     * IAM User Guide.
     */
    suspend fun createPolicy(input: CreatePolicyRequest): CreatePolicyResponse

    /**
     * Creates a new managed policy for your Amazon Web Services account.
     * This operation creates a policy version with a version identifier of v1
     * and sets v1 as the policy's default version. For more information about policy versions,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed policies in the
     * IAM User Guide.
     * As a best practice, you can validate your IAM policies.
     * To learn more, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM policies
     * in the IAM User Guide.
     * For more information about managed policies in general, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed
     * policies and inline policies in the
     * IAM User Guide.
     */
    suspend fun createPolicy(block: CreatePolicyRequest.Builder.() -> Unit) = createPolicy(CreatePolicyRequest.Builder().apply(block).build())

    /**
     * Creates a new version of the specified managed policy. To update a managed policy, you
     * create a new policy version. A managed policy can have up to five versions. If the
     * policy has five versions, you must delete an existing version using DeletePolicyVersion before you create a new version.
     * Optionally, you can set the new version as the policy's default version. The default
     * version is the version that is in effect for the IAM users, groups, and roles to which
     * the policy is attached.
     * For more information about managed policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies in the IAM User Guide.
     */
    suspend fun createPolicyVersion(input: CreatePolicyVersionRequest): CreatePolicyVersionResponse

    /**
     * Creates a new version of the specified managed policy. To update a managed policy, you
     * create a new policy version. A managed policy can have up to five versions. If the
     * policy has five versions, you must delete an existing version using DeletePolicyVersion before you create a new version.
     * Optionally, you can set the new version as the policy's default version. The default
     * version is the version that is in effect for the IAM users, groups, and roles to which
     * the policy is attached.
     * For more information about managed policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies in the IAM User Guide.
     */
    suspend fun createPolicyVersion(block: CreatePolicyVersionRequest.Builder.() -> Unit) = createPolicyVersion(CreatePolicyVersionRequest.Builder().apply(block).build())

    /**
     * Creates a new role for your Amazon Web Services account. For more information about roles, see
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">IAM
     * roles. For information about quotas for role names and the number of roles
     * you can create, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas in the
     * IAM User Guide.
     */
    suspend fun createRole(input: CreateRoleRequest): CreateRoleResponse

    /**
     * Creates a new role for your Amazon Web Services account. For more information about roles, see
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">IAM
     * roles. For information about quotas for role names and the number of roles
     * you can create, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas in the
     * IAM User Guide.
     */
    suspend fun createRole(block: CreateRoleRequest.Builder.() -> Unit) = createRole(CreateRoleRequest.Builder().apply(block).build())

    /**
     * Creates an IAM resource that describes an identity provider (IdP) that supports SAML
     * 2.0.
     * The SAML provider resource that you create with this operation can be used as a
     * principal in an IAM role's trust policy. Such a policy can enable federated users who
     * sign in using the SAML IdP to assume the role. You can create an IAM role that
     * supports Web-based single sign-on (SSO) to the Amazon Web Services Management Console or one that supports API access
     * to Amazon Web Services.
     * When you create the SAML provider resource, you upload a SAML metadata document that
     * you get from your IdP. That document includes the issuer's name, expiration information,
     * and keys that can be used to validate the SAML authentication response (assertions) that
     * the IdP sends. You must generate the metadata document using the identity management
     * software that is used as your organization's IdP.
     *
     * This operation requires <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4.
     *
     * For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-saml.html">Enabling SAML 2.0
     * federated users to access the Amazon Web Services Management Console and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based
     * federation in the IAM User Guide.
     */
    suspend fun createSamlProvider(input: CreateSamlProviderRequest): CreateSamlProviderResponse

    /**
     * Creates an IAM resource that describes an identity provider (IdP) that supports SAML
     * 2.0.
     * The SAML provider resource that you create with this operation can be used as a
     * principal in an IAM role's trust policy. Such a policy can enable federated users who
     * sign in using the SAML IdP to assume the role. You can create an IAM role that
     * supports Web-based single sign-on (SSO) to the Amazon Web Services Management Console or one that supports API access
     * to Amazon Web Services.
     * When you create the SAML provider resource, you upload a SAML metadata document that
     * you get from your IdP. That document includes the issuer's name, expiration information,
     * and keys that can be used to validate the SAML authentication response (assertions) that
     * the IdP sends. You must generate the metadata document using the identity management
     * software that is used as your organization's IdP.
     *
     * This operation requires <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4.
     *
     * For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-saml.html">Enabling SAML 2.0
     * federated users to access the Amazon Web Services Management Console and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based
     * federation in the IAM User Guide.
     */
    suspend fun createSamlProvider(block: CreateSamlProviderRequest.Builder.() -> Unit) = createSamlProvider(CreateSamlProviderRequest.Builder().apply(block).build())

    /**
     * Creates an IAM role that is linked to a specific Amazon Web Services service. The service controls
     * the attached policies and when the role can be deleted. This helps ensure that the
     * service is not broken by an unexpectedly changed or deleted role, which could put your
     * Amazon Web Services resources into an unknown state. Allowing the service to control the role helps
     * improve service stability and proper cleanup when a service and its role are no longer
     * needed. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html">Using service-linked
     * roles in the IAM User Guide.
     * To attach a policy to this service-linked role, you must make the request using the
     * Amazon Web Services service that depends on this role.
     */
    suspend fun createServiceLinkedRole(input: CreateServiceLinkedRoleRequest): CreateServiceLinkedRoleResponse

    /**
     * Creates an IAM role that is linked to a specific Amazon Web Services service. The service controls
     * the attached policies and when the role can be deleted. This helps ensure that the
     * service is not broken by an unexpectedly changed or deleted role, which could put your
     * Amazon Web Services resources into an unknown state. Allowing the service to control the role helps
     * improve service stability and proper cleanup when a service and its role are no longer
     * needed. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html">Using service-linked
     * roles in the IAM User Guide.
     * To attach a policy to this service-linked role, you must make the request using the
     * Amazon Web Services service that depends on this role.
     */
    suspend fun createServiceLinkedRole(block: CreateServiceLinkedRoleRequest.Builder.() -> Unit) = createServiceLinkedRole(CreateServiceLinkedRoleRequest.Builder().apply(block).build())

    /**
     * Generates a set of credentials consisting of a user name and password that can be used
     * to access the service specified in the request. These credentials are generated by
     * IAM, and can be used only for the specified service.
     * You can have a maximum of two sets of service-specific credentials for each supported
     * service per user.
     * You can create service-specific credentials for CodeCommit and Amazon Keyspaces (for Apache
     * Cassandra).
     * You can reset the password to a new service-generated value by calling ResetServiceSpecificCredential.
     * For more information about service-specific credentials, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_ssh-keys.html">Using IAM
     * with CodeCommit: Git credentials, SSH keys, and Amazon Web Services access keys in the
     * IAM User Guide.
     */
    suspend fun createServiceSpecificCredential(input: CreateServiceSpecificCredentialRequest): CreateServiceSpecificCredentialResponse

    /**
     * Generates a set of credentials consisting of a user name and password that can be used
     * to access the service specified in the request. These credentials are generated by
     * IAM, and can be used only for the specified service.
     * You can have a maximum of two sets of service-specific credentials for each supported
     * service per user.
     * You can create service-specific credentials for CodeCommit and Amazon Keyspaces (for Apache
     * Cassandra).
     * You can reset the password to a new service-generated value by calling ResetServiceSpecificCredential.
     * For more information about service-specific credentials, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_ssh-keys.html">Using IAM
     * with CodeCommit: Git credentials, SSH keys, and Amazon Web Services access keys in the
     * IAM User Guide.
     */
    suspend fun createServiceSpecificCredential(block: CreateServiceSpecificCredentialRequest.Builder.() -> Unit) = createServiceSpecificCredential(CreateServiceSpecificCredentialRequest.Builder().apply(block).build())

    /**
     * Creates a new IAM user for your Amazon Web Services account.
     * For information about quotas for the number of IAM users you can create, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS
     * quotas in the IAM User Guide.
     */
    suspend fun createUser(input: CreateUserRequest): CreateUserResponse

    /**
     * Creates a new IAM user for your Amazon Web Services account.
     * For information about quotas for the number of IAM users you can create, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS
     * quotas in the IAM User Guide.
     */
    suspend fun createUser(block: CreateUserRequest.Builder.() -> Unit) = createUser(CreateUserRequest.Builder().apply(block).build())

    /**
     * Creates a new virtual MFA device for the Amazon Web Services account. After creating the virtual
     * MFA, use EnableMFADevice to attach the MFA device to an IAM user.
     * For more information about creating and working with virtual MFA devices, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Using a virtual MFA
     * device in the IAM User Guide.
     * For information about the maximum number of MFA devices you can create, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS
     * quotas in the IAM User Guide.
     *
     * The seed information contained in the QR code and the Base32 string should be
     * treated like any other secret access information. In other words, protect the seed
     * information as you would your Amazon Web Services access keys or your passwords. After you
     * provision your virtual device, you should ensure that the information is destroyed
     * following secure procedures.
     */
    suspend fun createVirtualMfaDevice(input: CreateVirtualMfaDeviceRequest): CreateVirtualMfaDeviceResponse

    /**
     * Creates a new virtual MFA device for the Amazon Web Services account. After creating the virtual
     * MFA, use EnableMFADevice to attach the MFA device to an IAM user.
     * For more information about creating and working with virtual MFA devices, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Using a virtual MFA
     * device in the IAM User Guide.
     * For information about the maximum number of MFA devices you can create, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS
     * quotas in the IAM User Guide.
     *
     * The seed information contained in the QR code and the Base32 string should be
     * treated like any other secret access information. In other words, protect the seed
     * information as you would your Amazon Web Services access keys or your passwords. After you
     * provision your virtual device, you should ensure that the information is destroyed
     * following secure procedures.
     */
    suspend fun createVirtualMfaDevice(block: CreateVirtualMfaDeviceRequest.Builder.() -> Unit) = createVirtualMfaDevice(CreateVirtualMfaDeviceRequest.Builder().apply(block).build())

    /**
     * Deactivates the specified MFA device and removes it from association with the user
     * name for which it was originally enabled.
     * For more information about creating and working with virtual MFA devices, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Enabling a virtual
     * multi-factor authentication (MFA) device in the
     * IAM User Guide.
     */
    suspend fun deactivateMfaDevice(input: DeactivateMfaDeviceRequest): DeactivateMfaDeviceResponse

    /**
     * Deactivates the specified MFA device and removes it from association with the user
     * name for which it was originally enabled.
     * For more information about creating and working with virtual MFA devices, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Enabling a virtual
     * multi-factor authentication (MFA) device in the
     * IAM User Guide.
     */
    suspend fun deactivateMfaDevice(block: DeactivateMfaDeviceRequest.Builder.() -> Unit) = deactivateMfaDevice(DeactivateMfaDeviceRequest.Builder().apply(block).build())

    /**
     * Deletes the access key pair associated with the specified IAM user.
     * If you do not specify a user name, IAM determines the user name implicitly based on
     * the Amazon Web Services access key ID signing the request. This operation works for access keys under
     * the Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web Services account root
     * user credentials even if the Amazon Web Services account has no associated users.
     */
    suspend fun deleteAccessKey(input: DeleteAccessKeyRequest): DeleteAccessKeyResponse

    /**
     * Deletes the access key pair associated with the specified IAM user.
     * If you do not specify a user name, IAM determines the user name implicitly based on
     * the Amazon Web Services access key ID signing the request. This operation works for access keys under
     * the Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web Services account root
     * user credentials even if the Amazon Web Services account has no associated users.
     */
    suspend fun deleteAccessKey(block: DeleteAccessKeyRequest.Builder.() -> Unit) = deleteAccessKey(DeleteAccessKeyRequest.Builder().apply(block).build())

    /**
     * Deletes the specified Amazon Web Services account alias. For information about using an Amazon Web Services
     * account alias, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an alias for your Amazon Web Services account ID in the
     * IAM User Guide.
     */
    suspend fun deleteAccountAlias(input: DeleteAccountAliasRequest): DeleteAccountAliasResponse

    /**
     * Deletes the specified Amazon Web Services account alias. For information about using an Amazon Web Services
     * account alias, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an alias for your Amazon Web Services account ID in the
     * IAM User Guide.
     */
    suspend fun deleteAccountAlias(block: DeleteAccountAliasRequest.Builder.() -> Unit) = deleteAccountAlias(DeleteAccountAliasRequest.Builder().apply(block).build())

    /**
     * Deletes the password policy for the Amazon Web Services account. There are no parameters.
     */
    suspend fun deleteAccountPasswordPolicy(input: DeleteAccountPasswordPolicyRequest): DeleteAccountPasswordPolicyResponse

    /**
     * Deletes the password policy for the Amazon Web Services account. There are no parameters.
     */
    suspend fun deleteAccountPasswordPolicy(block: DeleteAccountPasswordPolicyRequest.Builder.() -> Unit) = deleteAccountPasswordPolicy(DeleteAccountPasswordPolicyRequest.Builder().apply(block).build())

    /**
     * Deletes the specified IAM group. The group must not contain any users or have any
     * attached policies.
     */
    suspend fun deleteGroup(input: DeleteGroupRequest): DeleteGroupResponse

    /**
     * Deletes the specified IAM group. The group must not contain any users or have any
     * attached policies.
     */
    suspend fun deleteGroup(block: DeleteGroupRequest.Builder.() -> Unit) = deleteGroup(DeleteGroupRequest.Builder().apply(block).build())

    /**
     * Deletes the specified inline policy that is embedded in the specified IAM
     * group.
     * A group can also have managed policies attached to it. To detach a managed policy from
     * a group, use DetachGroupPolicy. For more information about policies,
     * refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     */
    suspend fun deleteGroupPolicy(input: DeleteGroupPolicyRequest): DeleteGroupPolicyResponse

    /**
     * Deletes the specified inline policy that is embedded in the specified IAM
     * group.
     * A group can also have managed policies attached to it. To detach a managed policy from
     * a group, use DetachGroupPolicy. For more information about policies,
     * refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     */
    suspend fun deleteGroupPolicy(block: DeleteGroupPolicyRequest.Builder.() -> Unit) = deleteGroupPolicy(DeleteGroupPolicyRequest.Builder().apply(block).build())

    /**
     * Deletes the specified instance profile. The instance profile must not have an
     * associated role.
     *
     * Make sure that you do not have any Amazon EC2 instances running with the instance
     * profile you are about to delete. Deleting a role or instance profile that is
     * associated with a running instance will break any applications running on the
     * instance.
     *
     * For more information about instance profiles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance
     * profiles.
     */
    suspend fun deleteInstanceProfile(input: DeleteInstanceProfileRequest): DeleteInstanceProfileResponse

    /**
     * Deletes the specified instance profile. The instance profile must not have an
     * associated role.
     *
     * Make sure that you do not have any Amazon EC2 instances running with the instance
     * profile you are about to delete. Deleting a role or instance profile that is
     * associated with a running instance will break any applications running on the
     * instance.
     *
     * For more information about instance profiles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance
     * profiles.
     */
    suspend fun deleteInstanceProfile(block: DeleteInstanceProfileRequest.Builder.() -> Unit) = deleteInstanceProfile(DeleteInstanceProfileRequest.Builder().apply(block).build())

    /**
     * Deletes the password for the specified IAM user, which terminates the user's ability
     * to access Amazon Web Services services through the Amazon Web Services Management Console.
     * You can use the CLI, the Amazon Web Services API, or the Users
     * page in the IAM console to delete a password for any IAM user. You can use ChangePassword to update, but not delete, your own password in the
     * My Security Credentials page in the
     * Amazon Web Services Management Console.
     *
     * Deleting a user's password does not prevent a user from accessing Amazon Web Services through
     * the command line interface or the API. To prevent all user access, you must also
     * either make any access keys inactive or delete them. For more information about
     * making keys inactive or deleting them, see UpdateAccessKey and
     * DeleteAccessKey.
     */
    suspend fun deleteLoginProfile(input: DeleteLoginProfileRequest): DeleteLoginProfileResponse

    /**
     * Deletes the password for the specified IAM user, which terminates the user's ability
     * to access Amazon Web Services services through the Amazon Web Services Management Console.
     * You can use the CLI, the Amazon Web Services API, or the Users
     * page in the IAM console to delete a password for any IAM user. You can use ChangePassword to update, but not delete, your own password in the
     * My Security Credentials page in the
     * Amazon Web Services Management Console.
     *
     * Deleting a user's password does not prevent a user from accessing Amazon Web Services through
     * the command line interface or the API. To prevent all user access, you must also
     * either make any access keys inactive or delete them. For more information about
     * making keys inactive or deleting them, see UpdateAccessKey and
     * DeleteAccessKey.
     */
    suspend fun deleteLoginProfile(block: DeleteLoginProfileRequest.Builder.() -> Unit) = deleteLoginProfile(DeleteLoginProfileRequest.Builder().apply(block).build())

    /**
     * Deletes an OpenID Connect identity provider (IdP) resource object in IAM.
     * Deleting an IAM OIDC provider resource does not update any roles that reference the
     * provider as a principal in their trust policies. Any attempt to assume a role that
     * references a deleted provider fails.
     * This operation is idempotent; it does not fail or return an error if you call the
     * operation for a provider that does not exist.
     */
    suspend fun deleteOpenIdConnectProvider(input: DeleteOpenIdConnectProviderRequest): DeleteOpenIdConnectProviderResponse

    /**
     * Deletes an OpenID Connect identity provider (IdP) resource object in IAM.
     * Deleting an IAM OIDC provider resource does not update any roles that reference the
     * provider as a principal in their trust policies. Any attempt to assume a role that
     * references a deleted provider fails.
     * This operation is idempotent; it does not fail or return an error if you call the
     * operation for a provider that does not exist.
     */
    suspend fun deleteOpenIdConnectProvider(block: DeleteOpenIdConnectProviderRequest.Builder.() -> Unit) = deleteOpenIdConnectProvider(DeleteOpenIdConnectProviderRequest.Builder().apply(block).build())

    /**
     * Deletes the specified managed policy.
     * Before you can delete a managed policy, you must first detach the policy from all
     * users, groups, and roles that it is attached to. In addition, you must delete all the
     * policy's versions. The following steps describe the process for deleting a managed
     * policy:
     *
     *
     * Detach the policy from all users, groups, and roles that the policy is
     * attached to, using DetachUserPolicy, DetachGroupPolicy, or DetachRolePolicy. To
     * list all the users, groups, and roles that a policy is attached to, use ListEntitiesForPolicy.
     *
     * Delete all versions of the policy using DeletePolicyVersion.
     * To list the policy's versions, use ListPolicyVersions. You
     * cannot use DeletePolicyVersion to delete the version that is
     * marked as the default version. You delete the policy's default version in the
     * next step of the process.
     *
     * Delete the policy (this automatically deletes the policy's default version)
     * using this operation.
     *
     *
     * For information about managed policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     */
    suspend fun deletePolicy(input: DeletePolicyRequest): DeletePolicyResponse

    /**
     * Deletes the specified managed policy.
     * Before you can delete a managed policy, you must first detach the policy from all
     * users, groups, and roles that it is attached to. In addition, you must delete all the
     * policy's versions. The following steps describe the process for deleting a managed
     * policy:
     *
     *
     * Detach the policy from all users, groups, and roles that the policy is
     * attached to, using DetachUserPolicy, DetachGroupPolicy, or DetachRolePolicy. To
     * list all the users, groups, and roles that a policy is attached to, use ListEntitiesForPolicy.
     *
     * Delete all versions of the policy using DeletePolicyVersion.
     * To list the policy's versions, use ListPolicyVersions. You
     * cannot use DeletePolicyVersion to delete the version that is
     * marked as the default version. You delete the policy's default version in the
     * next step of the process.
     *
     * Delete the policy (this automatically deletes the policy's default version)
     * using this operation.
     *
     *
     * For information about managed policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     */
    suspend fun deletePolicy(block: DeletePolicyRequest.Builder.() -> Unit) = deletePolicy(DeletePolicyRequest.Builder().apply(block).build())

    /**
     * Deletes the specified version from the specified managed policy.
     * You cannot delete the default version from a policy using this operation. To delete
     * the default version from a policy, use DeletePolicy. To find out which
     * version of a policy is marked as the default version, use ListPolicyVersions.
     * For information about versions for managed policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies in the IAM User Guide.
     */
    suspend fun deletePolicyVersion(input: DeletePolicyVersionRequest): DeletePolicyVersionResponse

    /**
     * Deletes the specified version from the specified managed policy.
     * You cannot delete the default version from a policy using this operation. To delete
     * the default version from a policy, use DeletePolicy. To find out which
     * version of a policy is marked as the default version, use ListPolicyVersions.
     * For information about versions for managed policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies in the IAM User Guide.
     */
    suspend fun deletePolicyVersion(block: DeletePolicyVersionRequest.Builder.() -> Unit) = deletePolicyVersion(DeletePolicyVersionRequest.Builder().apply(block).build())

    /**
     * Deletes the specified role. The role must not have any policies attached. For more
     * information about roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with roles.
     *
     * Make sure that you do not have any Amazon EC2 instances running with the role you
     * are about to delete. Deleting a role or instance profile that is associated with a
     * running instance will break any applications running on the instance.
     */
    suspend fun deleteRole(input: DeleteRoleRequest): DeleteRoleResponse

    /**
     * Deletes the specified role. The role must not have any policies attached. For more
     * information about roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with roles.
     *
     * Make sure that you do not have any Amazon EC2 instances running with the role you
     * are about to delete. Deleting a role or instance profile that is associated with a
     * running instance will break any applications running on the instance.
     */
    suspend fun deleteRole(block: DeleteRoleRequest.Builder.() -> Unit) = deleteRole(DeleteRoleRequest.Builder().apply(block).build())

    /**
     * Deletes the permissions boundary for the specified IAM role.
     *
     * Deleting the permissions boundary for a role might increase its permissions. For
     * example, it might allow anyone who assumes the role to perform all the actions
     * granted in its permissions policies.
     */
    suspend fun deleteRolePermissionsBoundary(input: DeleteRolePermissionsBoundaryRequest): DeleteRolePermissionsBoundaryResponse

    /**
     * Deletes the permissions boundary for the specified IAM role.
     *
     * Deleting the permissions boundary for a role might increase its permissions. For
     * example, it might allow anyone who assumes the role to perform all the actions
     * granted in its permissions policies.
     */
    suspend fun deleteRolePermissionsBoundary(block: DeleteRolePermissionsBoundaryRequest.Builder.() -> Unit) = deleteRolePermissionsBoundary(DeleteRolePermissionsBoundaryRequest.Builder().apply(block).build())

    /**
     * Deletes the specified inline policy that is embedded in the specified IAM
     * role.
     * A role can also have managed policies attached to it. To detach a managed policy from
     * a role, use DetachRolePolicy. For more information about policies,
     * refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     */
    suspend fun deleteRolePolicy(input: DeleteRolePolicyRequest): DeleteRolePolicyResponse

    /**
     * Deletes the specified inline policy that is embedded in the specified IAM
     * role.
     * A role can also have managed policies attached to it. To detach a managed policy from
     * a role, use DetachRolePolicy. For more information about policies,
     * refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     */
    suspend fun deleteRolePolicy(block: DeleteRolePolicyRequest.Builder.() -> Unit) = deleteRolePolicy(DeleteRolePolicyRequest.Builder().apply(block).build())

    /**
     * Deletes a SAML provider resource in IAM.
     * Deleting the provider resource from IAM does not update any roles that reference the
     * SAML provider resource's ARN as a principal in their trust policies. Any attempt to
     * assume a role that references a non-existent provider resource ARN fails.
     *
     * This operation requires <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4.
     */
    suspend fun deleteSamlProvider(input: DeleteSamlProviderRequest): DeleteSamlProviderResponse

    /**
     * Deletes a SAML provider resource in IAM.
     * Deleting the provider resource from IAM does not update any roles that reference the
     * SAML provider resource's ARN as a principal in their trust policies. Any attempt to
     * assume a role that references a non-existent provider resource ARN fails.
     *
     * This operation requires <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4.
     */
    suspend fun deleteSamlProvider(block: DeleteSamlProviderRequest.Builder.() -> Unit) = deleteSamlProvider(DeleteSamlProviderRequest.Builder().apply(block).build())

    /**
     * Deletes the specified server certificate.
     * For more information about working with server certificates, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working
     * with server certificates in the IAM User Guide. This
     * topic also includes a list of Amazon Web Services services that can use the server certificates that
     * you manage with IAM.
     *
     * If you are using a server certificate with Elastic Load Balancing, deleting the
     * certificate could have implications for your application. If Elastic Load Balancing
     * doesn't detect the deletion of bound certificates, it may continue to use the
     * certificates. This could cause Elastic Load Balancing to stop accepting traffic. We
     * recommend that you remove the reference to the certificate from Elastic Load
     * Balancing before using this command to delete the certificate. For more information,
     * see <a href="https://docs.aws.amazon.com/ElasticLoadBalancing/latest/APIReference/API_DeleteLoadBalancerListeners.html">DeleteLoadBalancerListeners in the Elastic Load Balancing API
     * Reference.
     */
    suspend fun deleteServerCertificate(input: DeleteServerCertificateRequest): DeleteServerCertificateResponse

    /**
     * Deletes the specified server certificate.
     * For more information about working with server certificates, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working
     * with server certificates in the IAM User Guide. This
     * topic also includes a list of Amazon Web Services services that can use the server certificates that
     * you manage with IAM.
     *
     * If you are using a server certificate with Elastic Load Balancing, deleting the
     * certificate could have implications for your application. If Elastic Load Balancing
     * doesn't detect the deletion of bound certificates, it may continue to use the
     * certificates. This could cause Elastic Load Balancing to stop accepting traffic. We
     * recommend that you remove the reference to the certificate from Elastic Load
     * Balancing before using this command to delete the certificate. For more information,
     * see <a href="https://docs.aws.amazon.com/ElasticLoadBalancing/latest/APIReference/API_DeleteLoadBalancerListeners.html">DeleteLoadBalancerListeners in the Elastic Load Balancing API
     * Reference.
     */
    suspend fun deleteServerCertificate(block: DeleteServerCertificateRequest.Builder.() -> Unit) = deleteServerCertificate(DeleteServerCertificateRequest.Builder().apply(block).build())

    /**
     * Submits a service-linked role deletion request and returns a
     * DeletionTaskId, which you can use to check the status of the deletion.
     * Before you call this operation, confirm that the role has no active sessions and that
     * any resources used by the role in the linked service are deleted. If you call this
     * operation more than once for the same service-linked role and an earlier deletion task
     * is not complete, then the DeletionTaskId of the earlier request is
     * returned.
     * If you submit a deletion request for a service-linked role whose linked service is
     * still accessing a resource, then the deletion task fails. If it fails, the GetServiceLinkedRoleDeletionStatus operation returns the reason for the
     * failure, usually including the resources that must be deleted. To delete the
     * service-linked role, you must first remove those resources from the linked service and
     * then submit the deletion request again. Resources are specific to the service that is
     * linked to the role. For more information about removing resources from a service, see
     * the <a href="http://docs.aws.amazon.com/">Amazon Web Services documentation for your
     * service.
     * For more information about service-linked roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role">Roles terms and concepts: Amazon Web Services service-linked role in the
     * IAM User Guide.
     */
    suspend fun deleteServiceLinkedRole(input: DeleteServiceLinkedRoleRequest): DeleteServiceLinkedRoleResponse

    /**
     * Submits a service-linked role deletion request and returns a
     * DeletionTaskId, which you can use to check the status of the deletion.
     * Before you call this operation, confirm that the role has no active sessions and that
     * any resources used by the role in the linked service are deleted. If you call this
     * operation more than once for the same service-linked role and an earlier deletion task
     * is not complete, then the DeletionTaskId of the earlier request is
     * returned.
     * If you submit a deletion request for a service-linked role whose linked service is
     * still accessing a resource, then the deletion task fails. If it fails, the GetServiceLinkedRoleDeletionStatus operation returns the reason for the
     * failure, usually including the resources that must be deleted. To delete the
     * service-linked role, you must first remove those resources from the linked service and
     * then submit the deletion request again. Resources are specific to the service that is
     * linked to the role. For more information about removing resources from a service, see
     * the <a href="http://docs.aws.amazon.com/">Amazon Web Services documentation for your
     * service.
     * For more information about service-linked roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role">Roles terms and concepts: Amazon Web Services service-linked role in the
     * IAM User Guide.
     */
    suspend fun deleteServiceLinkedRole(block: DeleteServiceLinkedRoleRequest.Builder.() -> Unit) = deleteServiceLinkedRole(DeleteServiceLinkedRoleRequest.Builder().apply(block).build())

    /**
     * Deletes the specified service-specific credential.
     */
    suspend fun deleteServiceSpecificCredential(input: DeleteServiceSpecificCredentialRequest): DeleteServiceSpecificCredentialResponse

    /**
     * Deletes the specified service-specific credential.
     */
    suspend fun deleteServiceSpecificCredential(block: DeleteServiceSpecificCredentialRequest.Builder.() -> Unit) = deleteServiceSpecificCredential(DeleteServiceSpecificCredentialRequest.Builder().apply(block).build())

    /**
     * Deletes a signing certificate associated with the specified IAM user.
     * If you do not specify a user name, IAM determines the user name implicitly based on
     * the Amazon Web Services access key ID signing the request. This operation works for access keys under
     * the Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web Services account root
     * user credentials even if the Amazon Web Services account has no associated IAM users.
     */
    suspend fun deleteSigningCertificate(input: DeleteSigningCertificateRequest): DeleteSigningCertificateResponse

    /**
     * Deletes a signing certificate associated with the specified IAM user.
     * If you do not specify a user name, IAM determines the user name implicitly based on
     * the Amazon Web Services access key ID signing the request. This operation works for access keys under
     * the Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web Services account root
     * user credentials even if the Amazon Web Services account has no associated IAM users.
     */
    suspend fun deleteSigningCertificate(block: DeleteSigningCertificateRequest.Builder.() -> Unit) = deleteSigningCertificate(DeleteSigningCertificateRequest.Builder().apply(block).build())

    /**
     * Deletes the specified SSH public key.
     * The SSH public key deleted by this operation is used only for authenticating the
     * associated IAM user to an CodeCommit repository. For more information about using SSH keys
     * to authenticate to an CodeCommit repository, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up CodeCommit for
     * SSH connections in the CodeCommit User Guide.
     */
    suspend fun deleteSshPublicKey(input: DeleteSshPublicKeyRequest): DeleteSshPublicKeyResponse

    /**
     * Deletes the specified SSH public key.
     * The SSH public key deleted by this operation is used only for authenticating the
     * associated IAM user to an CodeCommit repository. For more information about using SSH keys
     * to authenticate to an CodeCommit repository, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up CodeCommit for
     * SSH connections in the CodeCommit User Guide.
     */
    suspend fun deleteSshPublicKey(block: DeleteSshPublicKeyRequest.Builder.() -> Unit) = deleteSshPublicKey(DeleteSshPublicKeyRequest.Builder().apply(block).build())

    /**
     * Deletes the specified IAM user. Unlike the Amazon Web Services Management Console, when you delete a user
     * programmatically, you must delete the items attached to the user manually, or the
     * deletion fails. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_manage.html#id_users_deleting_cli">Deleting an IAM
     * user. Before attempting to delete a user, remove the following items:
     *
     *
     * Password (DeleteLoginProfile)
     *
     * Access keys (DeleteAccessKey)
     *
     * Signing certificate (DeleteSigningCertificate)
     *
     * SSH public key (DeleteSSHPublicKey)
     *
     * Git credentials (DeleteServiceSpecificCredential)
     *
     * Multi-factor authentication (MFA) device (DeactivateMFADevice, DeleteVirtualMFADevice)
     *
     * Inline policies (DeleteUserPolicy)
     *
     * Attached managed policies (DetachUserPolicy)
     *
     * Group memberships (RemoveUserFromGroup)
     */
    suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse

    /**
     * Deletes the specified IAM user. Unlike the Amazon Web Services Management Console, when you delete a user
     * programmatically, you must delete the items attached to the user manually, or the
     * deletion fails. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_manage.html#id_users_deleting_cli">Deleting an IAM
     * user. Before attempting to delete a user, remove the following items:
     *
     *
     * Password (DeleteLoginProfile)
     *
     * Access keys (DeleteAccessKey)
     *
     * Signing certificate (DeleteSigningCertificate)
     *
     * SSH public key (DeleteSSHPublicKey)
     *
     * Git credentials (DeleteServiceSpecificCredential)
     *
     * Multi-factor authentication (MFA) device (DeactivateMFADevice, DeleteVirtualMFADevice)
     *
     * Inline policies (DeleteUserPolicy)
     *
     * Attached managed policies (DetachUserPolicy)
     *
     * Group memberships (RemoveUserFromGroup)
     */
    suspend fun deleteUser(block: DeleteUserRequest.Builder.() -> Unit) = deleteUser(DeleteUserRequest.Builder().apply(block).build())

    /**
     * Deletes the permissions boundary for the specified IAM user.
     *
     * Deleting the permissions boundary for a user might increase its permissions by
     * allowing the user to perform all the actions granted in its permissions policies.
     */
    suspend fun deleteUserPermissionsBoundary(input: DeleteUserPermissionsBoundaryRequest): DeleteUserPermissionsBoundaryResponse

    /**
     * Deletes the permissions boundary for the specified IAM user.
     *
     * Deleting the permissions boundary for a user might increase its permissions by
     * allowing the user to perform all the actions granted in its permissions policies.
     */
    suspend fun deleteUserPermissionsBoundary(block: DeleteUserPermissionsBoundaryRequest.Builder.() -> Unit) = deleteUserPermissionsBoundary(DeleteUserPermissionsBoundaryRequest.Builder().apply(block).build())

    /**
     * Deletes the specified inline policy that is embedded in the specified IAM
     * user.
     * A user can also have managed policies attached to it. To detach a managed policy from
     * a user, use DetachUserPolicy. For more information about policies,
     * refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     */
    suspend fun deleteUserPolicy(input: DeleteUserPolicyRequest): DeleteUserPolicyResponse

    /**
     * Deletes the specified inline policy that is embedded in the specified IAM
     * user.
     * A user can also have managed policies attached to it. To detach a managed policy from
     * a user, use DetachUserPolicy. For more information about policies,
     * refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     */
    suspend fun deleteUserPolicy(block: DeleteUserPolicyRequest.Builder.() -> Unit) = deleteUserPolicy(DeleteUserPolicyRequest.Builder().apply(block).build())

    /**
     * Deletes a virtual MFA device.
     *
     * You must deactivate a user's virtual MFA device before you can delete it. For
     * information about deactivating MFA devices, see DeactivateMFADevice.
     */
    suspend fun deleteVirtualMfaDevice(input: DeleteVirtualMfaDeviceRequest): DeleteVirtualMfaDeviceResponse

    /**
     * Deletes a virtual MFA device.
     *
     * You must deactivate a user's virtual MFA device before you can delete it. For
     * information about deactivating MFA devices, see DeactivateMFADevice.
     */
    suspend fun deleteVirtualMfaDevice(block: DeleteVirtualMfaDeviceRequest.Builder.() -> Unit) = deleteVirtualMfaDevice(DeleteVirtualMfaDeviceRequest.Builder().apply(block).build())

    /**
     * Removes the specified managed policy from the specified IAM group.
     * A group can also have inline policies embedded with it. To delete an inline policy,
     * use DeleteGroupPolicy. For information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed
     * policies and inline policies in the
     * IAM User Guide.
     */
    suspend fun detachGroupPolicy(input: DetachGroupPolicyRequest): DetachGroupPolicyResponse

    /**
     * Removes the specified managed policy from the specified IAM group.
     * A group can also have inline policies embedded with it. To delete an inline policy,
     * use DeleteGroupPolicy. For information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed
     * policies and inline policies in the
     * IAM User Guide.
     */
    suspend fun detachGroupPolicy(block: DetachGroupPolicyRequest.Builder.() -> Unit) = detachGroupPolicy(DetachGroupPolicyRequest.Builder().apply(block).build())

    /**
     * Removes the specified managed policy from the specified role.
     * A role can also have inline policies embedded with it. To delete an inline policy, use
     * DeleteRolePolicy. For information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed
     * policies and inline policies in the
     * IAM User Guide.
     */
    suspend fun detachRolePolicy(input: DetachRolePolicyRequest): DetachRolePolicyResponse

    /**
     * Removes the specified managed policy from the specified role.
     * A role can also have inline policies embedded with it. To delete an inline policy, use
     * DeleteRolePolicy. For information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed
     * policies and inline policies in the
     * IAM User Guide.
     */
    suspend fun detachRolePolicy(block: DetachRolePolicyRequest.Builder.() -> Unit) = detachRolePolicy(DetachRolePolicyRequest.Builder().apply(block).build())

    /**
     * Removes the specified managed policy from the specified user.
     * A user can also have inline policies embedded with it. To delete an inline policy, use
     * DeleteUserPolicy. For information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed
     * policies and inline policies in the
     * IAM User Guide.
     */
    suspend fun detachUserPolicy(input: DetachUserPolicyRequest): DetachUserPolicyResponse

    /**
     * Removes the specified managed policy from the specified user.
     * A user can also have inline policies embedded with it. To delete an inline policy, use
     * DeleteUserPolicy. For information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed
     * policies and inline policies in the
     * IAM User Guide.
     */
    suspend fun detachUserPolicy(block: DetachUserPolicyRequest.Builder.() -> Unit) = detachUserPolicy(DetachUserPolicyRequest.Builder().apply(block).build())

    /**
     * Enables the specified MFA device and associates it with the specified IAM user. When
     * enabled, the MFA device is required for every subsequent login by the IAM user
     * associated with the device.
     */
    suspend fun enableMfaDevice(input: EnableMfaDeviceRequest): EnableMfaDeviceResponse

    /**
     * Enables the specified MFA device and associates it with the specified IAM user. When
     * enabled, the MFA device is required for every subsequent login by the IAM user
     * associated with the device.
     */
    suspend fun enableMfaDevice(block: EnableMfaDeviceRequest.Builder.() -> Unit) = enableMfaDevice(EnableMfaDeviceRequest.Builder().apply(block).build())

    /**
     * Generates a credential report for the Amazon Web Services account. For more information about the
     * credential report, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential reports in
     * the IAM User Guide.
     */
    suspend fun generateCredentialReport(input: GenerateCredentialReportRequest): GenerateCredentialReportResponse

    /**
     * Generates a credential report for the Amazon Web Services account. For more information about the
     * credential report, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential reports in
     * the IAM User Guide.
     */
    suspend fun generateCredentialReport(block: GenerateCredentialReportRequest.Builder.() -> Unit) = generateCredentialReport(GenerateCredentialReportRequest.Builder().apply(block).build())

    /**
     * Generates a report for service last accessed data for Organizations. You can generate a
     * report for any entities (organization root, organizational unit, or account) or policies
     * in your organization.
     * To call this operation, you must be signed in using your Organizations management account
     * credentials. You can use your long-term IAM user or root user credentials, or
     * temporary credentials from assuming an IAM role. SCPs must be enabled for your
     * organization root. You must have the required IAM and Organizations permissions. For more
     * information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Refining permissions using
     * service last accessed data in the
     * IAM User Guide.
     * You can generate a service last accessed data report for entities by specifying only
     * the entity's path. This data includes a list of services that are allowed by any service
     * control policies (SCPs) that apply to the entity.
     * You can generate a service last accessed data report for a policy by specifying an
     * entity's path and an optional Organizations policy ID. This data includes a list of services that
     * are allowed by the specified SCP.
     * For each service in both report types, the data includes the most recent account
     * activity that the policy allows to account principals in the entity or the entity's
     * children. For important information about the data, reporting period, permissions
     * required, troubleshooting, and supported Regions see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing permissions using
     * service last accessed data in the
     * IAM User Guide.
     *
     * The data includes all attempts to access Amazon Web Services, not just the successful ones. This
     * includes all attempts that were made using the Amazon Web Services Management Console, the Amazon Web Services API through any
     * of the SDKs, or any of the command line tools. An unexpected entry in the service
     * last accessed data does not mean that an account has been compromised, because the
     * request might have been denied. Refer to your CloudTrail logs as the authoritative
     * source for information about all API calls and whether they were successful or
     * denied access. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html">Logging IAM events with
     * CloudTrail in the IAM User Guide.
     *
     * This operation returns a JobId. Use this parameter in the
     * GetOrganizationsAccessReport
     * operation to check the status of
     * the report generation. To check the status of this request, use the JobId
     * parameter in the
     * GetOrganizationsAccessReport
     * operation
     * and test the JobStatus response parameter. When the job is complete, you
     * can retrieve the report.
     * To generate a service last accessed data report for entities, specify an entity path
     * without specifying the optional Organizations policy ID. The type of entity that you specify
     * determines the data returned in the report.
     *
     *
     *
     * Root – When you specify the
     * organizations root as the entity, the resulting report lists all of the services
     * allowed by SCPs that are attached to your root. For each service, the report
     * includes data for all accounts in your organization except the
     * management account, because the management account is not limited by SCPs.
     *
     *
     * OU – When you specify an
     * organizational unit (OU) as the entity, the resulting report lists all of the
     * services allowed by SCPs that are attached to the OU and its parents. For each
     * service, the report includes data for all accounts in the OU or its children.
     * This data excludes the management account, because the management account is not
     * limited by SCPs.
     *
     *
     * management account – When you specify the
     * management account, the resulting report lists all Amazon Web Services services, because the
     * management account is not limited by SCPs. For each service, the report includes
     * data for only the management account.
     *
     *
     * Account – When you specify another
     * account as the entity, the resulting report lists all of the services allowed by
     * SCPs that are attached to the account and its parents. For each service, the
     * report includes data for only the specified account.
     *
     *
     * To generate a service last accessed data report for policies, specify an entity path
     * and the optional Organizations policy ID. The type of entity that you specify determines the data
     * returned for each service.
     *
     *
     *
     * Root – When you specify the root
     * entity and a policy ID, the resulting report lists all of the services that are
     * allowed by the specified SCP. For each service, the report includes data for all
     * accounts in your organization to which the SCP applies. This data excludes the
     * management account, because the management account is not limited by SCPs. If the
     * SCP is not attached to any entities in the organization, then the report will
     * return a list of services with no data.
     *
     *
     * OU – When you specify an OU entity and
     * a policy ID, the resulting report lists all of the services that are allowed by
     * the specified SCP. For each service, the report includes data for all accounts
     * in the OU or its children to which the SCP applies. This means that other
     * accounts outside the OU that are affected by the SCP might not be included in
     * the data. This data excludes the management account, because the
     * management account is not limited by SCPs. If the SCP is not attached to the OU
     * or one of its children, the report will return a list of services with no
     * data.
     *
     *
     * management account – When you specify the
     * management account, the resulting report lists all Amazon Web Services services, because the
     * management account is not limited by SCPs. If you specify a policy ID in the CLI
     * or API, the policy is ignored. For each service, the report includes data for
     * only the management account.
     *
     *
     * Account – When you specify another
     * account entity and a policy ID, the resulting report lists all of the services
     * that are allowed by the specified SCP. For each service, the report includes
     * data for only the specified account. This means that other accounts in the
     * organization that are affected by the SCP might not be included in the data. If
     * the SCP is not attached to the account, the report will return a list of
     * services with no data.
     *
     *
     *
     * Service last accessed data does not use other policy types when determining
     * whether a principal could access a service. These other policy types include
     * identity-based policies, resource-based policies, access control lists, IAM
     * permissions boundaries, and STS assume role policies. It only applies SCP logic.
     * For more about the evaluation of policy types, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics">Evaluating policies in the
     * IAM User Guide.
     *
     * For more information about service last accessed data, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing policy scope by
     * viewing user activity in the IAM User Guide.
     */
    suspend fun generateOrganizationsAccessReport(input: GenerateOrganizationsAccessReportRequest): GenerateOrganizationsAccessReportResponse

    /**
     * Generates a report for service last accessed data for Organizations. You can generate a
     * report for any entities (organization root, organizational unit, or account) or policies
     * in your organization.
     * To call this operation, you must be signed in using your Organizations management account
     * credentials. You can use your long-term IAM user or root user credentials, or
     * temporary credentials from assuming an IAM role. SCPs must be enabled for your
     * organization root. You must have the required IAM and Organizations permissions. For more
     * information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Refining permissions using
     * service last accessed data in the
     * IAM User Guide.
     * You can generate a service last accessed data report for entities by specifying only
     * the entity's path. This data includes a list of services that are allowed by any service
     * control policies (SCPs) that apply to the entity.
     * You can generate a service last accessed data report for a policy by specifying an
     * entity's path and an optional Organizations policy ID. This data includes a list of services that
     * are allowed by the specified SCP.
     * For each service in both report types, the data includes the most recent account
     * activity that the policy allows to account principals in the entity or the entity's
     * children. For important information about the data, reporting period, permissions
     * required, troubleshooting, and supported Regions see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing permissions using
     * service last accessed data in the
     * IAM User Guide.
     *
     * The data includes all attempts to access Amazon Web Services, not just the successful ones. This
     * includes all attempts that were made using the Amazon Web Services Management Console, the Amazon Web Services API through any
     * of the SDKs, or any of the command line tools. An unexpected entry in the service
     * last accessed data does not mean that an account has been compromised, because the
     * request might have been denied. Refer to your CloudTrail logs as the authoritative
     * source for information about all API calls and whether they were successful or
     * denied access. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html">Logging IAM events with
     * CloudTrail in the IAM User Guide.
     *
     * This operation returns a JobId. Use this parameter in the
     * GetOrganizationsAccessReport
     * operation to check the status of
     * the report generation. To check the status of this request, use the JobId
     * parameter in the
     * GetOrganizationsAccessReport
     * operation
     * and test the JobStatus response parameter. When the job is complete, you
     * can retrieve the report.
     * To generate a service last accessed data report for entities, specify an entity path
     * without specifying the optional Organizations policy ID. The type of entity that you specify
     * determines the data returned in the report.
     *
     *
     *
     * Root – When you specify the
     * organizations root as the entity, the resulting report lists all of the services
     * allowed by SCPs that are attached to your root. For each service, the report
     * includes data for all accounts in your organization except the
     * management account, because the management account is not limited by SCPs.
     *
     *
     * OU – When you specify an
     * organizational unit (OU) as the entity, the resulting report lists all of the
     * services allowed by SCPs that are attached to the OU and its parents. For each
     * service, the report includes data for all accounts in the OU or its children.
     * This data excludes the management account, because the management account is not
     * limited by SCPs.
     *
     *
     * management account – When you specify the
     * management account, the resulting report lists all Amazon Web Services services, because the
     * management account is not limited by SCPs. For each service, the report includes
     * data for only the management account.
     *
     *
     * Account – When you specify another
     * account as the entity, the resulting report lists all of the services allowed by
     * SCPs that are attached to the account and its parents. For each service, the
     * report includes data for only the specified account.
     *
     *
     * To generate a service last accessed data report for policies, specify an entity path
     * and the optional Organizations policy ID. The type of entity that you specify determines the data
     * returned for each service.
     *
     *
     *
     * Root – When you specify the root
     * entity and a policy ID, the resulting report lists all of the services that are
     * allowed by the specified SCP. For each service, the report includes data for all
     * accounts in your organization to which the SCP applies. This data excludes the
     * management account, because the management account is not limited by SCPs. If the
     * SCP is not attached to any entities in the organization, then the report will
     * return a list of services with no data.
     *
     *
     * OU – When you specify an OU entity and
     * a policy ID, the resulting report lists all of the services that are allowed by
     * the specified SCP. For each service, the report includes data for all accounts
     * in the OU or its children to which the SCP applies. This means that other
     * accounts outside the OU that are affected by the SCP might not be included in
     * the data. This data excludes the management account, because the
     * management account is not limited by SCPs. If the SCP is not attached to the OU
     * or one of its children, the report will return a list of services with no
     * data.
     *
     *
     * management account – When you specify the
     * management account, the resulting report lists all Amazon Web Services services, because the
     * management account is not limited by SCPs. If you specify a policy ID in the CLI
     * or API, the policy is ignored. For each service, the report includes data for
     * only the management account.
     *
     *
     * Account – When you specify another
     * account entity and a policy ID, the resulting report lists all of the services
     * that are allowed by the specified SCP. For each service, the report includes
     * data for only the specified account. This means that other accounts in the
     * organization that are affected by the SCP might not be included in the data. If
     * the SCP is not attached to the account, the report will return a list of
     * services with no data.
     *
     *
     *
     * Service last accessed data does not use other policy types when determining
     * whether a principal could access a service. These other policy types include
     * identity-based policies, resource-based policies, access control lists, IAM
     * permissions boundaries, and STS assume role policies. It only applies SCP logic.
     * For more about the evaluation of policy types, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics">Evaluating policies in the
     * IAM User Guide.
     *
     * For more information about service last accessed data, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing policy scope by
     * viewing user activity in the IAM User Guide.
     */
    suspend fun generateOrganizationsAccessReport(block: GenerateOrganizationsAccessReportRequest.Builder.() -> Unit) = generateOrganizationsAccessReport(GenerateOrganizationsAccessReportRequest.Builder().apply(block).build())

    /**
     * Generates a report that includes details about when an IAM resource (user, group,
     * role, or policy) was last used in an attempt to access Amazon Web Services services. Recent activity
     * usually appears within four hours. IAM reports activity for at least the last 400
     * days, or less if your Region began supporting this feature within the last year. For
     * more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked.
     *
     * The service last accessed data includes all attempts to access an Amazon Web Services API, not
     * just the successful ones. This includes all attempts that were made using the
     * Amazon Web Services Management Console, the Amazon Web Services API through any of the SDKs, or any of the command line tools.
     * An unexpected entry in the service last accessed data does not mean that your
     * account has been compromised, because the request might have been denied. Refer to
     * your CloudTrail logs as the authoritative source for information about all API calls
     * and whether they were successful or denied access. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html">Logging
     * IAM events with CloudTrail in the
     * IAM User Guide.
     *
     * The GenerateServiceLastAccessedDetails operation returns a
     * JobId. Use this parameter in the following operations to retrieve the
     * following details from your report:
     *
     *
     *
     * GetServiceLastAccessedDetails – Use this operation
     * for users, groups, roles, or policies to list every Amazon Web Services service that the
     * resource could access using permissions policies. For each service, the response
     * includes information about the most recent access attempt.
     * The JobId returned by
     * GenerateServiceLastAccessedDetail must be used by the same role
     * within a session, or by the same user when used to call
     * GetServiceLastAccessedDetail.
     *
     *
     * GetServiceLastAccessedDetailsWithEntities – Use this
     * operation for groups and policies to list information about the associated
     * entities (users or roles) that attempted to access a specific Amazon Web Services service.
     *
     *
     *
     * To check the status of the GenerateServiceLastAccessedDetails request,
     * use the JobId parameter in the same operations and test the
     * JobStatus response parameter.
     * For additional information about the permissions policies that allow an identity
     * (user, group, or role) to access specific services, use the ListPoliciesGrantingServiceAccess operation.
     *
     * Service last accessed data does not use other policy types when determining
     * whether a resource could access a service. These other policy types include
     * resource-based policies, access control lists, Organizations policies, IAM permissions
     * boundaries, and STS assume role policies. It only applies permissions policy
     * logic. For more about the evaluation of policy types, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics">Evaluating policies in the
     * IAM User Guide.
     *
     * For more information about service and action last accessed data, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing permissions using service last accessed data in the
     * IAM User Guide.
     */
    suspend fun generateServiceLastAccessedDetails(input: GenerateServiceLastAccessedDetailsRequest): GenerateServiceLastAccessedDetailsResponse

    /**
     * Generates a report that includes details about when an IAM resource (user, group,
     * role, or policy) was last used in an attempt to access Amazon Web Services services. Recent activity
     * usually appears within four hours. IAM reports activity for at least the last 400
     * days, or less if your Region began supporting this feature within the last year. For
     * more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked.
     *
     * The service last accessed data includes all attempts to access an Amazon Web Services API, not
     * just the successful ones. This includes all attempts that were made using the
     * Amazon Web Services Management Console, the Amazon Web Services API through any of the SDKs, or any of the command line tools.
     * An unexpected entry in the service last accessed data does not mean that your
     * account has been compromised, because the request might have been denied. Refer to
     * your CloudTrail logs as the authoritative source for information about all API calls
     * and whether they were successful or denied access. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html">Logging
     * IAM events with CloudTrail in the
     * IAM User Guide.
     *
     * The GenerateServiceLastAccessedDetails operation returns a
     * JobId. Use this parameter in the following operations to retrieve the
     * following details from your report:
     *
     *
     *
     * GetServiceLastAccessedDetails – Use this operation
     * for users, groups, roles, or policies to list every Amazon Web Services service that the
     * resource could access using permissions policies. For each service, the response
     * includes information about the most recent access attempt.
     * The JobId returned by
     * GenerateServiceLastAccessedDetail must be used by the same role
     * within a session, or by the same user when used to call
     * GetServiceLastAccessedDetail.
     *
     *
     * GetServiceLastAccessedDetailsWithEntities – Use this
     * operation for groups and policies to list information about the associated
     * entities (users or roles) that attempted to access a specific Amazon Web Services service.
     *
     *
     *
     * To check the status of the GenerateServiceLastAccessedDetails request,
     * use the JobId parameter in the same operations and test the
     * JobStatus response parameter.
     * For additional information about the permissions policies that allow an identity
     * (user, group, or role) to access specific services, use the ListPoliciesGrantingServiceAccess operation.
     *
     * Service last accessed data does not use other policy types when determining
     * whether a resource could access a service. These other policy types include
     * resource-based policies, access control lists, Organizations policies, IAM permissions
     * boundaries, and STS assume role policies. It only applies permissions policy
     * logic. For more about the evaluation of policy types, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics">Evaluating policies in the
     * IAM User Guide.
     *
     * For more information about service and action last accessed data, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing permissions using service last accessed data in the
     * IAM User Guide.
     */
    suspend fun generateServiceLastAccessedDetails(block: GenerateServiceLastAccessedDetailsRequest.Builder.() -> Unit) = generateServiceLastAccessedDetails(GenerateServiceLastAccessedDetailsRequest.Builder().apply(block).build())

    /**
     * Retrieves information about when the specified access key was last used. The
     * information includes the date and time of last use, along with the Amazon Web Services service and
     * Region that were specified in the last request made with that key.
     */
    suspend fun getAccessKeyLastUsed(input: GetAccessKeyLastUsedRequest): GetAccessKeyLastUsedResponse

    /**
     * Retrieves information about when the specified access key was last used. The
     * information includes the date and time of last use, along with the Amazon Web Services service and
     * Region that were specified in the last request made with that key.
     */
    suspend fun getAccessKeyLastUsed(block: GetAccessKeyLastUsedRequest.Builder.() -> Unit) = getAccessKeyLastUsed(GetAccessKeyLastUsedRequest.Builder().apply(block).build())

    /**
     * Retrieves information about all IAM users, groups, roles, and policies in your Amazon Web Services
     * account, including their relationships to one another. Use this operation to obtain a
     * snapshot of the configuration of IAM permissions (users, groups, roles, and policies)
     * in your account.
     *
     * Policies returned by this operation are URL-encoded compliant
     * with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986. You can use a URL
     * decoding method to convert the policy back to plain JSON text. For example, if you use Java, you
     * can use the decode method of the java.net.URLDecoder utility class in
     * the Java SDK. Other languages and SDKs provide similar functionality.
     *
     * You can optionally filter the results using the Filter parameter. You can
     * paginate the results using the MaxItems and Marker
     * parameters.
     */
    suspend fun getAccountAuthorizationDetails(input: GetAccountAuthorizationDetailsRequest): GetAccountAuthorizationDetailsResponse

    /**
     * Retrieves information about all IAM users, groups, roles, and policies in your Amazon Web Services
     * account, including their relationships to one another. Use this operation to obtain a
     * snapshot of the configuration of IAM permissions (users, groups, roles, and policies)
     * in your account.
     *
     * Policies returned by this operation are URL-encoded compliant
     * with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986. You can use a URL
     * decoding method to convert the policy back to plain JSON text. For example, if you use Java, you
     * can use the decode method of the java.net.URLDecoder utility class in
     * the Java SDK. Other languages and SDKs provide similar functionality.
     *
     * You can optionally filter the results using the Filter parameter. You can
     * paginate the results using the MaxItems and Marker
     * parameters.
     */
    suspend fun getAccountAuthorizationDetails(block: GetAccountAuthorizationDetailsRequest.Builder.() -> Unit) = getAccountAuthorizationDetails(GetAccountAuthorizationDetailsRequest.Builder().apply(block).build())

    /**
     * Retrieves the password policy for the Amazon Web Services account. This tells you the complexity
     * requirements and mandatory rotation periods for the IAM user passwords in your account.
     * For more information about using a password policy, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html">Managing an IAM password
     * policy.
     */
    suspend fun getAccountPasswordPolicy(input: GetAccountPasswordPolicyRequest): GetAccountPasswordPolicyResponse

    /**
     * Retrieves the password policy for the Amazon Web Services account. This tells you the complexity
     * requirements and mandatory rotation periods for the IAM user passwords in your account.
     * For more information about using a password policy, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html">Managing an IAM password
     * policy.
     */
    suspend fun getAccountPasswordPolicy(block: GetAccountPasswordPolicyRequest.Builder.() -> Unit) = getAccountPasswordPolicy(GetAccountPasswordPolicyRequest.Builder().apply(block).build())

    /**
     * Retrieves information about IAM entity usage and IAM quotas in the Amazon Web Services
     * account.
     * For information about IAM quotas, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas in the
     * IAM User Guide.
     */
    suspend fun getAccountSummary(input: GetAccountSummaryRequest): GetAccountSummaryResponse

    /**
     * Retrieves information about IAM entity usage and IAM quotas in the Amazon Web Services
     * account.
     * For information about IAM quotas, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas in the
     * IAM User Guide.
     */
    suspend fun getAccountSummary(block: GetAccountSummaryRequest.Builder.() -> Unit) = getAccountSummary(GetAccountSummaryRequest.Builder().apply(block).build())

    /**
     * Gets a list of all of the context keys referenced in the input policies. The policies
     * are supplied as a list of one or more strings. To get the context keys from policies
     * associated with an IAM user, group, or role, use GetContextKeysForPrincipalPolicy.
     * Context keys are variables maintained by Amazon Web Services and its services that provide details
     * about the context of an API query request. Context keys can be evaluated by testing
     * against a value specified in an IAM policy. Use
     * GetContextKeysForCustomPolicy to understand what key names and values
     * you must supply when you call SimulateCustomPolicy. Note that all
     * parameters are shown in unencoded form here for clarity but must be URL encoded to be
     * included as a part of a real HTML request.
     */
    suspend fun getContextKeysForCustomPolicy(input: GetContextKeysForCustomPolicyRequest): GetContextKeysForCustomPolicyResponse

    /**
     * Gets a list of all of the context keys referenced in the input policies. The policies
     * are supplied as a list of one or more strings. To get the context keys from policies
     * associated with an IAM user, group, or role, use GetContextKeysForPrincipalPolicy.
     * Context keys are variables maintained by Amazon Web Services and its services that provide details
     * about the context of an API query request. Context keys can be evaluated by testing
     * against a value specified in an IAM policy. Use
     * GetContextKeysForCustomPolicy to understand what key names and values
     * you must supply when you call SimulateCustomPolicy. Note that all
     * parameters are shown in unencoded form here for clarity but must be URL encoded to be
     * included as a part of a real HTML request.
     */
    suspend fun getContextKeysForCustomPolicy(block: GetContextKeysForCustomPolicyRequest.Builder.() -> Unit) = getContextKeysForCustomPolicy(GetContextKeysForCustomPolicyRequest.Builder().apply(block).build())

    /**
     * Gets a list of all of the context keys referenced in all the IAM policies that are
     * attached to the specified IAM entity. The entity can be an IAM user, group, or role.
     * If you specify a user, then the request also includes all of the policies attached to
     * groups that the user is a member of.
     * You can optionally include a list of one or more additional policies, specified as
     * strings. If you want to include only a list of policies by string,
     * use GetContextKeysForCustomPolicy instead.
     *
     * Note: This operation discloses information about the
     * permissions granted to other users. If you do not want users to see other user's
     * permissions, then consider allowing them to use GetContextKeysForCustomPolicy instead.
     * Context keys are variables maintained by Amazon Web Services and its services that provide details
     * about the context of an API query request. Context keys can be evaluated by testing
     * against a value in an IAM policy. Use GetContextKeysForPrincipalPolicy to understand what key names and values you must supply when you call SimulatePrincipalPolicy.
     */
    suspend fun getContextKeysForPrincipalPolicy(input: GetContextKeysForPrincipalPolicyRequest): GetContextKeysForPrincipalPolicyResponse

    /**
     * Gets a list of all of the context keys referenced in all the IAM policies that are
     * attached to the specified IAM entity. The entity can be an IAM user, group, or role.
     * If you specify a user, then the request also includes all of the policies attached to
     * groups that the user is a member of.
     * You can optionally include a list of one or more additional policies, specified as
     * strings. If you want to include only a list of policies by string,
     * use GetContextKeysForCustomPolicy instead.
     *
     * Note: This operation discloses information about the
     * permissions granted to other users. If you do not want users to see other user's
     * permissions, then consider allowing them to use GetContextKeysForCustomPolicy instead.
     * Context keys are variables maintained by Amazon Web Services and its services that provide details
     * about the context of an API query request. Context keys can be evaluated by testing
     * against a value in an IAM policy. Use GetContextKeysForPrincipalPolicy to understand what key names and values you must supply when you call SimulatePrincipalPolicy.
     */
    suspend fun getContextKeysForPrincipalPolicy(block: GetContextKeysForPrincipalPolicyRequest.Builder.() -> Unit) = getContextKeysForPrincipalPolicy(GetContextKeysForPrincipalPolicyRequest.Builder().apply(block).build())

    /**
     * Retrieves a credential report for the Amazon Web Services account. For more information about the
     * credential report, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential reports in
     * the IAM User Guide.
     */
    suspend fun getCredentialReport(input: GetCredentialReportRequest): GetCredentialReportResponse

    /**
     * Retrieves a credential report for the Amazon Web Services account. For more information about the
     * credential report, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential reports in
     * the IAM User Guide.
     */
    suspend fun getCredentialReport(block: GetCredentialReportRequest.Builder.() -> Unit) = getCredentialReport(GetCredentialReportRequest.Builder().apply(block).build())

    /**
     * Returns a list of IAM users that are in the specified IAM group. You can paginate
     * the results using the MaxItems and Marker parameters.
     */
    suspend fun getGroup(input: GetGroupRequest): GetGroupResponse

    /**
     * Returns a list of IAM users that are in the specified IAM group. You can paginate
     * the results using the MaxItems and Marker parameters.
     */
    suspend fun getGroup(block: GetGroupRequest.Builder.() -> Unit) = getGroup(GetGroupRequest.Builder().apply(block).build())

    /**
     * Retrieves the specified inline policy document that is embedded in the specified IAM
     * group.
     *
     * Policies returned by this operation are URL-encoded compliant
     * with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986. You can use a URL
     * decoding method to convert the policy back to plain JSON text. For example, if you use Java, you
     * can use the decode method of the java.net.URLDecoder utility class in
     * the Java SDK. Other languages and SDKs provide similar functionality.
     *
     * An IAM group can also have managed policies attached to it. To retrieve a managed
     * policy document that is attached to a group, use GetPolicy to
     * determine the policy's default version, then use GetPolicyVersion to
     * retrieve the policy document.
     * For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     */
    suspend fun getGroupPolicy(input: GetGroupPolicyRequest): GetGroupPolicyResponse

    /**
     * Retrieves the specified inline policy document that is embedded in the specified IAM
     * group.
     *
     * Policies returned by this operation are URL-encoded compliant
     * with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986. You can use a URL
     * decoding method to convert the policy back to plain JSON text. For example, if you use Java, you
     * can use the decode method of the java.net.URLDecoder utility class in
     * the Java SDK. Other languages and SDKs provide similar functionality.
     *
     * An IAM group can also have managed policies attached to it. To retrieve a managed
     * policy document that is attached to a group, use GetPolicy to
     * determine the policy's default version, then use GetPolicyVersion to
     * retrieve the policy document.
     * For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     */
    suspend fun getGroupPolicy(block: GetGroupPolicyRequest.Builder.() -> Unit) = getGroupPolicy(GetGroupPolicyRequest.Builder().apply(block).build())

    /**
     * Retrieves information about the specified instance profile, including the instance
     * profile's path, GUID, ARN, and role. For more information about instance profiles, see
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About
     * instance profiles in the IAM User Guide.
     */
    suspend fun getInstanceProfile(input: GetInstanceProfileRequest): GetInstanceProfileResponse

    /**
     * Retrieves information about the specified instance profile, including the instance
     * profile's path, GUID, ARN, and role. For more information about instance profiles, see
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About
     * instance profiles in the IAM User Guide.
     */
    suspend fun getInstanceProfile(block: GetInstanceProfileRequest.Builder.() -> Unit) = getInstanceProfile(GetInstanceProfileRequest.Builder().apply(block).build())

    /**
     * Retrieves the user name for the specified IAM user. A login profile is created when
     * you create a password for the user to access the Amazon Web Services Management Console. If the user does not exist
     * or does not have a password, the operation returns a 404 (NoSuchEntity)
     * error.
     * If you create an IAM user with access to the console, the CreateDate
     * reflects the date you created the initial password for the user.
     * If you create an IAM user with programmatic access, and then later add a password
     * for the user to access the Amazon Web Services Management Console, the CreateDate reflects the initial
     * password creation date. A user with programmatic access does not have a login profile
     * unless you create a password for the user to access the Amazon Web Services Management Console.
     */
    suspend fun getLoginProfile(input: GetLoginProfileRequest): GetLoginProfileResponse

    /**
     * Retrieves the user name for the specified IAM user. A login profile is created when
     * you create a password for the user to access the Amazon Web Services Management Console. If the user does not exist
     * or does not have a password, the operation returns a 404 (NoSuchEntity)
     * error.
     * If you create an IAM user with access to the console, the CreateDate
     * reflects the date you created the initial password for the user.
     * If you create an IAM user with programmatic access, and then later add a password
     * for the user to access the Amazon Web Services Management Console, the CreateDate reflects the initial
     * password creation date. A user with programmatic access does not have a login profile
     * unless you create a password for the user to access the Amazon Web Services Management Console.
     */
    suspend fun getLoginProfile(block: GetLoginProfileRequest.Builder.() -> Unit) = getLoginProfile(GetLoginProfileRequest.Builder().apply(block).build())

    /**
     * Returns information about the specified OpenID Connect (OIDC) provider resource object
     * in IAM.
     */
    suspend fun getOpenIdConnectProvider(input: GetOpenIdConnectProviderRequest): GetOpenIdConnectProviderResponse

    /**
     * Returns information about the specified OpenID Connect (OIDC) provider resource object
     * in IAM.
     */
    suspend fun getOpenIdConnectProvider(block: GetOpenIdConnectProviderRequest.Builder.() -> Unit) = getOpenIdConnectProvider(GetOpenIdConnectProviderRequest.Builder().apply(block).build())

    /**
     * Retrieves the service last accessed data report for Organizations that was previously
     * generated using the
     * GenerateOrganizationsAccessReport
     *
     * operation. This operation retrieves the status of your report job and the report
     * contents.
     * Depending on the parameters that you passed when you generated the report, the data
     * returned could include different information. For details, see GenerateOrganizationsAccessReport.
     * To call this operation, you must be signed in to the management account in your
     * organization. SCPs must be enabled for your organization root. You must have permissions
     * to perform this operation. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Refining permissions using
     * service last accessed data in the
     * IAM User Guide.
     * For each service that principals in an account (root users, IAM users, or IAM
     * roles) could access using SCPs, the operation returns details about the most recent
     * access attempt. If there was no attempt, the service is listed without details about the
     * most recent attempt to access the service. If the operation fails, it returns the reason
     * that it failed.
     * By default, the list is sorted by service namespace.
     */
    suspend fun getOrganizationsAccessReport(input: GetOrganizationsAccessReportRequest): GetOrganizationsAccessReportResponse

    /**
     * Retrieves the service last accessed data report for Organizations that was previously
     * generated using the
     * GenerateOrganizationsAccessReport
     *
     * operation. This operation retrieves the status of your report job and the report
     * contents.
     * Depending on the parameters that you passed when you generated the report, the data
     * returned could include different information. For details, see GenerateOrganizationsAccessReport.
     * To call this operation, you must be signed in to the management account in your
     * organization. SCPs must be enabled for your organization root. You must have permissions
     * to perform this operation. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Refining permissions using
     * service last accessed data in the
     * IAM User Guide.
     * For each service that principals in an account (root users, IAM users, or IAM
     * roles) could access using SCPs, the operation returns details about the most recent
     * access attempt. If there was no attempt, the service is listed without details about the
     * most recent attempt to access the service. If the operation fails, it returns the reason
     * that it failed.
     * By default, the list is sorted by service namespace.
     */
    suspend fun getOrganizationsAccessReport(block: GetOrganizationsAccessReportRequest.Builder.() -> Unit) = getOrganizationsAccessReport(GetOrganizationsAccessReportRequest.Builder().apply(block).build())

    /**
     * Retrieves information about the specified managed policy, including the policy's
     * default version and the total number of IAM users, groups, and roles to which the
     * policy is attached. To retrieve the list of the specific users, groups, and roles that
     * the policy is attached to, use ListEntitiesForPolicy. This operation
     * returns metadata about the policy. To retrieve the actual policy document for a specific
     * version of the policy, use GetPolicyVersion.
     * This operation retrieves information about managed policies. To retrieve information
     * about an inline policy that is embedded with an IAM user, group, or role, use GetUserPolicy, GetGroupPolicy, or GetRolePolicy.
     * For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     */
    suspend fun getPolicy(input: GetPolicyRequest): GetPolicyResponse

    /**
     * Retrieves information about the specified managed policy, including the policy's
     * default version and the total number of IAM users, groups, and roles to which the
     * policy is attached. To retrieve the list of the specific users, groups, and roles that
     * the policy is attached to, use ListEntitiesForPolicy. This operation
     * returns metadata about the policy. To retrieve the actual policy document for a specific
     * version of the policy, use GetPolicyVersion.
     * This operation retrieves information about managed policies. To retrieve information
     * about an inline policy that is embedded with an IAM user, group, or role, use GetUserPolicy, GetGroupPolicy, or GetRolePolicy.
     * For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     */
    suspend fun getPolicy(block: GetPolicyRequest.Builder.() -> Unit) = getPolicy(GetPolicyRequest.Builder().apply(block).build())

    /**
     * Retrieves information about the specified version of the specified managed policy,
     * including the policy document.
     *
     * Policies returned by this operation are URL-encoded compliant
     * with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986. You can use a URL
     * decoding method to convert the policy back to plain JSON text. For example, if you use Java, you
     * can use the decode method of the java.net.URLDecoder utility class in
     * the Java SDK. Other languages and SDKs provide similar functionality.
     *
     * To list the available versions for a policy, use ListPolicyVersions.
     * This operation retrieves information about managed policies. To retrieve information
     * about an inline policy that is embedded in a user, group, or role, use GetUserPolicy, GetGroupPolicy, or GetRolePolicy.
     * For more information about the types of policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     * For more information about managed policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies in the IAM User Guide.
     */
    suspend fun getPolicyVersion(input: GetPolicyVersionRequest): GetPolicyVersionResponse

    /**
     * Retrieves information about the specified version of the specified managed policy,
     * including the policy document.
     *
     * Policies returned by this operation are URL-encoded compliant
     * with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986. You can use a URL
     * decoding method to convert the policy back to plain JSON text. For example, if you use Java, you
     * can use the decode method of the java.net.URLDecoder utility class in
     * the Java SDK. Other languages and SDKs provide similar functionality.
     *
     * To list the available versions for a policy, use ListPolicyVersions.
     * This operation retrieves information about managed policies. To retrieve information
     * about an inline policy that is embedded in a user, group, or role, use GetUserPolicy, GetGroupPolicy, or GetRolePolicy.
     * For more information about the types of policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     * For more information about managed policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies in the IAM User Guide.
     */
    suspend fun getPolicyVersion(block: GetPolicyVersionRequest.Builder.() -> Unit) = getPolicyVersion(GetPolicyVersionRequest.Builder().apply(block).build())

    /**
     * Retrieves information about the specified role, including the role's path, GUID, ARN,
     * and the role's trust policy that grants permission to assume the role. For more
     * information about roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with roles.
     *
     * Policies returned by this operation are URL-encoded compliant
     * with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986. You can use a URL
     * decoding method to convert the policy back to plain JSON text. For example, if you use Java, you
     * can use the decode method of the java.net.URLDecoder utility class in
     * the Java SDK. Other languages and SDKs provide similar functionality.
     */
    suspend fun getRole(input: GetRoleRequest): GetRoleResponse

    /**
     * Retrieves information about the specified role, including the role's path, GUID, ARN,
     * and the role's trust policy that grants permission to assume the role. For more
     * information about roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with roles.
     *
     * Policies returned by this operation are URL-encoded compliant
     * with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986. You can use a URL
     * decoding method to convert the policy back to plain JSON text. For example, if you use Java, you
     * can use the decode method of the java.net.URLDecoder utility class in
     * the Java SDK. Other languages and SDKs provide similar functionality.
     */
    suspend fun getRole(block: GetRoleRequest.Builder.() -> Unit) = getRole(GetRoleRequest.Builder().apply(block).build())

    /**
     * Retrieves the specified inline policy document that is embedded with the specified
     * IAM role.
     *
     * Policies returned by this operation are URL-encoded compliant
     * with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986. You can use a URL
     * decoding method to convert the policy back to plain JSON text. For example, if you use Java, you
     * can use the decode method of the java.net.URLDecoder utility class in
     * the Java SDK. Other languages and SDKs provide similar functionality.
     *
     * An IAM role can also have managed policies attached to it. To retrieve a managed
     * policy document that is attached to a role, use GetPolicy to determine
     * the policy's default version, then use GetPolicyVersion to retrieve
     * the policy document.
     * For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     * For more information about roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html">Using roles to delegate permissions and
     * federate identities.
     */
    suspend fun getRolePolicy(input: GetRolePolicyRequest): GetRolePolicyResponse

    /**
     * Retrieves the specified inline policy document that is embedded with the specified
     * IAM role.
     *
     * Policies returned by this operation are URL-encoded compliant
     * with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986. You can use a URL
     * decoding method to convert the policy back to plain JSON text. For example, if you use Java, you
     * can use the decode method of the java.net.URLDecoder utility class in
     * the Java SDK. Other languages and SDKs provide similar functionality.
     *
     * An IAM role can also have managed policies attached to it. To retrieve a managed
     * policy document that is attached to a role, use GetPolicy to determine
     * the policy's default version, then use GetPolicyVersion to retrieve
     * the policy document.
     * For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     * For more information about roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html">Using roles to delegate permissions and
     * federate identities.
     */
    suspend fun getRolePolicy(block: GetRolePolicyRequest.Builder.() -> Unit) = getRolePolicy(GetRolePolicyRequest.Builder().apply(block).build())

    /**
     * Returns the SAML provider metadocument that was uploaded when the IAM SAML provider
     * resource object was created or updated.
     *
     * This operation requires <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4.
     */
    suspend fun getSamlProvider(input: GetSamlProviderRequest): GetSamlProviderResponse

    /**
     * Returns the SAML provider metadocument that was uploaded when the IAM SAML provider
     * resource object was created or updated.
     *
     * This operation requires <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4.
     */
    suspend fun getSamlProvider(block: GetSamlProviderRequest.Builder.() -> Unit) = getSamlProvider(GetSamlProviderRequest.Builder().apply(block).build())

    /**
     * Retrieves information about the specified server certificate stored in IAM.
     * For more information about working with server certificates, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working
     * with server certificates in the IAM User Guide. This
     * topic includes a list of Amazon Web Services services that can use the server certificates that you
     * manage with IAM.
     */
    suspend fun getServerCertificate(input: GetServerCertificateRequest): GetServerCertificateResponse

    /**
     * Retrieves information about the specified server certificate stored in IAM.
     * For more information about working with server certificates, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working
     * with server certificates in the IAM User Guide. This
     * topic includes a list of Amazon Web Services services that can use the server certificates that you
     * manage with IAM.
     */
    suspend fun getServerCertificate(block: GetServerCertificateRequest.Builder.() -> Unit) = getServerCertificate(GetServerCertificateRequest.Builder().apply(block).build())

    /**
     * Retrieves a service last accessed report that was created using the
     * GenerateServiceLastAccessedDetails operation. You can use the
     * JobId parameter in GetServiceLastAccessedDetails to
     * retrieve the status of your report job. When the report is complete, you can retrieve
     * the generated report. The report includes a list of Amazon Web Services services that the resource
     * (user, group, role, or managed policy) can access.
     *
     * Service last accessed data does not use other policy types when determining
     * whether a resource could access a service. These other policy types include
     * resource-based policies, access control lists, Organizations policies, IAM permissions
     * boundaries, and STS assume role policies. It only applies permissions policy
     * logic. For more about the evaluation of policy types, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics">Evaluating policies in the
     * IAM User Guide.
     *
     * For each service that the resource could access using permissions policies, the
     * operation returns details about the most recent access attempt. If there was no attempt,
     * the service is listed without details about the most recent attempt to access the
     * service. If the operation fails, the GetServiceLastAccessedDetails
     * operation returns the reason that it failed.
     * The GetServiceLastAccessedDetails operation returns a list of services.
     * This list includes the number of entities that have attempted to access the service and
     * the date and time of the last attempt. It also returns the ARN of the following entity,
     * depending on the resource ARN that you used to generate the report:
     *
     *
     *
     * User – Returns the user ARN that you
     * used to generate the report
     *
     *
     * Group – Returns the ARN of the group
     * member (user) that last attempted to access the service
     *
     *
     * Role – Returns the role ARN that you
     * used to generate the report
     *
     *
     * Policy – Returns the ARN of the user
     * or role that last used the policy to attempt to access the service
     *
     *
     * By default, the list is sorted by service namespace.
     * If you specified ACTION_LEVEL granularity when you generated the report,
     * this operation returns service and action last accessed data. This includes the most
     * recent access attempt for each tracked action within a service. Otherwise, this
     * operation returns only service data.
     * For more information about service and action last accessed data, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing permissions using service last accessed data in the
     * IAM User Guide.
     */
    suspend fun getServiceLastAccessedDetails(input: GetServiceLastAccessedDetailsRequest): GetServiceLastAccessedDetailsResponse

    /**
     * Retrieves a service last accessed report that was created using the
     * GenerateServiceLastAccessedDetails operation. You can use the
     * JobId parameter in GetServiceLastAccessedDetails to
     * retrieve the status of your report job. When the report is complete, you can retrieve
     * the generated report. The report includes a list of Amazon Web Services services that the resource
     * (user, group, role, or managed policy) can access.
     *
     * Service last accessed data does not use other policy types when determining
     * whether a resource could access a service. These other policy types include
     * resource-based policies, access control lists, Organizations policies, IAM permissions
     * boundaries, and STS assume role policies. It only applies permissions policy
     * logic. For more about the evaluation of policy types, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics">Evaluating policies in the
     * IAM User Guide.
     *
     * For each service that the resource could access using permissions policies, the
     * operation returns details about the most recent access attempt. If there was no attempt,
     * the service is listed without details about the most recent attempt to access the
     * service. If the operation fails, the GetServiceLastAccessedDetails
     * operation returns the reason that it failed.
     * The GetServiceLastAccessedDetails operation returns a list of services.
     * This list includes the number of entities that have attempted to access the service and
     * the date and time of the last attempt. It also returns the ARN of the following entity,
     * depending on the resource ARN that you used to generate the report:
     *
     *
     *
     * User – Returns the user ARN that you
     * used to generate the report
     *
     *
     * Group – Returns the ARN of the group
     * member (user) that last attempted to access the service
     *
     *
     * Role – Returns the role ARN that you
     * used to generate the report
     *
     *
     * Policy – Returns the ARN of the user
     * or role that last used the policy to attempt to access the service
     *
     *
     * By default, the list is sorted by service namespace.
     * If you specified ACTION_LEVEL granularity when you generated the report,
     * this operation returns service and action last accessed data. This includes the most
     * recent access attempt for each tracked action within a service. Otherwise, this
     * operation returns only service data.
     * For more information about service and action last accessed data, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing permissions using service last accessed data in the
     * IAM User Guide.
     */
    suspend fun getServiceLastAccessedDetails(block: GetServiceLastAccessedDetailsRequest.Builder.() -> Unit) = getServiceLastAccessedDetails(GetServiceLastAccessedDetailsRequest.Builder().apply(block).build())

    /**
     * After you generate a group or policy report using the
     * GenerateServiceLastAccessedDetails operation, you can use the
     * JobId parameter in
     * GetServiceLastAccessedDetailsWithEntities. This operation retrieves the
     * status of your report job and a list of entities that could have used group or policy
     * permissions to access the specified service.
     *
     *
     *
     * Group – For a group report, this
     * operation returns a list of users in the group that could have used the group’s
     * policies in an attempt to access the service.
     *
     *
     * Policy – For a policy report, this
     * operation returns a list of entities (users or roles) that could have used the
     * policy in an attempt to access the service.
     *
     *
     * You can also use this operation for user or role reports to retrieve details about
     * those entities.
     * If the operation fails, the GetServiceLastAccessedDetailsWithEntities
     * operation returns the reason that it failed.
     * By default, the list of associated entities is sorted by date, with the most recent
     * access listed first.
     */
    suspend fun getServiceLastAccessedDetailsWithEntities(input: GetServiceLastAccessedDetailsWithEntitiesRequest): GetServiceLastAccessedDetailsWithEntitiesResponse

    /**
     * After you generate a group or policy report using the
     * GenerateServiceLastAccessedDetails operation, you can use the
     * JobId parameter in
     * GetServiceLastAccessedDetailsWithEntities. This operation retrieves the
     * status of your report job and a list of entities that could have used group or policy
     * permissions to access the specified service.
     *
     *
     *
     * Group – For a group report, this
     * operation returns a list of users in the group that could have used the group’s
     * policies in an attempt to access the service.
     *
     *
     * Policy – For a policy report, this
     * operation returns a list of entities (users or roles) that could have used the
     * policy in an attempt to access the service.
     *
     *
     * You can also use this operation for user or role reports to retrieve details about
     * those entities.
     * If the operation fails, the GetServiceLastAccessedDetailsWithEntities
     * operation returns the reason that it failed.
     * By default, the list of associated entities is sorted by date, with the most recent
     * access listed first.
     */
    suspend fun getServiceLastAccessedDetailsWithEntities(block: GetServiceLastAccessedDetailsWithEntitiesRequest.Builder.() -> Unit) = getServiceLastAccessedDetailsWithEntities(GetServiceLastAccessedDetailsWithEntitiesRequest.Builder().apply(block).build())

    /**
     * Retrieves the status of your service-linked role deletion. After you use DeleteServiceLinkedRole to submit a service-linked role for deletion,
     * you can use the DeletionTaskId parameter in
     * GetServiceLinkedRoleDeletionStatus to check the status of the deletion.
     * If the deletion fails, this operation returns the reason that it failed, if that
     * information is returned by the service.
     */
    suspend fun getServiceLinkedRoleDeletionStatus(input: GetServiceLinkedRoleDeletionStatusRequest): GetServiceLinkedRoleDeletionStatusResponse

    /**
     * Retrieves the status of your service-linked role deletion. After you use DeleteServiceLinkedRole to submit a service-linked role for deletion,
     * you can use the DeletionTaskId parameter in
     * GetServiceLinkedRoleDeletionStatus to check the status of the deletion.
     * If the deletion fails, this operation returns the reason that it failed, if that
     * information is returned by the service.
     */
    suspend fun getServiceLinkedRoleDeletionStatus(block: GetServiceLinkedRoleDeletionStatusRequest.Builder.() -> Unit) = getServiceLinkedRoleDeletionStatus(GetServiceLinkedRoleDeletionStatusRequest.Builder().apply(block).build())

    /**
     * Retrieves the specified SSH public key, including metadata about the key.
     * The SSH public key retrieved by this operation is used only for authenticating the
     * associated IAM user to an CodeCommit repository. For more information about using SSH keys
     * to authenticate to an CodeCommit repository, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up CodeCommit for SSH
     * connections in the CodeCommit User Guide.
     */
    suspend fun getSshPublicKey(input: GetSshPublicKeyRequest): GetSshPublicKeyResponse

    /**
     * Retrieves the specified SSH public key, including metadata about the key.
     * The SSH public key retrieved by this operation is used only for authenticating the
     * associated IAM user to an CodeCommit repository. For more information about using SSH keys
     * to authenticate to an CodeCommit repository, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up CodeCommit for SSH
     * connections in the CodeCommit User Guide.
     */
    suspend fun getSshPublicKey(block: GetSshPublicKeyRequest.Builder.() -> Unit) = getSshPublicKey(GetSshPublicKeyRequest.Builder().apply(block).build())

    /**
     * Retrieves information about the specified IAM user, including the user's creation
     * date, path, unique ID, and ARN.
     * If you do not specify a user name, IAM determines the user name implicitly based on
     * the Amazon Web Services access key ID used to sign the request to this operation.
     */
    suspend fun getUser(input: GetUserRequest): GetUserResponse

    /**
     * Retrieves information about the specified IAM user, including the user's creation
     * date, path, unique ID, and ARN.
     * If you do not specify a user name, IAM determines the user name implicitly based on
     * the Amazon Web Services access key ID used to sign the request to this operation.
     */
    suspend fun getUser(block: GetUserRequest.Builder.() -> Unit) = getUser(GetUserRequest.Builder().apply(block).build())

    /**
     * Retrieves the specified inline policy document that is embedded in the specified IAM
     * user.
     *
     * Policies returned by this operation are URL-encoded compliant
     * with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986. You can use a URL
     * decoding method to convert the policy back to plain JSON text. For example, if you use Java, you
     * can use the decode method of the java.net.URLDecoder utility class in
     * the Java SDK. Other languages and SDKs provide similar functionality.
     *
     * An IAM user can also have managed policies attached to it. To retrieve a managed
     * policy document that is attached to a user, use GetPolicy to determine
     * the policy's default version. Then use GetPolicyVersion to retrieve
     * the policy document.
     * For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     */
    suspend fun getUserPolicy(input: GetUserPolicyRequest): GetUserPolicyResponse

    /**
     * Retrieves the specified inline policy document that is embedded in the specified IAM
     * user.
     *
     * Policies returned by this operation are URL-encoded compliant
     * with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986. You can use a URL
     * decoding method to convert the policy back to plain JSON text. For example, if you use Java, you
     * can use the decode method of the java.net.URLDecoder utility class in
     * the Java SDK. Other languages and SDKs provide similar functionality.
     *
     * An IAM user can also have managed policies attached to it. To retrieve a managed
     * policy document that is attached to a user, use GetPolicy to determine
     * the policy's default version. Then use GetPolicyVersion to retrieve
     * the policy document.
     * For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     */
    suspend fun getUserPolicy(block: GetUserPolicyRequest.Builder.() -> Unit) = getUserPolicy(GetUserPolicyRequest.Builder().apply(block).build())

    /**
     * Returns information about the access key IDs associated with the specified IAM user.
     * If there is none, the operation returns an empty list.
     * Although each user is limited to a small number of keys, you can still paginate the
     * results using the MaxItems and Marker parameters.
     * If the UserName field is not specified, the user name is determined
     * implicitly based on the Amazon Web Services access key ID used to sign the request. This operation
     * works for access keys under the Amazon Web Services account. Consequently, you can use this operation
     * to manage Amazon Web Services account root user credentials even if the Amazon Web Services account has no
     * associated users.
     *
     * To ensure the security of your Amazon Web Services account, the secret access key is accessible
     * only during key and user creation.
     */
    suspend fun listAccessKeys(input: ListAccessKeysRequest): ListAccessKeysResponse

    /**
     * Returns information about the access key IDs associated with the specified IAM user.
     * If there is none, the operation returns an empty list.
     * Although each user is limited to a small number of keys, you can still paginate the
     * results using the MaxItems and Marker parameters.
     * If the UserName field is not specified, the user name is determined
     * implicitly based on the Amazon Web Services access key ID used to sign the request. This operation
     * works for access keys under the Amazon Web Services account. Consequently, you can use this operation
     * to manage Amazon Web Services account root user credentials even if the Amazon Web Services account has no
     * associated users.
     *
     * To ensure the security of your Amazon Web Services account, the secret access key is accessible
     * only during key and user creation.
     */
    suspend fun listAccessKeys(block: ListAccessKeysRequest.Builder.() -> Unit) = listAccessKeys(ListAccessKeysRequest.Builder().apply(block).build())

    /**
     * Lists the account alias associated with the Amazon Web Services account (Note: you can have only
     * one). For information about using an Amazon Web Services account alias, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an alias for your
     * Amazon Web Services account ID in the IAM User Guide.
     */
    suspend fun listAccountAliases(input: ListAccountAliasesRequest): ListAccountAliasesResponse

    /**
     * Lists the account alias associated with the Amazon Web Services account (Note: you can have only
     * one). For information about using an Amazon Web Services account alias, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an alias for your
     * Amazon Web Services account ID in the IAM User Guide.
     */
    suspend fun listAccountAliases(block: ListAccountAliasesRequest.Builder.() -> Unit) = listAccountAliases(ListAccountAliasesRequest.Builder().apply(block).build())

    /**
     * Lists all managed policies that are attached to the specified IAM group.
     * An IAM group can also have inline policies embedded with it. To list the inline
     * policies for a group, use ListGroupPolicies. For information about
     * policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     * You can paginate the results using the MaxItems and Marker
     * parameters. You can use the PathPrefix parameter to limit the list of
     * policies to only those matching the specified path prefix. If there are no policies
     * attached to the specified group (or none that match the specified path prefix), the
     * operation returns an empty list.
     */
    suspend fun listAttachedGroupPolicies(input: ListAttachedGroupPoliciesRequest): ListAttachedGroupPoliciesResponse

    /**
     * Lists all managed policies that are attached to the specified IAM group.
     * An IAM group can also have inline policies embedded with it. To list the inline
     * policies for a group, use ListGroupPolicies. For information about
     * policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     * You can paginate the results using the MaxItems and Marker
     * parameters. You can use the PathPrefix parameter to limit the list of
     * policies to only those matching the specified path prefix. If there are no policies
     * attached to the specified group (or none that match the specified path prefix), the
     * operation returns an empty list.
     */
    suspend fun listAttachedGroupPolicies(block: ListAttachedGroupPoliciesRequest.Builder.() -> Unit) = listAttachedGroupPolicies(ListAttachedGroupPoliciesRequest.Builder().apply(block).build())

    /**
     * Lists all managed policies that are attached to the specified IAM role.
     * An IAM role can also have inline policies embedded with it. To list the inline
     * policies for a role, use ListRolePolicies. For information about
     * policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     * You can paginate the results using the MaxItems and Marker
     * parameters. You can use the PathPrefix parameter to limit the list of
     * policies to only those matching the specified path prefix. If there are no policies
     * attached to the specified role (or none that match the specified path prefix), the
     * operation returns an empty list.
     */
    suspend fun listAttachedRolePolicies(input: ListAttachedRolePoliciesRequest): ListAttachedRolePoliciesResponse

    /**
     * Lists all managed policies that are attached to the specified IAM role.
     * An IAM role can also have inline policies embedded with it. To list the inline
     * policies for a role, use ListRolePolicies. For information about
     * policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     * You can paginate the results using the MaxItems and Marker
     * parameters. You can use the PathPrefix parameter to limit the list of
     * policies to only those matching the specified path prefix. If there are no policies
     * attached to the specified role (or none that match the specified path prefix), the
     * operation returns an empty list.
     */
    suspend fun listAttachedRolePolicies(block: ListAttachedRolePoliciesRequest.Builder.() -> Unit) = listAttachedRolePolicies(ListAttachedRolePoliciesRequest.Builder().apply(block).build())

    /**
     * Lists all managed policies that are attached to the specified IAM user.
     * An IAM user can also have inline policies embedded with it. To list the inline
     * policies for a user, use ListUserPolicies. For information about
     * policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     * You can paginate the results using the MaxItems and Marker
     * parameters. You can use the PathPrefix parameter to limit the list of
     * policies to only those matching the specified path prefix. If there are no policies
     * attached to the specified group (or none that match the specified path prefix), the
     * operation returns an empty list.
     */
    suspend fun listAttachedUserPolicies(input: ListAttachedUserPoliciesRequest): ListAttachedUserPoliciesResponse

    /**
     * Lists all managed policies that are attached to the specified IAM user.
     * An IAM user can also have inline policies embedded with it. To list the inline
     * policies for a user, use ListUserPolicies. For information about
     * policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     * You can paginate the results using the MaxItems and Marker
     * parameters. You can use the PathPrefix parameter to limit the list of
     * policies to only those matching the specified path prefix. If there are no policies
     * attached to the specified group (or none that match the specified path prefix), the
     * operation returns an empty list.
     */
    suspend fun listAttachedUserPolicies(block: ListAttachedUserPoliciesRequest.Builder.() -> Unit) = listAttachedUserPolicies(ListAttachedUserPoliciesRequest.Builder().apply(block).build())

    /**
     * Lists all IAM users, groups, and roles that the specified managed policy is attached
     * to.
     * You can use the optional EntityFilter parameter to limit the results to a
     * particular type of entity (users, groups, or roles). For example, to list only the roles
     * that are attached to the specified policy, set EntityFilter to
     * Role.
     * You can paginate the results using the MaxItems and Marker
     * parameters.
     */
    suspend fun listEntitiesForPolicy(input: ListEntitiesForPolicyRequest): ListEntitiesForPolicyResponse

    /**
     * Lists all IAM users, groups, and roles that the specified managed policy is attached
     * to.
     * You can use the optional EntityFilter parameter to limit the results to a
     * particular type of entity (users, groups, or roles). For example, to list only the roles
     * that are attached to the specified policy, set EntityFilter to
     * Role.
     * You can paginate the results using the MaxItems and Marker
     * parameters.
     */
    suspend fun listEntitiesForPolicy(block: ListEntitiesForPolicyRequest.Builder.() -> Unit) = listEntitiesForPolicy(ListEntitiesForPolicyRequest.Builder().apply(block).build())

    /**
     * Lists the names of the inline policies that are embedded in the specified IAM
     * group.
     * An IAM group can also have managed policies attached to it. To list the managed
     * policies that are attached to a group, use ListAttachedGroupPolicies.
     * For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     * You can paginate the results using the MaxItems and Marker
     * parameters. If there are no inline policies embedded with the specified group, the
     * operation returns an empty list.
     */
    suspend fun listGroupPolicies(input: ListGroupPoliciesRequest): ListGroupPoliciesResponse

    /**
     * Lists the names of the inline policies that are embedded in the specified IAM
     * group.
     * An IAM group can also have managed policies attached to it. To list the managed
     * policies that are attached to a group, use ListAttachedGroupPolicies.
     * For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     * You can paginate the results using the MaxItems and Marker
     * parameters. If there are no inline policies embedded with the specified group, the
     * operation returns an empty list.
     */
    suspend fun listGroupPolicies(block: ListGroupPoliciesRequest.Builder.() -> Unit) = listGroupPolicies(ListGroupPoliciesRequest.Builder().apply(block).build())

    /**
     * Lists the IAM groups that have the specified path prefix.
     * You can paginate the results using the MaxItems and Marker
     * parameters.
     */
    suspend fun listGroups(input: ListGroupsRequest): ListGroupsResponse

    /**
     * Lists the IAM groups that have the specified path prefix.
     * You can paginate the results using the MaxItems and Marker
     * parameters.
     */
    suspend fun listGroups(block: ListGroupsRequest.Builder.() -> Unit) = listGroups(ListGroupsRequest.Builder().apply(block).build())

    /**
     * Lists the IAM groups that the specified IAM user belongs to.
     * You can paginate the results using the MaxItems and Marker
     * parameters.
     */
    suspend fun listGroupsForUser(input: ListGroupsForUserRequest): ListGroupsForUserResponse

    /**
     * Lists the IAM groups that the specified IAM user belongs to.
     * You can paginate the results using the MaxItems and Marker
     * parameters.
     */
    suspend fun listGroupsForUser(block: ListGroupsForUserRequest.Builder.() -> Unit) = listGroupsForUser(ListGroupsForUserRequest.Builder().apply(block).build())

    /**
     * Lists the tags that are attached to the specified IAM instance profile. The returned list of tags is sorted by tag key.
     * For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun listInstanceProfileTags(input: ListInstanceProfileTagsRequest): ListInstanceProfileTagsResponse

    /**
     * Lists the tags that are attached to the specified IAM instance profile. The returned list of tags is sorted by tag key.
     * For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun listInstanceProfileTags(block: ListInstanceProfileTagsRequest.Builder.() -> Unit) = listInstanceProfileTags(ListInstanceProfileTagsRequest.Builder().apply(block).build())

    /**
     * Lists the instance profiles that have the specified path prefix. If there are none,
     * the operation returns an empty list. For more information about instance profiles, see
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About
     * instance profiles.
     *
     * IAM resource-listing operations return a subset of the available
     * attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for an instance profile, see GetInstanceProfile.
     *
     * You can paginate the results using the MaxItems and Marker
     * parameters.
     */
    suspend fun listInstanceProfiles(input: ListInstanceProfilesRequest): ListInstanceProfilesResponse

    /**
     * Lists the instance profiles that have the specified path prefix. If there are none,
     * the operation returns an empty list. For more information about instance profiles, see
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About
     * instance profiles.
     *
     * IAM resource-listing operations return a subset of the available
     * attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for an instance profile, see GetInstanceProfile.
     *
     * You can paginate the results using the MaxItems and Marker
     * parameters.
     */
    suspend fun listInstanceProfiles(block: ListInstanceProfilesRequest.Builder.() -> Unit) = listInstanceProfiles(ListInstanceProfilesRequest.Builder().apply(block).build())

    /**
     * Lists the instance profiles that have the specified associated IAM role. If there
     * are none, the operation returns an empty list. For more information about instance
     * profiles, go to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance
     * profiles.
     * You can paginate the results using the MaxItems and Marker
     * parameters.
     */
    suspend fun listInstanceProfilesForRole(input: ListInstanceProfilesForRoleRequest): ListInstanceProfilesForRoleResponse

    /**
     * Lists the instance profiles that have the specified associated IAM role. If there
     * are none, the operation returns an empty list. For more information about instance
     * profiles, go to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance
     * profiles.
     * You can paginate the results using the MaxItems and Marker
     * parameters.
     */
    suspend fun listInstanceProfilesForRole(block: ListInstanceProfilesForRoleRequest.Builder.() -> Unit) = listInstanceProfilesForRole(ListInstanceProfilesForRoleRequest.Builder().apply(block).build())

    /**
     * Lists the tags that are attached to the specified IAM virtual multi-factor authentication (MFA) device. The returned list of tags is
     * sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun listMfaDeviceTags(input: ListMfaDeviceTagsRequest): ListMfaDeviceTagsResponse

    /**
     * Lists the tags that are attached to the specified IAM virtual multi-factor authentication (MFA) device. The returned list of tags is
     * sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun listMfaDeviceTags(block: ListMfaDeviceTagsRequest.Builder.() -> Unit) = listMfaDeviceTags(ListMfaDeviceTagsRequest.Builder().apply(block).build())

    /**
     * Lists the MFA devices for an IAM user. If the request includes a IAM user name,
     * then this operation lists all the MFA devices associated with the specified user. If you
     * do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services
     * access key ID signing the request for this operation.
     * You can paginate the results using the MaxItems and Marker
     * parameters.
     */
    suspend fun listMfaDevices(input: ListMfaDevicesRequest): ListMfaDevicesResponse

    /**
     * Lists the MFA devices for an IAM user. If the request includes a IAM user name,
     * then this operation lists all the MFA devices associated with the specified user. If you
     * do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services
     * access key ID signing the request for this operation.
     * You can paginate the results using the MaxItems and Marker
     * parameters.
     */
    suspend fun listMfaDevices(block: ListMfaDevicesRequest.Builder.() -> Unit) = listMfaDevices(ListMfaDevicesRequest.Builder().apply(block).build())

    /**
     * Lists the tags that are attached to the specified OpenID Connect (OIDC)-compatible
     * identity provider. The returned list of tags is sorted by tag key. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html">About web identity
     * federation.
     * For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun listOpenIdConnectProviderTags(input: ListOpenIdConnectProviderTagsRequest): ListOpenIdConnectProviderTagsResponse

    /**
     * Lists the tags that are attached to the specified OpenID Connect (OIDC)-compatible
     * identity provider. The returned list of tags is sorted by tag key. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html">About web identity
     * federation.
     * For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun listOpenIdConnectProviderTags(block: ListOpenIdConnectProviderTagsRequest.Builder.() -> Unit) = listOpenIdConnectProviderTags(ListOpenIdConnectProviderTagsRequest.Builder().apply(block).build())

    /**
     * Lists information about the IAM OpenID Connect (OIDC) provider resource objects
     * defined in the Amazon Web Services account.
     *
     * IAM resource-listing operations return a subset of the available
     * attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for an OIDC provider, see GetOpenIDConnectProvider.
     */
    suspend fun listOpenIdConnectProviders(input: ListOpenIdConnectProvidersRequest): ListOpenIdConnectProvidersResponse

    /**
     * Lists information about the IAM OpenID Connect (OIDC) provider resource objects
     * defined in the Amazon Web Services account.
     *
     * IAM resource-listing operations return a subset of the available
     * attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for an OIDC provider, see GetOpenIDConnectProvider.
     */
    suspend fun listOpenIdConnectProviders(block: ListOpenIdConnectProvidersRequest.Builder.() -> Unit) = listOpenIdConnectProviders(ListOpenIdConnectProvidersRequest.Builder().apply(block).build())

    /**
     * Lists all the managed policies that are available in your Amazon Web Services account, including
     * your own customer-defined managed policies and all Amazon Web Services managed policies.
     * You can filter the list of policies that is returned using the optional
     * OnlyAttached, Scope, and PathPrefix
     * parameters. For example, to list only the customer managed policies in your Amazon Web Services
     * account, set Scope to Local. To list only Amazon Web Services managed
     * policies, set Scope to AWS.
     * You can paginate the results using the MaxItems and Marker
     * parameters.
     * For more information about managed policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     *
     * IAM resource-listing operations return a subset of the available
     * attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a customer manged policy, see
     * GetPolicy.
     */
    suspend fun listPolicies(input: ListPoliciesRequest): ListPoliciesResponse

    /**
     * Lists all the managed policies that are available in your Amazon Web Services account, including
     * your own customer-defined managed policies and all Amazon Web Services managed policies.
     * You can filter the list of policies that is returned using the optional
     * OnlyAttached, Scope, and PathPrefix
     * parameters. For example, to list only the customer managed policies in your Amazon Web Services
     * account, set Scope to Local. To list only Amazon Web Services managed
     * policies, set Scope to AWS.
     * You can paginate the results using the MaxItems and Marker
     * parameters.
     * For more information about managed policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     *
     * IAM resource-listing operations return a subset of the available
     * attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a customer manged policy, see
     * GetPolicy.
     */
    suspend fun listPolicies(block: ListPoliciesRequest.Builder.() -> Unit) = listPolicies(ListPoliciesRequest.Builder().apply(block).build())

    /**
     * Retrieves a list of policies that the IAM identity (user, group, or role) can use to
     * access each specified service.
     *
     * This operation does not use other policy types when determining whether a resource
     * could access a service. These other policy types include resource-based policies,
     * access control lists, Organizations policies, IAM permissions boundaries, and STS
     * assume role policies. It only applies permissions policy logic. For more about the
     * evaluation of policy types, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics">Evaluating policies in the
     * IAM User Guide.
     *
     * The list of policies returned by the operation depends on the ARN of the identity that
     * you provide.
     *
     *
     *
     * User – The list of policies includes
     * the managed and inline policies that are attached to the user directly. The list
     * also includes any additional managed and inline policies that are attached to
     * the group to which the user belongs.
     *
     *
     * Group – The list of policies includes
     * only the managed and inline policies that are attached to the group directly.
     * Policies that are attached to the group’s user are not included.
     *
     *
     * Role – The list of policies includes
     * only the managed and inline policies that are attached to the role.
     *
     *
     * For each managed policy, this operation returns the ARN and policy name. For each
     * inline policy, it returns the policy name and the entity to which it is attached. Inline
     * policies do not have an ARN. For more information about these policy types, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies and inline policies in the
     * IAM User Guide.
     * Policies that are attached to users and roles as permissions boundaries are not
     * returned. To view which managed policy is currently used to set the permissions boundary
     * for a user or role, use the GetUser or GetRole
     * operations.
     */
    suspend fun listPoliciesGrantingServiceAccess(input: ListPoliciesGrantingServiceAccessRequest): ListPoliciesGrantingServiceAccessResponse

    /**
     * Retrieves a list of policies that the IAM identity (user, group, or role) can use to
     * access each specified service.
     *
     * This operation does not use other policy types when determining whether a resource
     * could access a service. These other policy types include resource-based policies,
     * access control lists, Organizations policies, IAM permissions boundaries, and STS
     * assume role policies. It only applies permissions policy logic. For more about the
     * evaluation of policy types, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics">Evaluating policies in the
     * IAM User Guide.
     *
     * The list of policies returned by the operation depends on the ARN of the identity that
     * you provide.
     *
     *
     *
     * User – The list of policies includes
     * the managed and inline policies that are attached to the user directly. The list
     * also includes any additional managed and inline policies that are attached to
     * the group to which the user belongs.
     *
     *
     * Group – The list of policies includes
     * only the managed and inline policies that are attached to the group directly.
     * Policies that are attached to the group’s user are not included.
     *
     *
     * Role – The list of policies includes
     * only the managed and inline policies that are attached to the role.
     *
     *
     * For each managed policy, this operation returns the ARN and policy name. For each
     * inline policy, it returns the policy name and the entity to which it is attached. Inline
     * policies do not have an ARN. For more information about these policy types, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies and inline policies in the
     * IAM User Guide.
     * Policies that are attached to users and roles as permissions boundaries are not
     * returned. To view which managed policy is currently used to set the permissions boundary
     * for a user or role, use the GetUser or GetRole
     * operations.
     */
    suspend fun listPoliciesGrantingServiceAccess(block: ListPoliciesGrantingServiceAccessRequest.Builder.() -> Unit) = listPoliciesGrantingServiceAccess(ListPoliciesGrantingServiceAccessRequest.Builder().apply(block).build())

    /**
     * Lists the tags that are attached to the specified IAM customer managed policy.
     * The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun listPolicyTags(input: ListPolicyTagsRequest): ListPolicyTagsResponse

    /**
     * Lists the tags that are attached to the specified IAM customer managed policy.
     * The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun listPolicyTags(block: ListPolicyTagsRequest.Builder.() -> Unit) = listPolicyTags(ListPolicyTagsRequest.Builder().apply(block).build())

    /**
     * Lists information about the versions of the specified managed policy, including the
     * version that is currently set as the policy's default version.
     * For more information about managed policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     */
    suspend fun listPolicyVersions(input: ListPolicyVersionsRequest): ListPolicyVersionsResponse

    /**
     * Lists information about the versions of the specified managed policy, including the
     * version that is currently set as the policy's default version.
     * For more information about managed policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     */
    suspend fun listPolicyVersions(block: ListPolicyVersionsRequest.Builder.() -> Unit) = listPolicyVersions(ListPolicyVersionsRequest.Builder().apply(block).build())

    /**
     * Lists the names of the inline policies that are embedded in the specified IAM
     * role.
     * An IAM role can also have managed policies attached to it. To list the managed
     * policies that are attached to a role, use ListAttachedRolePolicies.
     * For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     * You can paginate the results using the MaxItems and Marker
     * parameters. If there are no inline policies embedded with the specified role, the
     * operation returns an empty list.
     */
    suspend fun listRolePolicies(input: ListRolePoliciesRequest): ListRolePoliciesResponse

    /**
     * Lists the names of the inline policies that are embedded in the specified IAM
     * role.
     * An IAM role can also have managed policies attached to it. To list the managed
     * policies that are attached to a role, use ListAttachedRolePolicies.
     * For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     * You can paginate the results using the MaxItems and Marker
     * parameters. If there are no inline policies embedded with the specified role, the
     * operation returns an empty list.
     */
    suspend fun listRolePolicies(block: ListRolePoliciesRequest.Builder.() -> Unit) = listRolePolicies(ListRolePoliciesRequest.Builder().apply(block).build())

    /**
     * Lists the tags that are attached to the specified role. The returned list of tags is
     * sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun listRoleTags(input: ListRoleTagsRequest): ListRoleTagsResponse

    /**
     * Lists the tags that are attached to the specified role. The returned list of tags is
     * sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun listRoleTags(block: ListRoleTagsRequest.Builder.() -> Unit) = listRoleTags(ListRoleTagsRequest.Builder().apply(block).build())

    /**
     * Lists the IAM roles that have the specified path prefix. If there are none, the
     * operation returns an empty list. For more information about roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with
     * roles.
     *
     * IAM resource-listing operations return a subset of the available
     * attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a role, see GetRole.
     *
     * You can paginate the results using the MaxItems and Marker
     * parameters.
     */
    suspend fun listRoles(input: ListRolesRequest): ListRolesResponse

    /**
     * Lists the IAM roles that have the specified path prefix. If there are none, the
     * operation returns an empty list. For more information about roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with
     * roles.
     *
     * IAM resource-listing operations return a subset of the available
     * attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a role, see GetRole.
     *
     * You can paginate the results using the MaxItems and Marker
     * parameters.
     */
    suspend fun listRoles(block: ListRolesRequest.Builder.() -> Unit) = listRoles(ListRolesRequest.Builder().apply(block).build())

    /**
     * Lists the tags that are attached to the specified Security Assertion Markup Language
     * (SAML) identity provider. The returned list of tags is sorted by tag key. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based
     * federation.
     * For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun listSamlProviderTags(input: ListSamlProviderTagsRequest): ListSamlProviderTagsResponse

    /**
     * Lists the tags that are attached to the specified Security Assertion Markup Language
     * (SAML) identity provider. The returned list of tags is sorted by tag key. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based
     * federation.
     * For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun listSamlProviderTags(block: ListSamlProviderTagsRequest.Builder.() -> Unit) = listSamlProviderTags(ListSamlProviderTagsRequest.Builder().apply(block).build())

    /**
     * Lists the SAML provider resource objects defined in IAM in the account.
     * IAM resource-listing operations return a subset of the available
     * attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a SAML provider, see GetSAMLProvider.
     *
     * This operation requires <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4.
     */
    suspend fun listSamlProviders(input: ListSamlProvidersRequest): ListSamlProvidersResponse

    /**
     * Lists the SAML provider resource objects defined in IAM in the account.
     * IAM resource-listing operations return a subset of the available
     * attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a SAML provider, see GetSAMLProvider.
     *
     * This operation requires <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4.
     */
    suspend fun listSamlProviders(block: ListSamlProvidersRequest.Builder.() -> Unit) = listSamlProviders(ListSamlProvidersRequest.Builder().apply(block).build())

    /**
     * Lists the tags that are attached to the specified IAM server certificate. The
     * returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     *
     * For certificates in a Region supported by Certificate Manager (ACM), we
     * recommend that you don't use IAM server certificates. Instead, use ACM to provision,
     * manage, and deploy your server certificates. For more information about IAM server
     * certificates, <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates in the IAM User Guide.
     */
    suspend fun listServerCertificateTags(input: ListServerCertificateTagsRequest): ListServerCertificateTagsResponse

    /**
     * Lists the tags that are attached to the specified IAM server certificate. The
     * returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     *
     * For certificates in a Region supported by Certificate Manager (ACM), we
     * recommend that you don't use IAM server certificates. Instead, use ACM to provision,
     * manage, and deploy your server certificates. For more information about IAM server
     * certificates, <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates in the IAM User Guide.
     */
    suspend fun listServerCertificateTags(block: ListServerCertificateTagsRequest.Builder.() -> Unit) = listServerCertificateTags(ListServerCertificateTagsRequest.Builder().apply(block).build())

    /**
     * Lists the server certificates stored in IAM that have the specified path prefix. If
     * none exist, the operation returns an empty list.
     * You can paginate the results using the MaxItems and Marker
     * parameters.
     * For more information about working with server certificates, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working
     * with server certificates in the IAM User Guide. This
     * topic also includes a list of Amazon Web Services services that can use the server certificates that
     * you manage with IAM.
     *
     * IAM resource-listing operations return a subset of the available
     * attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a servercertificate, see GetServerCertificate.
     */
    suspend fun listServerCertificates(input: ListServerCertificatesRequest): ListServerCertificatesResponse

    /**
     * Lists the server certificates stored in IAM that have the specified path prefix. If
     * none exist, the operation returns an empty list.
     * You can paginate the results using the MaxItems and Marker
     * parameters.
     * For more information about working with server certificates, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working
     * with server certificates in the IAM User Guide. This
     * topic also includes a list of Amazon Web Services services that can use the server certificates that
     * you manage with IAM.
     *
     * IAM resource-listing operations return a subset of the available
     * attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a servercertificate, see GetServerCertificate.
     */
    suspend fun listServerCertificates(block: ListServerCertificatesRequest.Builder.() -> Unit) = listServerCertificates(ListServerCertificatesRequest.Builder().apply(block).build())

    /**
     * Returns information about the service-specific credentials associated with the
     * specified IAM user. If none exists, the operation returns an empty list. The
     * service-specific credentials returned by this operation are used only for authenticating
     * the IAM user to a specific service. For more information about using service-specific
     * credentials to authenticate to an Amazon Web Services service, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-gc.html">Set up service-specific credentials
     * in the CodeCommit User Guide.
     */
    suspend fun listServiceSpecificCredentials(input: ListServiceSpecificCredentialsRequest): ListServiceSpecificCredentialsResponse

    /**
     * Returns information about the service-specific credentials associated with the
     * specified IAM user. If none exists, the operation returns an empty list. The
     * service-specific credentials returned by this operation are used only for authenticating
     * the IAM user to a specific service. For more information about using service-specific
     * credentials to authenticate to an Amazon Web Services service, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-gc.html">Set up service-specific credentials
     * in the CodeCommit User Guide.
     */
    suspend fun listServiceSpecificCredentials(block: ListServiceSpecificCredentialsRequest.Builder.() -> Unit) = listServiceSpecificCredentials(ListServiceSpecificCredentialsRequest.Builder().apply(block).build())

    /**
     * Returns information about the signing certificates associated with the specified IAM
     * user. If none exists, the operation returns an empty list.
     * Although each user is limited to a small number of signing certificates, you can still
     * paginate the results using the MaxItems and Marker
     * parameters.
     * If the UserName field is not specified, the user name is determined
     * implicitly based on the Amazon Web Services access key ID used to sign the request for this operation.
     * This operation works for access keys under the Amazon Web Services account. Consequently, you can use
     * this operation to manage Amazon Web Services account root user credentials even if the Amazon Web Services account
     * has no associated users.
     */
    suspend fun listSigningCertificates(input: ListSigningCertificatesRequest): ListSigningCertificatesResponse

    /**
     * Returns information about the signing certificates associated with the specified IAM
     * user. If none exists, the operation returns an empty list.
     * Although each user is limited to a small number of signing certificates, you can still
     * paginate the results using the MaxItems and Marker
     * parameters.
     * If the UserName field is not specified, the user name is determined
     * implicitly based on the Amazon Web Services access key ID used to sign the request for this operation.
     * This operation works for access keys under the Amazon Web Services account. Consequently, you can use
     * this operation to manage Amazon Web Services account root user credentials even if the Amazon Web Services account
     * has no associated users.
     */
    suspend fun listSigningCertificates(block: ListSigningCertificatesRequest.Builder.() -> Unit) = listSigningCertificates(ListSigningCertificatesRequest.Builder().apply(block).build())

    /**
     * Returns information about the SSH public keys associated with the specified IAM
     * user. If none exists, the operation returns an empty list.
     * The SSH public keys returned by this operation are used only for authenticating the
     * IAM user to an CodeCommit repository. For more information about using SSH keys to
     * authenticate to an CodeCommit repository, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up CodeCommit for
     * SSH connections in the CodeCommit User Guide.
     * Although each user is limited to a small number of keys, you can still paginate the
     * results using the MaxItems and Marker parameters.
     */
    suspend fun listSshPublicKeys(input: ListSshPublicKeysRequest): ListSshPublicKeysResponse

    /**
     * Returns information about the SSH public keys associated with the specified IAM
     * user. If none exists, the operation returns an empty list.
     * The SSH public keys returned by this operation are used only for authenticating the
     * IAM user to an CodeCommit repository. For more information about using SSH keys to
     * authenticate to an CodeCommit repository, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up CodeCommit for
     * SSH connections in the CodeCommit User Guide.
     * Although each user is limited to a small number of keys, you can still paginate the
     * results using the MaxItems and Marker parameters.
     */
    suspend fun listSshPublicKeys(block: ListSshPublicKeysRequest.Builder.() -> Unit) = listSshPublicKeys(ListSshPublicKeysRequest.Builder().apply(block).build())

    /**
     * Lists the names of the inline policies embedded in the specified IAM user.
     * An IAM user can also have managed policies attached to it. To list the managed
     * policies that are attached to a user, use ListAttachedUserPolicies.
     * For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     * You can paginate the results using the MaxItems and Marker
     * parameters. If there are no inline policies embedded with the specified user, the
     * operation returns an empty list.
     */
    suspend fun listUserPolicies(input: ListUserPoliciesRequest): ListUserPoliciesResponse

    /**
     * Lists the names of the inline policies embedded in the specified IAM user.
     * An IAM user can also have managed policies attached to it. To list the managed
     * policies that are attached to a user, use ListAttachedUserPolicies.
     * For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     * You can paginate the results using the MaxItems and Marker
     * parameters. If there are no inline policies embedded with the specified user, the
     * operation returns an empty list.
     */
    suspend fun listUserPolicies(block: ListUserPoliciesRequest.Builder.() -> Unit) = listUserPolicies(ListUserPoliciesRequest.Builder().apply(block).build())

    /**
     * Lists the tags that are attached to the specified IAM user. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun listUserTags(input: ListUserTagsRequest): ListUserTagsResponse

    /**
     * Lists the tags that are attached to the specified IAM user. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun listUserTags(block: ListUserTagsRequest.Builder.() -> Unit) = listUserTags(ListUserTagsRequest.Builder().apply(block).build())

    /**
     * Lists the IAM users that have the specified path prefix. If no path prefix is
     * specified, the operation returns all users in the Amazon Web Services account. If there are none, the
     * operation returns an empty list.
     *
     * IAM resource-listing operations return a subset of the available
     * attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a user, see GetUser.
     *
     * You can paginate the results using the MaxItems and Marker
     * parameters.
     */
    suspend fun listUsers(input: ListUsersRequest): ListUsersResponse

    /**
     * Lists the IAM users that have the specified path prefix. If no path prefix is
     * specified, the operation returns all users in the Amazon Web Services account. If there are none, the
     * operation returns an empty list.
     *
     * IAM resource-listing operations return a subset of the available
     * attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a user, see GetUser.
     *
     * You can paginate the results using the MaxItems and Marker
     * parameters.
     */
    suspend fun listUsers(block: ListUsersRequest.Builder.() -> Unit) = listUsers(ListUsersRequest.Builder().apply(block).build())

    /**
     * Lists the virtual MFA devices defined in the Amazon Web Services account by assignment status. If
     * you do not specify an assignment status, the operation returns a list of all virtual MFA
     * devices. Assignment status can be Assigned, Unassigned, or
     * Any.
     *
     * IAM resource-listing operations return a subset of the available
     * attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view tag information for a virtual MFA device, see ListMFADeviceTags.
     *
     * You can paginate the results using the MaxItems and Marker
     * parameters.
     */
    suspend fun listVirtualMfaDevices(input: ListVirtualMfaDevicesRequest): ListVirtualMfaDevicesResponse

    /**
     * Lists the virtual MFA devices defined in the Amazon Web Services account by assignment status. If
     * you do not specify an assignment status, the operation returns a list of all virtual MFA
     * devices. Assignment status can be Assigned, Unassigned, or
     * Any.
     *
     * IAM resource-listing operations return a subset of the available
     * attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view tag information for a virtual MFA device, see ListMFADeviceTags.
     *
     * You can paginate the results using the MaxItems and Marker
     * parameters.
     */
    suspend fun listVirtualMfaDevices(block: ListVirtualMfaDevicesRequest.Builder.() -> Unit) = listVirtualMfaDevices(ListVirtualMfaDevicesRequest.Builder().apply(block).build())

    /**
     * Adds or updates an inline policy document that is embedded in the specified IAM
     * group.
     * A user can also have managed policies attached to it. To attach a managed policy to a
     * group, use AttachGroupPolicy. To create a new managed policy, use
     * CreatePolicy. For information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed
     * policies and inline policies in the
     * IAM User Guide.
     * For information about the maximum number of inline policies that you can embed in a
     * group, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas in the IAM User Guide.
     *
     * Because policy documents can be large, you should use POST rather than GET when
     * calling PutGroupPolicy. For general information about using the Query
     * API with IAM, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making query requests in the
     * IAM User Guide.
     */
    suspend fun putGroupPolicy(input: PutGroupPolicyRequest): PutGroupPolicyResponse

    /**
     * Adds or updates an inline policy document that is embedded in the specified IAM
     * group.
     * A user can also have managed policies attached to it. To attach a managed policy to a
     * group, use AttachGroupPolicy. To create a new managed policy, use
     * CreatePolicy. For information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed
     * policies and inline policies in the
     * IAM User Guide.
     * For information about the maximum number of inline policies that you can embed in a
     * group, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas in the IAM User Guide.
     *
     * Because policy documents can be large, you should use POST rather than GET when
     * calling PutGroupPolicy. For general information about using the Query
     * API with IAM, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making query requests in the
     * IAM User Guide.
     */
    suspend fun putGroupPolicy(block: PutGroupPolicyRequest.Builder.() -> Unit) = putGroupPolicy(PutGroupPolicyRequest.Builder().apply(block).build())

    /**
     * Adds or updates the policy that is specified as the IAM role's permissions boundary.
     * You can use an Amazon Web Services managed policy or a customer managed policy to set the boundary for
     * a role. Use the boundary to control the maximum permissions that the role can have.
     * Setting a permissions boundary is an advanced feature that can affect the permissions
     * for the role.
     * You cannot set the boundary for a service-linked role.
     *
     * Policies used as permissions boundaries do not provide permissions. You must also
     * attach a permissions policy to the role. To learn how the effective permissions for
     * a role are evaluated, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html">IAM JSON policy
     * evaluation logic in the IAM User Guide.
     */
    suspend fun putRolePermissionsBoundary(input: PutRolePermissionsBoundaryRequest): PutRolePermissionsBoundaryResponse

    /**
     * Adds or updates the policy that is specified as the IAM role's permissions boundary.
     * You can use an Amazon Web Services managed policy or a customer managed policy to set the boundary for
     * a role. Use the boundary to control the maximum permissions that the role can have.
     * Setting a permissions boundary is an advanced feature that can affect the permissions
     * for the role.
     * You cannot set the boundary for a service-linked role.
     *
     * Policies used as permissions boundaries do not provide permissions. You must also
     * attach a permissions policy to the role. To learn how the effective permissions for
     * a role are evaluated, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html">IAM JSON policy
     * evaluation logic in the IAM User Guide.
     */
    suspend fun putRolePermissionsBoundary(block: PutRolePermissionsBoundaryRequest.Builder.() -> Unit) = putRolePermissionsBoundary(PutRolePermissionsBoundaryRequest.Builder().apply(block).build())

    /**
     * Adds or updates an inline policy document that is embedded in the specified IAM
     * role.
     * When you embed an inline policy in a role, the inline policy is used as part of the
     * role's access (permissions) policy. The role's trust policy is created at the same time
     * as the role, using CreateRole. You can update a role's trust policy
     * using UpdateAssumeRolePolicy. For more information about IAM roles,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html">Using roles to
     * delegate permissions and federate identities.
     * A role can also have a managed policy attached to it. To attach a managed policy to a
     * role, use AttachRolePolicy. To create a new managed policy, use CreatePolicy. For information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed
     * policies and inline policies in the
     * IAM User Guide.
     * For information about the maximum number of inline policies that you can embed with a
     * role, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas in the IAM User Guide.
     *
     * Because policy documents can be large, you should use POST rather than GET when
     * calling PutRolePolicy. For general information about using the Query
     * API with IAM, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making query requests in the
     * IAM User Guide.
     */
    suspend fun putRolePolicy(input: PutRolePolicyRequest): PutRolePolicyResponse

    /**
     * Adds or updates an inline policy document that is embedded in the specified IAM
     * role.
     * When you embed an inline policy in a role, the inline policy is used as part of the
     * role's access (permissions) policy. The role's trust policy is created at the same time
     * as the role, using CreateRole. You can update a role's trust policy
     * using UpdateAssumeRolePolicy. For more information about IAM roles,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html">Using roles to
     * delegate permissions and federate identities.
     * A role can also have a managed policy attached to it. To attach a managed policy to a
     * role, use AttachRolePolicy. To create a new managed policy, use CreatePolicy. For information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed
     * policies and inline policies in the
     * IAM User Guide.
     * For information about the maximum number of inline policies that you can embed with a
     * role, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas in the IAM User Guide.
     *
     * Because policy documents can be large, you should use POST rather than GET when
     * calling PutRolePolicy. For general information about using the Query
     * API with IAM, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making query requests in the
     * IAM User Guide.
     */
    suspend fun putRolePolicy(block: PutRolePolicyRequest.Builder.() -> Unit) = putRolePolicy(PutRolePolicyRequest.Builder().apply(block).build())

    /**
     * Adds or updates the policy that is specified as the IAM user's permissions boundary.
     * You can use an Amazon Web Services managed policy or a customer managed policy to set the boundary for
     * a user. Use the boundary to control the maximum permissions that the user can have.
     * Setting a permissions boundary is an advanced feature that can affect the permissions
     * for the user.
     *
     * Policies that are used as permissions boundaries do not provide permissions. You
     * must also attach a permissions policy to the user. To learn how the effective
     * permissions for a user are evaluated, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html">IAM JSON policy
     * evaluation logic in the IAM User Guide.
     */
    suspend fun putUserPermissionsBoundary(input: PutUserPermissionsBoundaryRequest): PutUserPermissionsBoundaryResponse

    /**
     * Adds or updates the policy that is specified as the IAM user's permissions boundary.
     * You can use an Amazon Web Services managed policy or a customer managed policy to set the boundary for
     * a user. Use the boundary to control the maximum permissions that the user can have.
     * Setting a permissions boundary is an advanced feature that can affect the permissions
     * for the user.
     *
     * Policies that are used as permissions boundaries do not provide permissions. You
     * must also attach a permissions policy to the user. To learn how the effective
     * permissions for a user are evaluated, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html">IAM JSON policy
     * evaluation logic in the IAM User Guide.
     */
    suspend fun putUserPermissionsBoundary(block: PutUserPermissionsBoundaryRequest.Builder.() -> Unit) = putUserPermissionsBoundary(PutUserPermissionsBoundaryRequest.Builder().apply(block).build())

    /**
     * Adds or updates an inline policy document that is embedded in the specified IAM
     * user.
     * An IAM user can also have a managed policy attached to it. To attach a managed
     * policy to a user, use AttachUserPolicy. To create a new managed
     * policy, use CreatePolicy. For information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed
     * policies and inline policies in the
     * IAM User Guide.
     * For information about the maximum number of inline policies that you can embed in a
     * user, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas in the IAM User Guide.
     *
     * Because policy documents can be large, you should use POST rather than GET when
     * calling PutUserPolicy. For general information about using the Query
     * API with IAM, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making query requests in the
     * IAM User Guide.
     */
    suspend fun putUserPolicy(input: PutUserPolicyRequest): PutUserPolicyResponse

    /**
     * Adds or updates an inline policy document that is embedded in the specified IAM
     * user.
     * An IAM user can also have a managed policy attached to it. To attach a managed
     * policy to a user, use AttachUserPolicy. To create a new managed
     * policy, use CreatePolicy. For information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed
     * policies and inline policies in the
     * IAM User Guide.
     * For information about the maximum number of inline policies that you can embed in a
     * user, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas in the IAM User Guide.
     *
     * Because policy documents can be large, you should use POST rather than GET when
     * calling PutUserPolicy. For general information about using the Query
     * API with IAM, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making query requests in the
     * IAM User Guide.
     */
    suspend fun putUserPolicy(block: PutUserPolicyRequest.Builder.() -> Unit) = putUserPolicy(PutUserPolicyRequest.Builder().apply(block).build())

    /**
     * Removes the specified client ID (also known as audience) from the list of client IDs
     * registered for the specified IAM OpenID Connect (OIDC) provider resource
     * object.
     * This operation is idempotent; it does not fail or return an error if you try to remove
     * a client ID that does not exist.
     */
    suspend fun removeClientIdFromOpenIdConnectProvider(input: RemoveClientIdFromOpenIdConnectProviderRequest): RemoveClientIdFromOpenIdConnectProviderResponse

    /**
     * Removes the specified client ID (also known as audience) from the list of client IDs
     * registered for the specified IAM OpenID Connect (OIDC) provider resource
     * object.
     * This operation is idempotent; it does not fail or return an error if you try to remove
     * a client ID that does not exist.
     */
    suspend fun removeClientIdFromOpenIdConnectProvider(block: RemoveClientIdFromOpenIdConnectProviderRequest.Builder.() -> Unit) = removeClientIdFromOpenIdConnectProvider(RemoveClientIdFromOpenIdConnectProviderRequest.Builder().apply(block).build())

    /**
     * Removes the specified IAM role from the specified EC2 instance profile.
     *
     * Make sure that you do not have any Amazon EC2 instances running with the role you
     * are about to remove from the instance profile. Removing a role from an instance
     * profile that is associated with a running instance might break any applications
     * running on the instance.
     *
     * For more information about IAM roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with roles. For more
     * information about instance profiles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance
     * profiles.
     */
    suspend fun removeRoleFromInstanceProfile(input: RemoveRoleFromInstanceProfileRequest): RemoveRoleFromInstanceProfileResponse

    /**
     * Removes the specified IAM role from the specified EC2 instance profile.
     *
     * Make sure that you do not have any Amazon EC2 instances running with the role you
     * are about to remove from the instance profile. Removing a role from an instance
     * profile that is associated with a running instance might break any applications
     * running on the instance.
     *
     * For more information about IAM roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with roles. For more
     * information about instance profiles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance
     * profiles.
     */
    suspend fun removeRoleFromInstanceProfile(block: RemoveRoleFromInstanceProfileRequest.Builder.() -> Unit) = removeRoleFromInstanceProfile(RemoveRoleFromInstanceProfileRequest.Builder().apply(block).build())

    /**
     * Removes the specified user from the specified group.
     */
    suspend fun removeUserFromGroup(input: RemoveUserFromGroupRequest): RemoveUserFromGroupResponse

    /**
     * Removes the specified user from the specified group.
     */
    suspend fun removeUserFromGroup(block: RemoveUserFromGroupRequest.Builder.() -> Unit) = removeUserFromGroup(RemoveUserFromGroupRequest.Builder().apply(block).build())

    /**
     * Resets the password for a service-specific credential. The new password is Amazon Web Services
     * generated and cryptographically strong. It cannot be configured by the user. Resetting
     * the password immediately invalidates the previous password associated with this
     * user.
     */
    suspend fun resetServiceSpecificCredential(input: ResetServiceSpecificCredentialRequest): ResetServiceSpecificCredentialResponse

    /**
     * Resets the password for a service-specific credential. The new password is Amazon Web Services
     * generated and cryptographically strong. It cannot be configured by the user. Resetting
     * the password immediately invalidates the previous password associated with this
     * user.
     */
    suspend fun resetServiceSpecificCredential(block: ResetServiceSpecificCredentialRequest.Builder.() -> Unit) = resetServiceSpecificCredential(ResetServiceSpecificCredentialRequest.Builder().apply(block).build())

    /**
     * Synchronizes the specified MFA device with its IAM resource object on the Amazon Web Services
     * servers.
     * For more information about creating and working with virtual MFA devices, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Using a virtual MFA
     * device in the IAM User Guide.
     */
    suspend fun resyncMfaDevice(input: ResyncMfaDeviceRequest): ResyncMfaDeviceResponse

    /**
     * Synchronizes the specified MFA device with its IAM resource object on the Amazon Web Services
     * servers.
     * For more information about creating and working with virtual MFA devices, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Using a virtual MFA
     * device in the IAM User Guide.
     */
    suspend fun resyncMfaDevice(block: ResyncMfaDeviceRequest.Builder.() -> Unit) = resyncMfaDevice(ResyncMfaDeviceRequest.Builder().apply(block).build())

    /**
     * Sets the specified version of the specified policy as the policy's default (operative)
     * version.
     * This operation affects all users, groups, and roles that the policy is attached to. To
     * list the users, groups, and roles that the policy is attached to, use ListEntitiesForPolicy.
     * For information about managed policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     */
    suspend fun setDefaultPolicyVersion(input: SetDefaultPolicyVersionRequest): SetDefaultPolicyVersionResponse

    /**
     * Sets the specified version of the specified policy as the policy's default (operative)
     * version.
     * This operation affects all users, groups, and roles that the policy is attached to. To
     * list the users, groups, and roles that the policy is attached to, use ListEntitiesForPolicy.
     * For information about managed policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
     * policies in the IAM User Guide.
     */
    suspend fun setDefaultPolicyVersion(block: SetDefaultPolicyVersionRequest.Builder.() -> Unit) = setDefaultPolicyVersion(SetDefaultPolicyVersionRequest.Builder().apply(block).build())

    /**
     * Sets the specified version of the global endpoint token as the token version used for
     * the Amazon Web Services account.
     * By default, Security Token Service (STS) is available as a global service, and all STS requests
     * go to a single endpoint at https://sts.amazonaws.com. Amazon Web Services recommends
     * using Regional STS endpoints to reduce latency, build in redundancy, and increase
     * session token availability. For information about Regional endpoints for STS, see
     * <a href="https://docs.aws.amazon.com/general/latest/gr/sts.html">Security Token Service
     * endpoints and quotas in the Amazon Web Services General Reference.
     * If you make an STS call to the global endpoint, the resulting session tokens might
     * be valid in some Regions but not others. It depends on the version that is set in this
     * operation. Version 1 tokens are valid only in Amazon Web Services Regions that are
     * available by default. These tokens do not work in manually enabled Regions, such as Asia
     * Pacific (Hong Kong). Version 2 tokens are valid in all Regions. However, version 2
     * tokens are longer and might affect systems where you temporarily store tokens. For
     * information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
     * deactivating STS in an Amazon Web Services Region in the
     * IAM User Guide.
     * To view the current session token version, see the
     * GlobalEndpointTokenVersion entry in the response of the GetAccountSummary operation.
     */
    suspend fun setSecurityTokenServicePreferences(input: SetSecurityTokenServicePreferencesRequest): SetSecurityTokenServicePreferencesResponse

    /**
     * Sets the specified version of the global endpoint token as the token version used for
     * the Amazon Web Services account.
     * By default, Security Token Service (STS) is available as a global service, and all STS requests
     * go to a single endpoint at https://sts.amazonaws.com. Amazon Web Services recommends
     * using Regional STS endpoints to reduce latency, build in redundancy, and increase
     * session token availability. For information about Regional endpoints for STS, see
     * <a href="https://docs.aws.amazon.com/general/latest/gr/sts.html">Security Token Service
     * endpoints and quotas in the Amazon Web Services General Reference.
     * If you make an STS call to the global endpoint, the resulting session tokens might
     * be valid in some Regions but not others. It depends on the version that is set in this
     * operation. Version 1 tokens are valid only in Amazon Web Services Regions that are
     * available by default. These tokens do not work in manually enabled Regions, such as Asia
     * Pacific (Hong Kong). Version 2 tokens are valid in all Regions. However, version 2
     * tokens are longer and might affect systems where you temporarily store tokens. For
     * information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
     * deactivating STS in an Amazon Web Services Region in the
     * IAM User Guide.
     * To view the current session token version, see the
     * GlobalEndpointTokenVersion entry in the response of the GetAccountSummary operation.
     */
    suspend fun setSecurityTokenServicePreferences(block: SetSecurityTokenServicePreferencesRequest.Builder.() -> Unit) = setSecurityTokenServicePreferences(SetSecurityTokenServicePreferencesRequest.Builder().apply(block).build())

    /**
     * Simulate how a set of IAM policies and optionally a resource-based policy works with
     * a list of API operations and Amazon Web Services resources to determine the policies' effective
     * permissions. The policies are provided as strings.
     * The simulation does not perform the API operations; it only checks the authorization
     * to determine if the simulated policies allow or deny the operations. You can simulate
     * resources that don't exist in your account.
     * If you want to simulate existing policies that are attached to an IAM user, group,
     * or role, use SimulatePrincipalPolicy instead.
     * Context keys are variables that are maintained by Amazon Web Services and its services and which
     * provide details about the context of an API query request. You can use the
     * Condition element of an IAM policy to evaluate context keys. To get
     * the list of context keys that the policies require for correct simulation, use GetContextKeysForCustomPolicy.
     * If the output is long, you can use MaxItems and Marker
     * parameters to paginate the results.
     * For more information about using the policy simulator, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_testing-policies.html">Testing IAM policies
     * with the IAM policy simulator in the
     * IAM User Guide.
     */
    suspend fun simulateCustomPolicy(input: SimulateCustomPolicyRequest): SimulateCustomPolicyResponse

    /**
     * Simulate how a set of IAM policies and optionally a resource-based policy works with
     * a list of API operations and Amazon Web Services resources to determine the policies' effective
     * permissions. The policies are provided as strings.
     * The simulation does not perform the API operations; it only checks the authorization
     * to determine if the simulated policies allow or deny the operations. You can simulate
     * resources that don't exist in your account.
     * If you want to simulate existing policies that are attached to an IAM user, group,
     * or role, use SimulatePrincipalPolicy instead.
     * Context keys are variables that are maintained by Amazon Web Services and its services and which
     * provide details about the context of an API query request. You can use the
     * Condition element of an IAM policy to evaluate context keys. To get
     * the list of context keys that the policies require for correct simulation, use GetContextKeysForCustomPolicy.
     * If the output is long, you can use MaxItems and Marker
     * parameters to paginate the results.
     * For more information about using the policy simulator, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_testing-policies.html">Testing IAM policies
     * with the IAM policy simulator in the
     * IAM User Guide.
     */
    suspend fun simulateCustomPolicy(block: SimulateCustomPolicyRequest.Builder.() -> Unit) = simulateCustomPolicy(SimulateCustomPolicyRequest.Builder().apply(block).build())

    /**
     * Simulate how a set of IAM policies attached to an IAM entity works with a list of
     * API operations and Amazon Web Services resources to determine the policies' effective permissions. The
     * entity can be an IAM user, group, or role. If you specify a user, then the simulation
     * also includes all of the policies that are attached to groups that the user belongs to.
     * You can simulate resources that don't exist in your account.
     * You can optionally include a list of one or more additional policies specified as
     * strings to include in the simulation. If you want to simulate only policies specified as
     * strings, use SimulateCustomPolicy instead.
     * You can also optionally include one resource-based policy to be evaluated with each of
     * the resources included in the simulation.
     * The simulation does not perform the API operations; it only checks the authorization
     * to determine if the simulated policies allow or deny the operations.
     *
     * Note: This operation discloses information about the
     * permissions granted to other users. If you do not want users to see other user's
     * permissions, then consider allowing them to use SimulateCustomPolicy
     * instead.
     * Context keys are variables maintained by Amazon Web Services and its services that provide details
     * about the context of an API query request. You can use the Condition
     * element of an IAM policy to evaluate context keys. To get the list of context keys
     * that the policies require for correct simulation, use GetContextKeysForPrincipalPolicy.
     * If the output is long, you can use the MaxItems and Marker
     * parameters to paginate the results.
     * For more information about using the policy simulator, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_testing-policies.html">Testing IAM policies
     * with the IAM policy simulator in the
     * IAM User Guide.
     */
    suspend fun simulatePrincipalPolicy(input: SimulatePrincipalPolicyRequest): SimulatePrincipalPolicyResponse

    /**
     * Simulate how a set of IAM policies attached to an IAM entity works with a list of
     * API operations and Amazon Web Services resources to determine the policies' effective permissions. The
     * entity can be an IAM user, group, or role. If you specify a user, then the simulation
     * also includes all of the policies that are attached to groups that the user belongs to.
     * You can simulate resources that don't exist in your account.
     * You can optionally include a list of one or more additional policies specified as
     * strings to include in the simulation. If you want to simulate only policies specified as
     * strings, use SimulateCustomPolicy instead.
     * You can also optionally include one resource-based policy to be evaluated with each of
     * the resources included in the simulation.
     * The simulation does not perform the API operations; it only checks the authorization
     * to determine if the simulated policies allow or deny the operations.
     *
     * Note: This operation discloses information about the
     * permissions granted to other users. If you do not want users to see other user's
     * permissions, then consider allowing them to use SimulateCustomPolicy
     * instead.
     * Context keys are variables maintained by Amazon Web Services and its services that provide details
     * about the context of an API query request. You can use the Condition
     * element of an IAM policy to evaluate context keys. To get the list of context keys
     * that the policies require for correct simulation, use GetContextKeysForPrincipalPolicy.
     * If the output is long, you can use the MaxItems and Marker
     * parameters to paginate the results.
     * For more information about using the policy simulator, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_testing-policies.html">Testing IAM policies
     * with the IAM policy simulator in the
     * IAM User Guide.
     */
    suspend fun simulatePrincipalPolicy(block: SimulatePrincipalPolicyRequest.Builder.() -> Unit) = simulatePrincipalPolicy(SimulatePrincipalPolicyRequest.Builder().apply(block).build())

    /**
     * Adds one or more tags to an IAM instance profile. If a tag with the same key name
     * already exists, then that tag is overwritten with the new value.
     * Each tag consists of a key name and an associated value. By assigning tags to your resources, you can do the
     * following:
     *
     *
     *
     * Administrative grouping and discovery - Attach
     * tags to resources to aid in organization and search. For example, you could search for all
     * resources with the key name Project and the value
     * MyImportantProject. Or search for all resources with the key name
     * Cost Center and the value 41200.
     *
     *
     * Access control - Include tags in IAM user-based
     * and resource-based policies. You can use tags to restrict access to only an IAM instance
     * profile that has a specified tag attached. For examples of policies that show how to use
     * tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags in the
     * IAM User Guide.
     *
     *
     *
     *
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     *
     * Amazon Web Services always interprets the tag Value as a single string. If you
     * need to store an array, you can store comma-separated values in the string. However, you
     * must interpret the value in your code.
     */
    suspend fun tagInstanceProfile(input: TagInstanceProfileRequest): TagInstanceProfileResponse

    /**
     * Adds one or more tags to an IAM instance profile. If a tag with the same key name
     * already exists, then that tag is overwritten with the new value.
     * Each tag consists of a key name and an associated value. By assigning tags to your resources, you can do the
     * following:
     *
     *
     *
     * Administrative grouping and discovery - Attach
     * tags to resources to aid in organization and search. For example, you could search for all
     * resources with the key name Project and the value
     * MyImportantProject. Or search for all resources with the key name
     * Cost Center and the value 41200.
     *
     *
     * Access control - Include tags in IAM user-based
     * and resource-based policies. You can use tags to restrict access to only an IAM instance
     * profile that has a specified tag attached. For examples of policies that show how to use
     * tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags in the
     * IAM User Guide.
     *
     *
     *
     *
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     *
     * Amazon Web Services always interprets the tag Value as a single string. If you
     * need to store an array, you can store comma-separated values in the string. However, you
     * must interpret the value in your code.
     */
    suspend fun tagInstanceProfile(block: TagInstanceProfileRequest.Builder.() -> Unit) = tagInstanceProfile(TagInstanceProfileRequest.Builder().apply(block).build())

    /**
     * Adds one or more tags to an IAM virtual multi-factor authentication (MFA) device. If
     * a tag with the same key name already exists, then that tag is overwritten with the new
     * value.
     * A tag consists of a key name and an associated value. By assigning tags to your
     * resources, you can do the following:
     *
     *
     *
     * Administrative grouping and discovery - Attach
     * tags to resources to aid in organization and search. For example, you could search for all
     * resources with the key name Project and the value
     * MyImportantProject. Or search for all resources with the key name
     * Cost Center and the value 41200.
     *
     *
     * Access control - Include tags in IAM user-based
     * and resource-based policies. You can use tags to restrict access to only an IAM virtual
     * MFA device that has a specified tag attached. For examples of policies that show how to
     * use tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags in the
     * IAM User Guide.
     *
     *
     *
     *
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     *
     * Amazon Web Services always interprets the tag Value as a single string. If you
     * need to store an array, you can store comma-separated values in the string. However, you
     * must interpret the value in your code.
     */
    suspend fun tagMfaDevice(input: TagMfaDeviceRequest): TagMfaDeviceResponse

    /**
     * Adds one or more tags to an IAM virtual multi-factor authentication (MFA) device. If
     * a tag with the same key name already exists, then that tag is overwritten with the new
     * value.
     * A tag consists of a key name and an associated value. By assigning tags to your
     * resources, you can do the following:
     *
     *
     *
     * Administrative grouping and discovery - Attach
     * tags to resources to aid in organization and search. For example, you could search for all
     * resources with the key name Project and the value
     * MyImportantProject. Or search for all resources with the key name
     * Cost Center and the value 41200.
     *
     *
     * Access control - Include tags in IAM user-based
     * and resource-based policies. You can use tags to restrict access to only an IAM virtual
     * MFA device that has a specified tag attached. For examples of policies that show how to
     * use tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags in the
     * IAM User Guide.
     *
     *
     *
     *
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     *
     * Amazon Web Services always interprets the tag Value as a single string. If you
     * need to store an array, you can store comma-separated values in the string. However, you
     * must interpret the value in your code.
     */
    suspend fun tagMfaDevice(block: TagMfaDeviceRequest.Builder.() -> Unit) = tagMfaDevice(TagMfaDeviceRequest.Builder().apply(block).build())

    /**
     * Adds one or more tags to an OpenID Connect (OIDC)-compatible identity provider. For
     * more information about these providers, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html">About web identity federation. If
     * a tag with the same key name already exists, then that tag is overwritten with the new
     * value.
     * A tag consists of a key name and an associated value. By assigning tags to your
     * resources, you can do the following:
     *
     *
     *
     * Administrative grouping and discovery - Attach
     * tags to resources to aid in organization and search. For example, you could search for all
     * resources with the key name Project and the value
     * MyImportantProject. Or search for all resources with the key name
     * Cost Center and the value 41200.
     *
     *
     * Access control - Include tags in IAM user-based
     * and resource-based policies. You can use tags to restrict access to only an OIDC provider
     * that has a specified tag attached. For examples of policies that show how to use tags to
     * control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags in the
     * IAM User Guide.
     *
     *
     *
     *
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     *
     * Amazon Web Services always interprets the tag Value as a single string. If you
     * need to store an array, you can store comma-separated values in the string. However, you
     * must interpret the value in your code.
     */
    suspend fun tagOpenIdConnectProvider(input: TagOpenIdConnectProviderRequest): TagOpenIdConnectProviderResponse

    /**
     * Adds one or more tags to an OpenID Connect (OIDC)-compatible identity provider. For
     * more information about these providers, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html">About web identity federation. If
     * a tag with the same key name already exists, then that tag is overwritten with the new
     * value.
     * A tag consists of a key name and an associated value. By assigning tags to your
     * resources, you can do the following:
     *
     *
     *
     * Administrative grouping and discovery - Attach
     * tags to resources to aid in organization and search. For example, you could search for all
     * resources with the key name Project and the value
     * MyImportantProject. Or search for all resources with the key name
     * Cost Center and the value 41200.
     *
     *
     * Access control - Include tags in IAM user-based
     * and resource-based policies. You can use tags to restrict access to only an OIDC provider
     * that has a specified tag attached. For examples of policies that show how to use tags to
     * control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags in the
     * IAM User Guide.
     *
     *
     *
     *
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     *
     * Amazon Web Services always interprets the tag Value as a single string. If you
     * need to store an array, you can store comma-separated values in the string. However, you
     * must interpret the value in your code.
     */
    suspend fun tagOpenIdConnectProvider(block: TagOpenIdConnectProviderRequest.Builder.() -> Unit) = tagOpenIdConnectProvider(TagOpenIdConnectProviderRequest.Builder().apply(block).build())

    /**
     * Adds one or more tags to an IAM customer managed policy. If a tag with the same key
     * name already exists, then that tag is overwritten with the new value.
     * A tag consists of a key name and an associated value. By assigning tags to your
     * resources, you can do the following:
     *
     *
     *
     * Administrative grouping and discovery - Attach
     * tags to resources to aid in organization and search. For example, you could search for all
     * resources with the key name Project and the value
     * MyImportantProject. Or search for all resources with the key name
     * Cost Center and the value 41200.
     *
     *
     * Access control - Include tags in IAM user-based
     * and resource-based policies. You can use tags to restrict access to only an IAM customer
     * managed policy that has a specified tag attached. For examples of policies that show how
     * to use tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags in the
     * IAM User Guide.
     *
     *
     *
     *
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     *
     * Amazon Web Services always interprets the tag Value as a single string. If you
     * need to store an array, you can store comma-separated values in the string. However, you
     * must interpret the value in your code.
     */
    suspend fun tagPolicy(input: TagPolicyRequest): TagPolicyResponse

    /**
     * Adds one or more tags to an IAM customer managed policy. If a tag with the same key
     * name already exists, then that tag is overwritten with the new value.
     * A tag consists of a key name and an associated value. By assigning tags to your
     * resources, you can do the following:
     *
     *
     *
     * Administrative grouping and discovery - Attach
     * tags to resources to aid in organization and search. For example, you could search for all
     * resources with the key name Project and the value
     * MyImportantProject. Or search for all resources with the key name
     * Cost Center and the value 41200.
     *
     *
     * Access control - Include tags in IAM user-based
     * and resource-based policies. You can use tags to restrict access to only an IAM customer
     * managed policy that has a specified tag attached. For examples of policies that show how
     * to use tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags in the
     * IAM User Guide.
     *
     *
     *
     *
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     *
     * Amazon Web Services always interprets the tag Value as a single string. If you
     * need to store an array, you can store comma-separated values in the string. However, you
     * must interpret the value in your code.
     */
    suspend fun tagPolicy(block: TagPolicyRequest.Builder.() -> Unit) = tagPolicy(TagPolicyRequest.Builder().apply(block).build())

    /**
     * Adds one or more tags to an IAM role. The role can be a regular role or a
     * service-linked role. If a tag with the same key name already exists, then that tag is
     * overwritten with the new value.
     * A tag consists of a key name and an associated value. By assigning tags to your
     * resources, you can do the following:
     *
     *
     *
     * Administrative grouping and discovery - Attach
     * tags to resources to aid in organization and search. For example, you could search for all
     * resources with the key name Project and the value
     * MyImportantProject. Or search for all resources with the key name
     * Cost Center and the value 41200.
     *
     *
     * Access control - Include tags in IAM user-based
     * and resource-based policies. You can use tags to restrict access to only an IAM role
     * that has a specified tag attached. You can also restrict access to only those resources
     * that have a certain tag attached. For examples of policies that show how to use tags to
     * control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags in the
     * IAM User Guide.
     *
     *
     * Cost allocation - Use tags to help track which
     * individuals and teams are using which Amazon Web Services resources.
     *
     *
     *
     *
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     *
     * Amazon Web Services always interprets the tag Value as a single string. If you
     * need to store an array, you can store comma-separated values in the string. However, you
     * must interpret the value in your code.
     *
     *
     *
     * For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM identities in the
     * IAM User Guide.
     */
    suspend fun tagRole(input: TagRoleRequest): TagRoleResponse

    /**
     * Adds one or more tags to an IAM role. The role can be a regular role or a
     * service-linked role. If a tag with the same key name already exists, then that tag is
     * overwritten with the new value.
     * A tag consists of a key name and an associated value. By assigning tags to your
     * resources, you can do the following:
     *
     *
     *
     * Administrative grouping and discovery - Attach
     * tags to resources to aid in organization and search. For example, you could search for all
     * resources with the key name Project and the value
     * MyImportantProject. Or search for all resources with the key name
     * Cost Center and the value 41200.
     *
     *
     * Access control - Include tags in IAM user-based
     * and resource-based policies. You can use tags to restrict access to only an IAM role
     * that has a specified tag attached. You can also restrict access to only those resources
     * that have a certain tag attached. For examples of policies that show how to use tags to
     * control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags in the
     * IAM User Guide.
     *
     *
     * Cost allocation - Use tags to help track which
     * individuals and teams are using which Amazon Web Services resources.
     *
     *
     *
     *
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     *
     * Amazon Web Services always interprets the tag Value as a single string. If you
     * need to store an array, you can store comma-separated values in the string. However, you
     * must interpret the value in your code.
     *
     *
     *
     * For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM identities in the
     * IAM User Guide.
     */
    suspend fun tagRole(block: TagRoleRequest.Builder.() -> Unit) = tagRole(TagRoleRequest.Builder().apply(block).build())

    /**
     * Adds one or more tags to a Security Assertion Markup Language (SAML) identity provider.
     * For more information about these providers, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based federation .
     * If a tag with the same key name already exists, then that tag is overwritten with the new
     * value.
     * A tag consists of a key name and an associated value. By assigning tags to your
     * resources, you can do the following:
     *
     *
     *
     * Administrative grouping and discovery - Attach
     * tags to resources to aid in organization and search. For example, you could search for all
     * resources with the key name Project and the value
     * MyImportantProject. Or search for all resources with the key name
     * Cost Center and the value 41200.
     *
     *
     * Access control - Include tags in IAM user-based
     * and resource-based policies. You can use tags to restrict access to only a SAML identity
     * provider that has a specified tag attached. For examples of policies that show how to use
     * tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags in the
     * IAM User Guide.
     *
     *
     *
     *
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     *
     * Amazon Web Services always interprets the tag Value as a single string. If you
     * need to store an array, you can store comma-separated values in the string. However, you
     * must interpret the value in your code.
     */
    suspend fun tagSamlProvider(input: TagSamlProviderRequest): TagSamlProviderResponse

    /**
     * Adds one or more tags to a Security Assertion Markup Language (SAML) identity provider.
     * For more information about these providers, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based federation .
     * If a tag with the same key name already exists, then that tag is overwritten with the new
     * value.
     * A tag consists of a key name and an associated value. By assigning tags to your
     * resources, you can do the following:
     *
     *
     *
     * Administrative grouping and discovery - Attach
     * tags to resources to aid in organization and search. For example, you could search for all
     * resources with the key name Project and the value
     * MyImportantProject. Or search for all resources with the key name
     * Cost Center and the value 41200.
     *
     *
     * Access control - Include tags in IAM user-based
     * and resource-based policies. You can use tags to restrict access to only a SAML identity
     * provider that has a specified tag attached. For examples of policies that show how to use
     * tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags in the
     * IAM User Guide.
     *
     *
     *
     *
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     *
     * Amazon Web Services always interprets the tag Value as a single string. If you
     * need to store an array, you can store comma-separated values in the string. However, you
     * must interpret the value in your code.
     */
    suspend fun tagSamlProvider(block: TagSamlProviderRequest.Builder.() -> Unit) = tagSamlProvider(TagSamlProviderRequest.Builder().apply(block).build())

    /**
     * Adds one or more tags to an IAM server certificate. If a tag with the same key name
     * already exists, then that tag is overwritten with the new value.
     *
     * For certificates in a Region supported by Certificate Manager (ACM), we
     * recommend that you don't use IAM server certificates. Instead, use ACM to provision,
     * manage, and deploy your server certificates. For more information about IAM server
     * certificates, <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates in the IAM User Guide.
     *
     * A tag consists of a key name and an associated value. By assigning tags to your
     * resources, you can do the following:
     *
     *
     *
     * Administrative grouping and discovery - Attach
     * tags to resources to aid in organization and search. For example, you could search for all
     * resources with the key name Project and the value
     * MyImportantProject. Or search for all resources with the key name
     * Cost Center and the value 41200.
     *
     *
     * Access control - Include tags in IAM user-based
     * and resource-based policies. You can use tags to restrict access to only a server
     * certificate that has a specified tag attached. For examples of policies that show how to
     * use tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags in the
     * IAM User Guide.
     *
     *
     * Cost allocation - Use tags to help track which
     * individuals and teams are using which Amazon Web Services resources.
     *
     *
     *
     *
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     *
     * Amazon Web Services always interprets the tag Value as a single string. If you
     * need to store an array, you can store comma-separated values in the string. However, you
     * must interpret the value in your code.
     */
    suspend fun tagServerCertificate(input: TagServerCertificateRequest): TagServerCertificateResponse

    /**
     * Adds one or more tags to an IAM server certificate. If a tag with the same key name
     * already exists, then that tag is overwritten with the new value.
     *
     * For certificates in a Region supported by Certificate Manager (ACM), we
     * recommend that you don't use IAM server certificates. Instead, use ACM to provision,
     * manage, and deploy your server certificates. For more information about IAM server
     * certificates, <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates in the IAM User Guide.
     *
     * A tag consists of a key name and an associated value. By assigning tags to your
     * resources, you can do the following:
     *
     *
     *
     * Administrative grouping and discovery - Attach
     * tags to resources to aid in organization and search. For example, you could search for all
     * resources with the key name Project and the value
     * MyImportantProject. Or search for all resources with the key name
     * Cost Center and the value 41200.
     *
     *
     * Access control - Include tags in IAM user-based
     * and resource-based policies. You can use tags to restrict access to only a server
     * certificate that has a specified tag attached. For examples of policies that show how to
     * use tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags in the
     * IAM User Guide.
     *
     *
     * Cost allocation - Use tags to help track which
     * individuals and teams are using which Amazon Web Services resources.
     *
     *
     *
     *
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     *
     * Amazon Web Services always interprets the tag Value as a single string. If you
     * need to store an array, you can store comma-separated values in the string. However, you
     * must interpret the value in your code.
     */
    suspend fun tagServerCertificate(block: TagServerCertificateRequest.Builder.() -> Unit) = tagServerCertificate(TagServerCertificateRequest.Builder().apply(block).build())

    /**
     * Adds one or more tags to an IAM user. If a tag with the same key name already exists,
     * then that tag is overwritten with the new value.
     * A tag consists of a key name and an associated value. By assigning tags to your
     * resources, you can do the following:
     *
     *
     *
     * Administrative grouping and discovery - Attach
     * tags to resources to aid in organization and search. For example, you could search for all
     * resources with the key name Project and the value
     * MyImportantProject. Or search for all resources with the key name
     * Cost Center and the value 41200.
     *
     *
     * Access control - Include tags in IAM user-based
     * and resource-based policies. You can use tags to restrict access to only an IAM
     * requesting user that has a specified tag attached. You can also restrict access to only
     * those resources that have a certain tag attached. For examples of policies that show how
     * to use tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags in the
     * IAM User Guide.
     *
     *
     * Cost allocation - Use tags to help track which
     * individuals and teams are using which Amazon Web Services resources.
     *
     *
     *
     *
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     *
     * Amazon Web Services always interprets the tag Value as a single string. If you
     * need to store an array, you can store comma-separated values in the string. However, you
     * must interpret the value in your code.
     *
     *
     *
     * For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM identities in the
     * IAM User Guide.
     */
    suspend fun tagUser(input: TagUserRequest): TagUserResponse

    /**
     * Adds one or more tags to an IAM user. If a tag with the same key name already exists,
     * then that tag is overwritten with the new value.
     * A tag consists of a key name and an associated value. By assigning tags to your
     * resources, you can do the following:
     *
     *
     *
     * Administrative grouping and discovery - Attach
     * tags to resources to aid in organization and search. For example, you could search for all
     * resources with the key name Project and the value
     * MyImportantProject. Or search for all resources with the key name
     * Cost Center and the value 41200.
     *
     *
     * Access control - Include tags in IAM user-based
     * and resource-based policies. You can use tags to restrict access to only an IAM
     * requesting user that has a specified tag attached. You can also restrict access to only
     * those resources that have a certain tag attached. For examples of policies that show how
     * to use tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags in the
     * IAM User Guide.
     *
     *
     * Cost allocation - Use tags to help track which
     * individuals and teams are using which Amazon Web Services resources.
     *
     *
     *
     *
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     *
     * Amazon Web Services always interprets the tag Value as a single string. If you
     * need to store an array, you can store comma-separated values in the string. However, you
     * must interpret the value in your code.
     *
     *
     *
     * For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM identities in the
     * IAM User Guide.
     */
    suspend fun tagUser(block: TagUserRequest.Builder.() -> Unit) = tagUser(TagUserRequest.Builder().apply(block).build())

    /**
     * Removes the specified tags from the IAM instance profile. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun untagInstanceProfile(input: UntagInstanceProfileRequest): UntagInstanceProfileResponse

    /**
     * Removes the specified tags from the IAM instance profile. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun untagInstanceProfile(block: UntagInstanceProfileRequest.Builder.() -> Unit) = untagInstanceProfile(UntagInstanceProfileRequest.Builder().apply(block).build())

    /**
     * Removes the specified tags from the IAM virtual multi-factor authentication (MFA)
     * device. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun untagMfaDevice(input: UntagMfaDeviceRequest): UntagMfaDeviceResponse

    /**
     * Removes the specified tags from the IAM virtual multi-factor authentication (MFA)
     * device. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun untagMfaDevice(block: UntagMfaDeviceRequest.Builder.() -> Unit) = untagMfaDevice(UntagMfaDeviceRequest.Builder().apply(block).build())

    /**
     * Removes the specified tags from the specified OpenID Connect (OIDC)-compatible identity
     * provider in IAM. For more information about OIDC providers, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html">About web identity federation.
     * For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun untagOpenIdConnectProvider(input: UntagOpenIdConnectProviderRequest): UntagOpenIdConnectProviderResponse

    /**
     * Removes the specified tags from the specified OpenID Connect (OIDC)-compatible identity
     * provider in IAM. For more information about OIDC providers, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html">About web identity federation.
     * For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun untagOpenIdConnectProvider(block: UntagOpenIdConnectProviderRequest.Builder.() -> Unit) = untagOpenIdConnectProvider(UntagOpenIdConnectProviderRequest.Builder().apply(block).build())

    /**
     * Removes the specified tags from the customer managed policy. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun untagPolicy(input: UntagPolicyRequest): UntagPolicyResponse

    /**
     * Removes the specified tags from the customer managed policy. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun untagPolicy(block: UntagPolicyRequest.Builder.() -> Unit) = untagPolicy(UntagPolicyRequest.Builder().apply(block).build())

    /**
     * Removes the specified tags from the role. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun untagRole(input: UntagRoleRequest): UntagRoleResponse

    /**
     * Removes the specified tags from the role. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun untagRole(block: UntagRoleRequest.Builder.() -> Unit) = untagRole(UntagRoleRequest.Builder().apply(block).build())

    /**
     * Removes the specified tags from the specified Security Assertion Markup Language (SAML)
     * identity provider in IAM. For more information about these providers, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html">About web identity
     * federation. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun untagSamlProvider(input: UntagSamlProviderRequest): UntagSamlProviderResponse

    /**
     * Removes the specified tags from the specified Security Assertion Markup Language (SAML)
     * identity provider in IAM. For more information about these providers, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html">About web identity
     * federation. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun untagSamlProvider(block: UntagSamlProviderRequest.Builder.() -> Unit) = untagSamlProvider(UntagSamlProviderRequest.Builder().apply(block).build())

    /**
     * Removes the specified tags from the IAM server certificate.
     * For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     *
     * For certificates in a Region supported by Certificate Manager (ACM), we
     * recommend that you don't use IAM server certificates. Instead, use ACM to provision,
     * manage, and deploy your server certificates. For more information about IAM server
     * certificates, <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates in the IAM User Guide.
     */
    suspend fun untagServerCertificate(input: UntagServerCertificateRequest): UntagServerCertificateResponse

    /**
     * Removes the specified tags from the IAM server certificate.
     * For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     *
     * For certificates in a Region supported by Certificate Manager (ACM), we
     * recommend that you don't use IAM server certificates. Instead, use ACM to provision,
     * manage, and deploy your server certificates. For more information about IAM server
     * certificates, <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates in the IAM User Guide.
     */
    suspend fun untagServerCertificate(block: UntagServerCertificateRequest.Builder.() -> Unit) = untagServerCertificate(UntagServerCertificateRequest.Builder().apply(block).build())

    /**
     * Removes the specified tags from the user. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun untagUser(input: UntagUserRequest): UntagUserResponse

    /**
     * Removes the specified tags from the user. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    suspend fun untagUser(block: UntagUserRequest.Builder.() -> Unit) = untagUser(UntagUserRequest.Builder().apply(block).build())

    /**
     * Changes the status of the specified access key from Active to Inactive, or vice versa.
     * This operation can be used to disable a user's key as part of a key rotation
     * workflow.
     * If the UserName is not specified, the user name is determined implicitly
     * based on the Amazon Web Services access key ID used to sign the request. This operation works for
     * access keys under the Amazon Web Services account. Consequently, you can use this operation to manage
     * Amazon Web Services account root user credentials even if the Amazon Web Services account has no associated
     * users.
     * For information about rotating keys, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/ManagingCredentials.html">Managing keys and certificates
     * in the IAM User Guide.
     */
    suspend fun updateAccessKey(input: UpdateAccessKeyRequest): UpdateAccessKeyResponse

    /**
     * Changes the status of the specified access key from Active to Inactive, or vice versa.
     * This operation can be used to disable a user's key as part of a key rotation
     * workflow.
     * If the UserName is not specified, the user name is determined implicitly
     * based on the Amazon Web Services access key ID used to sign the request. This operation works for
     * access keys under the Amazon Web Services account. Consequently, you can use this operation to manage
     * Amazon Web Services account root user credentials even if the Amazon Web Services account has no associated
     * users.
     * For information about rotating keys, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/ManagingCredentials.html">Managing keys and certificates
     * in the IAM User Guide.
     */
    suspend fun updateAccessKey(block: UpdateAccessKeyRequest.Builder.() -> Unit) = updateAccessKey(UpdateAccessKeyRequest.Builder().apply(block).build())

    /**
     * Updates the password policy settings for the Amazon Web Services account.
     *
     * This operation does not support partial updates. No parameters are required, but
     * if you do not specify a parameter, that parameter's value reverts to its default
     * value. See the Request Parameters section for each
     * parameter's default value. Also note that some parameters do not allow the default
     * parameter to be explicitly set. Instead, to invoke the default value, do not include
     * that parameter when you invoke the operation.
     *
     * For more information about using a password policy, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html">Managing an IAM password
     * policy in the IAM User Guide.
     */
    suspend fun updateAccountPasswordPolicy(input: UpdateAccountPasswordPolicyRequest): UpdateAccountPasswordPolicyResponse

    /**
     * Updates the password policy settings for the Amazon Web Services account.
     *
     * This operation does not support partial updates. No parameters are required, but
     * if you do not specify a parameter, that parameter's value reverts to its default
     * value. See the Request Parameters section for each
     * parameter's default value. Also note that some parameters do not allow the default
     * parameter to be explicitly set. Instead, to invoke the default value, do not include
     * that parameter when you invoke the operation.
     *
     * For more information about using a password policy, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html">Managing an IAM password
     * policy in the IAM User Guide.
     */
    suspend fun updateAccountPasswordPolicy(block: UpdateAccountPasswordPolicyRequest.Builder.() -> Unit) = updateAccountPasswordPolicy(UpdateAccountPasswordPolicyRequest.Builder().apply(block).build())

    /**
     * Updates the policy that grants an IAM entity permission to assume a role. This is
     * typically referred to as the "role trust policy". For more information about roles, see
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html">Using roles to
     * delegate permissions and federate identities.
     */
    suspend fun updateAssumeRolePolicy(input: UpdateAssumeRolePolicyRequest): UpdateAssumeRolePolicyResponse

    /**
     * Updates the policy that grants an IAM entity permission to assume a role. This is
     * typically referred to as the "role trust policy". For more information about roles, see
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html">Using roles to
     * delegate permissions and federate identities.
     */
    suspend fun updateAssumeRolePolicy(block: UpdateAssumeRolePolicyRequest.Builder.() -> Unit) = updateAssumeRolePolicy(UpdateAssumeRolePolicyRequest.Builder().apply(block).build())

    /**
     * Updates the name and/or the path of the specified IAM group.
     *
     * You should understand the implications of changing a group's path or name. For
     * more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_WorkingWithGroupsAndUsers.html">Renaming users and
     * groups in the IAM User Guide.
     *
     * The person making the request (the principal), must have permission to change the
     * role group with the old name and the new name. For example, to change the group
     * named Managers to MGRs, the principal must have a policy
     * that allows them to update both groups. If the principal has permission to update
     * the Managers group, but not the MGRs group, then the
     * update fails. For more information about permissions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management.
     */
    suspend fun updateGroup(input: UpdateGroupRequest): UpdateGroupResponse

    /**
     * Updates the name and/or the path of the specified IAM group.
     *
     * You should understand the implications of changing a group's path or name. For
     * more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_WorkingWithGroupsAndUsers.html">Renaming users and
     * groups in the IAM User Guide.
     *
     * The person making the request (the principal), must have permission to change the
     * role group with the old name and the new name. For example, to change the group
     * named Managers to MGRs, the principal must have a policy
     * that allows them to update both groups. If the principal has permission to update
     * the Managers group, but not the MGRs group, then the
     * update fails. For more information about permissions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management.
     */
    suspend fun updateGroup(block: UpdateGroupRequest.Builder.() -> Unit) = updateGroup(UpdateGroupRequest.Builder().apply(block).build())

    /**
     * Changes the password for the specified IAM user. You can use the CLI,
     * the Amazon Web Services API, or the Users page in the IAM console
     * to change the password for any IAM user. Use ChangePassword to
     * change your own password in the My Security Credentials
     * page in the Amazon Web Services Management Console.
     * For more information about modifying passwords, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing passwords in the
     * IAM User Guide.
     */
    suspend fun updateLoginProfile(input: UpdateLoginProfileRequest): UpdateLoginProfileResponse

    /**
     * Changes the password for the specified IAM user. You can use the CLI,
     * the Amazon Web Services API, or the Users page in the IAM console
     * to change the password for any IAM user. Use ChangePassword to
     * change your own password in the My Security Credentials
     * page in the Amazon Web Services Management Console.
     * For more information about modifying passwords, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing passwords in the
     * IAM User Guide.
     */
    suspend fun updateLoginProfile(block: UpdateLoginProfileRequest.Builder.() -> Unit) = updateLoginProfile(UpdateLoginProfileRequest.Builder().apply(block).build())

    /**
     * Replaces the existing list of server certificate thumbprints associated with an OpenID
     * Connect (OIDC) provider resource object with a new list of thumbprints.
     * The list that you pass with this operation completely replaces the existing list of
     * thumbprints. (The lists are not merged.)
     * Typically, you need to update a thumbprint only when the identity provider certificate
     * changes, which occurs rarely. However, if the provider's certificate
     * does change, any attempt to assume an IAM role that specifies
     * the OIDC provider as a principal fails until the certificate thumbprint is
     * updated.
     *
     * Amazon Web Services secures communication with some OIDC identity providers (IdPs) through our
     * library of trusted certificate authorities (CAs) instead of using a certificate
     * thumbprint to verify your IdP server certificate. These OIDC IdPs include Google, and
     * those that use an Amazon S3 bucket to host a JSON Web Key Set (JWKS) endpoint. In these
     * cases, your legacy thumbprint remains in your configuration, but is no longer used for validation.
     *
     *
     * Trust for the OIDC provider is derived from the provider certificate and is
     * validated by the thumbprint. Therefore, it is best to limit access to the
     * UpdateOpenIDConnectProviderThumbprint operation to highly
     * privileged users.
     */
    suspend fun updateOpenIdConnectProviderThumbprint(input: UpdateOpenIdConnectProviderThumbprintRequest): UpdateOpenIdConnectProviderThumbprintResponse

    /**
     * Replaces the existing list of server certificate thumbprints associated with an OpenID
     * Connect (OIDC) provider resource object with a new list of thumbprints.
     * The list that you pass with this operation completely replaces the existing list of
     * thumbprints. (The lists are not merged.)
     * Typically, you need to update a thumbprint only when the identity provider certificate
     * changes, which occurs rarely. However, if the provider's certificate
     * does change, any attempt to assume an IAM role that specifies
     * the OIDC provider as a principal fails until the certificate thumbprint is
     * updated.
     *
     * Amazon Web Services secures communication with some OIDC identity providers (IdPs) through our
     * library of trusted certificate authorities (CAs) instead of using a certificate
     * thumbprint to verify your IdP server certificate. These OIDC IdPs include Google, and
     * those that use an Amazon S3 bucket to host a JSON Web Key Set (JWKS) endpoint. In these
     * cases, your legacy thumbprint remains in your configuration, but is no longer used for validation.
     *
     *
     * Trust for the OIDC provider is derived from the provider certificate and is
     * validated by the thumbprint. Therefore, it is best to limit access to the
     * UpdateOpenIDConnectProviderThumbprint operation to highly
     * privileged users.
     */
    suspend fun updateOpenIdConnectProviderThumbprint(block: UpdateOpenIdConnectProviderThumbprintRequest.Builder.() -> Unit) = updateOpenIdConnectProviderThumbprint(UpdateOpenIdConnectProviderThumbprintRequest.Builder().apply(block).build())

    /**
     * Updates the description or maximum session duration setting of a role.
     */
    suspend fun updateRole(input: UpdateRoleRequest): UpdateRoleResponse

    /**
     * Updates the description or maximum session duration setting of a role.
     */
    suspend fun updateRole(block: UpdateRoleRequest.Builder.() -> Unit) = updateRole(UpdateRoleRequest.Builder().apply(block).build())

    /**
     * Use UpdateRole instead.
     * Modifies only the description of a role. This operation performs the same function as
     * the Description parameter in the UpdateRole operation.
     */
    suspend fun updateRoleDescription(input: UpdateRoleDescriptionRequest): UpdateRoleDescriptionResponse

    /**
     * Use UpdateRole instead.
     * Modifies only the description of a role. This operation performs the same function as
     * the Description parameter in the UpdateRole operation.
     */
    suspend fun updateRoleDescription(block: UpdateRoleDescriptionRequest.Builder.() -> Unit) = updateRoleDescription(UpdateRoleDescriptionRequest.Builder().apply(block).build())

    /**
     * Updates the metadata document for an existing SAML provider resource object.
     *
     * This operation requires <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4.
     */
    suspend fun updateSamlProvider(input: UpdateSamlProviderRequest): UpdateSamlProviderResponse

    /**
     * Updates the metadata document for an existing SAML provider resource object.
     *
     * This operation requires <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4.
     */
    suspend fun updateSamlProvider(block: UpdateSamlProviderRequest.Builder.() -> Unit) = updateSamlProvider(UpdateSamlProviderRequest.Builder().apply(block).build())

    /**
     * Updates the name and/or the path of the specified server certificate stored in
     * IAM.
     * For more information about working with server certificates, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working
     * with server certificates in the IAM User Guide. This
     * topic also includes a list of Amazon Web Services services that can use the server certificates that
     * you manage with IAM.
     *
     * You should understand the implications of changing a server certificate's path or
     * name. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs_manage.html#RenamingServerCerts">Renaming a server certificate in the
     * IAM User Guide.
     *
     * The person making the request (the principal), must have permission to change the
     * server certificate with the old name and the new name. For example, to change the
     * certificate named ProductionCert to ProdCert, the
     * principal must have a policy that allows them to update both certificates. If the
     * principal has permission to update the ProductionCert group, but not
     * the ProdCert certificate, then the update fails. For more information
     * about permissions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management in the IAM User Guide.
     */
    suspend fun updateServerCertificate(input: UpdateServerCertificateRequest): UpdateServerCertificateResponse

    /**
     * Updates the name and/or the path of the specified server certificate stored in
     * IAM.
     * For more information about working with server certificates, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working
     * with server certificates in the IAM User Guide. This
     * topic also includes a list of Amazon Web Services services that can use the server certificates that
     * you manage with IAM.
     *
     * You should understand the implications of changing a server certificate's path or
     * name. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs_manage.html#RenamingServerCerts">Renaming a server certificate in the
     * IAM User Guide.
     *
     * The person making the request (the principal), must have permission to change the
     * server certificate with the old name and the new name. For example, to change the
     * certificate named ProductionCert to ProdCert, the
     * principal must have a policy that allows them to update both certificates. If the
     * principal has permission to update the ProductionCert group, but not
     * the ProdCert certificate, then the update fails. For more information
     * about permissions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management in the IAM User Guide.
     */
    suspend fun updateServerCertificate(block: UpdateServerCertificateRequest.Builder.() -> Unit) = updateServerCertificate(UpdateServerCertificateRequest.Builder().apply(block).build())

    /**
     * Sets the status of a service-specific credential to Active or
     * Inactive. Service-specific credentials that are inactive cannot be used
     * for authentication to the service. This operation can be used to disable a user's
     * service-specific credential as part of a credential rotation work flow.
     */
    suspend fun updateServiceSpecificCredential(input: UpdateServiceSpecificCredentialRequest): UpdateServiceSpecificCredentialResponse

    /**
     * Sets the status of a service-specific credential to Active or
     * Inactive. Service-specific credentials that are inactive cannot be used
     * for authentication to the service. This operation can be used to disable a user's
     * service-specific credential as part of a credential rotation work flow.
     */
    suspend fun updateServiceSpecificCredential(block: UpdateServiceSpecificCredentialRequest.Builder.() -> Unit) = updateServiceSpecificCredential(UpdateServiceSpecificCredentialRequest.Builder().apply(block).build())

    /**
     * Changes the status of the specified user signing certificate from active to disabled,
     * or vice versa. This operation can be used to disable an IAM user's signing certificate
     * as part of a certificate rotation work flow.
     * If the UserName field is not specified, the user name is determined
     * implicitly based on the Amazon Web Services access key ID used to sign the request. This operation
     * works for access keys under the Amazon Web Services account. Consequently, you can use this operation
     * to manage Amazon Web Services account root user credentials even if the Amazon Web Services account has no
     * associated users.
     */
    suspend fun updateSigningCertificate(input: UpdateSigningCertificateRequest): UpdateSigningCertificateResponse

    /**
     * Changes the status of the specified user signing certificate from active to disabled,
     * or vice versa. This operation can be used to disable an IAM user's signing certificate
     * as part of a certificate rotation work flow.
     * If the UserName field is not specified, the user name is determined
     * implicitly based on the Amazon Web Services access key ID used to sign the request. This operation
     * works for access keys under the Amazon Web Services account. Consequently, you can use this operation
     * to manage Amazon Web Services account root user credentials even if the Amazon Web Services account has no
     * associated users.
     */
    suspend fun updateSigningCertificate(block: UpdateSigningCertificateRequest.Builder.() -> Unit) = updateSigningCertificate(UpdateSigningCertificateRequest.Builder().apply(block).build())

    /**
     * Sets the status of an IAM user's SSH public key to active or inactive. SSH public
     * keys that are inactive cannot be used for authentication. This operation can be used to
     * disable a user's SSH public key as part of a key rotation work flow.
     * The SSH public key affected by this operation is used only for authenticating the
     * associated IAM user to an CodeCommit repository. For more information about using SSH keys
     * to authenticate to an CodeCommit repository, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up CodeCommit for
     * SSH connections in the CodeCommit User Guide.
     */
    suspend fun updateSshPublicKey(input: UpdateSshPublicKeyRequest): UpdateSshPublicKeyResponse

    /**
     * Sets the status of an IAM user's SSH public key to active or inactive. SSH public
     * keys that are inactive cannot be used for authentication. This operation can be used to
     * disable a user's SSH public key as part of a key rotation work flow.
     * The SSH public key affected by this operation is used only for authenticating the
     * associated IAM user to an CodeCommit repository. For more information about using SSH keys
     * to authenticate to an CodeCommit repository, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up CodeCommit for
     * SSH connections in the CodeCommit User Guide.
     */
    suspend fun updateSshPublicKey(block: UpdateSshPublicKeyRequest.Builder.() -> Unit) = updateSshPublicKey(UpdateSshPublicKeyRequest.Builder().apply(block).build())

    /**
     * Updates the name and/or the path of the specified IAM user.
     *
     * You should understand the implications of changing an IAM user's path or name.
     * For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_manage.html#id_users_renaming">Renaming an IAM
     * user and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups_manage_rename.html">Renaming an IAM
     * group in the IAM User Guide.
     *
     * To change a user name, the requester must have appropriate permissions on both
     * the source object and the target object. For example, to change Bob to Robert, the
     * entity making the request must have permission on Bob and Robert, or must have
     * permission on all (*). For more information about permissions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/PermissionsAndPolicies.html">Permissions and policies.
     */
    suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse

    /**
     * Updates the name and/or the path of the specified IAM user.
     *
     * You should understand the implications of changing an IAM user's path or name.
     * For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_manage.html#id_users_renaming">Renaming an IAM
     * user and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups_manage_rename.html">Renaming an IAM
     * group in the IAM User Guide.
     *
     * To change a user name, the requester must have appropriate permissions on both
     * the source object and the target object. For example, to change Bob to Robert, the
     * entity making the request must have permission on Bob and Robert, or must have
     * permission on all (*). For more information about permissions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/PermissionsAndPolicies.html">Permissions and policies.
     */
    suspend fun updateUser(block: UpdateUserRequest.Builder.() -> Unit) = updateUser(UpdateUserRequest.Builder().apply(block).build())

    /**
     * Uploads a server certificate entity for the Amazon Web Services account. The server certificate
     * entity includes a public key certificate, a private key, and an optional certificate
     * chain, which should all be PEM-encoded.
     * We recommend that you use <a href="https://docs.aws.amazon.com/acm/">Certificate Manager to
     * provision, manage, and deploy your server certificates. With ACM you can request a
     * certificate, deploy it to Amazon Web Services resources, and let ACM handle certificate renewals for
     * you. Certificates provided by ACM are free. For more information about using ACM,
     * see the <a href="https://docs.aws.amazon.com/acm/latest/userguide/">Certificate Manager User
     * Guide.
     * For more information about working with server certificates, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working
     * with server certificates in the IAM User Guide. This
     * topic includes a list of Amazon Web Services services that can use the server certificates that you
     * manage with IAM.
     * For information about the number of server certificates you can upload, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS
     * quotas in the IAM User Guide.
     *
     * Because the body of the public key certificate, private key, and the certificate
     * chain can be large, you should use POST rather than GET when calling
     * UploadServerCertificate. For information about setting up
     * signatures and authorization through the API, see <a href="https://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html">Signing Amazon Web Services API
     * requests in the Amazon Web Services General Reference. For general
     * information about using the Query API with IAM, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/programming.html">Calling the API by making HTTP query
     * requests in the IAM User Guide.
     */
    suspend fun uploadServerCertificate(input: UploadServerCertificateRequest): UploadServerCertificateResponse

    /**
     * Uploads a server certificate entity for the Amazon Web Services account. The server certificate
     * entity includes a public key certificate, a private key, and an optional certificate
     * chain, which should all be PEM-encoded.
     * We recommend that you use <a href="https://docs.aws.amazon.com/acm/">Certificate Manager to
     * provision, manage, and deploy your server certificates. With ACM you can request a
     * certificate, deploy it to Amazon Web Services resources, and let ACM handle certificate renewals for
     * you. Certificates provided by ACM are free. For more information about using ACM,
     * see the <a href="https://docs.aws.amazon.com/acm/latest/userguide/">Certificate Manager User
     * Guide.
     * For more information about working with server certificates, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working
     * with server certificates in the IAM User Guide. This
     * topic includes a list of Amazon Web Services services that can use the server certificates that you
     * manage with IAM.
     * For information about the number of server certificates you can upload, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS
     * quotas in the IAM User Guide.
     *
     * Because the body of the public key certificate, private key, and the certificate
     * chain can be large, you should use POST rather than GET when calling
     * UploadServerCertificate. For information about setting up
     * signatures and authorization through the API, see <a href="https://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html">Signing Amazon Web Services API
     * requests in the Amazon Web Services General Reference. For general
     * information about using the Query API with IAM, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/programming.html">Calling the API by making HTTP query
     * requests in the IAM User Guide.
     */
    suspend fun uploadServerCertificate(block: UploadServerCertificateRequest.Builder.() -> Unit) = uploadServerCertificate(UploadServerCertificateRequest.Builder().apply(block).build())

    /**
     * Uploads an X.509 signing certificate and associates it with the specified IAM user.
     * Some Amazon Web Services services require you to use certificates to validate requests that are signed
     * with a corresponding private key. When you upload the certificate, its default status is
     * Active.
     * For information about when you would use an X.509 signing certificate, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Managing
     * server certificates in IAM in the
     * IAM User Guide.
     * If the UserName is not specified, the IAM user name is determined
     * implicitly based on the Amazon Web Services access key ID used to sign the request. This operation
     * works for access keys under the Amazon Web Services account. Consequently, you can use this operation
     * to manage Amazon Web Services account root user credentials even if the Amazon Web Services account has no
     * associated users.
     *
     * Because the body of an X.509 certificate can be large, you should use POST rather
     * than GET when calling UploadSigningCertificate. For information about
     * setting up signatures and authorization through the API, see <a href="https://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html">Signing
     * Amazon Web Services API requests in the Amazon Web Services General Reference. For
     * general information about using the Query API with IAM, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making query
     * requests in the IAM User Guide.
     */
    suspend fun uploadSigningCertificate(input: UploadSigningCertificateRequest): UploadSigningCertificateResponse

    /**
     * Uploads an X.509 signing certificate and associates it with the specified IAM user.
     * Some Amazon Web Services services require you to use certificates to validate requests that are signed
     * with a corresponding private key. When you upload the certificate, its default status is
     * Active.
     * For information about when you would use an X.509 signing certificate, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Managing
     * server certificates in IAM in the
     * IAM User Guide.
     * If the UserName is not specified, the IAM user name is determined
     * implicitly based on the Amazon Web Services access key ID used to sign the request. This operation
     * works for access keys under the Amazon Web Services account. Consequently, you can use this operation
     * to manage Amazon Web Services account root user credentials even if the Amazon Web Services account has no
     * associated users.
     *
     * Because the body of an X.509 certificate can be large, you should use POST rather
     * than GET when calling UploadSigningCertificate. For information about
     * setting up signatures and authorization through the API, see <a href="https://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html">Signing
     * Amazon Web Services API requests in the Amazon Web Services General Reference. For
     * general information about using the Query API with IAM, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making query
     * requests in the IAM User Guide.
     */
    suspend fun uploadSigningCertificate(block: UploadSigningCertificateRequest.Builder.() -> Unit) = uploadSigningCertificate(UploadSigningCertificateRequest.Builder().apply(block).build())

    /**
     * Uploads an SSH public key and associates it with the specified IAM user.
     * The SSH public key uploaded by this operation can be used only for authenticating the
     * associated IAM user to an CodeCommit repository. For more information about using SSH keys
     * to authenticate to an CodeCommit repository, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up CodeCommit for
     * SSH connections in the CodeCommit User Guide.
     */
    suspend fun uploadSshPublicKey(input: UploadSshPublicKeyRequest): UploadSshPublicKeyResponse

    /**
     * Uploads an SSH public key and associates it with the specified IAM user.
     * The SSH public key uploaded by this operation can be used only for authenticating the
     * associated IAM user to an CodeCommit repository. For more information about using SSH keys
     * to authenticate to an CodeCommit repository, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up CodeCommit for
     * SSH connections in the CodeCommit User Guide.
     */
    suspend fun uploadSshPublicKey(block: UploadSshPublicKeyRequest.Builder.() -> Unit) = uploadSshPublicKey(UploadSshPublicKeyRequest.Builder().apply(block).build())
}
