// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.internal

import aws.sdk.kotlin.runtime.ClientException
import aws.sdk.kotlin.runtime.endpoint.AwsEndpoint
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.endpoint.CredentialScope
import aws.sdk.kotlin.runtime.endpoint.internal.EndpointDefinition
import aws.sdk.kotlin.runtime.endpoint.internal.Partition
import aws.sdk.kotlin.runtime.endpoint.internal.resolveEndpoint

internal class DefaultEndpointResolver : AwsEndpointResolver {
    override suspend fun resolve(service: String, region: String): AwsEndpoint {
        return resolveEndpoint(servicePartitions, region) ?: throw ClientException("unable to resolve endpoint for region: $region")
    }
}

private val servicePartitions = listOf(
    Partition(
        id = "aws",
        regionRegex = Regex("^(us|eu|ap|sa|ca|me|af)\\-\\w+\\-\\d+$"),
        partitionEndpoint = "aws-global",
        isRegionalized = false,
        defaults = EndpointDefinition(
            hostname = "iam.{region}.amazonaws.com",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
            "aws-global" to EndpointDefinition(
                hostname = "iam.amazonaws.com",
                credentialScope = CredentialScope(region = "us-east-1",),
            ),
            "iam-fips" to EndpointDefinition(
                hostname = "iam-fips.amazonaws.com",
                credentialScope = CredentialScope(region = "us-east-1",),
            ),
        )
    ),
    Partition(
        id = "aws-cn",
        regionRegex = Regex("^cn\\-\\w+\\-\\d+$"),
        partitionEndpoint = "aws-cn-global",
        isRegionalized = false,
        defaults = EndpointDefinition(
            hostname = "iam.{region}.amazonaws.com.cn",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
            "aws-cn-global" to EndpointDefinition(
                hostname = "iam.cn-north-1.amazonaws.com.cn",
                credentialScope = CredentialScope(region = "cn-north-1",),
            ),
        )
    ),
    Partition(
        id = "aws-iso",
        regionRegex = Regex("^us\\-iso\\-\\w+\\-\\d+$"),
        partitionEndpoint = "aws-iso-global",
        isRegionalized = false,
        defaults = EndpointDefinition(
            hostname = "iam.{region}.c2s.ic.gov",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
            "aws-iso-global" to EndpointDefinition(
                hostname = "iam.us-iso-east-1.c2s.ic.gov",
                credentialScope = CredentialScope(region = "us-iso-east-1",),
            ),
        )
    ),
    Partition(
        id = "aws-iso-b",
        regionRegex = Regex("^us\\-isob\\-\\w+\\-\\d+$"),
        partitionEndpoint = "aws-iso-b-global",
        isRegionalized = false,
        defaults = EndpointDefinition(
            hostname = "iam.{region}.sc2s.sgov.gov",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
            "aws-iso-b-global" to EndpointDefinition(
                hostname = "iam.us-isob-east-1.sc2s.sgov.gov",
                credentialScope = CredentialScope(region = "us-isob-east-1",),
            ),
        )
    ),
    Partition(
        id = "aws-us-gov",
        regionRegex = Regex("^us\\-gov\\-\\w+\\-\\d+$"),
        partitionEndpoint = "aws-us-gov-global",
        isRegionalized = false,
        defaults = EndpointDefinition(
            hostname = "iam.{region}.amazonaws.com",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
            "aws-us-gov-global" to EndpointDefinition(
                hostname = "iam.us-gov.amazonaws.com",
                credentialScope = CredentialScope(region = "us-gov-west-1",),
            ),
            "iam-govcloud-fips" to EndpointDefinition(
                hostname = "iam.us-gov.amazonaws.com",
                credentialScope = CredentialScope(region = "us-gov-west-1",),
            ),
        )
    ),
)
