// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object that contains details about when a principal in the reported Organizations entity
 * last attempted to access an Amazon Web Services service. A principal can be an IAM user, an IAM role,
 * or the Amazon Web Services account root user within the reported Organizations entity.
 * This data type is a response element in the GetOrganizationsAccessReport operation.
 */
class AccessDetail private constructor(builder: Builder) {
    /**
     * The path of the Organizations entity (root, organizational unit, or account) from which an
     * authenticated principal last attempted to access the service. Amazon Web Services does not report
     * unauthenticated requests.
     * This field is null if no principals (IAM users, IAM roles, or root users) in the
     * reported Organizations entity attempted to access the service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period.
     */
    val entityPath: kotlin.String? = builder.entityPath
    /**
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
     * format, when an authenticated principal most recently attempted to access the
     * service. Amazon Web Services does not report unauthenticated requests.
     * This field is null if no principals in the reported Organizations entity attempted to access the
     * service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period.
     */
    val lastAuthenticatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastAuthenticatedTime
    /**
     * The Region where the last service access attempt occurred.
     * This field is null if no principals in the reported Organizations entity attempted to access the
     * service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period.
     */
    val region: kotlin.String? = builder.region
    /**
     * The name of the service in which access was attempted.
     */
    val serviceName: kotlin.String? = builder.serviceName
    /**
     * The namespace of the service in which access was attempted.
     * To learn the service namespace of a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for Amazon Web Services services in the
     * Service Authorization Reference. Choose the name of the service to
     * view details for that service. In the first paragraph, find the service prefix. For
     * example, (service prefix: a4b). For more information about service namespaces,
     * see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">Amazon Web Services
     * service namespaces in the Amazon Web Services General Reference.
     */
    val serviceNamespace: kotlin.String? = builder.serviceNamespace
    /**
     * The number of accounts with authenticated principals (root users, IAM users, and IAM
     * roles) that attempted to access the service in the reporting period.
     */
    val totalAuthenticatedEntities: kotlin.Int? = builder.totalAuthenticatedEntities

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.AccessDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccessDetail(")
        append("entityPath=$entityPath,")
        append("lastAuthenticatedTime=$lastAuthenticatedTime,")
        append("region=$region,")
        append("serviceName=$serviceName,")
        append("serviceNamespace=$serviceNamespace,")
        append("totalAuthenticatedEntities=$totalAuthenticatedEntities)")
    }

    override fun hashCode(): kotlin.Int {
        var result = entityPath?.hashCode() ?: 0
        result = 31 * result + (lastAuthenticatedTime?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (serviceNamespace?.hashCode() ?: 0)
        result = 31 * result + (totalAuthenticatedEntities ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccessDetail

        if (entityPath != other.entityPath) return false
        if (lastAuthenticatedTime != other.lastAuthenticatedTime) return false
        if (region != other.region) return false
        if (serviceName != other.serviceName) return false
        if (serviceNamespace != other.serviceNamespace) return false
        if (totalAuthenticatedEntities != other.totalAuthenticatedEntities) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.AccessDetail = Builder(this).apply(block).build()

    class Builder {
        /**
         * The path of the Organizations entity (root, organizational unit, or account) from which an
         * authenticated principal last attempted to access the service. Amazon Web Services does not report
         * unauthenticated requests.
         * This field is null if no principals (IAM users, IAM roles, or root users) in the
         * reported Organizations entity attempted to access the service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period.
         */
        var entityPath: kotlin.String? = null
        /**
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
         * format, when an authenticated principal most recently attempted to access the
         * service. Amazon Web Services does not report unauthenticated requests.
         * This field is null if no principals in the reported Organizations entity attempted to access the
         * service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period.
         */
        var lastAuthenticatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Region where the last service access attempt occurred.
         * This field is null if no principals in the reported Organizations entity attempted to access the
         * service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period.
         */
        var region: kotlin.String? = null
        /**
         * The name of the service in which access was attempted.
         */
        var serviceName: kotlin.String? = null
        /**
         * The namespace of the service in which access was attempted.
         * To learn the service namespace of a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for Amazon Web Services services in the
         * Service Authorization Reference. Choose the name of the service to
         * view details for that service. In the first paragraph, find the service prefix. For
         * example, (service prefix: a4b). For more information about service namespaces,
         * see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">Amazon Web Services
         * service namespaces in the Amazon Web Services General Reference.
         */
        var serviceNamespace: kotlin.String? = null
        /**
         * The number of accounts with authenticated principals (root users, IAM users, and IAM
         * roles) that attempted to access the service in the reporting period.
         */
        var totalAuthenticatedEntities: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.AccessDetail) : this() {
            this.entityPath = x.entityPath
            this.lastAuthenticatedTime = x.lastAuthenticatedTime
            this.region = x.region
            this.serviceName = x.serviceName
            this.serviceNamespace = x.serviceNamespace
            this.totalAuthenticatedEntities = x.totalAuthenticatedEntities
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.AccessDetail = AccessDetail(this)
    }
}
