// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an Amazon Web Services access key.
 * This data type is used as a response element in the CreateAccessKey
 * and ListAccessKeys operations.
 *
 * The SecretAccessKey value is returned only in response to CreateAccessKey. You can get a secret access key only when you first
 * create an access key; you cannot recover the secret access key later. If you lose a
 * secret access key, you must create a new access key.
 */
class AccessKey private constructor(builder: Builder) {
    /**
     * The ID for this access key.
     */
    val accessKeyId: kotlin.String? = builder.accessKeyId
    /**
     * The date when the access key was created.
     */
    val createDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createDate
    /**
     * The secret key used to sign requests.
     */
    val secretAccessKey: kotlin.String? = builder.secretAccessKey
    /**
     * The status of the access key. Active means that the key is valid for API
     * calls, while Inactive means it is not.
     */
    val status: aws.sdk.kotlin.services.iam.model.StatusType? = builder.status
    /**
     * The name of the IAM user that the access key is associated with.
     */
    val userName: kotlin.String? = builder.userName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.AccessKey = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccessKey(")
        append("accessKeyId=$accessKeyId,")
        append("createDate=$createDate,")
        append("secretAccessKey=*** Sensitive Data Redacted ***,")
        append("status=$status,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessKeyId?.hashCode() ?: 0
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (secretAccessKey?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccessKey

        if (accessKeyId != other.accessKeyId) return false
        if (createDate != other.createDate) return false
        if (secretAccessKey != other.secretAccessKey) return false
        if (status != other.status) return false
        if (userName != other.userName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.AccessKey = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID for this access key.
         */
        var accessKeyId: kotlin.String? = null
        /**
         * The date when the access key was created.
         */
        var createDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The secret key used to sign requests.
         */
        var secretAccessKey: kotlin.String? = null
        /**
         * The status of the access key. Active means that the key is valid for API
         * calls, while Inactive means it is not.
         */
        var status: aws.sdk.kotlin.services.iam.model.StatusType? = null
        /**
         * The name of the IAM user that the access key is associated with.
         */
        var userName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.AccessKey) : this() {
            this.accessKeyId = x.accessKeyId
            this.createDate = x.createDate
            this.secretAccessKey = x.secretAccessKey
            this.status = x.status
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.AccessKey = AccessKey(this)
    }
}
