// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object that contains details about when the IAM entities (users or roles) were last
 * used in an attempt to access the specified Amazon Web Services service.
 * This data type is a response element in the GetServiceLastAccessedDetailsWithEntities operation.
 */
class EntityDetails private constructor(builder: Builder) {
    /**
     * The EntityInfo object that contains details about the entity (user or
     * role).
     */
    val entityInfo: aws.sdk.kotlin.services.iam.model.EntityInfo? = builder.entityInfo
    /**
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
     * format, when the authenticated entity last attempted to access Amazon Web Services. Amazon Web Services does
     * not report unauthenticated requests.
     * This field is null if no IAM entities attempted to access the service within the
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period.
     */
    val lastAuthenticated: aws.smithy.kotlin.runtime.time.Instant? = builder.lastAuthenticated

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.EntityDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EntityDetails(")
        append("entityInfo=$entityInfo,")
        append("lastAuthenticated=$lastAuthenticated)")
    }

    override fun hashCode(): kotlin.Int {
        var result = entityInfo?.hashCode() ?: 0
        result = 31 * result + (lastAuthenticated?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EntityDetails

        if (entityInfo != other.entityInfo) return false
        if (lastAuthenticated != other.lastAuthenticated) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.EntityDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The EntityInfo object that contains details about the entity (user or
         * role).
         */
        var entityInfo: aws.sdk.kotlin.services.iam.model.EntityInfo? = null
        /**
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
         * format, when the authenticated entity last attempted to access Amazon Web Services. Amazon Web Services does
         * not report unauthenticated requests.
         * This field is null if no IAM entities attempted to access the service within the
         * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period.
         */
        var lastAuthenticated: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.EntityDetails) : this() {
            this.entityInfo = x.entityInfo
            this.lastAuthenticated = x.lastAuthenticated
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.EntityDetails = EntityDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.iam.model.EntityInfo] inside the given [block]
         */
        fun entityInfo(block: aws.sdk.kotlin.services.iam.model.EntityInfo.Builder.() -> kotlin.Unit) {
            this.entityInfo = aws.sdk.kotlin.services.iam.model.EntityInfo.invoke(block)
        }
    }
}
