// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



/**
 * Contains the results of a simulation.
 * This data type is used by the return parameter of
 * SimulateCustomPolicy
 * and
 * SimulatePrincipalPolicy
 * .
 */
class EvaluationResult private constructor(builder: Builder) {
    /**
     * The name of the API operation tested on the indicated resource.
     */
    val evalActionName: kotlin.String? = builder.evalActionName
    /**
     * The result of the simulation.
     */
    val evalDecision: aws.sdk.kotlin.services.iam.model.PolicyEvaluationDecisionType? = builder.evalDecision
    /**
     * Additional details about the results of the cross-account evaluation decision. This
     * parameter is populated for only cross-account simulations. It contains a brief summary of
     * how each policy type contributes to the final evaluation decision.
     * If the simulation evaluates policies within the same account and includes a resource
     * ARN, then the parameter is present but the response is empty. If the simulation evaluates
     * policies within the same account and specifies all resources (*), then the
     * parameter is not returned.
     * When you make a cross-account request, Amazon Web Services evaluates the request in the trusting
     * account and the trusted account. The request is allowed only if both evaluations return
     * true. For more information about how policies are evaluated, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics">Evaluating policies within a single account.
     * If an Organizations SCP included in the evaluation denies access, the simulation ends. In
     * this case, policy evaluation does not proceed any further and this parameter is not
     * returned.
     */
    val evalDecisionDetails: Map<String, PolicyEvaluationDecisionType>? = builder.evalDecisionDetails
    /**
     * The ARN of the resource that the indicated API operation was tested on.
     */
    val evalResourceName: kotlin.String? = builder.evalResourceName
    /**
     * A list of the statements in the input policies that determine the result for this
     * scenario. Remember that even if multiple statements allow the operation on the resource, if
     * only one statement denies that operation, then the explicit deny overrides any allow. In
     * addition, the deny statement is the only entry included in the result.
     */
    val matchedStatements: List<Statement>? = builder.matchedStatements
    /**
     * A list of context keys that are required by the included input policies but that were
     * not provided by one of the input parameters. This list is used when the resource in a
     * simulation is "*", either explicitly, or when the ResourceArns parameter
     * blank. If you include a list of resources, then any missing context values are instead
     * included under the ResourceSpecificResults section. To discover the context
     * keys used by a set of policies, you can call GetContextKeysForCustomPolicy or GetContextKeysForPrincipalPolicy.
     */
    val missingContextValues: List<String>? = builder.missingContextValues
    /**
     * A structure that details how Organizations and its service control policies affect the results of
     * the simulation. Only applies if the simulated user's account is part of an
     * organization.
     */
    val organizationsDecisionDetail: aws.sdk.kotlin.services.iam.model.OrganizationsDecisionDetail? = builder.organizationsDecisionDetail
    /**
     * Contains information about the effect that a permissions boundary has on a policy
     * simulation when the boundary is applied to an IAM entity.
     */
    val permissionsBoundaryDecisionDetail: aws.sdk.kotlin.services.iam.model.PermissionsBoundaryDecisionDetail? = builder.permissionsBoundaryDecisionDetail
    /**
     * The individual results of the simulation of the API operation specified in
     * EvalActionName on each resource.
     */
    val resourceSpecificResults: List<ResourceSpecificResult>? = builder.resourceSpecificResults

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.EvaluationResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EvaluationResult(")
        append("evalActionName=$evalActionName,")
        append("evalDecision=$evalDecision,")
        append("evalDecisionDetails=$evalDecisionDetails,")
        append("evalResourceName=$evalResourceName,")
        append("matchedStatements=$matchedStatements,")
        append("missingContextValues=$missingContextValues,")
        append("organizationsDecisionDetail=$organizationsDecisionDetail,")
        append("permissionsBoundaryDecisionDetail=$permissionsBoundaryDecisionDetail,")
        append("resourceSpecificResults=$resourceSpecificResults)")
    }

    override fun hashCode(): kotlin.Int {
        var result = evalActionName?.hashCode() ?: 0
        result = 31 * result + (evalDecision?.hashCode() ?: 0)
        result = 31 * result + (evalDecisionDetails?.hashCode() ?: 0)
        result = 31 * result + (evalResourceName?.hashCode() ?: 0)
        result = 31 * result + (matchedStatements?.hashCode() ?: 0)
        result = 31 * result + (missingContextValues?.hashCode() ?: 0)
        result = 31 * result + (organizationsDecisionDetail?.hashCode() ?: 0)
        result = 31 * result + (permissionsBoundaryDecisionDetail?.hashCode() ?: 0)
        result = 31 * result + (resourceSpecificResults?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EvaluationResult

        if (evalActionName != other.evalActionName) return false
        if (evalDecision != other.evalDecision) return false
        if (evalDecisionDetails != other.evalDecisionDetails) return false
        if (evalResourceName != other.evalResourceName) return false
        if (matchedStatements != other.matchedStatements) return false
        if (missingContextValues != other.missingContextValues) return false
        if (organizationsDecisionDetail != other.organizationsDecisionDetail) return false
        if (permissionsBoundaryDecisionDetail != other.permissionsBoundaryDecisionDetail) return false
        if (resourceSpecificResults != other.resourceSpecificResults) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.EvaluationResult = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the API operation tested on the indicated resource.
         */
        var evalActionName: kotlin.String? = null
        /**
         * The result of the simulation.
         */
        var evalDecision: aws.sdk.kotlin.services.iam.model.PolicyEvaluationDecisionType? = null
        /**
         * Additional details about the results of the cross-account evaluation decision. This
         * parameter is populated for only cross-account simulations. It contains a brief summary of
         * how each policy type contributes to the final evaluation decision.
         * If the simulation evaluates policies within the same account and includes a resource
         * ARN, then the parameter is present but the response is empty. If the simulation evaluates
         * policies within the same account and specifies all resources (*), then the
         * parameter is not returned.
         * When you make a cross-account request, Amazon Web Services evaluates the request in the trusting
         * account and the trusted account. The request is allowed only if both evaluations return
         * true. For more information about how policies are evaluated, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics">Evaluating policies within a single account.
         * If an Organizations SCP included in the evaluation denies access, the simulation ends. In
         * this case, policy evaluation does not proceed any further and this parameter is not
         * returned.
         */
        var evalDecisionDetails: Map<String, PolicyEvaluationDecisionType>? = null
        /**
         * The ARN of the resource that the indicated API operation was tested on.
         */
        var evalResourceName: kotlin.String? = null
        /**
         * A list of the statements in the input policies that determine the result for this
         * scenario. Remember that even if multiple statements allow the operation on the resource, if
         * only one statement denies that operation, then the explicit deny overrides any allow. In
         * addition, the deny statement is the only entry included in the result.
         */
        var matchedStatements: List<Statement>? = null
        /**
         * A list of context keys that are required by the included input policies but that were
         * not provided by one of the input parameters. This list is used when the resource in a
         * simulation is "*", either explicitly, or when the ResourceArns parameter
         * blank. If you include a list of resources, then any missing context values are instead
         * included under the ResourceSpecificResults section. To discover the context
         * keys used by a set of policies, you can call GetContextKeysForCustomPolicy or GetContextKeysForPrincipalPolicy.
         */
        var missingContextValues: List<String>? = null
        /**
         * A structure that details how Organizations and its service control policies affect the results of
         * the simulation. Only applies if the simulated user's account is part of an
         * organization.
         */
        var organizationsDecisionDetail: aws.sdk.kotlin.services.iam.model.OrganizationsDecisionDetail? = null
        /**
         * Contains information about the effect that a permissions boundary has on a policy
         * simulation when the boundary is applied to an IAM entity.
         */
        var permissionsBoundaryDecisionDetail: aws.sdk.kotlin.services.iam.model.PermissionsBoundaryDecisionDetail? = null
        /**
         * The individual results of the simulation of the API operation specified in
         * EvalActionName on each resource.
         */
        var resourceSpecificResults: List<ResourceSpecificResult>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.EvaluationResult) : this() {
            this.evalActionName = x.evalActionName
            this.evalDecision = x.evalDecision
            this.evalDecisionDetails = x.evalDecisionDetails
            this.evalResourceName = x.evalResourceName
            this.matchedStatements = x.matchedStatements
            this.missingContextValues = x.missingContextValues
            this.organizationsDecisionDetail = x.organizationsDecisionDetail
            this.permissionsBoundaryDecisionDetail = x.permissionsBoundaryDecisionDetail
            this.resourceSpecificResults = x.resourceSpecificResults
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.EvaluationResult = EvaluationResult(this)

        /**
         * construct an [aws.sdk.kotlin.services.iam.model.OrganizationsDecisionDetail] inside the given [block]
         */
        fun organizationsDecisionDetail(block: aws.sdk.kotlin.services.iam.model.OrganizationsDecisionDetail.Builder.() -> kotlin.Unit) {
            this.organizationsDecisionDetail = aws.sdk.kotlin.services.iam.model.OrganizationsDecisionDetail.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iam.model.PermissionsBoundaryDecisionDetail] inside the given [block]
         */
        fun permissionsBoundaryDecisionDetail(block: aws.sdk.kotlin.services.iam.model.PermissionsBoundaryDecisionDetail.Builder.() -> kotlin.Unit) {
            this.permissionsBoundaryDecisionDetail = aws.sdk.kotlin.services.iam.model.PermissionsBoundaryDecisionDetail.invoke(block)
        }
    }
}
