// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

class GetServiceLastAccessedDetailsResponse private constructor(builder: Builder) {
    /**
     * An object that contains details about the reason the operation failed.
     */
    val error: aws.sdk.kotlin.services.iam.model.ErrorDetails? = builder.error
    /**
     * A flag that indicates whether there are more items to return. If your
     * results were truncated, you can make a subsequent pagination request using the Marker
     * request parameter to retrieve more items. Note that IAM might return fewer than the
     * MaxItems number of results even when there are more results available. We recommend
     * that you check IsTruncated after every call to ensure that you receive all your
     * results.
     */
    val isTruncated: kotlin.Boolean = builder.isTruncated
    /**
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
     * format, when the generated report job was completed or failed.
     * This field is null if the job is still in progress, as indicated by a job status value
     * of IN_PROGRESS.
     */
    val jobCompletionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.jobCompletionDate
    /**
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
     * format, when the report job was created.
     */
    val jobCreationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.jobCreationDate
    /**
     * The status of the job.
     */
    val jobStatus: aws.sdk.kotlin.services.iam.model.JobStatusType? = builder.jobStatus
    /**
     * The type of job. Service jobs return information about when each service was last
     * accessed. Action jobs also include information about when tracked actions within the
     * service were last accessed.
     */
    val jobType: aws.sdk.kotlin.services.iam.model.AccessAdvisorUsageGranularityType? = builder.jobType
    /**
     * When IsTruncated is true, this element
     * is present and contains the value to use for the Marker parameter in a subsequent
     * pagination request.
     */
    val marker: kotlin.String? = builder.marker
    /**
     * A ServiceLastAccessed object that contains details about the most recent
     * attempt to access the service.
     */
    val servicesLastAccessed: List<ServiceLastAccessed>? = builder.servicesLastAccessed

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.GetServiceLastAccessedDetailsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetServiceLastAccessedDetailsResponse(")
        append("error=$error,")
        append("isTruncated=$isTruncated,")
        append("jobCompletionDate=$jobCompletionDate,")
        append("jobCreationDate=$jobCreationDate,")
        append("jobStatus=$jobStatus,")
        append("jobType=$jobType,")
        append("marker=$marker,")
        append("servicesLastAccessed=$servicesLastAccessed)")
    }

    override fun hashCode(): kotlin.Int {
        var result = error?.hashCode() ?: 0
        result = 31 * result + (isTruncated.hashCode())
        result = 31 * result + (jobCompletionDate?.hashCode() ?: 0)
        result = 31 * result + (jobCreationDate?.hashCode() ?: 0)
        result = 31 * result + (jobStatus?.hashCode() ?: 0)
        result = 31 * result + (jobType?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (servicesLastAccessed?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetServiceLastAccessedDetailsResponse

        if (error != other.error) return false
        if (isTruncated != other.isTruncated) return false
        if (jobCompletionDate != other.jobCompletionDate) return false
        if (jobCreationDate != other.jobCreationDate) return false
        if (jobStatus != other.jobStatus) return false
        if (jobType != other.jobType) return false
        if (marker != other.marker) return false
        if (servicesLastAccessed != other.servicesLastAccessed) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.GetServiceLastAccessedDetailsResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * An object that contains details about the reason the operation failed.
         */
        var error: aws.sdk.kotlin.services.iam.model.ErrorDetails? = null
        /**
         * A flag that indicates whether there are more items to return. If your
         * results were truncated, you can make a subsequent pagination request using the Marker
         * request parameter to retrieve more items. Note that IAM might return fewer than the
         * MaxItems number of results even when there are more results available. We recommend
         * that you check IsTruncated after every call to ensure that you receive all your
         * results.
         */
        var isTruncated: kotlin.Boolean = false
        /**
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
         * format, when the generated report job was completed or failed.
         * This field is null if the job is still in progress, as indicated by a job status value
         * of IN_PROGRESS.
         */
        var jobCompletionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
         * format, when the report job was created.
         */
        var jobCreationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the job.
         */
        var jobStatus: aws.sdk.kotlin.services.iam.model.JobStatusType? = null
        /**
         * The type of job. Service jobs return information about when each service was last
         * accessed. Action jobs also include information about when tracked actions within the
         * service were last accessed.
         */
        var jobType: aws.sdk.kotlin.services.iam.model.AccessAdvisorUsageGranularityType? = null
        /**
         * When IsTruncated is true, this element
         * is present and contains the value to use for the Marker parameter in a subsequent
         * pagination request.
         */
        var marker: kotlin.String? = null
        /**
         * A ServiceLastAccessed object that contains details about the most recent
         * attempt to access the service.
         */
        var servicesLastAccessed: List<ServiceLastAccessed>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.GetServiceLastAccessedDetailsResponse) : this() {
            this.error = x.error
            this.isTruncated = x.isTruncated
            this.jobCompletionDate = x.jobCompletionDate
            this.jobCreationDate = x.jobCreationDate
            this.jobStatus = x.jobStatus
            this.jobType = x.jobType
            this.marker = x.marker
            this.servicesLastAccessed = x.servicesLastAccessed
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.GetServiceLastAccessedDetailsResponse = GetServiceLastAccessedDetailsResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.iam.model.ErrorDetails] inside the given [block]
         */
        fun error(block: aws.sdk.kotlin.services.iam.model.ErrorDetails.Builder.() -> kotlin.Unit) {
            this.error = aws.sdk.kotlin.services.iam.model.ErrorDetails.invoke(block)
        }
    }
}
