// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an IAM group, including all of the group's policies.
 * This data type is used as a response element in the GetAccountAuthorizationDetails operation.
 */
class GroupDetail private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.
     * For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) in
     * the Amazon Web Services General Reference.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * A list of the managed policies attached to the group.
     */
    val attachedManagedPolicies: List<AttachedPolicy>? = builder.attachedManagedPolicies
    /**
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
     * format, when the group was created.
     */
    val createDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createDate
    /**
     * The stable and unique string identifying the group. For more information about IDs, see
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
     * identifiers in the IAM User Guide.
     */
    val groupId: kotlin.String? = builder.groupId
    /**
     * The friendly name that identifies the group.
     */
    val groupName: kotlin.String? = builder.groupName
    /**
     * A list of the inline policies embedded in the group.
     */
    val groupPolicyList: List<PolicyDetail>? = builder.groupPolicyList
    /**
     * The path to the group. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers in the
     * IAM User Guide.
     */
    val path: kotlin.String? = builder.path

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.GroupDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GroupDetail(")
        append("arn=$arn,")
        append("attachedManagedPolicies=$attachedManagedPolicies,")
        append("createDate=$createDate,")
        append("groupId=$groupId,")
        append("groupName=$groupName,")
        append("groupPolicyList=$groupPolicyList,")
        append("path=$path)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (attachedManagedPolicies?.hashCode() ?: 0)
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (groupId?.hashCode() ?: 0)
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (groupPolicyList?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GroupDetail

        if (arn != other.arn) return false
        if (attachedManagedPolicies != other.attachedManagedPolicies) return false
        if (createDate != other.createDate) return false
        if (groupId != other.groupId) return false
        if (groupName != other.groupName) return false
        if (groupPolicyList != other.groupPolicyList) return false
        if (path != other.path) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.GroupDetail = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.
         * For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) in
         * the Amazon Web Services General Reference.
         */
        var arn: kotlin.String? = null
        /**
         * A list of the managed policies attached to the group.
         */
        var attachedManagedPolicies: List<AttachedPolicy>? = null
        /**
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
         * format, when the group was created.
         */
        var createDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The stable and unique string identifying the group. For more information about IDs, see
         * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
         * identifiers in the IAM User Guide.
         */
        var groupId: kotlin.String? = null
        /**
         * The friendly name that identifies the group.
         */
        var groupName: kotlin.String? = null
        /**
         * A list of the inline policies embedded in the group.
         */
        var groupPolicyList: List<PolicyDetail>? = null
        /**
         * The path to the group. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers in the
         * IAM User Guide.
         */
        var path: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.GroupDetail) : this() {
            this.arn = x.arn
            this.attachedManagedPolicies = x.attachedManagedPolicies
            this.createDate = x.createDate
            this.groupId = x.groupId
            this.groupName = x.groupName
            this.groupPolicyList = x.groupPolicyList
            this.path = x.path
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.GroupDetail = GroupDetail(this)
    }
}
