// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an instance profile.
 * This data type is used as a response element in the following operations:
 *
 *
 *
 * CreateInstanceProfile
 *
 *
 *
 * GetInstanceProfile
 *
 *
 *
 * ListInstanceProfiles
 *
 *
 *
 * ListInstanceProfilesForRole
 */
class InstanceProfile private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) specifying the instance profile. For more information
     * about ARNs and how to use them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers in the
     * IAM User Guide.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The date when the instance profile was created.
     */
    val createDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createDate
    /**
     * The stable and unique string identifying the instance profile. For more information
     * about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers in the IAM User Guide.
     */
    val instanceProfileId: kotlin.String? = builder.instanceProfileId
    /**
     * The name identifying the instance profile.
     */
    val instanceProfileName: kotlin.String? = builder.instanceProfileName
    /**
     * The path to the instance profile. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
     * identifiers in the IAM User Guide.
     */
    val path: kotlin.String? = builder.path
    /**
     * The role associated with the instance profile.
     */
    val roles: List<Role>? = builder.roles
    /**
     * A list of tags that are attached to the instance profile. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.InstanceProfile = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceProfile(")
        append("arn=$arn,")
        append("createDate=$createDate,")
        append("instanceProfileId=$instanceProfileId,")
        append("instanceProfileName=$instanceProfileName,")
        append("path=$path,")
        append("roles=$roles,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (instanceProfileId?.hashCode() ?: 0)
        result = 31 * result + (instanceProfileName?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (roles?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceProfile

        if (arn != other.arn) return false
        if (createDate != other.createDate) return false
        if (instanceProfileId != other.instanceProfileId) return false
        if (instanceProfileName != other.instanceProfileName) return false
        if (path != other.path) return false
        if (roles != other.roles) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.InstanceProfile = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) specifying the instance profile. For more information
         * about ARNs and how to use them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers in the
         * IAM User Guide.
         */
        var arn: kotlin.String? = null
        /**
         * The date when the instance profile was created.
         */
        var createDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The stable and unique string identifying the instance profile. For more information
         * about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers in the IAM User Guide.
         */
        var instanceProfileId: kotlin.String? = null
        /**
         * The name identifying the instance profile.
         */
        var instanceProfileName: kotlin.String? = null
        /**
         * The path to the instance profile. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
         * identifiers in the IAM User Guide.
         */
        var path: kotlin.String? = null
        /**
         * The role associated with the instance profile.
         */
        var roles: List<Role>? = null
        /**
         * A list of tags that are attached to the instance profile. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
         * IAM User Guide.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.InstanceProfile) : this() {
            this.arn = x.arn
            this.createDate = x.createDate
            this.instanceProfileId = x.instanceProfileId
            this.instanceProfileName = x.instanceProfileName
            this.path = x.path
            this.roles = x.roles
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.InstanceProfile = InstanceProfile(this)
    }
}
