// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



class ListPoliciesRequest private constructor(builder: Builder) {
    /**
     * Use this parameter only when paginating results and only after
     * you receive a response indicating that the results are truncated. Set it to the value of the
     * Marker element in the response that you received to indicate where the next call
     * should start.
     */
    val marker: kotlin.String? = builder.marker
    /**
     * Use this only when paginating results to indicate the
     * maximum number of items you want in the response. If additional items exist beyond the maximum
     * you specify, the IsTruncated response element is true.
     * If you do not include this parameter, the number of items defaults to 100. Note that
     * IAM might return fewer results, even when there are more results available. In that case, the
     * IsTruncated response element returns true, and Marker
     * contains a value to include in the subsequent call that tells the service where to continue
     * from.
     */
    val maxItems: kotlin.Int? = builder.maxItems
    /**
     * A flag to filter the results to only the attached policies.
     * When OnlyAttached is true, the returned list contains only
     * the policies that are attached to an IAM user, group, or role. When
     * OnlyAttached is false, or when the parameter is not
     * included, all policies are returned.
     */
    val onlyAttached: kotlin.Boolean = builder.onlyAttached
    /**
     * The path prefix for filtering the results. This parameter is optional. If it is not
     * included, it defaults to a slash (/), listing all policies. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern) a string of characters consisting
     * of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
     * In addition, it can contain any ASCII character from the ! (\u0021) through the DEL character (\u007F), including
     * most punctuation characters, digits, and upper and lowercased letters.
     */
    val pathPrefix: kotlin.String? = builder.pathPrefix
    /**
     * The policy usage method to use for filtering the results.
     * To list only permissions policies,
     * set PolicyUsageFilter to PermissionsPolicy. To list only
     * the policies used to set permissions boundaries, set the value
     * to PermissionsBoundary.
     * This parameter is optional. If it is not included, all policies are returned.
     */
    val policyUsageFilter: aws.sdk.kotlin.services.iam.model.PolicyUsageType? = builder.policyUsageFilter
    /**
     * The scope to use for filtering the results.
     * To list only Amazon Web Services managed policies, set Scope to AWS. To
     * list only the customer managed policies in your Amazon Web Services account, set Scope to
     * Local.
     * This parameter is optional. If it is not included, or if it is set to
     * All, all policies are returned.
     */
    val scope: aws.sdk.kotlin.services.iam.model.PolicyScopeType? = builder.scope

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.ListPoliciesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListPoliciesRequest(")
        append("marker=$marker,")
        append("maxItems=$maxItems,")
        append("onlyAttached=$onlyAttached,")
        append("pathPrefix=$pathPrefix,")
        append("policyUsageFilter=$policyUsageFilter,")
        append("scope=$scope)")
    }

    override fun hashCode(): kotlin.Int {
        var result = marker?.hashCode() ?: 0
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (onlyAttached.hashCode())
        result = 31 * result + (pathPrefix?.hashCode() ?: 0)
        result = 31 * result + (policyUsageFilter?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListPoliciesRequest

        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false
        if (onlyAttached != other.onlyAttached) return false
        if (pathPrefix != other.pathPrefix) return false
        if (policyUsageFilter != other.policyUsageFilter) return false
        if (scope != other.scope) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.ListPoliciesRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Use this parameter only when paginating results and only after
         * you receive a response indicating that the results are truncated. Set it to the value of the
         * Marker element in the response that you received to indicate where the next call
         * should start.
         */
        var marker: kotlin.String? = null
        /**
         * Use this only when paginating results to indicate the
         * maximum number of items you want in the response. If additional items exist beyond the maximum
         * you specify, the IsTruncated response element is true.
         * If you do not include this parameter, the number of items defaults to 100. Note that
         * IAM might return fewer results, even when there are more results available. In that case, the
         * IsTruncated response element returns true, and Marker
         * contains a value to include in the subsequent call that tells the service where to continue
         * from.
         */
        var maxItems: kotlin.Int? = null
        /**
         * A flag to filter the results to only the attached policies.
         * When OnlyAttached is true, the returned list contains only
         * the policies that are attached to an IAM user, group, or role. When
         * OnlyAttached is false, or when the parameter is not
         * included, all policies are returned.
         */
        var onlyAttached: kotlin.Boolean = false
        /**
         * The path prefix for filtering the results. This parameter is optional. If it is not
         * included, it defaults to a slash (/), listing all policies. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern) a string of characters consisting
         * of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
         * In addition, it can contain any ASCII character from the ! (\u0021) through the DEL character (\u007F), including
         * most punctuation characters, digits, and upper and lowercased letters.
         */
        var pathPrefix: kotlin.String? = null
        /**
         * The policy usage method to use for filtering the results.
         * To list only permissions policies,
         * set PolicyUsageFilter to PermissionsPolicy. To list only
         * the policies used to set permissions boundaries, set the value
         * to PermissionsBoundary.
         * This parameter is optional. If it is not included, all policies are returned.
         */
        var policyUsageFilter: aws.sdk.kotlin.services.iam.model.PolicyUsageType? = null
        /**
         * The scope to use for filtering the results.
         * To list only Amazon Web Services managed policies, set Scope to AWS. To
         * list only the customer managed policies in your Amazon Web Services account, set Scope to
         * Local.
         * This parameter is optional. If it is not included, or if it is set to
         * All, all policies are returned.
         */
        var scope: aws.sdk.kotlin.services.iam.model.PolicyScopeType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.ListPoliciesRequest) : this() {
            this.marker = x.marker
            this.maxItems = x.maxItems
            this.onlyAttached = x.onlyAttached
            this.pathPrefix = x.pathPrefix
            this.policyUsageFilter = x.policyUsageFilter
            this.scope = x.scope
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.ListPoliciesRequest = ListPoliciesRequest(this)
    }
}
