// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



/**
 * Contains the response to a successful ListPolicies request.
 */
class ListPoliciesResponse private constructor(builder: Builder) {
    /**
     * A flag that indicates whether there are more items to return. If your
     * results were truncated, you can make a subsequent pagination request using the Marker
     * request parameter to retrieve more items. Note that IAM might return fewer than the
     * MaxItems number of results even when there are more results available. We recommend
     * that you check IsTruncated after every call to ensure that you receive all your
     * results.
     */
    val isTruncated: kotlin.Boolean = builder.isTruncated
    /**
     * When IsTruncated is true, this element
     * is present and contains the value to use for the Marker parameter in a subsequent
     * pagination request.
     */
    val marker: kotlin.String? = builder.marker
    /**
     * A list of policies.
     */
    val policies: List<Policy>? = builder.policies

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.ListPoliciesResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListPoliciesResponse(")
        append("isTruncated=$isTruncated,")
        append("marker=$marker,")
        append("policies=$policies)")
    }

    override fun hashCode(): kotlin.Int {
        var result = isTruncated.hashCode()
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (policies?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListPoliciesResponse

        if (isTruncated != other.isTruncated) return false
        if (marker != other.marker) return false
        if (policies != other.policies) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.ListPoliciesResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * A flag that indicates whether there are more items to return. If your
         * results were truncated, you can make a subsequent pagination request using the Marker
         * request parameter to retrieve more items. Note that IAM might return fewer than the
         * MaxItems number of results even when there are more results available. We recommend
         * that you check IsTruncated after every call to ensure that you receive all your
         * results.
         */
        var isTruncated: kotlin.Boolean = false
        /**
         * When IsTruncated is true, this element
         * is present and contains the value to use for the Marker parameter in a subsequent
         * pagination request.
         */
        var marker: kotlin.String? = null
        /**
         * A list of policies.
         */
        var policies: List<Policy>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.ListPoliciesResponse) : this() {
            this.isTruncated = x.isTruncated
            this.marker = x.marker
            this.policies = x.policies
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.ListPoliciesResponse = ListPoliciesResponse(this)
    }
}
