// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a managed policy, including the policy's ARN, versions, and
 * the number of principal entities (users, groups, and roles) that the policy is attached
 * to.
 * This data type is used as a response element in the GetAccountAuthorizationDetails operation.
 * For more information about managed policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
 * policies in the IAM User Guide.
 */
class ManagedPolicyDetail private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.
     * For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) in
     * the Amazon Web Services General Reference.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The number of principal entities (users, groups, and roles) that the policy is attached
     * to.
     */
    val attachmentCount: kotlin.Int? = builder.attachmentCount
    /**
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
     * format, when the policy was created.
     */
    val createDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createDate
    /**
     * The identifier for the version of the policy that is set as the default (operative)
     * version.
     * For more information about policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies in the IAM User Guide.
     */
    val defaultVersionId: kotlin.String? = builder.defaultVersionId
    /**
     * A friendly description of the policy.
     */
    val description: kotlin.String? = builder.description
    /**
     * Specifies whether the policy can be attached to an IAM user, group, or role.
     */
    val isAttachable: kotlin.Boolean = builder.isAttachable
    /**
     * The path to the policy.
     * For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers in the
     * IAM User Guide.
     */
    val path: kotlin.String? = builder.path
    /**
     * The number of entities (users and roles) for which the policy is used as the permissions
     * boundary.
     * For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
     * identities  in the IAM User Guide.
     */
    val permissionsBoundaryUsageCount: kotlin.Int? = builder.permissionsBoundaryUsageCount
    /**
     * The stable and unique string identifying the policy.
     * For more information about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers in the
     * IAM User Guide.
     */
    val policyId: kotlin.String? = builder.policyId
    /**
     * The friendly name (not ARN) identifying the policy.
     */
    val policyName: kotlin.String? = builder.policyName
    /**
     * A list containing information about the versions of the policy.
     */
    val policyVersionList: List<PolicyVersion>? = builder.policyVersionList
    /**
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
     * format, when the policy was last updated.
     * When a policy has only one version, this field contains the date and time when the
     * policy was created. When a policy has more than one version, this field contains the date
     * and time when the most recent policy version was created.
     */
    val updateDate: aws.smithy.kotlin.runtime.time.Instant? = builder.updateDate

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.ManagedPolicyDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ManagedPolicyDetail(")
        append("arn=$arn,")
        append("attachmentCount=$attachmentCount,")
        append("createDate=$createDate,")
        append("defaultVersionId=$defaultVersionId,")
        append("description=$description,")
        append("isAttachable=$isAttachable,")
        append("path=$path,")
        append("permissionsBoundaryUsageCount=$permissionsBoundaryUsageCount,")
        append("policyId=$policyId,")
        append("policyName=$policyName,")
        append("policyVersionList=$policyVersionList,")
        append("updateDate=$updateDate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (attachmentCount ?: 0)
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (defaultVersionId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (isAttachable.hashCode())
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (permissionsBoundaryUsageCount ?: 0)
        result = 31 * result + (policyId?.hashCode() ?: 0)
        result = 31 * result + (policyName?.hashCode() ?: 0)
        result = 31 * result + (policyVersionList?.hashCode() ?: 0)
        result = 31 * result + (updateDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ManagedPolicyDetail

        if (arn != other.arn) return false
        if (attachmentCount != other.attachmentCount) return false
        if (createDate != other.createDate) return false
        if (defaultVersionId != other.defaultVersionId) return false
        if (description != other.description) return false
        if (isAttachable != other.isAttachable) return false
        if (path != other.path) return false
        if (permissionsBoundaryUsageCount != other.permissionsBoundaryUsageCount) return false
        if (policyId != other.policyId) return false
        if (policyName != other.policyName) return false
        if (policyVersionList != other.policyVersionList) return false
        if (updateDate != other.updateDate) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.ManagedPolicyDetail = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.
         * For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) in
         * the Amazon Web Services General Reference.
         */
        var arn: kotlin.String? = null
        /**
         * The number of principal entities (users, groups, and roles) that the policy is attached
         * to.
         */
        var attachmentCount: kotlin.Int? = null
        /**
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
         * format, when the policy was created.
         */
        var createDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier for the version of the policy that is set as the default (operative)
         * version.
         * For more information about policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
         * policies in the IAM User Guide.
         */
        var defaultVersionId: kotlin.String? = null
        /**
         * A friendly description of the policy.
         */
        var description: kotlin.String? = null
        /**
         * Specifies whether the policy can be attached to an IAM user, group, or role.
         */
        var isAttachable: kotlin.Boolean = false
        /**
         * The path to the policy.
         * For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers in the
         * IAM User Guide.
         */
        var path: kotlin.String? = null
        /**
         * The number of entities (users and roles) for which the policy is used as the permissions
         * boundary.
         * For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
         * identities  in the IAM User Guide.
         */
        var permissionsBoundaryUsageCount: kotlin.Int? = null
        /**
         * The stable and unique string identifying the policy.
         * For more information about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers in the
         * IAM User Guide.
         */
        var policyId: kotlin.String? = null
        /**
         * The friendly name (not ARN) identifying the policy.
         */
        var policyName: kotlin.String? = null
        /**
         * A list containing information about the versions of the policy.
         */
        var policyVersionList: List<PolicyVersion>? = null
        /**
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
         * format, when the policy was last updated.
         * When a policy has only one version, this field contains the date and time when the
         * policy was created. When a policy has more than one version, this field contains the date
         * and time when the most recent policy version was created.
         */
        var updateDate: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.ManagedPolicyDetail) : this() {
            this.arn = x.arn
            this.attachmentCount = x.attachmentCount
            this.createDate = x.createDate
            this.defaultVersionId = x.defaultVersionId
            this.description = x.description
            this.isAttachable = x.isAttachable
            this.path = x.path
            this.permissionsBoundaryUsageCount = x.permissionsBoundaryUsageCount
            this.policyId = x.policyId
            this.policyName = x.policyName
            this.policyVersionList = x.policyVersionList
            this.updateDate = x.updateDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.ManagedPolicyDetail = ManagedPolicyDetail(this)
    }
}
