// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an MFA device.
 * This data type is used as a response element in the ListMFADevices
 * operation.
 */
class MfaDevice private constructor(builder: Builder) {
    /**
     * The date when the MFA device was enabled for the user.
     */
    val enableDate: aws.smithy.kotlin.runtime.time.Instant? = builder.enableDate
    /**
     * The serial number that uniquely identifies the MFA device. For virtual MFA devices, the
     * serial number is the device ARN.
     */
    val serialNumber: kotlin.String? = builder.serialNumber
    /**
     * The user with whom the MFA device is associated.
     */
    val userName: kotlin.String? = builder.userName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.MfaDevice = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MfaDevice(")
        append("enableDate=$enableDate,")
        append("serialNumber=$serialNumber,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enableDate?.hashCode() ?: 0
        result = 31 * result + (serialNumber?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MfaDevice

        if (enableDate != other.enableDate) return false
        if (serialNumber != other.serialNumber) return false
        if (userName != other.userName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.MfaDevice = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date when the MFA device was enabled for the user.
         */
        var enableDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The serial number that uniquely identifies the MFA device. For virtual MFA devices, the
         * serial number is the device ARN.
         */
        var serialNumber: kotlin.String? = null
        /**
         * The user with whom the MFA device is associated.
         */
        var userName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.MfaDevice) : this() {
            this.enableDate = x.enableDate
            this.serialNumber = x.serialNumber
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.MfaDevice = MfaDevice(this)
    }
}
