// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



/**
 * Contains details about the permissions policies that are attached to the specified
 * identity (user, group, or role).
 * This data type is an element of the ListPoliciesGrantingServiceAccessEntry object.
 */
class PolicyGrantingServiceAccess private constructor(builder: Builder) {
    /**
     * The name of the entity (user or role) to which the inline policy is attached.
     * This field is null for managed policies. For more information about these policy types,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies and inline policies in the
     * IAM User Guide.
     */
    val entityName: kotlin.String? = builder.entityName
    /**
     * The type of entity (user or role) that used the policy to access the service to which
     * the inline policy is attached.
     * This field is null for managed policies. For more information about these policy types,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies and inline policies in the
     * IAM User Guide.
     */
    val entityType: aws.sdk.kotlin.services.iam.model.PolicyOwnerEntityType? = builder.entityType
    /**
     * The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.
     * For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) in
     * the Amazon Web Services General Reference.
     */
    val policyArn: kotlin.String? = builder.policyArn
    /**
     * The policy name.
     */
    val policyName: kotlin.String? = builder.policyName
    /**
     * The policy type. For more information about these policy types, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed
     * policies and inline policies in the
     * IAM User Guide.
     */
    val policyType: aws.sdk.kotlin.services.iam.model.PolicyType? = builder.policyType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.PolicyGrantingServiceAccess = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PolicyGrantingServiceAccess(")
        append("entityName=$entityName,")
        append("entityType=$entityType,")
        append("policyArn=$policyArn,")
        append("policyName=$policyName,")
        append("policyType=$policyType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = entityName?.hashCode() ?: 0
        result = 31 * result + (entityType?.hashCode() ?: 0)
        result = 31 * result + (policyArn?.hashCode() ?: 0)
        result = 31 * result + (policyName?.hashCode() ?: 0)
        result = 31 * result + (policyType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PolicyGrantingServiceAccess

        if (entityName != other.entityName) return false
        if (entityType != other.entityType) return false
        if (policyArn != other.policyArn) return false
        if (policyName != other.policyName) return false
        if (policyType != other.policyType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.PolicyGrantingServiceAccess = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the entity (user or role) to which the inline policy is attached.
         * This field is null for managed policies. For more information about these policy types,
         * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies and inline policies in the
         * IAM User Guide.
         */
        var entityName: kotlin.String? = null
        /**
         * The type of entity (user or role) that used the policy to access the service to which
         * the inline policy is attached.
         * This field is null for managed policies. For more information about these policy types,
         * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies and inline policies in the
         * IAM User Guide.
         */
        var entityType: aws.sdk.kotlin.services.iam.model.PolicyOwnerEntityType? = null
        /**
         * The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.
         * For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) in
         * the Amazon Web Services General Reference.
         */
        var policyArn: kotlin.String? = null
        /**
         * The policy name.
         */
        var policyName: kotlin.String? = null
        /**
         * The policy type. For more information about these policy types, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed
         * policies and inline policies in the
         * IAM User Guide.
         */
        var policyType: aws.sdk.kotlin.services.iam.model.PolicyType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.PolicyGrantingServiceAccess) : this() {
            this.entityName = x.entityName
            this.entityType = x.entityType
            this.policyArn = x.policyArn
            this.policyName = x.policyName
            this.policyType = x.policyType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.PolicyGrantingServiceAccess = PolicyGrantingServiceAccess(this)
    }
}
