// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



/**
 * Contains information about a group that a managed policy is attached to.
 * This data type is used as a response element in the ListEntitiesForPolicy operation.
 * For more information about managed policies, refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
 * policies in the IAM User Guide.
 */
class PolicyGroup private constructor(builder: Builder) {
    /**
     * The stable and unique string identifying the group. For more information about IDs, see
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
     * identifiers in the IAM User Guide.
     */
    val groupId: kotlin.String? = builder.groupId
    /**
     * The name (friendly name, not ARN) identifying the group.
     */
    val groupName: kotlin.String? = builder.groupName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.PolicyGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PolicyGroup(")
        append("groupId=$groupId,")
        append("groupName=$groupName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = groupId?.hashCode() ?: 0
        result = 31 * result + (groupName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PolicyGroup

        if (groupId != other.groupId) return false
        if (groupName != other.groupName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.PolicyGroup = Builder(this).apply(block).build()

    class Builder {
        /**
         * The stable and unique string identifying the group. For more information about IDs, see
         * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
         * identifiers in the IAM User Guide.
         */
        var groupId: kotlin.String? = null
        /**
         * The name (friendly name, not ARN) identifying the group.
         */
        var groupName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.PolicyGroup) : this() {
            this.groupId = x.groupId
            this.groupName = x.groupName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.PolicyGroup = PolicyGroup(this)
    }
}
