// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



/**
 * Contains information about a role that a managed policy is attached to.
 * This data type is used as a response element in the ListEntitiesForPolicy operation.
 * For more information about managed policies, refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
 * policies in the IAM User Guide.
 */
class PolicyRole private constructor(builder: Builder) {
    /**
     * The stable and unique string identifying the role. For more information about IDs, see
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
     * identifiers in the IAM User Guide.
     */
    val roleId: kotlin.String? = builder.roleId
    /**
     * The name (friendly name, not ARN) identifying the role.
     */
    val roleName: kotlin.String? = builder.roleName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.PolicyRole = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PolicyRole(")
        append("roleId=$roleId,")
        append("roleName=$roleName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = roleId?.hashCode() ?: 0
        result = 31 * result + (roleName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PolicyRole

        if (roleId != other.roleId) return false
        if (roleName != other.roleName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.PolicyRole = Builder(this).apply(block).build()

    class Builder {
        /**
         * The stable and unique string identifying the role. For more information about IDs, see
         * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
         * identifiers in the IAM User Guide.
         */
        var roleId: kotlin.String? = null
        /**
         * The name (friendly name, not ARN) identifying the role.
         */
        var roleName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.PolicyRole) : this() {
            this.roleId = x.roleId
            this.roleName = x.roleName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.PolicyRole = PolicyRole(this)
    }
}
