// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



/**
 * Contains the result of the simulation of a single API operation call on a single
 * resource.
 * This data type is used by a member of the EvaluationResult data
 * type.
 */
class ResourceSpecificResult private constructor(builder: Builder) {
    /**
     * Additional details about the results of the evaluation decision on a single resource.
     * This parameter is returned only for cross-account simulations. This parameter explains how
     * each policy type contributes to the resource-specific evaluation decision.
     */
    val evalDecisionDetails: Map<String, PolicyEvaluationDecisionType>? = builder.evalDecisionDetails
    /**
     * The result of the simulation of the simulated API operation on the resource specified in
     * EvalResourceName.
     */
    val evalResourceDecision: aws.sdk.kotlin.services.iam.model.PolicyEvaluationDecisionType? = builder.evalResourceDecision
    /**
     * The name of the simulated resource, in Amazon Resource Name (ARN) format.
     */
    val evalResourceName: kotlin.String? = builder.evalResourceName
    /**
     * A list of the statements in the input policies that determine the result for this part
     * of the simulation. Remember that even if multiple statements allow the operation on the
     * resource, if any statement denies that operation, then the explicit
     * deny overrides any allow. In addition, the deny statement is the only entry included in the
     * result.
     */
    val matchedStatements: List<Statement>? = builder.matchedStatements
    /**
     * A list of context keys that are required by the included input policies but that were
     * not provided by one of the input parameters. This list is used when a list of ARNs is
     * included in the ResourceArns parameter instead of "*". If you do not specify
     * individual resources, by setting ResourceArns to "*" or by not including the
     * ResourceArns parameter, then any missing context values are instead
     * included under the EvaluationResults section. To discover the context keys
     * used by a set of policies, you can call GetContextKeysForCustomPolicy or
     * GetContextKeysForPrincipalPolicy.
     */
    val missingContextValues: List<String>? = builder.missingContextValues
    /**
     * Contains information about the effect that a permissions boundary has on a policy
     * simulation when that boundary is applied to an IAM entity.
     */
    val permissionsBoundaryDecisionDetail: aws.sdk.kotlin.services.iam.model.PermissionsBoundaryDecisionDetail? = builder.permissionsBoundaryDecisionDetail

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.ResourceSpecificResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceSpecificResult(")
        append("evalDecisionDetails=$evalDecisionDetails,")
        append("evalResourceDecision=$evalResourceDecision,")
        append("evalResourceName=$evalResourceName,")
        append("matchedStatements=$matchedStatements,")
        append("missingContextValues=$missingContextValues,")
        append("permissionsBoundaryDecisionDetail=$permissionsBoundaryDecisionDetail)")
    }

    override fun hashCode(): kotlin.Int {
        var result = evalDecisionDetails?.hashCode() ?: 0
        result = 31 * result + (evalResourceDecision?.hashCode() ?: 0)
        result = 31 * result + (evalResourceName?.hashCode() ?: 0)
        result = 31 * result + (matchedStatements?.hashCode() ?: 0)
        result = 31 * result + (missingContextValues?.hashCode() ?: 0)
        result = 31 * result + (permissionsBoundaryDecisionDetail?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceSpecificResult

        if (evalDecisionDetails != other.evalDecisionDetails) return false
        if (evalResourceDecision != other.evalResourceDecision) return false
        if (evalResourceName != other.evalResourceName) return false
        if (matchedStatements != other.matchedStatements) return false
        if (missingContextValues != other.missingContextValues) return false
        if (permissionsBoundaryDecisionDetail != other.permissionsBoundaryDecisionDetail) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.ResourceSpecificResult = Builder(this).apply(block).build()

    class Builder {
        /**
         * Additional details about the results of the evaluation decision on a single resource.
         * This parameter is returned only for cross-account simulations. This parameter explains how
         * each policy type contributes to the resource-specific evaluation decision.
         */
        var evalDecisionDetails: Map<String, PolicyEvaluationDecisionType>? = null
        /**
         * The result of the simulation of the simulated API operation on the resource specified in
         * EvalResourceName.
         */
        var evalResourceDecision: aws.sdk.kotlin.services.iam.model.PolicyEvaluationDecisionType? = null
        /**
         * The name of the simulated resource, in Amazon Resource Name (ARN) format.
         */
        var evalResourceName: kotlin.String? = null
        /**
         * A list of the statements in the input policies that determine the result for this part
         * of the simulation. Remember that even if multiple statements allow the operation on the
         * resource, if any statement denies that operation, then the explicit
         * deny overrides any allow. In addition, the deny statement is the only entry included in the
         * result.
         */
        var matchedStatements: List<Statement>? = null
        /**
         * A list of context keys that are required by the included input policies but that were
         * not provided by one of the input parameters. This list is used when a list of ARNs is
         * included in the ResourceArns parameter instead of "*". If you do not specify
         * individual resources, by setting ResourceArns to "*" or by not including the
         * ResourceArns parameter, then any missing context values are instead
         * included under the EvaluationResults section. To discover the context keys
         * used by a set of policies, you can call GetContextKeysForCustomPolicy or
         * GetContextKeysForPrincipalPolicy.
         */
        var missingContextValues: List<String>? = null
        /**
         * Contains information about the effect that a permissions boundary has on a policy
         * simulation when that boundary is applied to an IAM entity.
         */
        var permissionsBoundaryDecisionDetail: aws.sdk.kotlin.services.iam.model.PermissionsBoundaryDecisionDetail? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.ResourceSpecificResult) : this() {
            this.evalDecisionDetails = x.evalDecisionDetails
            this.evalResourceDecision = x.evalResourceDecision
            this.evalResourceName = x.evalResourceName
            this.matchedStatements = x.matchedStatements
            this.missingContextValues = x.missingContextValues
            this.permissionsBoundaryDecisionDetail = x.permissionsBoundaryDecisionDetail
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.ResourceSpecificResult = ResourceSpecificResult(this)

        /**
         * construct an [aws.sdk.kotlin.services.iam.model.PermissionsBoundaryDecisionDetail] inside the given [block]
         */
        fun permissionsBoundaryDecisionDetail(block: aws.sdk.kotlin.services.iam.model.PermissionsBoundaryDecisionDetail.Builder.() -> kotlin.Unit) {
            this.permissionsBoundaryDecisionDetail = aws.sdk.kotlin.services.iam.model.PermissionsBoundaryDecisionDetail.invoke(block)
        }
    }
}
