// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an IAM role, including all of the role's policies.
 * This data type is used as a response element in the GetAccountAuthorizationDetails operation.
 */
class RoleDetail private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.
     * For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) in
     * the Amazon Web Services General Reference.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The trust policy that grants permission to assume the role.
     */
    val assumeRolePolicyDocument: kotlin.String? = builder.assumeRolePolicyDocument
    /**
     * A list of managed policies attached to the role. These policies are the role's access
     * (permissions) policies.
     */
    val attachedManagedPolicies: List<AttachedPolicy>? = builder.attachedManagedPolicies
    /**
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
     * format, when the role was created.
     */
    val createDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createDate
    /**
     * A list of instance profiles that contain this role.
     */
    val instanceProfileList: List<InstanceProfile>? = builder.instanceProfileList
    /**
     * The path to the role. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers in the
     * IAM User Guide.
     */
    val path: kotlin.String? = builder.path
    /**
     * The ARN of the policy used to set the permissions boundary for the role.
     * For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
     * identities  in the IAM User Guide.
     */
    val permissionsBoundary: aws.sdk.kotlin.services.iam.model.AttachedPermissionsBoundary? = builder.permissionsBoundary
    /**
     * The stable and unique string identifying the role. For more information about IDs, see
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
     * identifiers in the IAM User Guide.
     */
    val roleId: kotlin.String? = builder.roleId
    /**
     * Contains information about the last time that an IAM role was used. This includes the
     * date and time and the Region in which the role was last used. Activity is only reported for
     * the trailing 400 days. This period can be shorter if your Region began supporting these
     * features within the last year. The role might have been used more than 400 days ago. For
     * more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked in the IAM User
     * Guide.
     */
    val roleLastUsed: aws.sdk.kotlin.services.iam.model.RoleLastUsed? = builder.roleLastUsed
    /**
     * The friendly name that identifies the role.
     */
    val roleName: kotlin.String? = builder.roleName
    /**
     * A list of inline policies embedded in the role. These policies are the role's access
     * (permissions) policies.
     */
    val rolePolicyList: List<PolicyDetail>? = builder.rolePolicyList
    /**
     * A list of tags that are attached to the role. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.RoleDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RoleDetail(")
        append("arn=$arn,")
        append("assumeRolePolicyDocument=$assumeRolePolicyDocument,")
        append("attachedManagedPolicies=$attachedManagedPolicies,")
        append("createDate=$createDate,")
        append("instanceProfileList=$instanceProfileList,")
        append("path=$path,")
        append("permissionsBoundary=$permissionsBoundary,")
        append("roleId=$roleId,")
        append("roleLastUsed=$roleLastUsed,")
        append("roleName=$roleName,")
        append("rolePolicyList=$rolePolicyList,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (assumeRolePolicyDocument?.hashCode() ?: 0)
        result = 31 * result + (attachedManagedPolicies?.hashCode() ?: 0)
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (instanceProfileList?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (permissionsBoundary?.hashCode() ?: 0)
        result = 31 * result + (roleId?.hashCode() ?: 0)
        result = 31 * result + (roleLastUsed?.hashCode() ?: 0)
        result = 31 * result + (roleName?.hashCode() ?: 0)
        result = 31 * result + (rolePolicyList?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RoleDetail

        if (arn != other.arn) return false
        if (assumeRolePolicyDocument != other.assumeRolePolicyDocument) return false
        if (attachedManagedPolicies != other.attachedManagedPolicies) return false
        if (createDate != other.createDate) return false
        if (instanceProfileList != other.instanceProfileList) return false
        if (path != other.path) return false
        if (permissionsBoundary != other.permissionsBoundary) return false
        if (roleId != other.roleId) return false
        if (roleLastUsed != other.roleLastUsed) return false
        if (roleName != other.roleName) return false
        if (rolePolicyList != other.rolePolicyList) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.RoleDetail = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.
         * For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) in
         * the Amazon Web Services General Reference.
         */
        var arn: kotlin.String? = null
        /**
         * The trust policy that grants permission to assume the role.
         */
        var assumeRolePolicyDocument: kotlin.String? = null
        /**
         * A list of managed policies attached to the role. These policies are the role's access
         * (permissions) policies.
         */
        var attachedManagedPolicies: List<AttachedPolicy>? = null
        /**
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
         * format, when the role was created.
         */
        var createDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of instance profiles that contain this role.
         */
        var instanceProfileList: List<InstanceProfile>? = null
        /**
         * The path to the role. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers in the
         * IAM User Guide.
         */
        var path: kotlin.String? = null
        /**
         * The ARN of the policy used to set the permissions boundary for the role.
         * For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
         * identities  in the IAM User Guide.
         */
        var permissionsBoundary: aws.sdk.kotlin.services.iam.model.AttachedPermissionsBoundary? = null
        /**
         * The stable and unique string identifying the role. For more information about IDs, see
         * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
         * identifiers in the IAM User Guide.
         */
        var roleId: kotlin.String? = null
        /**
         * Contains information about the last time that an IAM role was used. This includes the
         * date and time and the Region in which the role was last used. Activity is only reported for
         * the trailing 400 days. This period can be shorter if your Region began supporting these
         * features within the last year. The role might have been used more than 400 days ago. For
         * more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked in the IAM User
         * Guide.
         */
        var roleLastUsed: aws.sdk.kotlin.services.iam.model.RoleLastUsed? = null
        /**
         * The friendly name that identifies the role.
         */
        var roleName: kotlin.String? = null
        /**
         * A list of inline policies embedded in the role. These policies are the role's access
         * (permissions) policies.
         */
        var rolePolicyList: List<PolicyDetail>? = null
        /**
         * A list of tags that are attached to the role. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
         * IAM User Guide.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.RoleDetail) : this() {
            this.arn = x.arn
            this.assumeRolePolicyDocument = x.assumeRolePolicyDocument
            this.attachedManagedPolicies = x.attachedManagedPolicies
            this.createDate = x.createDate
            this.instanceProfileList = x.instanceProfileList
            this.path = x.path
            this.permissionsBoundary = x.permissionsBoundary
            this.roleId = x.roleId
            this.roleLastUsed = x.roleLastUsed
            this.roleName = x.roleName
            this.rolePolicyList = x.rolePolicyList
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.RoleDetail = RoleDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.iam.model.AttachedPermissionsBoundary] inside the given [block]
         */
        fun permissionsBoundary(block: aws.sdk.kotlin.services.iam.model.AttachedPermissionsBoundary.Builder.() -> kotlin.Unit) {
            this.permissionsBoundary = aws.sdk.kotlin.services.iam.model.AttachedPermissionsBoundary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iam.model.RoleLastUsed] inside the given [block]
         */
        fun roleLastUsed(block: aws.sdk.kotlin.services.iam.model.RoleLastUsed.Builder.() -> kotlin.Unit) {
            this.roleLastUsed = aws.sdk.kotlin.services.iam.model.RoleLastUsed.invoke(block)
        }
    }
}
